/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.graphics.DefineShape;
import com.klg.jclass.util.style.JCLineStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastHLOCChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCHLOCChartFormat hlocf = null;
    protected boolean usePercentageWidth = false;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    @Override
    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.hlocf = (JCHLOCChartFormat)this.dataObject.getChartFormat();
        this.xaxis = this.dataObject.getXAxis();
        if (this.xaxis == null) {
            return;
        }
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.i_vertical;
        if (n2 == -1 || n2 == 0) {
            MinMax minMax = this.dataObject.getXLimits();
            if (minMax == null) {
                return;
            }
            MinMax minMax2 = this.dataObject.getYLimits();
            if (minMax2 == null) {
                return;
            }
            this.xlim = new MinMax(minMax.min, minMax.max);
            this.ylim = new MinMax(minMax2.min, minMax2.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    @Override
    public void draw(Graphics graphics) {
        block11: {
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
                    return;
                }
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                boolean bl = this.hlocf.isOpenCloseFullWidth();
                boolean bl2 = this.hlocf.isShowingOpen();
                boolean bl3 = this.hlocf.isShowingClose();
                this.usePercentageWidth = this.hlocf.getOpenCloseWidthMode() == 2;
                boolean bl4 = this.xaxis.isLogarithmic();
                boolean bl5 = this.yaxis.isLogarithmic();
                Rectangle rectangle2 = this.chartArea.getPlotRect();
                int n2 = this.inverted ? rectangle2.height : rectangle2.width;
                int n3 = this.seriesList.size() / 4;
                int n4 = 0;
                int n5 = n3;
                for (int i2 = n4; i2 < n5; ++i2) {
                    ChartDataViewSeries chartDataViewSeries;
                    JCChartStyle jCChartStyle;
                    Serializable serializable;
                    int n6;
                    int n7 = this.hlocf.getTickSize(i2);
                    boolean bl6 = true;
                    boolean bl7 = true;
                    int n8 = Integer.MAX_VALUE;
                    int n9 = Integer.MAX_VALUE;
                    int n10 = n6 = 4 * i2;
                    int n11 = 0;
                    while (n11 < 4) {
                        serializable = (ChartDataViewSeries)this.seriesList.get(n10);
                        if (!((ChartDataViewSeries)serializable).isVisible()) {
                            bl7 = false;
                            break;
                        }
                        if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                            bl6 = false;
                            break;
                        }
                        n8 = Math.min(n8, ((ChartDataViewSeries)serializable).getFirstPoint());
                        n9 = Math.min(n9, ((ChartDataViewSeries)serializable).getLastPoint());
                        ++n11;
                        ++n10;
                    }
                    if (!bl6 || !bl7) continue;
                    if (this.usePercentageWidth) {
                        n10 = 0;
                        ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n6);
                        for (int i3 = n8; i3 <= n9; ++i3) {
                            double d2 = chartDataViewSeries2.getX(i3);
                            if (this.xaxis.isValueExcluded(d2)) continue;
                            ++n10;
                        }
                        if (n10 == 0) continue;
                        n7 = this.hlocf.percentageWidth * n2 / (200 * n10);
                    }
                    if ((jCChartStyle = (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6)).getStyle()) == null || !((JCLineStyle)(serializable = jCChartStyle.getLineStyle())).updateGraphics(graphics2D)) continue;
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    for (int i4 = n8; i4 <= n9; ++i4) {
                        this.drawPoints(graphics2D, this.seriesList, i2, i4, plotPointArray, bl, bl2, bl3, n7, bl4, bl5);
                    }
                    ((JCLineStyle)serializable).resetGraphics(graphics2D);
                }
            }
            catch (Exception exception) {
                JCChart jCChart = (JCChart)this.chartArea.getParent();
                if (jCChart == null) break block11;
                jCChart.getErrorLog().logErrorMessage("drawing", exception);
            }
        }
    }

    private void drawPoints(Graphics2D graphics2D, List<ChartDataViewSeries> list, int n2, int n3, PlotPoint[] plotPointArray, boolean bl, boolean bl2, boolean bl3, int n4, boolean bl4, boolean bl5) {
        double d2;
        ChartDataViewSeries chartDataViewSeries;
        double d3;
        DefineShape defineShape = null;
        if (graphics2D instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics2D);
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MAX_VALUE;
        int n8 = 4 * n2;
        if (this.xaxis.isValueExcluded(d3 = (chartDataViewSeries = list.get(n8++)).getX(n3))) {
            return;
        }
        if (bl4 && d3 <= 0.0) {
            d3 = this.holeValue;
        }
        double d4 = chartDataViewSeries.getY(n3);
        if (bl5 && d4 <= 0.0) {
            d4 = this.holeValue;
        }
        ChartDataViewSeries chartDataViewSeries2 = list.get(n8++);
        double d5 = chartDataViewSeries2.getX(n3);
        if (bl4 && d5 <= 0.0) {
            d5 = this.holeValue;
        }
        double d6 = chartDataViewSeries2.getY(n3);
        if (bl5 && d6 <= 0.0) {
            d6 = this.holeValue;
        }
        plotPointArray[0].valid = false;
        plotPointArray[1].valid = false;
        this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
        if (plotPointArray[0].valid && plotPointArray[1].valid) {
            graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
            if (defineShape != null) {
                if (!this.inverted) {
                    n5 = (int)plotPointArray[0].px;
                    n6 = (int)plotPointArray[0].py;
                    n7 = (int)plotPointArray[1].py;
                } else {
                    n5 = (int)plotPointArray[0].py;
                    n6 = (int)plotPointArray[0].px;
                    n7 = (int)plotPointArray[1].px;
                }
                if (!plotPointArray[0].drawPoint) {
                    chartDataViewSeries = null;
                }
                if (!plotPointArray[1].drawPoint) {
                    chartDataViewSeries2 = null;
                }
            }
        }
        int n9 = !this.xaxis.i_vertical && !this.xaxis.isReversed() || this.xaxis.i_vertical && this.xaxis.isReversed() ? 1 : -1;
        ChartDataViewSeries chartDataViewSeries3 = null;
        int n10 = Integer.MAX_VALUE;
        if (n4 > 0 && bl2) {
            chartDataViewSeries3 = list.get(n8);
            double d7 = chartDataViewSeries3.getX(n3);
            if (bl4 && d7 <= 0.0) {
                d7 = this.holeValue;
            }
            d2 = chartDataViewSeries3.getY(n3);
            if (bl5 && d2 <= 0.0) {
                d2 = this.holeValue;
            }
            if (d7 != this.holeValue && d2 != this.holeValue) {
                int n11 = this.xaxis.toPixel(d7, this.drawFront);
                d3 = this.xaxis.toData(n11 - n9 * n4, this.drawFront);
                d4 = d2;
                d5 = bl ? this.xaxis.toData(n11 + n9 * n4, this.drawFront) : d7;
                d6 = d2;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    if (this.xaxis.hasTimeExclusions()) {
                        if (this.inverted) {
                            if (plotPointArray[0].py == 2.147483647E9 || plotPointArray[0].py == Double.MAX_VALUE) {
                                plotPointArray[0].py = n11 - n9 * n4;
                            }
                            if (plotPointArray[1].py == 2.147483647E9 || plotPointArray[1].py == Double.MAX_VALUE) {
                                plotPointArray[1].py = bl ? (double)(n11 + n9 * n4) : (double)n11;
                            }
                        } else {
                            if (plotPointArray[0].px == 2.147483647E9 || plotPointArray[0].px == Double.MAX_VALUE) {
                                plotPointArray[0].px = n11 - n9 * n4;
                            }
                            if (plotPointArray[1].px == 2.147483647E9 || plotPointArray[1].px == Double.MAX_VALUE) {
                                plotPointArray[1].px = bl ? (double)(n11 + n9 * n4) : (double)n11;
                            }
                        }
                    }
                    graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                    if (defineShape != null) {
                        n10 = !this.inverted ? (int)plotPointArray[0].py : (int)plotPointArray[0].px;
                        if (!plotPointArray[0].drawPoint && !plotPointArray[1].drawPoint) {
                            chartDataViewSeries3 = null;
                        }
                    }
                }
            }
        }
        ++n8;
        ChartDataViewSeries chartDataViewSeries4 = null;
        int n12 = Integer.MAX_VALUE;
        if (n4 > 0 && bl3) {
            chartDataViewSeries4 = list.get(n8);
            d2 = chartDataViewSeries4.getX(n3);
            if (bl4 && d2 <= 0.0) {
                d2 = this.holeValue;
            }
            double d8 = chartDataViewSeries4.getY(n3);
            if (bl5 && d8 <= 0.0) {
                d8 = this.holeValue;
            }
            if (d2 != this.holeValue && d8 != this.holeValue) {
                int n13 = this.xaxis.toPixel(d2, this.drawFront);
                d3 = bl ? this.xaxis.toData(n13 - n9 * n4, this.drawFront) : d2;
                d4 = d8;
                d5 = this.xaxis.toData(n13 + n9 * n4, this.drawFront);
                d6 = d8;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    if (this.xaxis.hasTimeExclusions()) {
                        if (this.inverted) {
                            if (plotPointArray[0].py == 2.147483647E9 || plotPointArray[0].py == Double.MAX_VALUE) {
                                double d9 = plotPointArray[0].py = bl ? (double)(n13 - n9 * n4) : (double)n13;
                            }
                            if (plotPointArray[1].py == 2.147483647E9 || plotPointArray[1].py == Double.MAX_VALUE) {
                                plotPointArray[1].py = n13 + n9 * n4;
                            }
                        } else {
                            if (plotPointArray[0].px == 2.147483647E9 || plotPointArray[0].px == Double.MAX_VALUE) {
                                double d10 = plotPointArray[0].px = bl ? (double)(n13 - n9 * n4) : (double)n13;
                            }
                            if (plotPointArray[1].px == 2.147483647E9 || plotPointArray[1].px == Double.MAX_VALUE) {
                                plotPointArray[1].px = n13 + n9 * n4;
                            }
                        }
                    }
                    graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                    if (defineShape != null) {
                        n12 = !this.inverted ? (int)plotPointArray[0].py : (int)plotPointArray[0].px;
                        if (!plotPointArray[0].drawPoint && !plotPointArray[1].drawPoint) {
                            chartDataViewSeries4 = null;
                        }
                    }
                }
            }
        }
        if (defineShape != null) {
            this.defineHLOCShapes(defineShape, graphics2D, this.inverted, n3, chartDataViewSeries, chartDataViewSeries2, chartDataViewSeries3, chartDataViewSeries4, n6, n7, n10, n12, n5, n4);
        }
    }

    protected void defineHLOCShapes(DefineShape defineShape, Graphics2D graphics2D, boolean bl, int n2, ChartDataViewSeries chartDataViewSeries, ChartDataViewSeries chartDataViewSeries2, ChartDataViewSeries chartDataViewSeries3, ChartDataViewSeries chartDataViewSeries4, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        if (n3 == Integer.MAX_VALUE || n4 == Integer.MAX_VALUE || n5 == Integer.MAX_VALUE || n6 == Integer.MAX_VALUE || n7 == Integer.MAX_VALUE) {
            return;
        }
        if (n8 < 5) {
            n8 = 5;
        }
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[4];
        int[] nArray = new int[4];
        for (n11 = 0; n11 < 4; ++n11) {
            n10 = Integer.MAX_VALUE;
            n9 = 0;
            if (n3 != Integer.MAX_VALUE && n3 < n10) {
                n10 = n3;
                n9 = 1;
            }
            if (n4 != Integer.MAX_VALUE && n4 < n10) {
                n10 = n4;
                n9 = 2;
            }
            if (n5 != Integer.MAX_VALUE && n5 < n10) {
                n10 = n5;
                n9 = 3;
            }
            if (n6 != Integer.MAX_VALUE && n6 < n10) {
                n10 = n6;
                n9 = 4;
            }
            nArray[n11] = n10;
            if (n9 == 1) {
                chartDataViewSeriesArray[n11] = chartDataViewSeries;
                n3 = Integer.MAX_VALUE;
                continue;
            }
            if (n9 == 2) {
                chartDataViewSeriesArray[n11] = chartDataViewSeries2;
                n4 = Integer.MAX_VALUE;
                continue;
            }
            if (n9 == 3) {
                chartDataViewSeriesArray[n11] = chartDataViewSeries3;
                n5 = Integer.MAX_VALUE;
                continue;
            }
            if (n9 != 4) continue;
            chartDataViewSeriesArray[n11] = chartDataViewSeries4;
            n6 = Integer.MAX_VALUE;
        }
        n11 = Integer.MAX_VALUE;
        for (n10 = 0; n10 < nArray.length && nArray[n10] != Integer.MAX_VALUE; ++n10) {
            n9 = nArray[n10];
            int n12 = n10 == 0 ? n9 : n11;
            int n13 = n10 + 1 < nArray.length && nArray[n10 + 1] != Integer.MAX_VALUE ? nArray[n10 + 1] : nArray[n10];
            int n14 = n11 = n10 + 1 < nArray.length && chartDataViewSeriesArray[n10 + 1] != null ? n9 + (n13 - n9) / 2 : n13;
            if (chartDataViewSeriesArray[n10] != null) {
                if (n11 <= n12) continue;
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeriesArray[n10]));
                if (!bl) {
                    graphics2D.fillRect(n7 - n8, n12, n8 * 2 + 1, n11 - n12);
                } else {
                    graphics2D.fillRect(n12, n7 - n8, n11 - n12, n8 * 2 + 1);
                }
                defineShape.endShape(false);
                continue;
            }
            n11 = n9;
        }
    }

    @Override
    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        Point2D.Double double_ = new Point2D.Double(n3, n4);
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        boolean bl3 = this.hlocf.isShowingOpen();
        boolean bl4 = this.hlocf.isShowingClose();
        boolean bl5 = this.hlocf.isOpenCloseFullWidth();
        this.usePercentageWidth = this.hlocf.getOpenCloseWidthMode() == 2;
        boolean bl6 = n2 == 1;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        int n7 = !this.xaxis.i_vertical && !this.xaxis.isReversed() || this.xaxis.i_vertical && this.xaxis.isReversed() ? -1 : 1;
        Rectangle rectangle2 = this.chartArea.getPlotRect();
        int n8 = this.inverted ? rectangle2.height : rectangle2.width;
        rectangle2 = new Rectangle(rectangle2);
        rectangle2.setSize(rectangle2.width + 1, rectangle2.height + 1);
        int n9 = this.seriesList.size() / 4;
        int n10 = 0;
        int n11 = n9;
        int n12 = Integer.MAX_VALUE;
        int n13 = Integer.MAX_VALUE;
        try {
            for (int i2 = n10; i2 < n11; ++i2) {
                int n14;
                int n15;
                Object object;
                int n16 = this.hlocf.getTickSize(i2);
                boolean bl7 = true;
                boolean bl8 = true;
                int n17 = Integer.MAX_VALUE;
                int n18 = Integer.MAX_VALUE;
                int n19 = 4 * i2;
                int n20 = 4 * i2;
                int n21 = 0;
                while (n21 < 4) {
                    object = (ChartDataViewSeries)this.seriesList.get(n20);
                    if (!((ChartDataViewSeries)object).isVisible()) {
                        bl8 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)object).maxXIndex() == 0 || ((ChartDataViewSeries)object).maxYIndex() == 0) {
                        bl7 = false;
                        break;
                    }
                    n17 = Math.min(n17, ((ChartDataViewSeries)object).getFirstPoint());
                    n18 = Math.min(n18, ((ChartDataViewSeries)object).getLastPoint());
                    ++n21;
                    ++n20;
                }
                if (!bl7 || !bl8) continue;
                if (this.usePercentageWidth) {
                    n20 = 0;
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n19);
                    for (int i3 = n17; i3 <= n18; ++i3) {
                        double d5 = chartDataViewSeries.getX(i3);
                        if (this.xaxis.isValueExcluded(d5)) continue;
                        ++n20;
                    }
                    if (n20 == 0) continue;
                    n16 = this.hlocf.percentageWidth * n8 / (200 * n20);
                }
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n19 + 0);
                double[] dArray = chartDataViewSeries.getX();
                object = chartDataViewSeries.getY();
                ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n19 + 1);
                double[] dArray2 = chartDataViewSeries2.getX();
                double[] dArray3 = chartDataViewSeries2.getY();
                ChartDataViewSeries chartDataViewSeries3 = (ChartDataViewSeries)this.seriesList.get(n19 + 2);
                double[] dArray4 = chartDataViewSeries3.getX();
                double[] dArray5 = chartDataViewSeries3.getY();
                ChartDataViewSeries chartDataViewSeries4 = (ChartDataViewSeries)this.seriesList.get(n19 + 3);
                double[] dArray6 = chartDataViewSeries4.getX();
                double[] dArray7 = chartDataViewSeries4.getY();
                double d6 = Double.MAX_VALUE;
                Object object2 = Double.MAX_VALUE;
                double d7 = Double.MAX_VALUE;
                double d8 = Double.MAX_VALUE;
                boolean bl9 = false;
                for (n15 = n17; n15 <= n18; ++n15) {
                    double d9;
                    int n22;
                    int n23;
                    double d10 = dArray[n15];
                    Object object3 = object[n15];
                    double d11 = dArray2[n15];
                    double d12 = dArray3[n15];
                    double d13 = dArray4[n15];
                    double d14 = dArray5[n15];
                    double d15 = dArray6[n15];
                    double d16 = dArray7[n15];
                    boolean bl10 = !this.isHoleValue(d13, bl) && !this.isHoleValue(d14, bl2) && !this.isHoleValue(d15, bl) && !this.isHoleValue(d16, bl2);
                    n12 = this.xaxis.toPixel(d10, this.drawFront);
                    if (n12 == Integer.MAX_VALUE) continue;
                    double d17 = Double.MAX_VALUE;
                    double d18 = Double.MAX_VALUE;
                    if (bl10) {
                        int n24;
                        int n25;
                        int n26;
                        n23 = this.yaxis.toPixel(d14, this.drawFront);
                        int n27 = this.xaxis.toPixel(d13, this.drawFront);
                        if (bl5) {
                            n22 = n27 - n16;
                            n26 = n27 + n16;
                        } else {
                            n22 = n27 + n7 * n16;
                            n26 = n27;
                        }
                        d9 = this.calcDistanceToLine(double_, n22, n23, n26, n23, n2);
                        double d19 = Double.MAX_VALUE;
                        if (bl6) {
                            d19 = this.calcDistanceToLine(double_, n22, n23, n26, n23, 0);
                        }
                        if (d9 < d17) {
                            d17 = d9;
                        }
                        if (bl6 && d19 < d18) {
                            d18 = d19;
                        }
                        int n28 = this.yaxis.toPixel(d16, this.drawFront);
                        n27 = this.xaxis.toPixel(d15, this.drawFront);
                        if (bl5) {
                            n25 = n27 - n16;
                            n24 = n27 + n16;
                        } else {
                            n25 = n27 - n7 * n16;
                            n24 = n27;
                        }
                        double d20 = this.calcDistanceToLine(double_, n25, n28, n24, n28, n2);
                        double d21 = Double.MAX_VALUE;
                        if (bl6) {
                            d21 = this.calcDistanceToLine(double_, n25, n28, n24, n28, 0);
                        }
                        if (d20 < d17) {
                            d17 = d20;
                        }
                        if (bl6 && d21 < d18) {
                            d18 = d21;
                        }
                    }
                    n23 = this.yaxis.toPixel((double)object3, this.drawFront);
                    n22 = this.yaxis.toPixel(d12, this.drawFront);
                    double d22 = this.calcDistanceToLine(double_, n12, n23, n12, n22, n2);
                    d9 = Double.MAX_VALUE;
                    if (bl6) {
                        d9 = this.calcDistanceToLine(double_, n12, n23, n12, n22, 0);
                    }
                    if (d22 < d17) {
                        d17 = d22;
                    }
                    if (bl6 && d9 < d18) {
                        d18 = d9;
                    }
                    if (!(d17 < d2) && (d17 != d2 || bl6 && !(d18 <= d4))) continue;
                    d6 = d10;
                    object2 = object3;
                    d7 = d11;
                    d8 = d12;
                    n6 = n15;
                    d2 = d17;
                    bl9 = true;
                    if (!bl6 || !(d18 <= d4)) continue;
                    d4 = d18;
                }
                if (!bl9) continue;
                n15 = 0;
                boolean bl11 = !this.isHoleValue(dArray2[n6], bl) && !this.isHoleValue(dArray3[n6], bl2) && !this.isHoleValue(dArray[n6], bl) && !this.isHoleValue((double)object[n6], bl2);
                boolean bl12 = !this.isHoleValue(dArray4[n6], bl) && !this.isHoleValue(dArray5[n6], bl2);
                boolean bl13 = !this.isHoleValue(dArray6[n6], bl) && !this.isHoleValue(dArray7[n6], bl2);
                int n29 = n14 = bl11 ? 0 : 2;
                block14: while (n14 < 4) {
                    double d23;
                    boolean bl14;
                    switch (n14) {
                        case 0: {
                            n12 = this.xaxis.toPixel(d6, this.drawFront);
                            n13 = this.yaxis.toPixel((double)object2, this.drawFront);
                            break;
                        }
                        case 1: {
                            n12 = this.xaxis.toPixel(d7, this.drawFront);
                            n13 = this.yaxis.toPixel(d8, this.drawFront);
                            break;
                        }
                        case 2: {
                            if (!bl3 || !bl12 || n16 == 0) {
                                ++n14;
                                continue block14;
                            }
                            if (n15 == 0) {
                                n12 = this.xaxis.toPixel(dArray4[n6], this.drawFront);
                                if (bl5) {
                                    n12 -= n7 * n16;
                                }
                                n13 = this.yaxis.toPixel(dArray5[n6], this.drawFront);
                                n15 = 1;
                                break;
                            }
                            n12 = this.xaxis.toPixel(dArray4[n6], this.drawFront) + n7 * n16;
                            n15 = 0;
                            break;
                        }
                        case 3: {
                            if (!bl4 || !bl13 || n16 == 0) {
                                ++n14;
                                continue block14;
                            }
                            if (n15 == 0) {
                                n12 = this.xaxis.toPixel(dArray6[n6], this.drawFront);
                                if (bl5) {
                                    n12 += n7 * n16;
                                }
                                n13 = this.yaxis.toPixel(dArray7[n6], this.drawFront);
                                n15 = 1;
                                break;
                            }
                            n12 = this.xaxis.toPixel(dArray6[n6], this.drawFront) - n7 * n16;
                            n15 = 0;
                        }
                    }
                    boolean bl15 = bl14 = this.inverted ? rectangle2.contains(n13, n12) : rectangle2.contains(n12, n13);
                    if (!bl14) {
                        if (n15 != 0) continue;
                        ++n14;
                        continue;
                    }
                    switch (n2) {
                        default: 
                    }
                    double d24 = d23 = this.inverted ? Math.sqrt((n13 - n3) * (n13 - n3) + (n12 - n4) * (n12 - n4)) : Math.sqrt((n12 - n3) * (n12 - n3) + (n13 - n4) * (n13 - n4));
                    if (d3 > d23) {
                        n5 = n19 + n14;
                        d3 = d23;
                    }
                    if (n15 != 0) continue;
                    ++n14;
                }
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            JCChart jCChart = (JCChart)this.chartArea.getParent();
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage("picking", exception);
            }
            return null;
        }
    }

    @Override
    public Point unpick(int n2, int n3) {
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4;
            int n5;
            if (this.inverted) {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                n4 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n5, n4);
        }
        return null;
    }

    @Override
    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n3 = n2 * 4;
        int n4 = jCDataIndex.seriesIndex - n3;
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d3) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d3) + this.r.y);
    }

    @Override
    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getXAxis();
        boolean bl = jCAxis.i_vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            int n4 = jCAxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront);
            this.end = bl ? new Point(n2, n4 + this.r.y) : new Point(n4 + this.r.x, n3);
        } else if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    @Override
    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().i_vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    @Override
    public int getNumSeriesPerData() {
        return 4;
    }
}

