/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.DataLabelChartDataModel;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.ImageMapChartDataModel;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.ThresholdChartDataModel;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.TimelineChartDataModel;
import com.klg.jclass.util.ImageMapInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DataHandler {
    private ChartDataView view;

    public DataHandler(ChartDataView chartDataView) {
        this.view = chartDataView;
    }

    public void reloadPoint(int n2, int n3) {
        int n4;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n5 = n4 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (chartDataModel != null && n2 >= 0 && n2 < n4) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            double[] dArray = chartDataViewSeries.getX();
            double[] dArray2 = chartDataModel.getXSeries(n2);
            if (n3 >= 0 && n3 < Math.min(dArray.length, dArray2.length)) {
                dArray[n3] = dArray2[n3];
            }
            double[] dArray3 = chartDataViewSeries.getY();
            double[] dArray4 = chartDataModel.getYSeries(n2);
            if (n3 >= 0 && n3 < Math.min(dArray3.length, dArray4.length)) {
                dArray3[n3] = dArray4[n3];
            }
            this.view.setChanged(true);
        }
    }

    public void reloadPoint(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        for (int i2 = 0; i2 < chartDataModel.getNumSeries(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            double[] dArray = chartDataViewSeries.getY();
            double[] dArray2 = chartDataModel.getYSeries(i2);
            if (n2 >= 0 && n2 < Math.min(dArray.length, dArray2.length)) {
                dArray[n2] = dArray2[n2];
            }
            if (this.view.getX() != null) continue;
            double[] dArray3 = chartDataViewSeries.getX();
            double[] dArray4 = chartDataModel.getXSeries(i2);
            if (n2 < 0 || n2 >= Math.min(dArray3.length, dArray4.length)) continue;
            dArray3[n2] = dArray4[n2];
        }
        this.view.setChanged(true);
    }

    public void reloadXSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = chartDataModel.getNumSeries();
        if (n2 >= 0 && n2 < n3) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            if (this.view.getX() == null) {
                chartDataViewSeries.setX(chartDataModel.getXSeries(n2));
            } else {
                double[] dArray = chartDataModel.getXSeries(0);
                this.view.setX(dArray);
                for (int i2 = 0; i2 < n3; ++i2) {
                    chartDataViewSeries = this.view.getSeries(i2);
                    chartDataViewSeries.setX(dArray);
                }
            }
            this.view.setChanged(true);
        }
    }

    public void reloadSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        if (n2 >= 0 && n2 < chartDataModel.getNumSeries()) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            double[] dArray = chartDataModel.getYSeries(n2);
            chartDataViewSeries.setY(dArray);
            if (this.view.getX() == null) {
                double[] dArray2 = chartDataModel.getXSeries(n2);
                chartDataViewSeries.setX(dArray2);
            }
            this.view.setChanged(true);
        }
    }

    public void reloadAllSeries() {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        for (int i2 = 0; i2 < chartDataModel.getNumSeries(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            double[] dArray = chartDataModel.getYSeries(i2);
            chartDataViewSeries.setY(dArray);
            if (this.view.getX() != null) continue;
            double[] dArray2 = chartDataModel.getXSeries(i2);
            chartDataViewSeries.setX(dArray2);
        }
        this.view.setChanged(true);
    }

    public void addSeries() {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n2 = this.view.getNumSeries();
        double[] dArray = chartDataModel.getXSeries(n2);
        double[] dArray2 = chartDataModel.getYSeries(n2);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
        this.view.addSeries(chartDataViewSeries);
        this.reloadSeriesLabel(n2);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void insertSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = this.view.getNumSeries();
        if (n2 >= n3) {
            return;
        }
        double[] dArray = chartDataModel.getXSeries(n2);
        double[] dArray2 = chartDataModel.getYSeries(n2);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = this.view.addSeries(n2);
        chartDataViewSeries.setX(dArray);
        chartDataViewSeries.setY(dArray2);
        this.reloadSeriesLabel(n2);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void removeSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = this.view.getNumSeries();
        if (n2 >= n3) {
            return;
        }
        this.view.removeSeries(n2);
    }

    public void removeAllSeries() {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n2 = this.view.getNumSeries();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.view.removeSeries(i2);
        }
    }

    public void reloadAllPointLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            this.view.setPointLabels(new Vector<String>());
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        Vector<Object> vector = stringArray == null ? new Vector() : new Vector<String>(Arrays.asList(stringArray));
        this.view.setPointLabels(vector);
    }

    public void reloadPointLabel(int n2) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        if (stringArray != null) {
            if (n2 == -1) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.view.setPointLabel(i2, stringArray[i2]);
                }
            } else if (n2 >= 0 && n2 < stringArray.length) {
                this.view.setPointLabel(n2, stringArray[n2]);
            }
        }
    }

    public void reloadAllSeriesLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < this.view.getNumSeries() && i2 < stringArray.length; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            chartDataViewSeries.setLabel(stringArray[i2]);
        }
    }

    public void reloadSeriesLabel(int n2) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray != null && n2 < stringArray.length && n2 < this.view.getNumSeries()) {
            this.view.getSeries(n2).setLabel(stringArray[n2]);
        }
    }

    public void reloadDataSourceName() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)this.view.getDataSource());
            this.view.setName(labelledChartDataModel.getDataSourceName());
        }
    }

    public void reloadHoleValue() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof HoleValueChartDataModel) {
            HoleValueChartDataModel holeValueChartDataModel = (HoleValueChartDataModel)((Object)this.view.getDataSource());
            this.view.setHoleValue(holeValueChartDataModel.getHoleValue());
        }
    }

    public void appendData() {
        this.refreshData(this.view.getDataSource());
    }

    public void reset() {
        this.loadData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadTimelineStates();
        this.reloadAllPointLabels();
        this.reloadAllSeriesLabels();
        this.reloadAllTrackLabels();
        this.reloadAllDataLabels();
        this.reloadDataSourceName();
        this.reloadAllDataThresholds();
        this.loadImageMapInfo();
    }

    public void reload() {
        this.refreshData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadAllPointLabels();
        this.reloadAllSeriesLabels();
        this.reloadAllTrackLabels();
        this.reloadAllDataLabels();
    }

    public void changeChartType(int n2) {
        this.view.setChartType(n2);
    }

    public void loadData(ChartDataModel chartDataModel) {
        int n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        Vector<ChartDataViewSeries> vector = null;
        if (chartDataModel != null) {
            vector = new Vector<ChartDataViewSeries>(n2);
        }
        List<ChartDataViewSeries> list = this.view.getSeries();
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        if (chartDataModel != null && n2 != 0) {
            int n3 = 0;
            this.view.setX(chartDataModel.getXSeries(0));
            for (int i2 = 0; i2 < n2; ++i2) {
                ChartDataViewSeries chartDataViewSeries;
                double[] dArray = chartDataModel.getXSeries(i2);
                double[] dArray2 = chartDataModel.getYSeries(i2);
                if (dArray2 != null && n3 < dArray2.length) {
                    n3 = dArray2.length;
                }
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                if (i2 < list.size()) {
                    chartDataViewSeries = list.get(i2);
                    chartDataViewSeries.setX(dArray);
                    chartDataViewSeries.setY(dArray2);
                } else {
                    chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
                    chartDataViewSeries.setDrawingOrder(i2);
                }
                vector.add(chartDataViewSeries);
            }
        } else {
            this.view.setX(null);
        }
        this.view.setSeries(vector);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void reloadDataThresholds(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (!(chartDataModel instanceof ThresholdChartDataModel)) {
            return;
        }
        ThresholdChartDataModel thresholdChartDataModel = (ThresholdChartDataModel)((Object)chartDataModel);
        if (n2 >= 0 && n2 < chartDataModel.getNumSeries()) {
            this.replaceDataThresholds(this.view.getSeries(n2), thresholdChartDataModel.getDataThreshold(n2));
            this.view.setChanged(true);
        }
    }

    public void reloadAllDataThresholds() {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (!(chartDataModel instanceof ThresholdChartDataModel)) {
            return;
        }
        ThresholdChartDataModel thresholdChartDataModel = (ThresholdChartDataModel)((Object)chartDataModel);
        for (int i2 = 0; i2 < this.view.getNumSeries(); ++i2) {
            this.replaceDataThresholds(this.view.getSeries(i2), thresholdChartDataModel.getDataThreshold(i2));
        }
        this.view.setChanged(true);
    }

    protected void replaceDataThresholds(ChartDataViewSeries chartDataViewSeries, JCDataThreshold[] jCDataThresholdArray) {
        if (chartDataViewSeries == null) {
            return;
        }
        int n2 = chartDataViewSeries.getNumDataThresholds();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            chartDataViewSeries.removeDataThreshold(i2);
        }
        if (jCDataThresholdArray != null) {
            for (JCDataThreshold jCDataThreshold : jCDataThresholdArray) {
                chartDataViewSeries.addDataThreshold(jCDataThreshold);
            }
        }
    }

    protected void reloadDataLabels(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (!(chartDataModel instanceof DataLabelChartDataModel)) {
            return;
        }
        if (n2 >= 0 && n2 < chartDataModel.getNumSeries()) {
            DataLabelChartDataModel dataLabelChartDataModel = (DataLabelChartDataModel)((Object)chartDataModel);
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            chartDataViewSeries.setDataLabels(dataLabelChartDataModel.getDataLabel(n2));
            this.view.setChanged(true);
        }
    }

    protected void reloadAllDataLabels() {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n3 = n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (n2 == 0) {
            return;
        }
        DataLabelChartDataModel dataLabelChartDataModel = null;
        if (chartDataModel instanceof DataLabelChartDataModel) {
            dataLabelChartDataModel = (DataLabelChartDataModel)((Object)chartDataModel);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            String[] stringArray = null;
            if (dataLabelChartDataModel != null) {
                stringArray = dataLabelChartDataModel.getDataLabel(i2);
            }
            chartDataViewSeries.setDataLabels(stringArray);
        }
    }

    public void reloadAllTrackLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof TimelineChartDataModel)) {
            return;
        }
        TimelineChartDataModel timelineChartDataModel = (TimelineChartDataModel)((Object)chartDataModel);
        String[] stringArray = timelineChartDataModel.getTrackLabels();
        if (stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < this.view.getNumSeries() && i2 < stringArray.length; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            chartDataViewSeries.setTrackLabel(stringArray[i2]);
        }
    }

    public void reloadTrackLabel(int n2) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof TimelineChartDataModel)) {
            return;
        }
        TimelineChartDataModel timelineChartDataModel = (TimelineChartDataModel)((Object)chartDataModel);
        String[] stringArray = timelineChartDataModel.getTrackLabels();
        if (stringArray != null && n2 < stringArray.length && n2 < this.view.getNumSeries()) {
            this.view.getSeries(n2).setTrackLabel(stringArray[n2]);
        }
    }

    public void reloadTimelineStates() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof TimelineChartDataModel)) {
            return;
        }
        TimelineChartDataModel timelineChartDataModel = (TimelineChartDataModel)((Object)chartDataModel);
        TimeLineState[] timeLineStateArray = timelineChartDataModel.getTimelineStates();
        if (timeLineStateArray == null) {
            return;
        }
        this.view.setTimeLineStates(Arrays.asList(timeLineStateArray));
    }

    public void loadPointImageMapInfo() {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n3 = n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (n2 == 0) {
            return;
        }
        ImageMapChartDataModel imageMapChartDataModel = null;
        if (chartDataModel instanceof ImageMapChartDataModel) {
            imageMapChartDataModel = (ImageMapChartDataModel)((Object)chartDataModel);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            ImageMapInfo[] imageMapInfoArray = null;
            if (imageMapChartDataModel != null) {
                imageMapInfoArray = imageMapChartDataModel.getPointImageMapInfo(i2);
            }
            chartDataViewSeries.setPointImageMapInfo(imageMapInfoArray);
        }
    }

    public void loadClusterImageMapInfo() {
        ChartDataModel chartDataModel = this.view.getDataSource();
        ImageMapChartDataModel imageMapChartDataModel = null;
        if (chartDataModel instanceof ImageMapChartDataModel) {
            imageMapChartDataModel = (ImageMapChartDataModel)((Object)chartDataModel);
        }
        ImageMapInfo[] imageMapInfoArray = null;
        if (imageMapChartDataModel != null) {
            imageMapInfoArray = imageMapChartDataModel.getClusterImageMapInfo();
        }
        this.view.setClusterImageMapInfo(imageMapInfoArray);
    }

    public void loadSeriesImageMapInfo() {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n3 = n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (n2 == 0) {
            return;
        }
        ImageMapChartDataModel imageMapChartDataModel = null;
        if (chartDataModel instanceof ImageMapChartDataModel) {
            imageMapChartDataModel = (ImageMapChartDataModel)((Object)chartDataModel);
        }
        ImageMapInfo[] imageMapInfoArray = null;
        if (imageMapChartDataModel != null) {
            imageMapInfoArray = imageMapChartDataModel.getSeriesImageMapInfo();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            ImageMapInfo imageMapInfo = imageMapInfoArray == null || i2 >= imageMapInfoArray.length ? null : imageMapInfoArray[i2];
            chartDataViewSeries.setSeriesImageMapInfo(imageMapInfo);
        }
    }

    public void loadLegendImageMapInfo() {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n3 = n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (n2 == 0) {
            return;
        }
        ImageMapChartDataModel imageMapChartDataModel = null;
        if (chartDataModel instanceof ImageMapChartDataModel) {
            imageMapChartDataModel = (ImageMapChartDataModel)((Object)chartDataModel);
        }
        ImageMapInfo[] imageMapInfoArray = null;
        if (imageMapChartDataModel != null) {
            imageMapInfoArray = imageMapChartDataModel.getLegendImageMapInfo();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
            ImageMapInfo imageMapInfo = imageMapInfoArray == null || i2 >= imageMapInfoArray.length ? null : imageMapInfoArray[i2];
            chartDataViewSeries.setLegendImageMapInfo(imageMapInfo);
        }
    }

    public void loadImageMapInfo() {
        this.loadPointImageMapInfo();
        this.loadClusterImageMapInfo();
        this.loadSeriesImageMapInfo();
        this.loadLegendImageMapInfo();
    }

    public void refreshData(ChartDataModel chartDataModel) {
        int n2;
        int n3 = n2 = this.view == null ? 0 : this.view.getNumSeries();
        if (chartDataModel != null && n2 != 0) {
            this.view.setX(chartDataModel.getXSeries(0));
            for (int i2 = 0; i2 < n2; ++i2) {
                double[] dArray = chartDataModel.getXSeries(i2);
                double[] dArray2 = chartDataModel.getYSeries(i2);
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                ChartDataViewSeries chartDataViewSeries = this.view.getSeries(i2);
                chartDataViewSeries.setX(dArray);
                chartDataViewSeries.setY(dArray2);
            }
        } else if (this.view != null) {
            this.view.setX(null);
        }
    }

    public boolean editPoint(int n2, int n3, double d2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof EditableChartDataModel)) {
            return false;
        }
        EditableChartDataModel editableChartDataModel = (EditableChartDataModel)chartDataModel;
        return editableChartDataModel.setDataItem(n2, n3, d2);
    }
}

