/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.CircularChartAxisHandler;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.LogAxisHandler;
import com.klg.jclass.chart.LogAxisScaleHandler;
import java.awt.Dimension;
import java.awt.Point;

class CircularChartLogAxisHandler
extends CircularChartAxisHandler
implements LogAxisHandler {
    CircularChartLogAxisHandler() {
        this.axisScaleHandler = new LogAxisScaleHandler();
    }

    protected double getScaledValue(double d2) {
        double d3 = this.parent.isReversed() ? this.scale * (-JCChartUtil.log10(d2) + JCChartUtil.log10(this.parent.max.value)) : this.scale * (JCChartUtil.log10(d2) - JCChartUtil.log10(this.parent.min.value));
        return d3;
    }

    protected JCDataCoord toDataPolar(int n2, int n3) {
        double d2 = (double)n2 - this.parent.polarAxisParams.xCenter;
        double d3 = (double)n3 - this.parent.polarAxisParams.yCenter;
        JCAxis jCAxis = this.getRadialAxis();
        if (jCAxis == null) {
            return null;
        }
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = jCAxis.isReversed() ? JCChartUtil.log10(jCAxis.max.value) - d4 / -this.scale : d4 / this.scale + JCChartUtil.log10(jCAxis.min.value);
        double d6 = Math.pow(10.0, d5);
        double d7 = this.calcThetaAngle(d2, d3);
        return new JCDataCoord(d7, d6);
    }

    protected Point toPixelPolar(double d2, double d3, boolean bl) {
        JCDataCoord jCDataCoord;
        double d4;
        JCAxis jCAxis;
        if (bl) {
            JCAxis jCAxis2 = jCAxis = this.parent.i_vertical ? this.parent : this.parent.otherAxis;
            d3 = jCAxis.isReversed() ? (d3 > 0.0 && jCAxis.max.value > 0.0 ? JCChartUtil.log10(jCAxis.max.value) - JCChartUtil.log10(d3) : 0.0) : (d3 > 0.0 && jCAxis.min.value > 0.0 ? JCChartUtil.log10(d3) - JCChartUtil.log10(jCAxis.min.value) : 0.0);
        }
        JCAxis jCAxis3 = jCAxis = this.parent.i_vertical ? this.parent.otherAxis : this.parent;
        if (jCAxis.isReversed()) {
            d2 *= -1.0;
        }
        int n2 = (d4 = (jCDataCoord = this.toScreenLocationPolar(d2, d3, bl)).getX()) < this.parent.polarAxisParams.xCenter ? (int)Math.ceil(d4) : (int)Math.round(d4);
        d4 = jCDataCoord.getY();
        int n3 = d4 < this.parent.polarAxisParams.yCenter ? (int)Math.ceil(d4) : (int)Math.round(d4);
        return new Point(n2, n3);
    }

    protected void calcParams() {
        int n2;
        int n3;
        int n4;
        if (!this.parent.i_vertical) {
            return;
        }
        double d2 = this.parent.dataLimits == null ? 1.0 : this.parent.dataLimits.min;
        double d3 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        int n5 = 0;
        int n6 = 0;
        d2 = this.parent.min.isDefault ? d2 : this.parent.min.value;
        d3 = this.parent.max.isDefault ? d3 : this.parent.max.value;
        int n7 = JCChartUtil.ifloor(JCChartUtil.precCorrect(10, JCChartUtil.log10(d2)));
        int n8 = JCChartUtil.iceil(JCChartUtil.log10(d3));
        do {
            this.calcPrecision();
        } while (this.axisScaleHandler.fixBounds());
        if (this.parent.i_vertical) {
            if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
                n4 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
                if (n4 < n7 && this.parent.min.isDefault) {
                    n7 = n4;
                }
                if (n4 > n8 && this.parent.max.isDefault) {
                    n8 = n4;
                }
            }
        } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
            n4 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
            if (n4 < n7 && this.parent.min.isDefault) {
                n7 = n4;
            }
            if (n4 > n8 && this.parent.max.isDefault) {
                n8 = n4;
            }
        }
        n4 = 0;
        Dimension dimension = new Dimension();
        int n9 = (int)Math.round(this.parent.polarAxisParams.radius);
        for (n3 = 1; n3 <= 5; ++n3) {
            n5 = n7;
            n6 = n8;
            int n10 = n2 = JCChartUtil.abs(n6) > JCChartUtil.abs(n5) ? 1 : 0;
            while ((n6 - n5) % n3 != 0) {
                if (n2 != 0) {
                    ++n6;
                } else {
                    --n5;
                }
                n2 = n2 == 0 ? 1 : 0;
            }
            if (this.parent.annotationRotation == 4) {
                n4 = this.calcRotatedAnnoSpacing(n5, n6);
            } else {
                this.getAnnoExtent(dimension, n6, this.parent.getPrecision());
                this.getAnnoExtent(dimension, n5, this.parent.getPrecision());
                if (this.parent.i_vertical) {
                    n4 = this.parent.annotationRotation == 0 ? dimension.height * 2 : dimension.width + dimension.width / 2;
                } else {
                    int n11 = n4 = this.parent.annotationRotation == 0 ? dimension.width + dimension.width / 2 : dimension.height * 2;
                }
            }
            if ((n6 - n5) / n3 * n4 < n9) break;
        }
        if (n3 <= 5) {
            this.parent.tickSpacing.value = JCChartUtil.pow10(n3);
        } else {
            n5 = n7;
            n6 = n8;
            n2 = Math.max(n6 - n5, 1);
            this.parent.tickSpacing.value = JCChartUtil.pow10(n2);
        }
        this.parent.numSpacing.value = this.parent.tickSpacing.value;
        if (this.parent.min.isDefault) {
            this.parent.min.value = JCChartUtil.pow10(n5);
        }
        if (this.parent.max.isDefault) {
            this.parent.max.value = JCChartUtil.pow10(n6);
        }
        if (this.parent.i_vertical) {
            this.parent.origin.value = this.parent.max.value;
        }
        if (this.parent.i_vertical) {
            this.parent.setSize(n4 + 1 + this.parent.tickLength / 2, this.parent.getHeight());
        } else {
            this.parent.setSize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
        }
    }

    protected void calcTransformation() {
        if (!this.parent.i_vertical) {
            return;
        }
        int n2 = (int)Math.rint(this.parent.polarAxisParams.radius);
        this.computeTransformation(JCChartUtil.log10(this.parent.min.value), JCChartUtil.log10(this.parent.max.value), n2);
    }
}

