/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.CircularChartAxisHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCGrid;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.LinearAxisHandler;
import com.klg.jclass.chart.LinearAxisScaleHandler;
import com.klg.jclass.chart.LinearAxisUtil;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PolarAxisParams;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.List;
import java.util.Vector;

class CircularChartLinearAxisHandler
extends CircularChartAxisHandler
implements LinearAxisHandler {
    CircularChartLinearAxisHandler() {
        this.axisScaleHandler = new LinearAxisScaleHandler();
    }

    protected double getScaledValue(double d2) {
        return this.scale * (d2 - this.parent.min.value);
    }

    protected JCDataCoord toDataPolar(int n2, int n3) {
        double d2 = (double)n2 - this.parent.polarAxisParams.xCenter;
        double d3 = (double)n3 - this.parent.polarAxisParams.yCenter;
        JCAxis jCAxis = this.getRadialAxis();
        if (jCAxis == null) {
            return null;
        }
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = jCAxis.isReversed() ? jCAxis.max.value - d4 / -this.scale : d4 / this.scale + jCAxis.min.value;
        double d6 = this.calcThetaAngle(d2, d3);
        return new JCDataCoord(d6, d5);
    }

    protected Point toPixelPolar(double d2, double d3, boolean bl) {
        JCAxis jCAxis;
        if (bl) {
            d3 = this.parent.isPolar() ? this.polarSubtractMinimum(d3) : this.radarSubtractMinimum(d3);
        }
        JCAxis jCAxis2 = jCAxis = this.parent.i_vertical ? this.parent.otherAxis : this.parent;
        if (jCAxis.isReversed()) {
            d2 *= -1.0;
        }
        JCDataCoord jCDataCoord = this.toScreenLocationPolar(d2, d3, bl);
        double d4 = jCDataCoord.getX();
        PolarAxisParams polarAxisParams = this.parent.polarAxisParams;
        int n2 = d4 < polarAxisParams.xCenter ? (int)Math.ceil(d4) : (int)Math.round(d4);
        d4 = jCDataCoord.getY();
        int n3 = d4 < polarAxisParams.yCenter ? (int)Math.ceil(d4) : (int)Math.round(d4);
        return new Point(n2, n3);
    }

    private double polarSubtractMinimum(double d2) {
        JCAxis jCAxis;
        JCAxis jCAxis2 = jCAxis = this.parent.i_vertical ? this.parent : this.parent.otherAxis;
        if (jCAxis.isReversed()) {
            d2 = jCAxis.max.value - d2;
        } else {
            boolean bl = jCAxis.dataLimits.min < 0.0;
            d2 -= bl ? -jCAxis.min.value : jCAxis.min.value;
        }
        return d2;
    }

    private double radarSubtractMinimum(double d2) {
        JCAxis jCAxis;
        JCAxis jCAxis2 = jCAxis = this.parent.i_vertical ? this.parent : this.parent.otherAxis;
        d2 = jCAxis.isReversed() ? jCAxis.max.value - d2 : (d2 -= jCAxis.min.value);
        return d2;
    }

    private void setDefaultThetaMinMax() {
        if (!this.parent.i_vertical) {
            int n2 = this.parent.chartArea.getAngleUnit();
            double d2 = this.parent.isHalfRange() ? JCChartUtil.convertAngle(2, n2, -Math.PI) : 0.0;
            double d3 = this.parent.isHalfRange() ? Math.PI : Math.PI * 2;
            d3 = JCChartUtil.convertAngle(2, n2, d3);
            this.parent.setMinIsDefault(true);
            this.parent.setMaxIsDefault(true);
            LinearAxisUtil.setAxisMinMax(this.parent, d2, d3, d2, d3);
        }
    }

    protected void calcParams() {
        JCGrid jCGrid;
        List<JCGrid> list;
        double d2;
        int n2;
        double d3;
        int n3;
        double d4;
        boolean bl;
        double d5;
        double d6;
        MinMax minMax = this.parent.dataLimits;
        double d7 = minMax == null ? 0.0 : minMax.min;
        double d8 = minMax == null ? 100.0 : minMax.max;
        double d9 = Double.MAX_VALUE;
        if (this.parent.i_vertical) {
            d9 = this.parent.isReversed() ? (minMax == null ? 100.0 : minMax.max) : Math.max(Math.abs(d7), Math.abs(d8));
        }
        JCChartArea jCChartArea = this.parent.chartArea;
        if (!this.parent.i_vertical) {
            d6 = 0.0;
            d5 = JCChartUtil.convertAngle(2, jCChartArea.getAngleUnit(), Math.PI * 2);
        } else {
            double d10 = d7;
            if (this.parent.chartType == 2 && !this.parent.isReversed() && d10 < 0.0) {
                d10 = 0.0;
            }
            d6 = d10;
            d5 = d9;
        }
        boolean bl2 = bl = this.parent.chartType == 2;
        if (bl && this.parent.i_vertical && !this.parent.isReversed()) {
            if (d5 < 0.0) {
                d4 = d6;
                d6 = Math.abs(d5);
                d5 = Math.abs(d4);
            } else {
                d4 = Math.abs(d6);
                if (d4 > d5) {
                    d5 = d4;
                }
                if (d6 < 0.0) {
                    d6 = 0.0;
                }
            }
        }
        d4 = d5;
        double d11 = d6;
        double d12 = this.parent.numSpacing.value;
        double d13 = this.parent.tickSpacing.value;
        if (!this.parent.i_vertical) {
            this.setDefaultThetaMinMax();
        } else if (bl) {
            if (this.parent.min.value < 0.0 && !this.parent.isReversed()) {
                this.parent.min.value = 0.0;
                this.parent.setMinIsDefault(true);
            } else if (this.parent.min.value > d7) {
                this.parent.min.value = d7 < 0.0 && !this.parent.isReversed() ? 0.0 : d7;
                this.parent.setMinIsDefault(true);
            } else if (d7 < 0.0 && d8 < 0.0 && !this.parent.isReversed()) {
                this.parent.min.value = 0.0;
                this.parent.setMinIsDefault(true);
            }
            if (this.parent.max.value < d9) {
                this.parent.max.value = d9;
                this.parent.setMaxIsDefault(true);
            }
        } else {
            if (this.parent.min.value > d7) {
                this.parent.min.value = d7;
                this.parent.setMinIsDefault(true);
            }
            if (this.parent.max.value < d8) {
                this.parent.max.value = d8;
                this.parent.setMaxIsDefault(true);
            }
        }
        do {
            this.calcPrecision();
        } while (this.axisScaleHandler.fixBounds());
        double d14 = d4;
        double d15 = d11;
        int n4 = this.parent.getPrecision();
        d11 = JCChartUtil.precFloor(n4, d6);
        d4 = JCChartUtil.precCeil(n4, d5);
        if (d4 <= d11) {
            n4 = this.parent.getPrecision();
            if (this.parent.max.isDefault) {
                do {
                    d4 = d11 + JCChartUtil.pow10(-n4);
                    --n4;
                } while (d4 <= d11);
            } else {
                do {
                    d11 = d4 - JCChartUtil.pow10(-n4);
                    --n4;
                } while (d4 <= d11);
            }
        }
        d11 = this.parent.min.isDefault ? d11 : this.parent.min.value;
        d4 = this.parent.max.isDefault ? d4 : this.parent.max.value;
        double d16 = this.calcOrigin(d11, d4);
        double d17 = this.parent.min.isDefault ? JCChartUtil.min(d11, d16) : d11;
        double d18 = this.parent.max.isDefault ? JCChartUtil.max(d4, d16) : d4;
        boolean bl3 = false;
        PolarAxisParams polarAxisParams = this.parent.polarAxisParams;
        if (this.parent.i_vertical) {
            for (n3 = 0; n3 < 2 && !bl3; ++n3) {
                double d19 = LinearAxisUtil.calcMinUsed(this.parent, d11, d16);
                double d20 = LinearAxisUtil.calcMaxUsed(this.parent, d4, d16);
                d11 = d19;
                d4 = d20;
                d3 = 0.5 * JCChartUtil.pow10(-this.parent.getPrecision() - 1);
                d12 = this.parent.numSpacing.value;
                d13 = this.parent.tickSpacing.value;
                int n5 = this.calcMaxAnnoSize(d11, d4);
                if (this.parent.numSpacing.isDefault && this.parent.tickSpacing.isDefault) {
                    double d21;
                    double d22;
                    n2 = 0;
                    if (this.parent.i_vertical) {
                        if (this.useAnnoWidthForRAxisTickCalculation()) {
                            n2 = n5 == 0 ? 0 : (int)polarAxisParams.radius / (n5 + 2);
                        } else {
                            d22 = JCChartUtil.boundAngle(2, this.parent.yAxisAngle + polarAxisParams.originBase);
                            d21 = Math.sin(d22) * polarAxisParams.radius;
                            n2 = n5 == 0 ? 0 : (int)Math.abs(d21) / (n5 + 2);
                        }
                    }
                    d22 = JCChartUtil.abs(d20 - d19);
                    if (n2 <= 0) {
                        d12 = 1.0;
                        d13 = 1.0;
                    } else {
                        d21 = d22 / (double)n2;
                        DoubleCoord doubleCoord = JCChartUtil.calcTik(d21, this.parent.getPrecision());
                        d13 = doubleCoord.x;
                        d12 = doubleCoord.y;
                    }
                } else if (this.parent.tickSpacing.isDefault) {
                    d12 = JCChartUtil.precCorrect(this.parent.getPrecision(), d12);
                    d13 = this.parent.numSpacing.value / 2.0;
                } else if (this.parent.numSpacing.isDefault) {
                    d12 = 2.0 * d13;
                    d12 = JCChartUtil.precCorrect(this.parent.getPrecision(), d12);
                }
                if (d12 != 0.0) {
                    d11 = LinearAxisUtil.updateMinValue(d11, d16, d12);
                    if (JCChartUtil.abs((d4 = LinearAxisUtil.updateMaxValue(d4, d16, d12)) - d11) < d3) {
                        d4 = d11 + d12;
                    }
                } else if (JCChartUtil.abs(d4 - d11) < d3) {
                    d4 = d11 + 1.0;
                }
                if (!(JCChartUtil.abs(d11 - d19) > d3) && !(JCChartUtil.abs(d4 - d20) > d3)) continue;
                bl3 = true;
                if (d4 - d12 >= d18) {
                    d4 -= d12;
                } else {
                    bl3 = false;
                }
                if (d11 + d12 <= d17) {
                    d11 += d12;
                    continue;
                }
                bl3 = false;
            }
        } else if (bl) {
            n3 = 13;
            FontMetrics fontMetrics = this.getFontMetrics();
            if (fontMetrics != null) {
                n3 = fontMetrics.getAscent();
            }
            d2 = 4.0;
            JCAnno jCAnno = this.parent.getDefaultLabels();
            if (jCAnno != null && jCAnno.getDrawLabels()) {
                d2 = jCAnno.getLabelExtent();
            }
            d3 = polarAxisParams.radius + d2;
            double d23 = Math.acos(1.0 - 0.3 * (double)n3 / d3);
            n2 = 2 * (int)(Math.PI * 2 / d23);
            n2 = Math.max(1, n2);
            int n6 = 64;
            if (jCChartArea.getAngleUnit() == 1) {
                n6 = 144;
            } else if (jCChartArea.getAngleUnit() == 3) {
                n6 = 80;
            }
            while (n6 % n2 != 0 && n2 > 1) {
                --n2;
            }
            d13 = JCChartUtil.convertAngle(2, jCChartArea.getAngleUnit(), Math.PI * 2) / (double)n2;
            d12 = 2.0 * d13;
        }
        if (!this.parent.i_vertical && this.parent.getAnnotationMethod() == 2) {
            d4 = d5;
            d11 = d6;
            if (d4 <= d11) {
                n4 = 0;
                do {
                    d4 = d11 + JCChartUtil.pow10(n4);
                    d11 -= d4 - d11;
                    ++n4;
                } while (d4 <= d11);
            }
            d17 = d11;
            d18 = d4;
        }
        if (minMax != null && this.parent.getAnnotationMethod() == 3) {
            double d24 = d15;
            d2 = d14;
            if (this.parent.min.isDefault) {
                d24 = d6 - this.parent.step / 2.0;
            }
            if (this.parent.max.isDefault) {
                d2 = d5 + this.parent.step / 2.0;
            }
            d11 = d17 = JCChartUtil.min(d15, d24);
            d4 = d18 = JCChartUtil.max(d14, d2);
        }
        if (!this.parent.i_vertical) {
            this.setDefaultThetaMinMax();
        } else {
            LinearAxisUtil.setAxisMinMax(this.parent, d11, d4, d17, d18);
        }
        d16 = this.calcOrigin(this.parent.min.value, this.parent.max.value);
        if (this.parent.origin.isDefault) {
            this.parent.origin.value = d16;
        }
        if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = d13;
        }
        if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = d12;
        }
        if ((list = this.parent.getGridList()).size() > 0 && (jCGrid = list.get(0)) != null && jCGrid.getIncrementIsDefault()) {
            jCGrid.incrementValue.value = this.parent.numSpacing.value;
        }
    }

    private boolean useAnnoWidthForRAxisTickCalculation() {
        double d2 = JCChartUtil.getAngleRatio(2, this.parent.yAxisAngle, this.parent.polarAxisParams.originBase);
        return d2 < 0.125 || d2 > 0.875 || d2 > 0.375 && d2 < 0.625;
    }

    private int calcMaxAnnoSize(double d2, double d3) {
        Dimension dimension = new Dimension();
        if (this.parent.getAnnotationRotation() == 4 && this.parent.getAnnotationMethod() != 0) {
            dimension = this.parent.getAnnotationHandler().getMaxRotatedAnnoDimensions();
        } else {
            this.getAnnoExtent(dimension, d3, this.parent.getPrecision());
            this.getAnnoExtent(dimension, d2, this.parent.getPrecision());
        }
        int n2 = this.useAnnoWidthForRAxisTickCalculation() ? dimension.width : dimension.height;
        return n2;
    }

    protected void calcTransformation() {
        if (!this.parent.i_vertical) {
            return;
        }
        int n2 = (int)Math.rint(this.parent.polarAxisParams.radius);
        this.computeTransformation(this.parent.min.value, this.parent.max.value, n2);
    }

    public void makeTickLabels(JCAnno jCAnno) {
        super.makeTickLabels(jCAnno);
        PolarAxisParams polarAxisParams = this.parent.getPolarAxisParams();
        if (this.parent.isPolar() && !this.parent.i_vertical && polarAxisParams != null && !polarAxisParams.isPolarHalfRange()) {
            Vector<JCValueLabel> vector = this.parent.getAnnotations();
            int n2 = this.parent.getAnnotationHandler().getMaxVisibleLabel();
            if (n2 >= 0 && n2 < vector.size()) {
                JCValueLabel jCValueLabel = (JCValueLabel)vector.get(n2);
                double d2 = JCChartUtil.convertAngle(this.parent.chartArea.getAngleUnit(), 2, jCValueLabel.value);
                d2 = JCChartUtil.precCorrect(5, d2);
                double d3 = JCChartUtil.precCorrect(5, Math.PI * 2);
                jCValueLabel.label.visible = d2 != d3;
            }
        }
    }
}

