/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public class ChartRegion
extends JComponent
implements Changeable,
Serializable {
    protected boolean updateParent = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected Dimension preferredSize = null;
    protected CellRendererPane cellRendererPane = null;

    public ChartRegion() {
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
    }

    public ChartRegion(JCChart jCChart) {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
    }

    public JCFillStyle getFillStyle() {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.isOpaque()) {
            JCFillStyle jCFillStyle;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
            if (renderProperties != null) {
                object = GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
            }
            Rectangle rectangle = this.getBounds();
            Color color = this.getBackground();
            if (color != null) {
                if (!graphics.getColor().equals(color)) {
                    graphics.setColor(color);
                }
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if ((jCFillStyle = this.getFillStyle()) != null) {
                Insets insets = this.getInsets();
                int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
                jCFillStyle.updateAnchorRect(rectangle2);
                jCFillStyle.fillRect(graphics, insets.left, insets.top, n2, n3);
                jCFillStyle.updateAnchorRect(null);
            }
            if (renderProperties != null && object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public void setChanged(boolean bl, int n2) {
        if (bl != this.getChanged() || !this.getChanged(n2)) {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
        if (bl && this.getParent() != null && this.updateParent) {
            this.updateParent(n2);
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
    }

    public void updateParent(int n2) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                jCChart.invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n2 & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }

    public boolean isBatched() {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n2 = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }
}

