/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCName;
import com.klg.jclass.util.JCUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartDataViewSeries
implements Serializable,
JCName,
LegendEntry {
    protected ChartDataView parent = null;
    private double[] xvalues;
    private double[] yvalues;
    private double[] yCalcValues = null;
    private String[] dataLabels = null;
    private String trackLabel = null;
    protected int firstPoint;
    protected DerivedInt lastPoint = new DerivedInt(0, true);
    protected String name;
    protected int drawingOrder = -1;
    protected boolean visible = true;
    protected boolean visibleInLegend = true;
    protected boolean included = true;
    protected String label;
    protected ImageMapInfo[] pointImageMapInfo;
    protected ImageMapInfo seriesImageMapInfo;
    protected ImageMapInfo legendImageMapInfo;
    protected Locale locale = Locale.getDefault();
    protected List<JCDataThreshold> dataThresholds = new Vector<JCDataThreshold>();
    protected boolean dataThresholdEntireValue = false;
    protected static int dataViewSeriesNum = 0;

    void init(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        if (this.dataThresholds.size() > 0) {
            for (JCDataThreshold jCDataThreshold : this.dataThresholds) {
                if (jCDataThreshold == null) continue;
                jCDataThreshold.setParent(chartDataView);
            }
        }
        this.setLocale(this.parent.getLocale());
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
        this.name = JCChartBundle.string("com.klg.jclass.chart.Key27", this.locale) + ++dataViewSeriesNum;
    }

    public ChartDataViewSeries() {
        this.parent = null;
        this.xvalues = null;
        this.yvalues = null;
    }

    ChartDataViewSeries(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.setLocale(this.parent.getLocale());
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
    }

    protected void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    public void editPoint(int n2, double d2) {
        if (this.parent.editPoint(this, n2, d2)) {
            this.yvalues[n2] = d2;
            this.yCalcValues = null;
            this.parent.setChanged(true, 2);
        }
    }

    public int getFirstPoint() {
        if (this.firstPoint == Integer.MAX_VALUE && this.getX() != null && this.getY() != null) {
            this.firstPoint = 0;
        }
        return this.firstPoint;
    }

    public void setFirstPoint(int n2) {
        if (n2 < 0 || n2 > this.maxIndex()) {
            throw new IllegalArgumentException("FirstPoint value does not address a point in the data series");
        }
        if (this.firstPoint == n2) {
            return;
        }
        this.firstPoint = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public int getLastPoint() {
        if (this.getX() == null || this.getY() == null) {
            return -1;
        }
        this.checkLastPoint();
        return this.lastPoint.value;
    }

    public boolean getLastPointIsDefault() {
        return this.lastPoint.isDefault;
    }

    public void setLastPoint(int n2) {
        if (n2 < 0 || n2 > this.maxIndex()) {
            throw new IllegalArgumentException("LastPoint value does not address a point in the data series");
        }
        if (this.lastPoint.value == n2) {
            return;
        }
        this.lastPoint.value = n2;
        this.lastPoint.isDefault = false;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLastPointIsDefault(boolean bl) {
        this.lastPoint.isDefault = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    private void checkLastPoint() {
        int n2 = this.maxIndex();
        if (this.lastPoint.value > n2) {
            this.lastPoint.value = n2;
        } else if (this.lastPoint.isDefault) {
            this.lastPoint.value = n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public ChartDataView getParent() {
        return this.parent;
    }

    public JCChartStyle getStyle() {
        if (this.parent == null) {
            return null;
        }
        int n2 = this.parent.getSeriesIndex(this);
        if (n2 < 0) {
            return null;
        }
        return this.parent.getChartStyle(n2);
    }

    public void setStyle(JCChartStyle jCChartStyle) {
        if (this.parent == null) {
            return;
        }
        int n2 = this.parent.getSeriesIndex(this);
        this.parent.setChartStyle(n2, jCChartStyle);
    }

    public JCChartStyle getHoleStyle() {
        if (this.parent == null) {
            return null;
        }
        int n2 = this.parent.getSeriesIndex(this);
        if (n2 < 0) {
            return null;
        }
        return this.parent.getHoleStyle(n2);
    }

    public void setHoleStyle(JCChartStyle jCChartStyle) {
        if (this.parent == null) {
            return;
        }
        int n2 = this.parent.getSeriesIndex(this);
        this.parent.setHoleStyle(n2, jCChartStyle);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int n2) {
        if (this.drawingOrder == n2) {
            return;
        }
        this.drawingOrder = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 17);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl == this.visible) {
            return;
        }
        this.visible = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    @Override
    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.visibleInLegend) {
            return;
        }
        this.visibleInLegend = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    @Override
    public int getDrawType() {
        boolean bl;
        if (this.parent == null) {
            return 0;
        }
        int n2 = this.parent.getChartType();
        boolean bl2 = n2 == 9 || n2 == 10;
        boolean bl3 = n2 == 8 || n2 == 12 || n2 == 4;
        boolean bl4 = bl = n2 == 11;
        if (bl2 || bl3 || bl) {
            return 1;
        }
        return 4;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean bl) {
        if (bl == this.included) {
            return;
        }
        this.included = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLabel(String string) {
        if (this.label == null ? string == null : this.label.equals(string)) {
            return;
        }
        this.label = string;
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            this.label = JCChartBundle.string("com.klg.jclass.chart.Key127", this.locale) + (this.drawingOrder + 1);
        }
        return this.label;
    }

    public List<JCDataThreshold> getDataThresholds() {
        return this.dataThresholds;
    }

    public JCDataThreshold getDataThreshold(int n2) {
        if (n2 < 0 || n2 >= this.dataThresholds.size()) {
            throw new IllegalArgumentException("Invalid data threshold index");
        }
        return this.dataThresholds.get(n2);
    }

    public int getNumDataThresholds() {
        return this.dataThresholds.size();
    }

    public void addDataThreshold(JCDataThreshold jCDataThreshold) {
        if (jCDataThreshold == null) {
            return;
        }
        jCDataThreshold.setParent(this.parent);
        jCDataThreshold.setSeries(this);
        this.dataThresholds.add(jCDataThreshold);
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public void addDataThreshold(int n2, JCDataThreshold jCDataThreshold) {
        if (jCDataThreshold == null) {
            return;
        }
        if (n2 < 0 || n2 > this.dataThresholds.size()) {
            throw new IllegalArgumentException("Invalid data threshold index");
        }
        jCDataThreshold.setParent(this.parent);
        jCDataThreshold.setSeries(this);
        this.dataThresholds.add(n2, jCDataThreshold);
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public void removeDataThreshold(JCDataThreshold jCDataThreshold) {
        if (jCDataThreshold == null) {
            return;
        }
        this.dataThresholds.remove(jCDataThreshold);
        jCDataThreshold.setParent(null);
        jCDataThreshold.setSeries(null);
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public JCDataThreshold removeDataThreshold(int n2) {
        if (n2 < 0 || n2 >= this.dataThresholds.size()) {
            throw new IllegalArgumentException("Invalid data threshold index");
        }
        JCDataThreshold jCDataThreshold = this.dataThresholds.remove(n2);
        if (jCDataThreshold != null) {
            jCDataThreshold.setParent(null);
            jCDataThreshold.setSeries(null);
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
        return jCDataThreshold;
    }

    public void removeAllDataThresholds() {
        for (JCDataThreshold jCDataThreshold : this.dataThresholds) {
            if (jCDataThreshold == null) continue;
            jCDataThreshold.setParent(null);
            jCDataThreshold.setSeries(null);
        }
        this.dataThresholds.clear();
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public boolean isDataThresholdEntireValue() {
        return this.dataThresholdEntireValue;
    }

    public void setDataThresholdEntireValue(boolean bl) {
        this.dataThresholdEntireValue = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public ImageMapInfo[] getPointImageMapInfo() {
        return this.pointImageMapInfo;
    }

    public void setPointImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.pointImageMapInfo = imageMapInfoArray;
    }

    public ImageMapInfo getSeriesImageMapInfo() {
        return this.seriesImageMapInfo;
    }

    public void setSeriesImageMapInfo(ImageMapInfo imageMapInfo) {
        this.seriesImageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getLegendImageMapInfo() {
        return this.legendImageMapInfo;
    }

    public void setLegendImageMapInfo(ImageMapInfo imageMapInfo) {
        this.legendImageMapInfo = imageMapInfo;
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key143", this.locale) : string;
    }

    public int maxXIndex() {
        double[] dArray;
        int n2 = 0;
        if (this.parent != null && (dArray = this.parent.getX()) != null) {
            n2 = dArray.length;
        }
        return this.xvalues == null ? n2 : this.xvalues.length;
    }

    public int maxYIndex() {
        return this.yvalues == null ? 0 : this.yvalues.length;
    }

    public int maxIndex() {
        return Math.max(0, Math.min(this.maxXIndex(), this.maxYIndex()) - 1);
    }

    protected void getXMinMax(MinMax minMax) {
        if (minMax == null || this.parent == null) {
            return;
        }
        JCAxis jCAxis = this.parent.getXAxis();
        boolean bl = jCAxis != null && jCAxis.isLogarithmic() && !jCAxis.isPolar() && !jCAxis.isRadar();
        double[] dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
        double d2 = this.parent.getHoleValue();
        if (dArray != null) {
            for (double d3 : dArray) {
                if (jCAxis != null && jCAxis.skipValue(d3, d2)) continue;
                minMax.setMinMax(d3, d2, bl);
            }
        }
    }

    protected void calcStep(ChartDataView chartDataView) {
        double[] dArray;
        if (chartDataView == null) {
            return;
        }
        double[] dArray2 = dArray = this.xvalues == null ? chartDataView.getX() : this.xvalues;
        if (dArray == null || dArray.length == 0) {
            return;
        }
        JCAxis jCAxis = chartDataView.getXAxis();
        double d2 = chartDataView.getHoleValue();
        double d3 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d4;
            double d5 = dArray[i2];
            if (jCAxis != null) {
                if (jCAxis.skipValue(d3, d2)) {
                    d3 = d5;
                    continue;
                }
                if (jCAxis.skipValue(d5, d2)) continue;
            }
            if ((d4 = d5 - d3) < 0.0) {
                d4 = -d4;
            }
            if (d4 < chartDataView.step && d4 != 0.0) {
                chartDataView.step = d4;
            }
            d3 = d5;
        }
        if (chartDataView.step == Double.MAX_VALUE) {
            chartDataView.step = 1.0;
        }
    }

    protected void getYMinMax(MinMax minMax) {
        block6: {
            boolean bl;
            double[] dArray;
            double d2;
            JCAxis jCAxis;
            block5: {
                if (minMax == null || this.parent == null) {
                    return;
                }
                jCAxis = this.parent.getXAxis();
                JCAxis jCAxis2 = this.parent.getYAxis();
                d2 = this.parent.getHoleValue();
                double[] dArray2 = dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
                if (dArray == null) {
                    return;
                }
                boolean bl2 = bl = jCAxis2 != null && jCAxis2.isLogarithmic();
                if (this.parent.getChartType() != 8 || jCAxis == null || jCAxis2 == null) break block5;
                JCAreaChartFormat jCAreaChartFormat = (JCAreaChartFormat)this.parent.getChartFormat(8);
                this.yCalcValues = jCAreaChartFormat.getCalculatedYValues(this, jCAxis, jCAxis2, d2);
                if (this.yCalcValues == null) {
                    return;
                }
                int n2 = Math.min(this.yCalcValues.length, dArray.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (jCAxis.skipValue(dArray[i2], d2)) continue;
                    minMax.setMinMax(this.yCalcValues[i2], d2, bl);
                }
                break block6;
            }
            if (this.yvalues == null) break block6;
            int n3 = Math.min(this.yvalues.length, dArray.length);
            for (int i3 = 0; i3 < n3; ++i3) {
                if (jCAxis != null && jCAxis.skipValue(dArray[i3], d2)) continue;
                minMax.setMinMax(this.yvalues[i3], d2, bl);
            }
        }
    }

    public double getX(int n2) {
        double[] dArray;
        if (this.parent == null) {
            return Double.MAX_VALUE;
        }
        double d2 = this.parent.getHoleValue();
        double[] dArray2 = dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
        if (n2 >= 0 && n2 < dArray.length) {
            d2 = dArray[n2];
        }
        return d2;
    }

    public double getY(int n2) {
        if (this.parent == null) {
            return Double.MAX_VALUE;
        }
        double d2 = this.parent.getHoleValue();
        if (n2 >= 0 && n2 < this.yvalues.length) {
            d2 = this.yvalues[n2];
        }
        return d2;
    }

    public double getCalculatedY(int n2) {
        boolean bl;
        if (this.parent == null) {
            return Double.MAX_VALUE;
        }
        int n3 = this.parent.getChartType();
        JCAxis jCAxis = this.parent.getYAxis();
        boolean bl2 = jCAxis != null && jCAxis.isLogarithmic();
        boolean bl3 = bl = n3 == 8 || n3 == 12;
        if (!bl || !this.isYHole(n2, bl2)) {
            return this.getY(n2);
        }
        JCChartStyle jCChartStyle = this.getHoleStyle();
        if (jCChartStyle == null || jCChartStyle.getFillStyle() == null) {
            return this.getY(n2);
        }
        double d2 = this.parent.getHoleValue();
        if (this.yCalcValues == null) {
            JCAreaChartFormat jCAreaChartFormat = (JCAreaChartFormat)this.parent.getChartFormat();
            this.yCalcValues = jCAreaChartFormat.getCalculatedYValues(this, this.parent.getXAxis(), jCAxis, d2);
        }
        double d3 = d2;
        if (n2 >= 0 && n2 < this.yCalcValues.length) {
            d3 = this.yCalcValues[n2];
        }
        return d3;
    }

    protected double[] getX() {
        return this.xvalues == null ? (Object)(this.parent == null ? null : this.parent.getX()) : this.xvalues;
    }

    protected double[] getY() {
        return this.yvalues;
    }

    public double[] getXArrayCopy() {
        if (this.xvalues == null) {
            return null;
        }
        double[] dArray = new double[this.xvalues.length];
        System.arraycopy(this.xvalues, 0, dArray, 0, this.xvalues.length);
        return dArray;
    }

    public double[] getYArrayCopy() {
        if (this.yvalues == null) {
            return null;
        }
        double[] dArray = new double[this.yvalues.length];
        System.arraycopy(this.yvalues, 0, dArray, 0, this.yvalues.length);
        return dArray;
    }

    protected void setX(double[] dArray) {
        this.xvalues = dArray;
        this.checkLastPoint();
    }

    protected void setY(double[] dArray) {
        this.yvalues = dArray;
        this.yCalcValues = null;
        this.checkLastPoint();
    }

    public int getX(double d2) {
        return this.getPoint(d2, this.getX());
    }

    public int getY(double d2) {
        return this.getPoint(d2, this.yvalues);
    }

    protected int getPoint(double d2, double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        double d3 = Double.MAX_VALUE;
        int n2 = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d4 = Math.abs(dArray[i2] - d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            n2 = i2;
        }
        return n2;
    }

    protected boolean hasYHoles(double d2, boolean bl) {
        if (this.yvalues == null) {
            return false;
        }
        for (double d3 : this.yvalues) {
            if (d3 != d2 && (!bl || !(d3 <= 0.0))) continue;
            return true;
        }
        return false;
    }

    protected boolean isYHole(int n2, boolean bl) {
        if (this.yvalues == null || n2 < 0 || n2 >= this.yvalues.length) {
            return false;
        }
        double d2 = this.parent == null ? Double.MAX_VALUE : this.parent.getHoleValue();
        double d3 = this.yvalues[n2];
        return d3 == d2 || bl && d3 <= 0.0;
    }

    protected double[] getNormalizedYValues(boolean bl, boolean bl2) {
        double d2;
        double d3 = d2 = this.parent == null ? Double.MAX_VALUE : this.parent.getHoleValue();
        if (!this.hasYHoles(d2, bl)) {
            return bl2 ? this.getYArrayCopy() : this.yvalues;
        }
        double[] dArray = new double[this.yvalues.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.yvalues[i2] == d2 || bl && this.yvalues[i2] <= 0.0 ? Double.MAX_VALUE : this.yvalues[i2];
        }
        return dArray;
    }

    public String[] getDataLabels() {
        return this.dataLabels;
    }

    public String getDataLabel(int n2) {
        String string = null;
        if (this.dataLabels != null && n2 >= 0 && n2 < this.dataLabels.length) {
            string = this.dataLabels[n2];
        }
        return string;
    }

    public void setDataLabels(String[] stringArray) {
        this.dataLabels = stringArray;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public String getTrackLabel() {
        return this.trackLabel;
    }

    public void setTrackLabel(String string) {
        this.trackLabel = string;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    protected int booleanHashCode(boolean bl) {
        return bl ? 1231 : 1237;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.booleanHashCode(this.visible);
        n2 = 37 * n2 + this.booleanHashCode(this.visibleInLegend);
        n2 = 37 * n2 + this.booleanHashCode(this.included);
        n2 = 37 * n2 + this.booleanHashCode(this.dataThresholdEntireValue);
        n2 = 37 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 37 * n2 + (this.label == null ? 0 : this.label.hashCode());
        n2 = 37 * n2 + (this.trackLabel == null ? 0 : this.trackLabel.hashCode());
        n2 = 37 * n2 + Arrays.hashCode(this.getX());
        n2 = 37 * n2 + Arrays.hashCode(this.getY());
        n2 = 37 * n2 + Arrays.hashCode(this.yCalcValues);
        n2 = 37 * n2 + Arrays.hashCode(this.dataLabels);
        n2 = 37 * n2 + Arrays.hashCode(this.pointImageMapInfo);
        n2 = 37 * n2 + (this.seriesImageMapInfo == null ? 0 : this.seriesImageMapInfo.hashCode());
        n2 = 37 * n2 + (this.legendImageMapInfo == null ? 0 : this.legendImageMapInfo.hashCode());
        n2 = 37 * n2 + ((Object)this.dataThresholds).hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        ChartDataViewSeries chartDataViewSeries;
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass()) && (this == (chartDataViewSeries = (ChartDataViewSeries)object) || this.visible == chartDataViewSeries.isVisible() && this.visibleInLegend == chartDataViewSeries.isVisibleInLegend() && this.included == chartDataViewSeries.isIncluded() && this.dataThresholdEntireValue == chartDataViewSeries.isDataThresholdEntireValue() && this.drawingOrder == chartDataViewSeries.getDrawingOrder() && this.firstPoint == chartDataViewSeries.getFirstPoint() && this.lastPoint.value == chartDataViewSeries.getLastPoint() && this.lastPoint.isDefault == chartDataViewSeries.getLastPointIsDefault() && this.parent == chartDataViewSeries.getParent() && JCUtil.equalStrings(this.name, chartDataViewSeries.getName()) && JCUtil.equalStrings(this.label, chartDataViewSeries.getLabel()) && JCUtil.equalStrings(this.trackLabel, chartDataViewSeries.getTrackLabel()) && Arrays.equals(this.getX(), chartDataViewSeries.getX()) && Arrays.equals(this.getY(), chartDataViewSeries.getY()) && Arrays.equals(this.yCalcValues, chartDataViewSeries.yCalcValues) && Arrays.equals(this.dataLabels, chartDataViewSeries.getDataLabels()) && Arrays.equals(this.pointImageMapInfo, chartDataViewSeries.getPointImageMapInfo()) && ImageMapInfo.equalImageMapInfo(this.seriesImageMapInfo, chartDataViewSeries.getSeriesImageMapInfo()) && ImageMapInfo.equalImageMapInfo(this.legendImageMapInfo, chartDataViewSeries.getLegendImageMapInfo()) && ((Object)this.dataThresholds).equals(chartDataViewSeries.getDataThresholds()))) {
            bl = true;
        }
        return bl;
    }
}

