/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataEvent;
import com.klg.jclass.chart.ChartDataListener;
import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.DataHandler;
import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAutoLabelGenerator;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.JCDrawableColorHandler;
import com.klg.jclass.chart.JCEnvelope;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCMarker;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.JCThreshold;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCName;
import com.klg.jclass.util.io.OutputDataProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartDataView
implements Changeable,
ChartDataListener,
Serializable,
JCName {
    protected Vector<ChartDataViewSeries> series = new Vector();
    public static final int PICK_FOCUS_LOCAL = -1;
    public static final int PICK_FOCUS_XY = 0;
    public static final int PICK_FOCUS_X = 1;
    public static final int PICK_FOCUS_Y = 2;
    public static final int PICK_FOCUS_NONE = 3;
    public static final int PICK_TOLERANCE_DEFAULT = 10;
    public static final int PICK_TOLERANCE_MAXIMUM = Integer.MAX_VALUE;
    public static final int AUTO_LABEL_TYPE_DATA_VALUES = 0;
    public static final int AUTO_LABEL_TYPE_DATA_LABELS = 1;
    public static final int AUTO_LABEL_TYPE_GENERATOR = 2;
    public static final String ERRMSG_INVALID_SERIES_INDEX = "Invalid ChartDataViewSeries index: ";
    private double[] xvalues = null;
    protected boolean batched = false;
    protected boolean fastUpdate = false;
    protected boolean bufferPlotData = true;
    protected double holeValue = Double.MAX_VALUE;
    protected int chartType = 0;
    protected String name = null;
    protected int drawingOrder = -1;
    protected boolean drawFrontPlane = true;
    protected ChartDataModel dataSource = null;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected DerivedDouble yAxisDataMinHint = new DerivedDouble(-1.7976931348623157E308, true);
    protected DerivedDouble yAxisDataMaxHint = new DerivedDouble(Double.MAX_VALUE, true);
    protected ImageMapInfo[] clusterImageMapInfo;
    protected ImageMapInfo[] pointLabelImageMapInfo;
    protected ImageMapInfo imageMapInfo;
    protected boolean inverted = false;
    protected int pickFocus = 0;
    protected int pickTolerance = 10;
    protected boolean visibleInLegend = true;
    protected boolean visibleInLegendChanged = false;
    protected boolean legendSeriesReversed = false;
    private Vector<JCChartStyle> styles = new Vector();
    private Vector<JCChartStyle> holeStyles = new Vector();
    protected boolean autoLabel = false;
    protected int autoLabelType = 0;
    protected JCAutoLabelGenerator autoLabelGenerator = null;
    protected JCLineStyle outlineStyle = null;
    protected JCDrawableColorHandler colorHandler;
    protected OutputDataProperties outputDataProperties;
    protected List<JCMarker> markers = new Vector<JCMarker>();
    protected List<JCThreshold> thresholds = new Vector<JCThreshold>();
    protected List<JCEnvelope> envelopes = new Vector<JCEnvelope>();
    protected List<String> pointLabels = new Vector<String>();
    protected List<String> shortPointLabels = new Vector<String>();
    protected List<TimeLineState> timeLineStates = new Vector<TimeLineState>();
    protected transient DataHandler dataHandler;
    private transient Object transientData = null;
    protected boolean visible = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected boolean generateAutoLabels = false;
    protected double step = 1.0;
    protected JCChart chart = null;
    protected MinMax xLimits;
    protected MinMax yLimits;
    protected Locale locale = Locale.getDefault();
    public static final String[] format_class_names = new String[]{"com.klg.jclass.chart.JCPlotChartFormat", null, "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCHiloChartFormat", "com.klg.jclass.chart.JCHLOCChartFormat", "com.klg.jclass.chart.JCCandleChartFormat", "com.klg.jclass.chart.JCAreaChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCPieChartFormat", "com.klg.jclass.chart.JCAreaChartFormat", "com.klg.jclass.chart.JCTimeLineChartFormat"};
    protected Hashtable<Integer, JCChartTypeFormat> formatClassHashtable = new Hashtable();
    protected static int dataViewNum = 0;

    ChartDataView(JCChart jCChart) {
        this(jCChart.getLocale());
        this.setParent(jCChart);
    }

    ChartDataView(Locale locale) {
        this.locale = locale;
        this.setChartType(0);
        this.name = JCChartBundle.string("com.klg.jclass.chart.Key26", locale) + ++dataViewNum;
    }

    public ChartDataView() {
        this(Locale.getDefault());
    }

    public void setParent(JCChart jCChart) {
        this.chart = jCChart;
        this.locale = this.chart.getLocale();
        JCChartArea jCChartArea = this.chart.getChartArea();
        if (this.chart != null && jCChartArea != null) {
            if (this.xaxis == null || !jCChartArea.getXAxes().contains(this.xaxis)) {
                this.xaxis = jCChartArea.getXAxis(0);
            }
            if (this.yaxis == null || !jCChartArea.getYAxes().contains(this.yaxis)) {
                this.yaxis = jCChartArea.getYAxis(0);
            }
        }
        this.setChanged(true, 2, false);
    }

    public JCChart getParent() {
        return this.chart;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.setChanged(true, 1);
    }

    public Locale getLocale() {
        return this.locale;
    }

    boolean editPoint(ChartDataViewSeries chartDataViewSeries, int n2, double d2) {
        if (this.dataSource == null) {
            return true;
        }
        if (!(this.dataSource instanceof EditableChartDataModel)) {
            return false;
        }
        int n3 = this.series.indexOf(chartDataViewSeries);
        if (n3 == -1) {
            throw new RuntimeException("Bad row in editPoint!");
        }
        return this.getDataHandler().editPoint(n3, n2, d2);
    }

    @Override
    public void chartDataChange(ChartDataEvent chartDataEvent) {
        if (chartDataEvent == null) {
            return;
        }
        int n2 = chartDataEvent.getSeriesIndex();
        int n3 = chartDataEvent.getPointIndex();
        switch (chartDataEvent.getType()) {
            case 0: {
                if (n2 == -1 && n3 == -1) {
                    this.getDataHandler().reloadAllSeries();
                    break;
                }
                if (n2 == -1) {
                    this.getDataHandler().reloadPoint(n3);
                    break;
                }
                if (n3 == -1) {
                    this.getDataHandler().reloadSeries(n2);
                    break;
                }
                this.getDataHandler().reloadPoint(n2, n3);
                break;
            }
            case 1: {
                if (n2 == -1) {
                    this.getDataHandler().reloadAllSeries();
                    break;
                }
                this.getDataHandler().reloadSeries(n2);
                break;
            }
            case 19: {
                this.getDataHandler().reloadXSeries(n2);
                break;
            }
            case 2: {
                this.getDataHandler().addSeries();
                break;
            }
            case 3: {
                if (n2 == -1) {
                    return;
                }
                this.getDataHandler().insertSeries(n2);
                break;
            }
            case 5: {
                if (n2 == -1) {
                    this.getDataHandler().removeAllSeries();
                    break;
                }
                this.getDataHandler().removeSeries(n2);
                break;
            }
            case 6: {
                this.getDataHandler().reloadAllPointLabels();
                break;
            }
            case 7: {
                if (n3 == -1) {
                    this.getDataHandler().reloadAllPointLabels();
                    break;
                }
                this.getDataHandler().reloadPointLabel(n3);
                break;
            }
            case 8: {
                this.getDataHandler().reloadAllSeriesLabels();
                break;
            }
            case 9: {
                if (n2 == -1) {
                    this.getDataHandler().reloadAllSeriesLabels();
                    break;
                }
                this.getDataHandler().reloadSeriesLabel(n2);
                break;
            }
            case 21: {
                this.getDataHandler().reloadAllDataLabels();
                break;
            }
            case 20: {
                if (n2 == -1) {
                    this.getDataHandler().reloadAllDataLabels();
                    break;
                }
                this.getDataHandler().reloadDataLabels(n2);
                break;
            }
            case 22: {
                this.getDataHandler().reloadTimelineStates();
                break;
            }
            case 23: {
                if (n2 == -1) {
                    this.getDataHandler().reloadAllTrackLabels();
                    break;
                }
                this.getDataHandler().reloadTrackLabel(n2);
                break;
            }
            case 24: {
                this.getDataHandler().reloadAllTrackLabels();
                break;
            }
            case 10: {
                this.getDataHandler().reloadDataSourceName();
                break;
            }
            case 15: {
                this.getDataHandler().reloadHoleValue();
                break;
            }
            case 11: {
                boolean bl;
                this.getDataHandler().appendData();
                if (n2 == -1 || n3 == -1) break;
                int n4 = n3;
                int n5 = n2;
                int n6 = this.getChartType();
                if (!this.fastUpdate || !this.chart.isDisplayable() || n6 != 0 && n6 != 1 && n6 != 8 || !this.checkNewPoints(n5) || !(bl = this.doFastUpdate(n4, n5))) break;
                return;
            }
            case 12: {
                this.getDataHandler().reset();
                break;
            }
            case 13: {
                this.getDataHandler().reload();
                break;
            }
            case 14: {
                int n7 = n2;
                if (n7 < 0 || n7 > 13) {
                    throw new IllegalArgumentException("Invalid chart type");
                }
                this.getDataHandler().changeChartType(n7);
                break;
            }
            case 16: {
                this.getDataHandler().loadImageMapInfo();
                break;
            }
            case 17: {
                this.getDataHandler().reloadDataThresholds(n2);
                break;
            }
            case 18: {
                this.getDataHandler().reloadAllDataThresholds();
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type: " + chartDataEvent.getType());
            }
        }
        this.setChanged(true, 34);
    }

    public boolean doFastUpdate(int n2, int n3) {
        boolean bl = false;
        JCChartArea jCChartArea = this.chart.getChartArea();
        ChartDraw chartDraw = jCChartArea.getDrawable(this);
        if (chartDraw != null) {
            Graphics graphics = null;
            try {
                chartDraw.recalc(n2, n2 + n3 - 1);
                graphics = jCChartArea.getGraphics();
                Rectangle rectangle = jCChartArea.getDrawingArea();
                graphics.translate(rectangle.x, rectangle.y);
                Rectangle rectangle2 = jCChartArea.clipForDrawing(jCChartArea.symbolPad);
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                chartDraw.draw(graphics, n2, n2 + n3 - 1);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (graphics != null) {
                graphics.dispose();
            }
        }
        if (bl) {
            this.chart.firePaint();
        }
        return bl;
    }

    public boolean checkNewPoints(int n2) {
        for (int i2 = 0; i2 < this.series.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.getSeries(i2);
            int n3 = chartDataViewSeries.maxIndex();
            for (int i3 = n3 - n2 + 1; i3 <= n3; ++i3) {
                double d2 = chartDataViewSeries.getX(i3);
                if (d2 != this.holeValue && (this.xaxis.getMaxIsDefault() && d2 > this.xaxis.getMax() || this.xaxis.getMinIsDefault() && d2 < this.xaxis.getMin())) {
                    return false;
                }
                double d3 = chartDataViewSeries.getY(i3);
                if (d3 == this.holeValue || !(this.yaxis.getMaxIsDefault() && d3 > this.yaxis.getMax()) && (!this.yaxis.getMinIsDefault() || !(d3 < this.yaxis.getMin()))) continue;
                return false;
            }
        }
        return true;
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public void setHoleValue(double d2) {
        if (this.holeValue == d2) {
            return;
        }
        this.holeValue = d2;
        this.setChanged(true, 130);
    }

    @Override
    public boolean isBatched() {
        return this.batched;
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!this.batched) {
            this.propagateChange();
        }
    }

    public boolean getFastUpdate() {
        return this.fastUpdate;
    }

    public void setFastUpdate(boolean bl) {
        if (this.fastUpdate == bl) {
            return;
        }
        this.fastUpdate = bl;
    }

    public boolean getBufferPlotData() {
        return this.bufferPlotData;
    }

    public void setBufferPlotData(boolean bl) {
        if (this.bufferPlotData == bl) {
            return;
        }
        this.bufferPlotData = bl;
    }

    private void updateAnnotationHandlers(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.updateAnnoHandler(this.chartType);
        }
    }

    private void updateAnnotationHandlers() {
        if (this.chart != null) {
            this.updateAnnotationHandlers(this.chart.getChartArea().getXAxes());
            this.updateAnnotationHandlers(this.chart.getChartArea().getYAxes());
        }
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int n2) {
        if (this.chartType == n2) {
            return;
        }
        if (this.xaxis != null && this.xaxis.annotationMethod != this.xaxis.savedAxisAnnotationMethod) {
            this.xaxis.annotationMethod = this.xaxis.savedAxisAnnotationMethod;
            this.xaxis.updateAnnoDefaultPrecision(n2);
        }
        if (this.yaxis != null && this.yaxis.annotationMethod != this.yaxis.savedAxisAnnotationMethod) {
            this.yaxis.annotationMethod = this.yaxis.savedAxisAnnotationMethod;
            this.yaxis.updateAnnoDefaultPrecision(n2);
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid chart type");
            }
        }
        switch (this.chartType) {
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                if (this.yaxis != null) {
                    this.yaxis.setVisible(true);
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis == null) break;
                this.xaxis.setVisible(true);
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                if (this.xaxis == null) break;
                this.xaxis.setChanged(true, 2, false);
            }
        }
        this.chartType = n2;
        this.updateAnnotationHandlers();
        JCChartArea jCChartArea = this.chart == null ? null : this.chart.getChartArea();
        switch (this.chartType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getOriginPlacementIsDefault() && this.yaxis.originPlacement.value != 0) {
                    this.yaxis.originPlacement.value = 0;
                    bl = true;
                }
                if (this.yaxis.getPlacementIsDefault() && this.yaxis.placement.value != 0) {
                    this.yaxis.placement.value = 0;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (!this.xaxis.getPlacementIsDefault() || this.xaxis.placement.value == 0) break;
                this.xaxis.placement.value = 0;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                int n3;
                if (this.yaxis == null || this.xaxis == null) break;
                this.xaxis.savedAxisAnnotationMethod = this.xaxis.getAnnotationMethod();
                this.xaxis.placementAxis = this.yaxis;
                boolean bl = true;
                if (jCChartArea != null) {
                    for (n3 = 0; n3 < jCChartArea.getXAxes().size(); ++n3) {
                        JCAxis jCAxis = jCChartArea.getXAxis(n3);
                        if (jCAxis.getAnnotationMethod() == 0) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    this.xaxis.annotationMethod = 3;
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.setChanged(true, 2, false);
                n3 = 0;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    n3 = 1;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    n3 = 1;
                }
                if (n3 == 0) break;
                this.yaxis.setChanged(true, 2, false);
                break;
            }
            case 8: 
            case 12: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    bl = true;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.placementAxis = this.yaxis;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 13: {
                if (this.xaxis == null) break;
                this.xaxis.savedAxisAnnotationMethod = this.xaxis.getAnnotationMethod();
                this.xaxis.annotationMethod = 2;
                break;
            }
        }
        if (this.yaxis != null && this.chartType != 13 && this.yaxis.annotationMethod == 3) {
            this.yaxis.savedAxisAnnotationMethod = this.yaxis.getAnnotationMethod();
            this.yaxis.annotationMethod = 0;
        }
        if (jCChartArea != null) {
            jCChartArea.removeDrawable(this);
        }
        this.transientData = null;
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 34);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (this.name != null && this.name.equals(string)) {
            return;
        }
        if (string != null) {
            this.name = string;
        }
        this.setChanged(true, 33);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int n2) {
        if (n2 < 0 || this.chart != null && n2 >= this.chart.getOriginalDataView().size()) {
            throw new IllegalArgumentException("DrawingOrder property for ChartDataView is out of range");
        }
        this.drawingOrder = n2;
        this.setChanged(true, 17);
    }

    public boolean getDrawFrontPlane() {
        return this.drawFrontPlane;
    }

    public void setDrawFrontPlane(boolean bl) {
        this.drawFrontPlane = bl;
        this.setChanged(true, 2);
    }

    public ChartDataModel getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ChartDataModel chartDataModel) {
        if (this.dataSource instanceof ChartDataManageable) {
            ChartDataManageable chartDataManageable = (ChartDataManageable)((Object)this.dataSource);
            chartDataManageable.getChartDataManager().removeChartDataListener(this);
        }
        this.dataSource = chartDataModel;
        if (this.dataSource == null) {
            this.series = new Vector();
            if (this.autoLabel && this.chart != null) {
                this.chart.getChartLabelManager().clearAutoLabels(this);
            }
            this.setX(null);
            this.setChanged(true, 162);
            return;
        }
        boolean bl = this.isBatched();
        this.setBatched(true);
        this.getDataHandler().reset();
        this.getDataHandler().reloadAllPointLabels();
        this.getDataHandler().reloadAllSeriesLabels();
        this.getDataHandler().reloadDataSourceName();
        if (chartDataModel instanceof ChartDataManageable) {
            ChartDataManageable chartDataManageable = (ChartDataManageable)((Object)chartDataModel);
            chartDataManageable.getChartDataManager().addChartDataListener(this);
        }
        if (!(this.dataSource instanceof EditableChartDataModel) && !(this.dataSource instanceof ChartDataManageable)) {
            this.dataSource = null;
        }
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 162, false);
        this.setBatched(bl);
    }

    public String getPointLabel(int n2) {
        if (n2 < 0 || n2 >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        return this.pointLabels.get(n2);
    }

    public void setPointLabel(int n2, String string) {
        if (n2 < 0 || n2 >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        this.pointLabels.set(n2, string);
        this.setChanged(true, 130);
    }

    public List<String> getPointLabels() {
        return this.pointLabels;
    }

    public int getNumPointLabels() {
        return this.pointLabels.size();
    }

    public void setPointLabels(List<String> list) {
        this.pointLabels = list;
        if (this.pointLabels == null) {
            this.pointLabels = new Vector<String>();
        }
        this.setChanged(true, 130);
    }

    public String getShortPointLabel(int n2) {
        if (n2 < 0 || n2 >= this.shortPointLabels.size()) {
            throw new IllegalArgumentException("Invalid short point label index");
        }
        return this.shortPointLabels.get(n2);
    }

    public void setShortPointLabel(int n2, String string) {
        if (n2 < 0 || n2 >= this.shortPointLabels.size()) {
            throw new IllegalArgumentException("Invalid short point label index");
        }
        this.shortPointLabels.set(n2, string);
        this.setChanged(true, 130);
    }

    public List<String> getShortPointLabels() {
        return this.shortPointLabels;
    }

    public int getNumShortPointLabels() {
        return this.shortPointLabels.size();
    }

    public void setShortPointLabels(List<String> list) {
        this.shortPointLabels = list;
        if (this.shortPointLabels == null) {
            this.shortPointLabels = new Vector<String>();
        }
        this.setChanged(true, 130);
    }

    public ImageMapInfo[] getPointLabelImageMapInfo() {
        return this.pointLabelImageMapInfo;
    }

    public void setPointLabelImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.pointLabelImageMapInfo = imageMapInfoArray;
    }

    public List<JCMarker> getMarkers() {
        return this.markers;
    }

    public JCMarker getMarker(int n2) {
        if (n2 < 0 || n2 >= this.markers.size()) {
            throw new IllegalArgumentException("Invalid marker index");
        }
        return this.markers.get(n2);
    }

    public int getNumMarkers() {
        return this.markers.size();
    }

    public void addMarker(JCMarker jCMarker) {
        if (jCMarker == null) {
            return;
        }
        jCMarker.dataView = this;
        this.markers.add(jCMarker);
        this.setChanged(true, 34);
    }

    public void addMarker(int n2, JCMarker jCMarker) {
        if (jCMarker == null) {
            return;
        }
        if (n2 < 0 || n2 > this.markers.size()) {
            throw new IllegalArgumentException("Invalid marker index");
        }
        jCMarker.dataView = this;
        this.markers.add(n2, jCMarker);
        this.setChanged(true, 34);
    }

    public void removeMarker(JCMarker jCMarker) {
        if (jCMarker == null) {
            return;
        }
        this.markers.remove(jCMarker);
        jCMarker.dataView = null;
        this.setChanged(true, 34);
    }

    public JCMarker removeMarker(int n2) {
        if (n2 < 0 || n2 >= this.markers.size()) {
            throw new IllegalArgumentException("Invalid marker index");
        }
        JCMarker jCMarker = this.markers.remove(n2);
        if (jCMarker != null) {
            jCMarker.dataView = null;
        }
        this.setChanged(true, 34);
        return jCMarker;
    }

    public void removeAllMarkers() {
        for (JCMarker jCMarker : this.markers) {
            if (jCMarker == null) continue;
            jCMarker.dataView = null;
        }
        this.markers.clear();
        this.setChanged(true, 34);
    }

    public List<JCThreshold> getThresholds() {
        return this.thresholds;
    }

    public JCThreshold getThreshold(int n2) {
        if (n2 < 0 || n2 >= this.thresholds.size()) {
            throw new IllegalArgumentException("Invalid threshold index");
        }
        return this.thresholds.get(n2);
    }

    public int getNumThresholds() {
        return this.thresholds.size();
    }

    public void addThreshold(JCThreshold jCThreshold) {
        if (jCThreshold == null) {
            return;
        }
        jCThreshold.setParent(this);
        this.thresholds.add(jCThreshold);
        this.setChanged(true, 34);
    }

    public void addThreshold(int n2, JCThreshold jCThreshold) {
        if (jCThreshold == null) {
            return;
        }
        if (n2 < 0 || n2 > this.thresholds.size()) {
            throw new IllegalArgumentException("Invalid threshold index");
        }
        jCThreshold.setParent(this);
        this.thresholds.add(n2, jCThreshold);
        this.setChanged(true, 34);
    }

    public void removeThreshold(JCThreshold jCThreshold) {
        if (jCThreshold == null) {
            return;
        }
        this.thresholds.remove(jCThreshold);
        jCThreshold.setParent(null);
        this.setChanged(true, 34);
    }

    public JCThreshold removeThreshold(int n2) {
        if (n2 < 0 || n2 >= this.thresholds.size()) {
            throw new IllegalArgumentException("Invalid threshold index");
        }
        JCThreshold jCThreshold = this.thresholds.remove(n2);
        if (jCThreshold != null) {
            jCThreshold.setParent(null);
        }
        this.setChanged(true, 34);
        return jCThreshold;
    }

    public void removeAllThresholds() {
        for (JCThreshold jCThreshold : this.thresholds) {
            if (jCThreshold == null) continue;
            jCThreshold.setParent(null);
        }
        this.thresholds.clear();
        this.setChanged(true, 34);
    }

    public List<JCEnvelope> getEnvelopes() {
        return this.envelopes;
    }

    public JCEnvelope getEnvelope(int n2) {
        if (n2 < 0 || n2 >= this.envelopes.size()) {
            throw new IllegalArgumentException("Invalid envelope index");
        }
        return this.envelopes.get(n2);
    }

    public int getNumEnvelopes() {
        return this.envelopes.size();
    }

    public void addEnvelope(JCEnvelope jCEnvelope) {
        if (jCEnvelope == null) {
            return;
        }
        jCEnvelope.setParent(this);
        this.envelopes.add(jCEnvelope);
        this.setChanged(true, 34);
    }

    public void addEnvelope(int n2, JCEnvelope jCEnvelope) {
        if (jCEnvelope == null) {
            return;
        }
        if (n2 < 0 || n2 > this.envelopes.size()) {
            throw new IllegalArgumentException("Invalid envelope index");
        }
        jCEnvelope.setParent(this);
        this.envelopes.add(n2, jCEnvelope);
        this.setChanged(true, 34);
    }

    public void removeEnvelope(JCEnvelope jCEnvelope) {
        if (jCEnvelope == null) {
            return;
        }
        this.envelopes.remove(jCEnvelope);
        jCEnvelope.setParent(null);
        this.setChanged(true, 34);
    }

    public JCEnvelope removeEnvelope(int n2) {
        if (n2 < 0 || n2 >= this.envelopes.size()) {
            throw new IllegalArgumentException("Invalid envelope index");
        }
        JCEnvelope jCEnvelope = this.envelopes.remove(n2);
        if (jCEnvelope != null) {
            jCEnvelope.setParent(null);
        }
        this.setChanged(true, 34);
        return jCEnvelope;
    }

    public void removeAllEnvelopes() {
        for (JCEnvelope jCEnvelope : this.envelopes) {
            if (jCEnvelope == null) continue;
            jCEnvelope.setParent(null);
        }
        this.envelopes.clear();
        this.setChanged(true, 34);
    }

    public void setTimeLineStates(List<TimeLineState> list) {
        if (this.timeLineStates != null) {
            for (TimeLineState timeLineState : this.timeLineStates) {
                if (timeLineState == null) continue;
                timeLineState.dataView = null;
            }
        }
        this.timeLineStates = list == null ? new Vector<TimeLineState>() : new Vector<TimeLineState>(list);
        for (TimeLineState timeLineState : this.timeLineStates) {
            if (timeLineState == null) continue;
            timeLineState.dataView = this;
        }
        this.setChanged(true, 34);
    }

    public List<TimeLineState> getTimeLineStates() {
        return this.timeLineStates;
    }

    public TimeLineState getTimeLineState(int n2) {
        if (n2 < 0 || n2 >= this.timeLineStates.size()) {
            throw new IllegalArgumentException("Invalid time line state index");
        }
        return this.timeLineStates.get(n2);
    }

    public int getNumTimeLineStates() {
        return this.timeLineStates.size();
    }

    public void addTimeLineState(TimeLineState timeLineState) {
        if (timeLineState == null) {
            return;
        }
        timeLineState.dataView = this;
        this.timeLineStates.add(timeLineState);
        this.setChanged(true, 34);
    }

    public void addTimeLineState(int n2, TimeLineState timeLineState) {
        if (timeLineState == null) {
            return;
        }
        if (n2 < 0 || n2 > this.timeLineStates.size()) {
            throw new IllegalArgumentException("Invalid time line state index");
        }
        timeLineState.setParent(this);
        this.timeLineStates.add(n2, timeLineState);
        this.setChanged(true, 34);
    }

    public void removeTimeLineState(TimeLineState timeLineState) {
        if (timeLineState == null) {
            return;
        }
        this.timeLineStates.remove(timeLineState);
        timeLineState.setParent(null);
        this.setChanged(true, 34);
    }

    public TimeLineState removeTimeLineState(int n2) {
        if (n2 < 0 || n2 >= this.timeLineStates.size()) {
            throw new IllegalArgumentException("Invalid time line state index");
        }
        TimeLineState timeLineState = this.timeLineStates.remove(n2);
        if (timeLineState != null) {
            timeLineState.setParent(null);
        }
        this.setChanged(true, 34);
        return timeLineState;
    }

    public void removeAllTimeLineStates() {
        for (TimeLineState timeLineState : this.timeLineStates) {
            if (timeLineState == null) continue;
            timeLineState.setParent(null);
        }
        this.timeLineStates.clear();
        this.setChanged(true, 34);
    }

    public ImageMapInfo[] getClusterImageMapInfo() {
        return this.clusterImageMapInfo;
    }

    public void setClusterImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.clusterImageMapInfo = imageMapInfoArray;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public List<ChartDataViewSeries> getSeries() {
        return new Vector<ChartDataViewSeries>(this.series);
    }

    public ChartDataViewSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX + n2 + " numSeries: " + this.series.size());
        }
        return this.series.get(n2);
    }

    public void setSeries(List<ChartDataViewSeries> list) {
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().removeAutoLabels(this);
        }
        this.series = list == null ? new Vector() : new Vector<ChartDataViewSeries>(list);
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        if (this.chart != null) {
            if (this.chartType == 11) {
                ((JCPieChartFormat)this.getChartFormat()).getOtherStyle();
            }
            for (int i2 = 0; i2 < this.series.size(); ++i2) {
                this.getChartStyle(i2);
            }
        }
        this.setChanged(true, 162);
    }

    public void setSeries(int n2, ChartDataViewSeries chartDataViewSeries) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX + n2 + " numSeries: " + this.series.size());
        }
        this.series.set(n2, chartDataViewSeries);
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 162);
    }

    public ChartDataViewSeries addSeries(int n2) {
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries();
        this.addSeries(chartDataViewSeries, n2);
        return chartDataViewSeries;
    }

    public void addSeries(ChartDataViewSeries chartDataViewSeries) {
        this.addSeries(chartDataViewSeries, this.series.size());
    }

    public void addSeries(ChartDataViewSeries chartDataViewSeries, int n2) {
        if (chartDataViewSeries == null) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.series.size()) {
            n2 = this.series.size();
        }
        chartDataViewSeries.init(chartDataViewSeries.getX(), chartDataViewSeries.getY(), this);
        chartDataViewSeries.setDrawingOrder(n2);
        this.series.add(n2, chartDataViewSeries);
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 2);
    }

    public void removeSeries(int n2) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX + n2 + " numSeries: " + this.series.size());
        }
        this.series.remove(n2);
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 2);
    }

    public int getSeriesIndex(String string) {
        for (int i2 = 0; i2 < this.series.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = this.series.get(i2);
            if (!string.equals(chartDataViewSeries.getName())) continue;
            return i2;
        }
        return -1;
    }

    public int getSeriesIndex(ChartDataViewSeries chartDataViewSeries) {
        return this.series.indexOf(chartDataViewSeries);
    }

    public JCChartTypeFormat getChartFormat() {
        return this.getChartFormat(this.chartType);
    }

    public JCChartTypeFormat getChartFormat(int n2) {
        JCChartTypeFormat jCChartTypeFormat = this.getExistingChartFormat(n2);
        if (jCChartTypeFormat != null) {
            return jCChartTypeFormat;
        }
        if (n2 == 10) {
            n2 = 9;
        } else if (n2 == 12) {
            n2 = 8;
        }
        if (n2 < 0 || n2 >= format_class_names.length) {
            return null;
        }
        String string = format_class_names[n2];
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                jCChartTypeFormat = (JCChartTypeFormat)clazz.newInstance();
                jCChartTypeFormat.setParent(this);
                this.formatClassHashtable.put(new Integer(n2), jCChartTypeFormat);
            }
            catch (Exception exception) {
                if (this.chart != null) {
                    this.chart.getErrorLog().logErrorMessage("getChartFormat", exception);
                }
                return null;
            }
        }
        return jCChartTypeFormat;
    }

    public JCChartTypeFormat getExistingChartFormat(int n2) {
        if (n2 == 10) {
            n2 = 9;
        } else if (n2 == 12) {
            n2 = 8;
        }
        if (n2 < 0 || n2 >= format_class_names.length) {
            return null;
        }
        if (format_class_names[n2] != null) {
            return this.formatClassHashtable.get(new Integer(n2));
        }
        return null;
    }

    public JCAxis getXAxis() {
        return this.xaxis;
    }

    public void setXAxis(JCAxis jCAxis) {
        if (this.xaxis == jCAxis) {
            return;
        }
        this.xaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public JCAxis getYAxis() {
        return this.yaxis;
    }

    public void setYAxis(JCAxis jCAxis) {
        if (this.yaxis == jCAxis) {
            return;
        }
        this.yaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public double getYAxisDataMinHint() {
        return this.yAxisDataMinHint.value;
    }

    public void setYAxisDataMinHint(double d2) {
        if (!this.yAxisDataMaxHint.isDefault && d2 > this.yAxisDataMaxHint.value) {
            throw new IllegalArgumentException("yAxisDataMinHint cannot be greater than yAxisDataMaxHint");
        }
        this.yAxisDataMinHint.value = d2;
        this.yAxisDataMinHint.isDefault = false;
        this.setChanged(true, 130);
    }

    public boolean getYAxisDataMinHintIsDefault() {
        return this.yAxisDataMinHint.isDefault;
    }

    public void setYAxisDataMinHintIsDefault(boolean bl) {
        if (this.yAxisDataMinHint.isDefault == bl) {
            return;
        }
        this.yAxisDataMinHint.isDefault = bl;
        this.setChanged(true, 130);
    }

    public double getYAxisDataMaxHint() {
        return this.yAxisDataMaxHint.value;
    }

    public void setYAxisDataMaxHint(double d2) {
        if (!this.yAxisDataMinHint.isDefault && d2 < this.yAxisDataMinHint.value) {
            throw new IllegalArgumentException("yAxisDataMaxHint cannot be less than yAxisDataMinHint");
        }
        this.yAxisDataMaxHint.value = d2;
        this.yAxisDataMaxHint.isDefault = false;
        this.setChanged(true, 130);
    }

    public boolean getYAxisDataMaxHintIsDefault() {
        return this.yAxisDataMaxHint.isDefault;
    }

    public void setYAxisDataMaxHintIsDefault(boolean bl) {
        if (this.yAxisDataMaxHint.isDefault == bl) {
            return;
        }
        this.yAxisDataMaxHint.isDefault = bl;
        this.setChanged(true, 130);
    }

    public JCDataCoord map(int n2, int n3) {
        Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
        Point point = this.chart.getChartArea().getLocation();
        n2 -= rectangle.x + point.x;
        n3 -= rectangle.y + point.y;
        JCDataCoord jCDataCoord = new JCDataCoord(this.holeValue, this.holeValue);
        if (this.chartType == 2 || this.chartType == 3 || this.chartType == 4) {
            if (this.yaxis != null) {
                JCDataCoord jCDataCoord2 = this.yaxis.toDataPolar(n2, n3);
                jCDataCoord.x = jCDataCoord2.getX();
                jCDataCoord.y = jCDataCoord2.getY();
            }
        } else {
            if (this.xaxis != null) {
                double d2 = jCDataCoord.x = this.xaxis.i_vertical ? this.xaxis.toData(n3) : this.xaxis.toData(n2);
            }
            if (this.yaxis != null) {
                jCDataCoord.y = this.yaxis.i_vertical ? this.yaxis.toData(n3) : this.yaxis.toData(n2);
            }
        }
        return jCDataCoord;
    }

    public Point unmap(double d2, double d3) {
        boolean bl;
        JCChartArea jCChartArea = this.chart.getChartArea();
        Rectangle rectangle = jCChartArea.getDrawingArea();
        Point point = jCChartArea.getLocation();
        Point point2 = new Point(rectangle.x + point.x, rectangle.y + point.y);
        boolean bl2 = this.chartType == 2;
        boolean bl3 = bl = this.chartType == 3 || this.chartType == 4;
        if (bl2 || bl) {
            if (this.yaxis != null) {
                double d4;
                if (bl) {
                    int n2 = ChartDataView.getNumRadarSpokes(this);
                    d4 = JCChartUtil.getRadarAngle(2, n2, d2, false);
                } else {
                    d4 = JCChartUtil.convertAngle(jCChartArea.getAngleUnit(), 2, d2);
                }
                Point point3 = this.yaxis.toPixelPolar(d4, d3, true);
                if (point3 != null) {
                    point2.x += point3.x;
                    point2.y += point3.y;
                }
            }
        } else {
            if (this.xaxis != null) {
                if (this.xaxis.i_vertical) {
                    point2.y += this.xaxis.toPixel(d2);
                } else {
                    point2.x += this.xaxis.toPixel(d2);
                }
            }
            if (this.yaxis != null) {
                if (this.yaxis.i_vertical) {
                    point2.y += this.yaxis.toPixel(d3);
                } else {
                    point2.x += this.yaxis.toPixel(d3);
                }
            }
        }
        return point2;
    }

    public JCDataCoord coordToDataCoord(int n2, int n3) {
        return this.map(n2, n3);
    }

    public Point dataCoordToCoord(double d2, double d3) {
        return this.unmap(d2, d3);
    }

    public Point dataIndexToCoord(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null) {
            return null;
        }
        return this.chart.unpick(this, jCDataIndex.point, jCDataIndex.seriesIndex);
    }

    public JCDataIndex coordToDataIndex(int n2, int n3, int n4) {
        JCChartArea jCChartArea = this.chart.getChartArea();
        Point point = jCChartArea.getLocation();
        return jCChartArea.pick(new Point(n2 - point.x, n3 - point.y), this, n4);
    }

    public JCDataIndex coordToDataSeries(int n2, int n3, int n4) {
        JCChartArea jCChartArea = this.chart.getChartArea();
        Point point = jCChartArea.getLocation();
        return jCChartArea.pickSeries(new Point(n2 - point.x, n3 - point.y), this, n4);
    }

    public boolean is3DChartType() {
        return this.chartType == 9 || this.chartType == 10;
    }

    public int getNumSeries() {
        return this.series == null ? 0 : this.series.size();
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key142", this.locale) : string;
    }

    private void calcXMinMax(MinMax minMax) {
        this.step = Double.MAX_VALUE;
        for (ChartDataViewSeries chartDataViewSeries : this.series) {
            if (!chartDataViewSeries.isIncluded()) continue;
            chartDataViewSeries.getXMinMax(minMax);
            chartDataViewSeries.calcStep(this);
        }
        if (this.step != Double.MAX_VALUE && this.step != 0.0 && this.step < this.xaxis.step) {
            this.xaxis.step = this.step;
        }
        if (this.xaxis.step == Double.MAX_VALUE) {
            this.xaxis.step = 1.0;
        }
    }

    private void calcYMinMax(MinMax minMax) {
        if (this.chartType == 13) {
            return;
        }
        for (ChartDataViewSeries chartDataViewSeries : this.series) {
            if (!chartDataViewSeries.isIncluded()) continue;
            chartDataViewSeries.getYMinMax(minMax);
        }
    }

    private void calcYMinMaxOfTotals(MinMax minMax) {
        Serializable serializable;
        Point point = this.getFirstLast();
        if (point == null) {
            return;
        }
        int n2 = this.series.size();
        JCChartTypeFormat jCChartTypeFormat = this.getChartFormat();
        Object object = null;
        if (this.chartType == 12) {
            serializable = (JCAreaChartFormat)jCChartTypeFormat;
            object = new double[n2][];
            for (int i2 = 0; i2 < n2; ++i2) {
                ChartDataViewSeries chartDataViewSeries = this.series.get(i2);
                if (!chartDataViewSeries.isIncluded()) continue;
                object[i2] = ((JCAreaChartFormat)serializable).getCalculatedYValues(chartDataViewSeries, this.xaxis, this.yaxis, this.holeValue);
            }
        }
        serializable = new MinMax();
        double d2 = this.yaxis.getOrigin();
        for (int i3 = point.x; i3 <= point.y; ++i3) {
            MinMax minMax2 = new MinMax(0.0, 0.0);
            for (int i4 = 0; i4 < n2; ++i4) {
                ChartDataViewSeries chartDataViewSeries = this.series.get(i4);
                if (!chartDataViewSeries.isIncluded() || this.xaxis.skipValue(chartDataViewSeries.getX(i3), this.holeValue)) continue;
                double d3 = this.holeValue;
                if (this.chartType == 12) {
                    if (object != null && object[i4] != null) {
                        d3 = object[i4][i3] - d2;
                    }
                } else {
                    if (chartDataViewSeries.isYHole(i3, this.yaxis.isLogarithmic())) continue;
                    d3 = chartDataViewSeries.getY(i3) - d2;
                }
                if (d3 == this.holeValue) continue;
                if (d3 >= 0.0) {
                    minMax2.max += d3;
                    continue;
                }
                minMax2.min += d3;
            }
            ((MinMax)serializable).union(minMax2);
        }
        if (this.chartType == 12) {
            JCAreaChartFormat jCAreaChartFormat = (JCAreaChartFormat)jCChartTypeFormat;
            if (!jCAreaChartFormat.is100Percent()) {
                ((MinMax)serializable).min += d2;
                ((MinMax)serializable).max += d2;
            }
        } else {
            JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)jCChartTypeFormat;
            if (!jCBarChartFormat.is100Percent()) {
                ((MinMax)serializable).min += d2;
                ((MinMax)serializable).max += d2;
            }
        }
        minMax.union((MinMax)serializable);
    }

    protected void getDataBounds(MinMax minMax, MinMax minMax2) {
        boolean bl;
        boolean bl2 = this.chartType == 2;
        boolean bl3 = this.chartType == 3 || this.chartType == 4;
        boolean bl4 = bl2 || bl3;
        boolean bl5 = bl = this.chartType == 6 || this.chartType == 7;
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            this.calcXMinMax(minMax);
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            this.calcYMinMax(minMax2);
        }
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            minMax.min = -1.7976931348623157E308;
            minMax.max = Double.MAX_VALUE;
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            minMax2.min = -1.7976931348623157E308;
            minMax2.max = Double.MAX_VALUE;
        }
        if (bl) {
            double d2 = JCChartUtil.abs(this.xaxis.getTickSpacing());
            minMax.min -= d2;
            minMax.max += d2;
        }
        if (!this.xaxis.min.isDefault && this.xaxis.min.value > minMax.min || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.min.value > minMax.min || bl4) {
            minMax.min = this.xaxis.min.value;
        }
        if (!this.xaxis.max.isDefault && this.xaxis.max.value < minMax.max || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.max.value < minMax.max || bl4) {
            minMax.max = this.xaxis.max.value;
        }
        if (!this.yaxis.min.isDefault && this.yaxis.min.value > minMax2.min || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.min.value > minMax2.min || bl4) {
            minMax2.min = this.yaxis.min.value;
        }
        if (bl2 && minMax2.min < 0.0) {
            if (JCChartUtil.abs(minMax2.min) > minMax2.max) {
                minMax2.max = JCChartUtil.abs(minMax2.min);
            }
            minMax2.min = 0.0;
        }
        if (!this.yaxis.max.isDefault && this.yaxis.max.value < minMax2.max || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.max.value < minMax2.max || bl4) {
            minMax2.max = this.yaxis.max.value;
        }
    }

    protected DoubleCoord getOrigin(MinMax minMax, MinMax minMax2, boolean bl) {
        DoubleCoord doubleCoord = new DoubleCoord(minMax.min, minMax2.min);
        if (!bl) {
            return doubleCoord;
        }
        int n2 = this.chart.getChartArea().getAngleUnit();
        if (this.xaxis.origin.isDefault) {
            if (this.chartType == 2 || this.chartType == 3 || this.chartType == 4) {
                switch (n2) {
                    case 1: {
                        doubleCoord.x = 90.0;
                        break;
                    }
                    case 2: {
                        doubleCoord.x = 1.5707963267948966;
                        break;
                    }
                    case 3: {
                        doubleCoord.x = 100.0;
                    }
                }
            } else {
                switch (this.xaxis.originPlacement.value) {
                    case 3: {
                        doubleCoord.x = 0.0;
                        break;
                    }
                    case 1: {
                        doubleCoord.x = minMax.min;
                        break;
                    }
                    case 2: {
                        doubleCoord.x = minMax.max;
                        break;
                    }
                    case 0: {
                        doubleCoord.x = minMax.min <= 0.0 && minMax.max >= 0.0 ? 0.0 : minMax.min;
                    }
                }
            }
        } else {
            doubleCoord.x = JCChartUtil.boundAngle(n2, this.xaxis.origin.value);
        }
        if (this.chartType == 10 || this.chartType == 12) {
            doubleCoord.y = this.yaxis.logarithmic ? JCChartUtil.max(minMax2.min, 0.0) : 0.0;
        } else if (this.chartType == 2 || this.chartType == 3 || this.chartType == 4) {
            doubleCoord.y = this.yaxis.reversed ? minMax2.min : minMax2.max;
        } else if (this.yaxis.origin.isDefault) {
            switch (this.yaxis.originPlacement.value) {
                case 3: {
                    doubleCoord.y = 0.0;
                    break;
                }
                case 1: {
                    doubleCoord.y = minMax2.min;
                    break;
                }
                case 2: {
                    doubleCoord.y = minMax2.max;
                    break;
                }
                case 0: {
                    doubleCoord.y = (this.chartType == 9 || this.chartType == 8) && !this.yaxis.logarithmic ? 0.0 : (minMax2.min <= 0.0 && minMax2.max >= 0.0 ? 0.0 : minMax2.min);
                }
            }
        } else {
            doubleCoord.y = this.yaxis.origin.value;
        }
        return doubleCoord;
    }

    protected void clearLimits() {
        if (this.xaxis != null) {
            this.xaxis.clearLimits();
            this.xaxis.step = Double.MAX_VALUE;
        }
        if (this.yaxis != null) {
            this.yaxis.clearLimits();
            this.yaxis.step = Double.MAX_VALUE;
        }
        this.xLimits = null;
        this.yLimits = null;
    }

    protected void calcLimits() {
        if (this.xaxis != null) {
            this.xLimits = new MinMax();
            this.calcXMinMax(this.xLimits);
            this.xaxis.setOriginalLimits(this.xLimits);
            this.adjustLimits(this.xLimits, false);
            this.xaxis.setLimits(this.xLimits);
        }
        if (this.yaxis != null) {
            boolean bl;
            this.yLimits = new MinMax();
            this.yaxis.is100Percent = bl = this.is100Percent();
            if (this.chartType == 10 || this.chartType == 12) {
                this.calcYMinMaxOfTotals(this.yLimits);
                if (bl) {
                    this.yLimits.min = this.yLimits.min < 0.0 ? -100.0 : 0.0;
                    this.yLimits.max = this.yLimits.max > 0.0 ? 100.0 : 0.0;
                }
            } else {
                this.calcYMinMax(this.yLimits);
            }
            this.yaxis.setOriginalLimits(this.yLimits);
            if (!bl) {
                this.adjustLimits(this.yLimits, true);
                double d2 = -1.7976931348623157E308;
                if (!this.yAxisDataMinHint.isDefault) {
                    d2 = this.yAxisDataMinHint.value;
                }
                double d3 = Double.MAX_VALUE;
                if (!this.yAxisDataMaxHint.isDefault) {
                    d3 = this.yAxisDataMaxHint.value;
                }
                this.yLimits.overRide(d2, d3);
            }
            if (this.yAxisDataMinHint.isDefault && this.yLimits.min != Double.MAX_VALUE) {
                this.yAxisDataMinHint.value = this.yLimits.min;
            }
            if (this.yAxisDataMaxHint.isDefault && this.yLimits.max != -1.7976931348623157E308) {
                this.yAxisDataMaxHint.value = this.yLimits.max;
            }
            this.yaxis.setLimits(this.yLimits);
        }
    }

    protected boolean is100Percent() {
        boolean bl = false;
        switch (this.chartType) {
            case 10: {
                JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.getChartFormat();
                bl = jCBarChartFormat.is100Percent();
                break;
            }
            case 12: {
                JCAreaChartFormat jCAreaChartFormat = (JCAreaChartFormat)this.getChartFormat();
                bl = jCAreaChartFormat.is100Percent();
            }
        }
        return bl;
    }

    private void adjustLimits(MinMax minMax, boolean bl) {
        if (this.markers != null) {
            for (JCMarker legendEntry : this.markers) {
                if (legendEntry == null || !legendEntry.isIncludedInDataBounds()) continue;
                legendEntry.adjustMinMax(minMax, bl);
            }
        }
        if (this.series != null && bl) {
            for (ChartDataViewSeries chartDataViewSeries : this.series) {
                List<JCDataThreshold> list = chartDataViewSeries.getDataThresholds();
                if (list == null) continue;
                for (JCDataThreshold jCDataThreshold : list) {
                    if (jCDataThreshold == null || !jCDataThreshold.isIncludedInDataBounds()) continue;
                    jCDataThreshold.adjustMinMax(minMax, true);
                }
            }
        }
        if (this.thresholds != null) {
            for (JCThreshold jCThreshold : this.thresholds) {
                if (jCThreshold == null || !jCThreshold.isIncludedInDataBounds()) continue;
                jCThreshold.adjustMinMax(minMax, bl);
            }
        }
        if (this.envelopes != null && (this.chartType == 0 || this.chartType == 1)) {
            for (JCEnvelope jCEnvelope : this.envelopes) {
                if (jCEnvelope == null || !jCEnvelope.isIncludedInDataBounds()) continue;
                jCEnvelope.adjustMinMax(minMax, bl);
            }
        }
    }

    public MinMax getXLimits() {
        return this.xLimits;
    }

    public MinMax getYLimits() {
        return this.yLimits;
    }

    void getDataBoundValues(MinMax minMax, MinMax minMax2) {
        if (this.xLimits != null) {
            minMax.reset(this.xLimits);
        }
        if (this.yLimits != null) {
            minMax2.reset(this.yLimits);
        }
    }

    @Override
    public boolean isChanged() {
        return this.getChanged();
    }

    @Override
    public boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    @Override
    public boolean getChanged() {
        return this.changed;
    }

    @Override
    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    protected void setChanged(boolean bl) {
        this.changed = bl;
    }

    @Override
    public void setChanged(boolean bl, int n2) {
        this.changed = bl;
        if (!this.changed) {
            this.changedFlag = n2;
            return;
        }
        this.changedFlag |= n2;
        this.markAsChanged(n2);
        this.propagateChange();
    }

    private void propagateChange() {
        if (!this.changed) {
            return;
        }
        if (this.isBatched()) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.isBatched()) {
            return;
        }
        this.chart.update();
        this.setChanged(false, 0);
    }

    private void markAsChanged(int n2) {
        int n3 = 0;
        if ((n2 & 0x80) > 0) {
            n3 |= 2;
        } else if ((n2 & 0x40) > 0) {
            n3 |= 1;
        }
        if (n3 != 0) {
            if (this.xaxis != null) {
                this.xaxis.setChanged(true, n3, false);
            }
            if (this.yaxis != null) {
                this.yaxis.setChanged(true, n3, false);
            }
        }
        if (this.chart != null && this.chart.getChartArea() != null) {
            this.chart.getChartArea().setChanged(true, n2 & 3, false);
        }
        int n4 = 0;
        if ((n2 & 0x20) > 0) {
            n4 |= 2;
        } else if ((n2 & 0x10) > 0) {
            n4 |= 1;
        }
        if (n4 != 0 && this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, n4, false);
        }
    }

    @Override
    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (this.changed == bl && (this.changedFlag & n2) == n2) {
            return;
        }
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            if (this.changed) {
                this.changedFlag |= n2;
                this.markAsChanged(n2);
            } else {
                this.changedFlag = n2;
            }
        }
    }

    public Point getFirstLast() {
        if (this.series == null) {
            return null;
        }
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (ChartDataViewSeries chartDataViewSeries : this.series) {
            int n5;
            if (!chartDataViewSeries.isVisible()) continue;
            if (n2 < chartDataViewSeries.getFirstPoint()) {
                n2 = chartDataViewSeries.getFirstPoint();
            }
            if (n3 > chartDataViewSeries.getLastPoint()) {
                n3 = chartDataViewSeries.getLastPoint();
            }
            if (n4 <= (n5 = chartDataViewSeries.maxIndex())) continue;
            n4 = n5;
        }
        if (n4 == Integer.MAX_VALUE) {
            return null;
        }
        if (n2 > n4) {
            return null;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            return null;
        }
        return new Point(n2, n3);
    }

    public int getVisibleDataSeries() {
        int n2 = 0;
        for (ChartDataViewSeries chartDataViewSeries : this.series) {
            if (!chartDataViewSeries.isVisible()) continue;
            ++n2;
        }
        return n2;
    }

    public void calcTransientData() {
        ChartDraw chartDraw;
        boolean bl;
        boolean bl2 = bl = this.getChartType() == 11;
        if (bl && (chartDraw = this.chart.getChartArea().getDrawable(this)) != null) {
            chartDraw.calcTransientData();
        }
    }

    public void setInverted(boolean bl) {
        if (this.inverted == bl) {
            return;
        }
        this.inverted = bl;
        if (this.xaxis != null) {
            this.xaxis.vertical = bl;
            this.xaxis.i_vertical = bl;
        }
        if (this.yaxis != null) {
            this.yaxis.vertical = !bl;
            this.yaxis.i_vertical = !bl;
        }
        int n2 = 130;
        if (this.chartType == 5 || this.chartType == 6 || this.chartType == 7) {
            n2 |= 0x20;
        }
        this.setChanged(true, n2);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setPickFocus(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("pickFocus must be one of PICK_FOCUS_XY, PICK_FOCUS_X, PICK_FOCUS_Y, or PICK_FOCUS_NONE");
        }
        this.pickFocus = n2;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public int getPickTolerance() {
        return this.pickTolerance;
    }

    public void setPickTolerance(int n2) {
        if (n2 < 0) {
            String string = "Pick tolerance must be non-negative";
            throw new IllegalArgumentException(string);
        }
        this.pickTolerance = n2;
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.visibleInLegend) {
            return;
        }
        this.visibleInLegend = bl;
        this.visibleInLegendChanged = true;
        this.setChanged(true, 34);
    }

    public boolean hasVisibleInLegendChanged() {
        return this.visibleInLegendChanged;
    }

    public void setVisibleInLegendChanged(boolean bl) {
        this.visibleInLegendChanged = bl;
    }

    public boolean isLegendSeriesReversed() {
        return this.legendSeriesReversed;
    }

    public void setLegendSeriesReversed(boolean bl) {
        if (this.legendSeriesReversed == bl) {
            return;
        }
        this.legendSeriesReversed = bl;
        this.setChanged(true, 34);
    }

    public boolean getAutoLabel() {
        return this.autoLabel;
    }

    public void setAutoLabel(boolean bl) {
        this.setAutoLabel(bl, false);
    }

    public void setAutoLabel(boolean bl, boolean bl2) {
        if (this.autoLabel == bl) {
            return;
        }
        this.autoLabel = bl;
        if (this.chart != null) {
            if (this.autoLabel) {
                if (bl2) {
                    this.chart.getChartLabelManager().generateAutoLabels(this);
                }
                this.generateAutoLabels = true;
            } else {
                this.chart.getChartLabelManager().removeAutoLabels(this);
            }
        }
        this.setChanged(true, 2);
    }

    public int getAutoLabelType() {
        return this.autoLabelType;
    }

    public void setAutoLabelType(int n2) {
        if (this.autoLabelType == n2) {
            return;
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("AutoLabelType must be one of AUTO_LABEL_TYPE_DATA_VALUES, AUTO_LABEL_TYPE_DATA_LABELS, or AUTO_LABEL_TYPE_GENERATOR");
        }
        this.autoLabelType = n2;
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 2);
    }

    public JCAutoLabelGenerator getAutoLabelGenerator() {
        return this.autoLabelGenerator;
    }

    public void setAutoLabelGenerator(JCAutoLabelGenerator jCAutoLabelGenerator) {
        if (this.autoLabelGenerator == jCAutoLabelGenerator) {
            return;
        }
        this.autoLabelGenerator = jCAutoLabelGenerator;
        if (this.autoLabel) {
            this.generateAutoLabels = true;
        }
        this.setChanged(true, 2);
    }

    public Color getOutlineColor() {
        if (this.outlineStyle == null) {
            if (this.chart != null && this.chart.getChartArea() != null) {
                return this.chart.getChartArea().getForeground();
            }
            return null;
        }
        return this.outlineStyle.getColor();
    }

    public void setOutlineColor(Color color) {
        if (this.outlineStyle == null) {
            this.outlineStyle = new JCLineStyle(1, color, 1);
        } else {
            if (this.outlineStyle.getColor() == color) {
                return;
            }
            this.outlineStyle.setColor(color);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineWidth() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getWidth();
        }
        return 1;
    }

    public void setOutlineWidth(int n2) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(n2, color, 1);
        } else {
            if (this.outlineStyle.getWidth() == n2) {
                return;
            }
            this.outlineStyle.setWidth(n2);
        }
        this.setChanged(true, 34);
    }

    public int getOutlinePattern() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getPattern();
        }
        return 1;
    }

    public void setOutlinePattern(int n2) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, n2);
        } else {
            if (this.outlineStyle.getPattern() == n2) {
                return;
            }
            this.outlineStyle.setPattern(n2);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineJoin() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getJoin();
        }
        return 0;
    }

    public void setOutlineJoin(int n2) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1, 0, n2);
        } else {
            if (this.outlineStyle.getJoin() == n2) {
                return;
            }
            this.outlineStyle.setJoin(n2);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineCap() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getCap();
        }
        return 0;
    }

    public void setOutlineCap(int n2) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1, n2, 0);
        } else {
            if (this.outlineStyle.getCap() == n2) {
                return;
            }
            this.outlineStyle.setCap(n2);
        }
        this.setChanged(true, 34);
    }

    public JCLineStyle getOutlineStyle() {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1);
        }
        return this.outlineStyle;
    }

    public void setOutlineStyle(JCLineStyle jCLineStyle) {
        this.outlineStyle = jCLineStyle;
        this.setChanged(true, 34);
    }

    public void setChartStyle(int n2, JCChartStyle jCChartStyle) {
        if (n2 < 0 || n2 > this.styles.size()) {
            throw new IllegalArgumentException("Invalid ChartStyle index in ChartDataView.");
        }
        if (jCChartStyle != null) {
            jCChartStyle.addParent(this);
        }
        if (n2 < this.styles.size()) {
            JCChartStyle jCChartStyle2 = this.styles.get(n2);
            if (jCChartStyle2 != null) {
                jCChartStyle2.removeParent(this);
            }
            this.styles.set(n2, jCChartStyle);
        } else {
            this.styles.add(n2, jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public JCChartStyle getChartStyle(int n2) {
        JCChartStyle jCChartStyle;
        if (n2 < 0) {
            throw new IllegalArgumentException("ChartStyle index must be positive");
        }
        if (n2 >= this.styles.size()) {
            while (n2 >= this.styles.size()) {
                this.styles.add(null);
            }
        }
        if ((jCChartStyle = this.styles.get(n2)) == null) {
            jCChartStyle = JCChartStyle.makeDefault(this.chart, this);
            this.styles.set(n2, jCChartStyle);
        }
        return jCChartStyle;
    }

    public List<JCChartStyle> getChartStyle() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        return new Vector<JCChartStyle>(this.styles);
    }

    public void setChartStyle(List<JCChartStyle> list) {
        this.styles = new Vector();
        if (list == null) {
            return;
        }
        for (JCChartStyle jCChartStyle : list) {
            if (jCChartStyle != null) {
                jCChartStyle.addParent(this);
            }
            this.styles.add(jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public void setHoleStyle(int n2, JCChartStyle jCChartStyle) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid HoleStyle index in ChartDataView.");
        }
        if (jCChartStyle != null) {
            jCChartStyle.addParent(this);
        }
        if (n2 < this.holeStyles.size()) {
            JCChartStyle jCChartStyle2 = this.holeStyles.get(n2);
            if (jCChartStyle2 != null) {
                jCChartStyle2.removeParent(this);
            }
            this.holeStyles.set(n2, jCChartStyle);
        } else {
            for (int i2 = this.holeStyles.size(); i2 < n2; ++i2) {
                this.holeStyles.add(i2, null);
            }
            this.holeStyles.add(n2, jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public JCChartStyle getHoleStyle(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("HoleStyle index must be positive");
        }
        if (n2 >= this.holeStyles.size()) {
            return null;
        }
        return this.holeStyles.get(n2);
    }

    public List<JCChartStyle> getHoleStyle() {
        if (this.holeStyles == null || this.holeStyles.size() == 0) {
            return null;
        }
        return new Vector<JCChartStyle>(this.holeStyles);
    }

    public void setHoleStyle(List<JCChartStyle> list) {
        this.holeStyles = new Vector();
        if (list == null) {
            return;
        }
        for (JCChartStyle jCChartStyle : list) {
            if (jCChartStyle != null) {
                jCChartStyle.addParent(this);
            }
            this.holeStyles.add(jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public void setColorHandler(JCDrawableColorHandler jCDrawableColorHandler) {
        if (this.colorHandler == jCDrawableColorHandler) {
            return;
        }
        this.colorHandler = jCDrawableColorHandler;
        this.setChanged(true, 33);
    }

    public JCDrawableColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public OutputDataProperties getOutputDataProperties() {
        return this.outputDataProperties;
    }

    public void setOutputDataProperties(OutputDataProperties outputDataProperties) {
        this.outputDataProperties = outputDataProperties;
    }

    public double[] getXArrayCopy() {
        if (this.xvalues == null) {
            return null;
        }
        double[] dArray = new double[this.xvalues.length];
        System.arraycopy(this.xvalues, 0, dArray, 0, this.xvalues.length);
        return dArray;
    }

    double[] getX() {
        return this.xvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    public boolean isArrayData() {
        return this.xvalues != null;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        block3: {
            try {
                objectInputStream.defaultReadObject();
                if (this.dataSource != null && this.dataSource instanceof ChartDataManageable) {
                    ((ChartDataManageable)((Object)this.dataSource)).getChartDataManager().addChartDataListener(this);
                }
            }
            catch (Exception exception) {
                if (this.chart == null) break block3;
                this.chart.getErrorLog().logErrorMessage("readObject", exception);
            }
        }
    }

    Object getTransientData() {
        return this.transientData;
    }

    void setTransientData(Object object) {
        this.transientData = object;
        if (this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, 2, false);
        }
    }

    public int getNumSeriesPerData() {
        int n2 = 1;
        switch (this.chartType) {
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 4;
            }
        }
        return n2;
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        int n2 = 2;
        if (!this.visibleInLegendChanged) {
            this.visibleInLegend = bl;
            n2 |= 0x20;
        }
        this.setChanged(true, n2);
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void drawThresholds(Graphics graphics, boolean bl, boolean bl2, boolean bl3, Rectangle rectangle, boolean bl4) {
        if (this.thresholds != null) {
            for (JCThreshold jCThreshold : this.thresholds) {
                if (bl4 ^ jCThreshold.isDrawJustBeforeData()) continue;
                jCThreshold.draw(graphics, bl, bl2, bl3, rectangle);
            }
        }
    }

    protected void drawEnvelopes(Graphics graphics, boolean bl) {
        if (this.envelopes != null) {
            for (JCEnvelope jCEnvelope : this.envelopes) {
                if (bl ^ jCEnvelope.isDrawnWithData()) continue;
                jCEnvelope.draw(graphics);
            }
        }
    }

    protected void drawMarkers(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.markers != null) {
            for (JCMarker jCMarker : this.markers) {
                if (jCMarker.isDrawnBeforeData() ^ bl4) continue;
                jCMarker.draw(graphics, bl, bl2, bl3);
            }
            for (JCMarker jCMarker : this.markers) {
                if (jCMarker.isDrawnBeforeData() ^ bl4) continue;
                jCMarker.drawChartLabel(graphics);
            }
        }
    }

    public void outputData(OutputStream outputStream) {
        block3: {
            String string = ChartDataSourceUtil.buildDataSourceString(this.getDataSource());
            if (string != null) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    dataOutputStream.writeBytes(string);
                    dataOutputStream.flush();
                }
                catch (IOException iOException) {
                    if (this.chart == null) break block3;
                    this.chart.getErrorLog().logErrorMessage("outputData", iOException);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        this.changed = true;
        int n2 = this.changedFlag;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }

    protected DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(this);
        }
        return this.dataHandler;
    }

    protected static int[] getFirstLastPoints(ChartDataView chartDataView) {
        List<ChartDataViewSeries> list;
        if (chartDataView != null && (list = chartDataView.getSeries()) != null) {
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MAX_VALUE;
            for (ChartDataViewSeries chartDataViewSeries : list) {
                if (chartDataViewSeries == null || !chartDataViewSeries.isVisible()) continue;
                int n4 = chartDataViewSeries.getFirstPoint();
                if (n4 > n2) {
                    n2 = n4;
                }
                if ((n4 = chartDataViewSeries.getLastPoint()) >= n3) continue;
                n3 = n4;
            }
            Object object = new int[2];
            object[0] = n2;
            object[1] = n3;
            return object;
        }
        return null;
    }

    public static int getNumRadarSpokes(ChartDataView chartDataView) {
        int[] nArray;
        int n2 = 0;
        if (chartDataView != null && (nArray = ChartDataView.getFirstLastPoints(chartDataView)) != null) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            n2 = n4 - n3 + 1;
        }
        return n2;
    }

    public boolean isUsingDoublePixels() {
        return this.chart != null && (this.chartType == 0 || this.chartType == 1) && this.chart.isUsingDoublePixels();
    }
}

