/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisScaleHandler;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCTimeExclusion;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.util.calendar.ICalendar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

abstract class AxisHandler {
    protected static final int ANNO_PADDING = 2;
    protected JCAxis parent = null;
    protected double shift;
    protected double scale = 1.0;
    protected boolean transformComputed = false;
    protected AxisScaleHandler axisScaleHandler = null;
    protected ICalendar gCalendar = null;
    protected int nDaysInWeekend = 2;

    AxisHandler() {
    }

    protected void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
        this.axisScaleHandler.setParent(jCAxis);
        this.updateCalendarObject(this.parent.hasTimeExclusions());
    }

    static AxisHandler makeAxisHandler(JCAxis jCAxis) {
        AxisHandler axisHandler;
        try {
            String string = jCAxis.isPolar() || jCAxis.isRadar() ? (jCAxis.logarithmic && jCAxis.i_vertical ? "com.klg.jclass.chart.CircularChartLogAxisHandler" : "com.klg.jclass.chart.CircularChartLinearAxisHandler") : (jCAxis.logarithmic ? "com.klg.jclass.chart.RectangularChartLogAxisHandler" : "com.klg.jclass.chart.RectangularChartLinearAxisHandler");
            axisHandler = (AxisHandler)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            JCChart jCChart;
            if (jCAxis.chartArea != null && (jCChart = (JCChart)jCAxis.chartArea.getParent()) != null) {
                jCChart.getErrorLog().logErrorMessage("makeAxisHandler", exception);
            }
            axisHandler = null;
        }
        if (axisHandler != null) {
            axisHandler.setParent(jCAxis);
        }
        return axisHandler;
    }

    protected FontMetrics getFontMetrics() {
        JCChart jCChart = this.parent.getParentChart();
        FontMetrics fontMetrics = null;
        try {
            Graphics graphics = jCChart.getQueryGraphics();
            fontMetrics = graphics != null ? graphics.getFontMetrics(this.parent.getFont()) : jCChart.getToolkit().getFontMetrics(this.parent.getFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fontMetrics;
    }

    protected Dimension getAnnoDimension(double d2, int n2) {
        Dimension dimension;
        FontMetrics fontMetrics = this.getFontMetrics();
        if (fontMetrics == null) {
            return null;
        }
        if (this.parent.labelGenerator != null) {
            Object object = this.parent.labelGenerator.makeLabel(d2, n2);
            if (object == null) {
                return null;
            }
            if (object instanceof ChartText) {
                ChartText chartText = (ChartText)object;
                chartText.setParentChart(this.parent.getParentChart());
                dimension = new Dimension(chartText.getWidth(), chartText.getHeight());
            } else {
                String string = object instanceof String ? (String)object : object.toString();
                dimension = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
        } else {
            String string = this.axisScaleHandler.format(d2, n2);
            dimension = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        return dimension;
    }

    protected void getAnnotationExtent(Dimension dimension, double d2, int n2) {
        Dimension dimension2 = this.getAnnoDimension(d2, n2);
        if (dimension2 == null) {
            return;
        }
        int n3 = this.parent.getAnnotationRotation();
        if (n3 == 1 || n3 == 3) {
            if (dimension.width < dimension2.height) {
                dimension.width = dimension2.height;
            }
            if (dimension.height < dimension2.width) {
                dimension.height = dimension2.width;
            }
        } else {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
        }
    }

    protected double calcOrigin(double d2, double d3) {
        double d4 = 0.0;
        if (this.parent.is100Percent) {
            return d4;
        }
        if (this.parent.origin.isDefault) {
            switch (this.parent.originPlacement.value) {
                case 3: {
                    d4 = 0.0;
                    break;
                }
                case 1: {
                    d4 = d2;
                    break;
                }
                case 2: {
                    d4 = d3;
                    break;
                }
                case 0: {
                    d4 = d2 <= 0.0 && d3 >= 0.0 ? 0.0 : d2;
                }
            }
        } else {
            d4 = this.parent.origin.value;
        }
        return d4;
    }

    protected int calcRotatedAnnoSpacing(double d2, double d3) {
        int n2 = 0;
        double d4 = this.parent.getAnnotationRotationAngle(2);
        AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
        Vector<JCValueLabel> vector = annotationHandler.userValueLabels;
        if (this.parent.getAnnotationMethod() != 0 && vector != null && vector.size() > 0) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                JCValueLabel jCValueLabel = vector.elementAt(i2);
                ChartText chartText = jCValueLabel.getChartText();
                int n3 = annotationHandler.calcRotatedAnnoSpacing(chartText.width.value, chartText.height.value, d4);
                n2 = Math.max(n3, n2);
            }
        } else {
            int n4 = 0;
            int n5 = 0;
            Dimension dimension = this.getAnnoDimension(d2, this.parent.getPrecision());
            if (dimension != null) {
                n4 = annotationHandler.calcRotatedAnnoSpacing(dimension.width, dimension.height, d4);
            }
            if ((dimension = this.getAnnoDimension(d3, this.parent.getPrecision())) != null) {
                n5 = annotationHandler.calcRotatedAnnoSpacing(dimension.width, dimension.height, d4);
            }
            n2 = Math.max(n4, n5);
        }
        return n2;
    }

    protected void drawTicks(Graphics graphics) {
        if (this.parent == null) {
            return;
        }
        int n2 = this.parent.linePosition();
        Vector<JCValueLabel> vector = this.parent.getAnnotations();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            JCValueLabel jCValueLabel = vector.elementAt(i2);
            if (!jCValueLabel.isDrawTick()) continue;
            this.drawTickMark(graphics, jCValueLabel, n2);
        }
    }

    protected void updateCalendarObject(boolean bl) {
        this.gCalendar = JCChartUtil.getGregorianCalendar(bl, this.parent.getTimeZone(), this.parent.getLocale());
        this.nDaysInWeekend = this.gCalendar.getNumberOfDaysInWeekend();
    }

    protected double adjustValueForward(double d2, double d3) {
        Date date;
        if (this.parent.getNumTimeExclusions() == 0 || d2 >= d3) {
            return d2;
        }
        long l2 = this.parent.getTimeUnit();
        AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
        Date date2 = annotationHandler.dataToTime(d2, l2);
        Date date3 = this.findNextAvailableTime(date2, date = annotationHandler.dataToTime(d3, l2));
        if (date3 == null || !date3.before(date)) {
            return d2;
        }
        if (date3.equals(date2)) {
            return d2;
        }
        return this.getDelta(this.parent.getTimeBase(), date3, l2, true);
    }

    protected double adjustValueBackward(double d2, double d3) {
        Date date;
        if (this.parent.getNumTimeExclusions() == 0 || d2 <= d3) {
            return d2;
        }
        long l2 = this.parent.getTimeUnit();
        AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
        Date date2 = annotationHandler.dataToTime(d2, l2);
        Date date3 = this.findPrevAvailableTime(date2, date = annotationHandler.dataToTime(d3, l2));
        if (date3 == null || !date3.after(date)) {
            return d2;
        }
        if (date3.equals(date2)) {
            return d2;
        }
        return this.getDelta(this.parent.getTimeBase(), date3, l2, true);
    }

    protected boolean isTimeExcluded(Date date) {
        List<JCTimeExclusion> list = this.parent.getTimeExclusions();
        boolean bl = false;
        for (JCTimeExclusion jCTimeExclusion : list) {
            if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable() || !jCTimeExclusion.isTimeExcluded(date)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected double getDelta(Date date, Date date2, long l2, boolean bl) {
        double d2 = (double)(date2.getTime() - date.getTime()) / (double)l2;
        if (l2 >= 86400000L) {
            d2 += this.getDaylightSavingsTimeCorrection(date, date2, l2, bl);
        }
        return d2;
    }

    protected double adjustValueAddExclusions(double d2, double d3, double d4) {
        if (this.parent.getNumTimeExclusions() > 0) {
            double d5 = d4;
            double d6 = this.adjustValueForward(d2, d3);
            long l2 = this.parent.getTimeUnit();
            AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
            Date date = annotationHandler.dataToTime(d6, l2);
            Date date2 = annotationHandler.dataToTime(d3, l2);
            JCTimeExclusion jCTimeExclusion = this.findNextExclusion(date, date2);
            while (jCTimeExclusion != null && d6 < d5) {
                Date date3 = jCTimeExclusion.getNextExcludedTime(date);
                Date date4 = jCTimeExclusion.getNextAvailableTime(date3);
                if ((d6 += this.getDelta(date, date3, l2, true)) >= d5) break;
                d4 += this.getDelta(date3, date4, l2, true);
                date = date4;
                jCTimeExclusion = this.findNextExclusion(date, date2);
            }
        }
        return d4;
    }

    protected double adjustValueRemExclusions(double d2, double d3, ClusterAdjustment clusterAdjustment) {
        if (this.parent.getNumTimeExclusions() > 0) {
            long l2 = this.parent.getTimeUnit();
            AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
            Date date = annotationHandler.dataToTime(d2, l2);
            Date date2 = annotationHandler.dataToTime(d3, l2);
            JCTimeExclusion jCTimeExclusion = this.findNextExclusion(date, date2);
            while (jCTimeExclusion != null) {
                Date date3 = jCTimeExclusion.getNextExcludedTime(date);
                Date date4 = jCTimeExclusion.getNextAvailableTime(date3);
                boolean bl = false;
                if (!date2.after(date4)) {
                    if (clusterAdjustment == ClusterAdjustment.NONE) {
                        date4 = date2;
                    }
                    bl = true;
                }
                if (!bl || clusterAdjustment != ClusterAdjustment.RIGHT) {
                    d3 -= this.getDelta(date3, date4, l2, true);
                }
                if (bl) break;
                date = date4;
                jCTimeExclusion = this.findNextExclusion(date, date2);
            }
        }
        return d3;
    }

    protected JCTimeExclusion findNextExclusion(Date date, Date date2) {
        if (date == null || date2 == null || date.equals(date2) || date.after(date2)) {
            return null;
        }
        List<JCTimeExclusion> list = this.parent.getTimeExclusions();
        if (list.size() == 0) {
            return null;
        }
        Date date3 = null;
        JCTimeExclusion jCTimeExclusion = null;
        for (JCTimeExclusion jCTimeExclusion2 : list) {
            Date date4;
            Date date5;
            Date date6;
            if (jCTimeExclusion2 == null || !jCTimeExclusion2.isActive() || !jCTimeExclusion2.isUseable() || (date6 = jCTimeExclusion2.getNextExcludedTime(date)) == null || !date6.before(date2)) continue;
            if (date3 == null || date3.after(date6)) {
                date3 = date6;
                jCTimeExclusion = jCTimeExclusion2;
                continue;
            }
            if (!date3.equals(date6) || !(date5 = jCTimeExclusion.getNextAvailableTime(date3)).before(date4 = jCTimeExclusion2.getNextAvailableTime(date6))) continue;
            date3 = date6;
            jCTimeExclusion = jCTimeExclusion2;
        }
        return jCTimeExclusion;
    }

    protected Date findNextExcludedTime(Date date) {
        if (date == null) {
            return null;
        }
        List<JCTimeExclusion> list = this.parent.getTimeExclusions();
        if (list.size() == 0) {
            return null;
        }
        Date date2 = null;
        for (JCTimeExclusion jCTimeExclusion : list) {
            Date date3;
            if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable() || (date3 = jCTimeExclusion.getNextExcludedTime(date)) == null || date2 != null && !date2.after(date3)) continue;
            date2 = date3;
        }
        return date;
    }

    protected Date findNextAvailableTime(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        if (date.after(date2)) {
            return date2;
        }
        List<JCTimeExclusion> list = this.parent.getTimeExclusions();
        if (list.size() == 0) {
            return date;
        }
        boolean bl = false;
        while (!bl) {
            Date date3 = null;
            for (JCTimeExclusion jCTimeExclusion : list) {
                Date date4;
                if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable() || (date4 = jCTimeExclusion.getNextAvailableTime(date)) == null || date3 != null && !date3.before(date4)) continue;
                date3 = date4;
            }
            if (date3 == null || date3.equals(date)) {
                bl = true;
                continue;
            }
            if (!date3.before(date2)) {
                date = date2;
                bl = true;
                continue;
            }
            date = date3;
            bl = !this.isTimeExcluded(date);
        }
        return date;
    }

    protected Date findPrevAvailableTime(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        if (date.before(date2)) {
            return date2;
        }
        List<JCTimeExclusion> list = this.parent.getTimeExclusions();
        if (list.size() == 0) {
            return date;
        }
        boolean bl = false;
        while (!bl) {
            Date date3 = null;
            for (JCTimeExclusion jCTimeExclusion : list) {
                Date date4;
                if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable() || (date4 = jCTimeExclusion.getPrevAvailableTime(date)) == null || date3 != null && !date3.after(date4)) continue;
                date3 = date4;
            }
            if (date3 == null || date3.equals(date)) {
                bl = true;
                continue;
            }
            if (!date3.after(date2)) {
                date = date2;
                bl = true;
                continue;
            }
            date = date3;
            bl = !this.isTimeExcluded(date);
        }
        return date;
    }

    protected int getDaylightSavings(Date date) {
        TimeZone timeZone = this.gCalendar.getTZone();
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            return timeZone.getDSTSavings();
        }
        return 0;
    }

    protected double getDaylightSavingsTimeCorrection(Date date, Date date2, long l2, boolean bl) {
        TimeZone timeZone;
        double d2 = 0.0;
        if (date != null && date2 != null && (timeZone = this.gCalendar.getTZone()).useDaylightTime()) {
            int n2 = timeZone.getDSTSavings();
            if (!bl) {
                n2 *= -1;
            }
            boolean bl2 = timeZone.inDaylightTime(date);
            boolean bl3 = timeZone.inDaylightTime(date2);
            if (bl2 && !bl3) {
                d2 = -((double)n2) / (double)l2;
            } else if (!bl2 && bl3) {
                d2 = (double)n2 / (double)l2;
            }
        }
        return d2;
    }

    protected double getDaylightSavingsTimeCorrection(double d2, double d3, long l2, boolean bl) {
        Date date = this.parent.getAnnotationHandler().dataToTime(d2, l2);
        Date date2 = this.parent.getAnnotationHandler().dataToTime(d3, l2);
        return this.getDaylightSavingsTimeCorrection(date, date2, l2, bl);
    }

    protected void computeTransformation(double d2, double d3, int n2) {
        double d4;
        double d5 = JCChartUtil.calcError(this.parent.getPrecision());
        if (this.parent.isReversed()) {
            n2 = -n2;
        }
        if (!this.parent.logarithmic && Math.abs(d3 - d2) < d5) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        if (this.parent.hasTimeExclusions()) {
            this.parent.computeExclusionSwitchList(d2, d3);
            d2 = this.adjustValueForward(d2, d3);
            d3 = this.adjustValueBackward(d3, d2);
            d4 = this.getDaylightSavingsTimeCorrection(d2, d3, this.parent.getTimeUnit(), true);
            d3 = this.adjustValueRemExclusions(d2, d3, ClusterAdjustment.NONE);
            d3 += d4;
        }
        this.scale = (d4 = d3 - d2) != 0.0 ? (double)n2 / d4 : 0.0;
        int n3 = this.parent.pixelStart();
        this.shift = n2 < 0 ? (double)n3 - d3 * this.scale : (double)n3 - d2 * this.scale;
        this.transformComputed = true;
    }

    void calcPrecision() {
        this.axisScaleHandler.calcPrecision();
    }

    double range() {
        return this.axisScaleHandler.range();
    }

    void translate(double d2) {
        this.axisScaleHandler.translate(d2);
    }

    protected void makeTickLabels(JCAnno jCAnno) {
        this.axisScaleHandler.makeTickLabels(jCAnno);
    }

    protected double getInnerExtent(JCAnno jCAnno) {
        return jCAnno == null ? 2.0 : (double)jCAnno.getInnerExtent();
    }

    protected double getOuterExtent(JCAnno jCAnno) {
        return jCAnno == null ? 2.0 : (double)jCAnno.getOuterExtent();
    }

    protected Color getTickColor(JCAnno jCAnno) {
        Color color;
        Color color2 = color = jCAnno == null ? this.parent.getForeground() : jCAnno.getTickColor();
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    protected void updateAnnoObject(JCAnno jCAnno) {
        this.axisScaleHandler.updateAnnoObject(jCAnno);
    }

    protected ICalendar getCalendar() {
        return this.gCalendar;
    }

    protected abstract void calcParams();

    protected abstract void calcTransformation();

    protected abstract void drawTickMark(Graphics var1, JCValueLabel var2, int var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClusterAdjustment {
        LEFT,
        NONE,
        RIGHT;

    }
}

