/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.JCTimeExclusion;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.chart.XYProjection;
import com.klg.jclass.util.JCUtil;
import com.klg.jclass.util.calendar.ICalendar;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandler
implements Serializable {
    protected Vector<JCValueLabel> valueLabels = new Vector();
    protected Vector<JCValueLabel> userValueLabels = new Vector();
    protected Extents extents = new Extents();
    protected int realPlacement = 1;
    protected int anchor = 16;
    protected JCAxis parent = null;
    protected boolean annotationVisible = true;
    protected boolean dropOverlappingLabels = false;
    protected int maxAnnotationWidth = Integer.MAX_VALUE;
    protected boolean useEllipsisWhenTruncating = true;
    protected int truncateMode = 5;
    private transient JCChartDateFormat dateFormatter = null;
    private static final double angleCenteredLabel = 0.17453292519943295;
    private static final double[] vertAxisAnnoRotationLimit = new double[]{1.3962634015954636, 1.5707963267948966, 1.7453292519943295, Math.PI, 4.537856055185257, 4.71238898038469, 4.886921905584122, Math.PI * 2};
    private static final double[] horizAxisAnnoRotationLimit = new double[]{0.17453292519943295, 1.5707963267948966, 2.9670597283903604, Math.PI, 3.316125578789226, 4.71238898038469, 6.1086523819801535, Math.PI * 2};

    public AnnotationHandler(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public AnnotationHandler(AnnotationHandler annotationHandler) {
        this.parent = annotationHandler.parent;
        this.anchor = annotationHandler.anchor;
        this.userValueLabels = annotationHandler.userValueLabels;
        this.annotationVisible = annotationHandler.annotationVisible;
        this.dropOverlappingLabels = annotationHandler.dropOverlappingLabels;
        this.realPlacement = annotationHandler.realPlacement;
        this.extents = annotationHandler.extents;
        this.maxAnnotationWidth = annotationHandler.maxAnnotationWidth;
        this.useEllipsisWhenTruncating = annotationHandler.useEllipsisWhenTruncating;
        this.truncateMode = annotationHandler.truncateMode;
    }

    public JCChartDateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new JCChartDateFormat();
        }
        return this.dateFormatter;
    }

    protected void calcAnnotationExtents(List<JCAnno> list, boolean bl) {
        this.extents.ortho = 0;
        this.extents.minor = 0;
        this.extents.major = 0;
        if (list == null) {
            return;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Extents extents;
            JCAnno jCAnno = list.get(i2);
            if (jCAnno == null || !jCAnno.getDrawLabels() && this.parent.getAnnotationMethod() == 0 || (extents = this.calcAnnotationExtents(jCAnno, bl)) == null) continue;
            this.extents.minor = Math.max(this.extents.minor, extents.minor);
            this.extents.major = Math.max(this.extents.major, extents.major);
            this.extents.ortho = Math.max(this.extents.ortho, extents.ortho);
        }
    }

    protected Extents calcAnnotationExtents(JCAnno jCAnno, boolean bl) {
        if (!this.parent.visible) {
            return null;
        }
        Extents extents = new Extents();
        if (this.annotationVisible && jCAnno != null) {
            if (this.parent.getAnnotationRotation() == 4 && !this.parent.isPolar() && !this.parent.isRadar()) {
                double d2;
                AxisHandler axisHandler = this.parent.getAxisHandler();
                if (!axisHandler.transformComputed) {
                    axisHandler.calcTransformation();
                }
                if ((d2 = this.parent.getAnnotationRotationAngle(2)) < 0.0) {
                    d2 += Math.PI * 2;
                }
                extents.minor = this.getRotatedAnnoMinorExtent(d2, jCAnno.getLabelExtent());
                extents.major = this.getRotatedAnnoMajorExtent(extents.minor, d2, jCAnno.getLabelExtent());
                extents.ortho = this.getRotatedAnnoOrthoExtent(d2, jCAnno.getLabelExtent());
            } else {
                Serializable serializable;
                int n2 = this.getMinVisibleLabel();
                int n3 = this.getMaxVisibleLabel();
                if (n2 >= 0 && n2 < this.valueLabels.size() && n3 >= 0 && n3 < this.valueLabels.size()) {
                    JCValueLabel jCValueLabel = this.valueLabels.elementAt(n2);
                    JCValueLabel jCValueLabel2 = this.valueLabels.elementAt(n3);
                    ChartText chartText = jCValueLabel.label;
                    serializable = jCValueLabel2.label;
                    chartText.recalc();
                    ((ChartText)serializable).recalc();
                    if (this.parent.i_vertical) {
                        extents.minor = bl ? 0 : ((ChartInteriorRegion)serializable).getHeight() / 2 + 1;
                        extents.major = bl ? 0 : chartText.getHeight() / 2 + 1;
                    } else {
                        extents.minor = bl ? 0 : chartText.getWidth() / 2 + 1;
                        extents.major = bl ? 0 : ((ChartInteriorRegion)serializable).getWidth() / 2 + 1;
                    }
                }
                int n4 = this.firstVisibleLabel();
                int n5 = this.lastVisibleLabel();
                if (n4 >= 0 && n4 < this.valueLabels.size() && n5 >= 0 && n5 < this.valueLabels.size()) {
                    for (int i2 = n4; i2 <= n5; ++i2) {
                        int n6;
                        serializable = this.valueLabels.elementAt(i2);
                        ((JCValueLabel)serializable).label.recalc();
                        int n7 = n6 = this.parent.i_vertical ? ((JCValueLabel)serializable).label.getWidth() : ((JCValueLabel)serializable).label.getHeight();
                        if ((n6 += jCAnno.getLabelExtent() + 1) <= extents.ortho) continue;
                        extents.ortho = n6;
                    }
                }
            }
        }
        if (this.parent.isReversed() && this.parent.getAnnotationRotation() != 4) {
            int n8 = extents.minor;
            extents.minor = extents.major;
            extents.major = n8;
        }
        if (this.parent.title.visible) {
            if (this.parent.i_vertical) {
                switch (this.parent.title.getEffectivePlacement()) {
                    case 17: 
                    case 18: {
                        extents.minor += this.parent.title.getHeight() + 1;
                        extents.ortho = Math.max(this.parent.title.getWidth() + 1, extents.ortho);
                        break;
                    }
                    case 33: 
                    case 34: {
                        extents.major += this.parent.title.getHeight() + 1;
                        extents.ortho = Math.max(this.parent.title.getWidth() + 1, extents.ortho);
                        break;
                    }
                    case 1: 
                    case 2: {
                        extents.ortho += this.parent.title.getWidth() + 1;
                    }
                }
            } else {
                switch (this.parent.title.getEffectivePlacement()) {
                    case 16: 
                    case 32: {
                        extents.ortho += this.parent.title.getHeight() + 1;
                    }
                }
            }
        }
        return extents;
    }

    protected void calcAnchor() {
        this.realPlacement = this.parent.placement.value;
        if (this.realPlacement == 0) {
            this.realPlacement = 1;
        }
        boolean bl = false;
        if (this.parent.otherAxis != null) {
            boolean bl2 = bl = this.parent.otherAxis.origin.value - this.parent.otherAxis.min.value > this.parent.otherAxis.max.value - this.parent.otherAxis.origin.value;
        }
        if (this.parent.i_vertical) {
            this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 1 : 2;
            if (this.parent.otherAxis != null && this.parent.otherAxis.isReversed()) {
                switch (this.anchor) {
                    case 1: {
                        this.anchor = 2;
                        break;
                    }
                    case 2: {
                        this.anchor = 1;
                    }
                }
            }
        } else {
            this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 16 : 32;
            if (this.parent.otherAxis != null && this.parent.otherAxis.isReversed()) {
                switch (this.anchor) {
                    case 16: {
                        this.anchor = 32;
                        break;
                    }
                    case 32: {
                        this.anchor = 16;
                    }
                }
            }
        }
    }

    protected void checkAnnotations() {
        if (!this.annotationVisible || this.parent == null) {
            return;
        }
        if (this.valueLabels == null || this.valueLabels.size() < 1) {
            return;
        }
        int n2 = this.parent.getAnnotationMethod();
        if (n2 == 0) {
            this.checkValueAnnotations();
        } else if (n2 == 2) {
            this.checkTimeAnnotations();
        } else {
            this.checkUserProvidedAnnotations();
        }
    }

    protected boolean doUserProvidedLabelsFit() {
        int n2 = this.parent.getAnnotationMethod();
        if (!this.annotationVisible || this.valueLabels == null || this.valueLabels.size() < 1 || n2 != 3 && n2 != 1 || this.parent.isPolarRadar()) {
            return true;
        }
        Rectangle rectangle = this.parent.getChartArea().getBounds();
        int[] nArray = new int[]{this.firstVisibleLabel(), this.lastVisibleLabel()};
        for (int i2 = 0; i2 < 2; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(nArray[i2]);
            ChartText chartText = jCValueLabel.getChartText();
            if (!(this.parent.i_vertical ? chartText.getTop() < 0 || chartText.getTop() + chartText.getHeight() > rectangle.height : chartText.getLeft() < 0 || chartText.getLeft() + chartText.getWidth() > rectangle.width)) continue;
            return false;
        }
        return true;
    }

    protected void layout() {
        if (this.parent.isPolarRadar()) {
            return;
        }
        int n2 = this.valueLabels.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            if (this.parent.skipValue(jCValueLabel.value, Double.MAX_VALUE)) continue;
            int n3 = this.parent.toPixel(jCValueLabel.value);
            JCAnno jCAnno = jCValueLabel.getAnno();
            int n4 = 3;
            if (jCAnno != null) {
                n4 = jCAnno.getLabelExtent();
            }
            this.layout(jCValueLabel.label, n3, n4);
        }
    }

    protected Date dataToTime(double d2, long l2) {
        Date date = this.parent.getTimeBase();
        if (l2 < 86400000L) {
            return new Date(date.getTime() + (long)(d2 * (double)l2));
        }
        Date date2 = new Date(date.getTime());
        boolean bl = l2 >= 604800000L && l2 < 2678400000L;
        long l3 = (long)d2;
        double d3 = d2 - (double)l3;
        long l4 = bl ? l3 * 7L : l3;
        this.getDateFormatter().addToUnit(date2, l2, (int)l4);
        try {
            if (d2 < 0.0 && date2.after(date)) {
                return null;
            }
            if (d2 > 0.0 && date2.before(date)) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (10.0 + d3 != 10.0) {
            Date date3 = new Date(date.getTime());
            if (d2 < 0.0) {
                --l3;
                d3 = -d3;
            } else {
                ++l3;
            }
            l4 = bl ? l3 * 7L : l3;
            this.getDateFormatter().addToUnit(date3, l2, (int)l4);
            Date date4 = date2;
            date2 = new Date(date4.getTime() + (long)(d3 * (double)(date3.getTime() - date4.getTime())));
        }
        return date2;
    }

    protected double timeToData(Date date, long l2) {
        double d2 = l2;
        if (date == null) {
            return 0.0;
        }
        long l3 = this.parent.timeBase.getTime();
        Date date2 = JCChartDateFormat.getMinTime();
        Date date3 = JCChartDateFormat.getMaxTime();
        if (date.before(date2)) {
            return (double)(date2.getTime() - l3) / d2;
        }
        if (date.after(date3)) {
            return (double)(date3.getTime() - l3) / d2;
        }
        double d3 = (double)(date.getTime() - l3) / d2;
        if (l2 < 86400000L) {
            return d3;
        }
        double d4 = d3 - 2.0;
        double d5 = d3 + 2.0;
        Date date4 = this.dataToTime(d4, l2);
        Date date5 = this.dataToTime(d5, l2);
        if (date4 == null || date4.after(date)) {
            d4 = (double)(date2.getTime() - l3) / d2;
            date4 = this.dataToTime(d4, l2);
        }
        if (date5 == null || date5.before(date)) {
            d5 = (double)(date3.getTime() - l3) / d2;
            date5 = this.dataToTime(d5, l2);
        }
        double d6 = d3;
        while (d5 - d4 > 1.0E-6) {
            d3 = (d4 + d5) / 2.0;
            Date date6 = this.dataToTime(d3, l2);
            if (date6 == null) {
                return d6;
            }
            if (date6.before(date) || date4 == null) {
                d4 = d3;
                date4 = date6;
                continue;
            }
            if (date6.after(date) || date5 == null) {
                d5 = d3;
                date5 = date6;
                continue;
            }
            return d3;
        }
        return d3;
    }

    protected void checkValueAnnotations() {
        this.checkRotatedValueLabels();
    }

    private void checkTimeAnnotations() {
        JCValueLabel jCValueLabel;
        int n2;
        AxisHandler axisHandler = this.parent.getAxisHandler();
        double d2 = this.parent.min.value;
        double d3 = this.parent.max.value;
        AxisHandler.ClusterAdjustment clusterAdjustment = AxisHandler.ClusterAdjustment.NONE;
        boolean bl = this.parent.hasTimeExclusions();
        if (bl) {
            d3 = axisHandler.adjustValueRemExclusions(d2, d3, clusterAdjustment);
        }
        double d4 = d3 - d2;
        int n3 = this.valueLabels.size();
        this.makeAllInRangeLabelsVisible();
        int n4 = this.firstVisibleLabel();
        int n5 = this.lastVisibleLabel();
        Dimension dimension = new Dimension(0, 0);
        this.timeLabelExtents(dimension);
        int n6 = this.parent.i_vertical ? this.parent.getHeight() : this.parent.getWidth();
        int n7 = 0;
        if (n3 >= 2) {
            for (n2 = 0; n2 < this.valueLabels.size() - 1; ++n2) {
                double d5;
                JCValueLabel jCValueLabel2 = this.valueLabels.elementAt(n2);
                JCValueLabel jCValueLabel3 = this.valueLabels.elementAt(n2 + 1);
                if (!jCValueLabel2.drawLabel || !jCValueLabel3.drawLabel) continue;
                double d6 = jCValueLabel2.value;
                double d7 = jCValueLabel3.value;
                if (bl) {
                    d5 = this.parent.min.value;
                    d6 = axisHandler.adjustValueRemExclusions(d5, d6, clusterAdjustment);
                    d7 = axisHandler.adjustValueRemExclusions(d5, d7, clusterAdjustment);
                }
                d5 = (double)n6 * (Math.abs(d7 - d6) / d4);
                n7 = (int)JCChartUtil.precCorrect(0, d5);
                break;
            }
            n7 = Math.max(n7, 1);
        } else {
            n7 = 1;
        }
        n2 = this.parent.i_vertical ? dimension.height : dimension.width;
        int n8 = (n2 + this.parent.gap * 2) / n7;
        boolean bl2 = n8 >= 1;
        ++n8;
        if (n4 >= 0) {
            for (int i2 = n4; i2 <= n5; ++i2) {
                jCValueLabel = this.valueLabels.elementAt(i2);
                ChartText chartText = jCValueLabel.getChartText();
                if (this.parent.annotationRotation != 4) {
                    chartText.visible = this.checkLocation(jCValueLabel);
                    if (!chartText.visible) continue;
                }
                if (!bl2) continue;
                chartText.visible = (i2 - n4) % n8 == 0;
            }
        }
        if (this.dropOverlappingLabels && bl) {
            int n9 = this.labelsOverlap();
            while (n9 >= 0) {
                jCValueLabel = this.valueLabels.elementAt(n9);
                ChartText chartText = jCValueLabel.getChartText();
                chartText.visible = false;
                n9 = this.labelsOverlap();
            }
        }
        if (this.parent.dropTicksForHiddenLabels) {
            this.hideTicksForHiddenLabels();
        }
    }

    private boolean checkLocation(JCValueLabel jCValueLabel) {
        if (jCValueLabel == null) {
            return false;
        }
        ChartText chartText = jCValueLabel.getChartText();
        if (this.parent.i_vertical) {
            int n2 = chartText.getTop() + chartText.getHeight() / 2;
            return n2 >= this.parent.getTop() && n2 <= this.parent.getTop() + this.parent.getHeight();
        }
        int n3 = chartText.getLeft() + chartText.getWidth() / 2;
        return n3 >= this.parent.getLeft() && n3 <= this.parent.getLeft() + this.parent.getWidth();
    }

    private void dropLabels(int n2) {
        if (this.valueLabels == null || this.valueLabels.size() < 1) {
            return;
        }
        int n3 = this.firstVisibleLabel();
        int n4 = this.lastVisibleLabel();
        for (int i2 = n3 + 1; i2 <= n4; ++i2) {
            for (int i3 = 0; i3 < n2 && i2 <= n4; ++i2, ++i3) {
                JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
                ChartText chartText = jCValueLabel.getChartText();
                chartText.visible = false;
            }
        }
    }

    private void hideTicksForHiddenLabels() {
        int n2 = this.valueLabels.size() - 1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            jCValueLabel.drawTick = jCValueLabel.getChartText().visible;
        }
    }

    private int labelsOverlap() {
        double d2 = this.parent.getAnnotationRotationAngle(2);
        int n2 = this.firstVisibleLabel();
        int n3 = this.lastVisibleLabel();
        block0: for (int i2 = n2; i2 <= n3; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible) continue;
            Line2D.Double[] doubleArray = this.getLine2DArray(chartText, d2);
            for (int i3 = i2 + 1; i3 <= n3; ++i3) {
                JCValueLabel jCValueLabel2 = this.valueLabels.elementAt(i3);
                ChartText chartText2 = jCValueLabel2.getChartText();
                if (!chartText2.visible) continue;
                Line2D.Double[] doubleArray2 = this.getLine2DArray(chartText2, d2);
                if (!this.doLinesIntersect(doubleArray, doubleArray2)) continue block0;
                return i3;
            }
        }
        return -1;
    }

    protected void makeAllInRangeLabelsVisible() {
        double d2 = this.parent.min.value;
        double d3 = this.parent.max.value;
        if (this.parent.hasTimeExclusions()) {
            AxisHandler axisHandler = this.parent.getAxisHandler();
            d2 = axisHandler.adjustValueForward(d2, this.parent.max.value);
            d3 = axisHandler.adjustValueBackward(d3, this.parent.min.value);
        }
        for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
            double d4;
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            chartText.visible = this.parent.skipValue(jCValueLabel.value, Double.MAX_VALUE) ? false : (d4 = JCChartUtil.precCorrect(6, jCValueLabel.value)) >= d2 && d4 <= d3 && jCValueLabel.drawLabel;
        }
    }

    private void checkRotatedValueLabels() {
        if (!this.annotationVisible) {
            return;
        }
        if (this.valueLabels == null || this.valueLabels.size() < 1) {
            return;
        }
        if (this.parent.isPolarRadar()) {
            return;
        }
        if (this.dropOverlappingLabels) {
            this.hideOverlappingLabels();
        } else {
            int n2 = this.parent.toPixel(this.parent.min.value);
            int n3 = this.parent.toPixel(this.parent.max.value);
            int n4 = JCChartUtil.abs(n3 - n2);
            int n5 = this.valueLabels.size();
            if (n5 > n4) {
                n5 = n4;
                this.valueLabels = new Vector();
                int n6 = this.parent.getPrecision();
                for (int i2 = 0; i2 < n5; ++i2) {
                    double d2 = this.parent.toData(n2 + i2);
                    d2 = JCChartUtil.precCorrect(n6, d2);
                    JCValueLabel jCValueLabel = new JCValueLabel(this.parent, d2, n6);
                    this.valueLabels.addElement(jCValueLabel);
                }
                this.layout();
            }
        }
    }

    protected Rectangle getTextBoundingRectangle(ChartText chartText) {
        int n2;
        int n3 = chartText.getWidth() + this.parent.gap;
        if (n3 < 1) {
            n3 = 1;
        }
        if ((n2 = chartText.getHeight() + this.parent.gap) < 1) {
            n2 = 1;
        }
        return new Rectangle(chartText.getLeft(), chartText.getTop(), n3, n2);
    }

    protected void hideOverlappingLabels() {
        this.makeAllInRangeLabelsVisible();
        int n2 = 0;
        while (this.labelsOverlap() >= 0) {
            if (n2 > 0) {
                this.makeAllInRangeLabelsVisible();
            }
            this.dropLabels(++n2);
        }
    }

    protected void checkUserProvidedLabels() {
        if (!this.annotationVisible) {
            return;
        }
        if (this.valueLabels == null || this.valueLabels.size() < 1) {
            return;
        }
        if (this.parent.isTimelineYAxis() && this.parent.getAnnotationMethod() == 3) {
            return;
        }
        this.hideOverlappingLabels();
        if (this.parent.dropTicksForHiddenLabels) {
            this.hideTicksForHiddenLabels();
        }
    }

    protected void checkUserProvidedAnnotations() {
        if (!this.annotationVisible) {
            return;
        }
        this.checkUserProvidedLabels();
    }

    private Line2D.Double[] getLine2DArray(ChartText chartText, double d2) {
        Rectangle rectangle = this.getTextBoundingRectangle(chartText);
        Line2D.Double[] doubleArray = new Line2D.Double[4];
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2, rectangle.x, rectangle.y);
        PathIterator pathIterator = rectangle.getPathIterator(affineTransform);
        int n2 = 0;
        double[] dArray = new double[6];
        Point2D.Double double_ = null;
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(dArray);
            switch (n3) {
                case 0: {
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    if (double_ != null) {
                        doubleArray[n2] = new Line2D.Double(double_.x, double_.y, dArray[0], dArray[1]);
                        ++n2;
                    }
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("Bad PathIterator enum");
                }
            }
            pathIterator.next();
        }
        return doubleArray;
    }

    private boolean doLinesIntersect(Line2D.Double[] doubleArray, Line2D.Double[] doubleArray2) {
        if (doubleArray == null || doubleArray2 == null) {
            throw new IllegalArgumentException("Line2D array is null.");
        }
        for (Line2D.Double double_ : doubleArray) {
            for (Line2D.Double double_2 : doubleArray2) {
                if (double_ == null || double_2 == null || !double_.intersectsLine(double_2)) continue;
                return true;
            }
        }
        return false;
    }

    protected XYProjection getXYProjection(int n2, int n3, double d2) {
        XYProjection xYProjection = new XYProjection();
        xYProjection.x1 = Math.abs((double)n3 * Math.sin(d2));
        xYProjection.y1 = Math.abs((double)n3 * Math.cos(d2));
        xYProjection.x2 = Math.abs((double)n2 * Math.cos(d2));
        xYProjection.y2 = Math.abs((double)n2 * Math.sin(d2));
        return xYProjection;
    }

    private XYProjection getXYProjection(ChartText chartText, double d2) {
        return this.getXYProjection(chartText.width.value, chartText.height.value, d2);
    }

    private int getAnnoRotationCase(boolean bl, double d2) {
        int n2;
        double[] dArray = bl ? vertAxisAnnoRotationLimit : horizAxisAnnoRotationLimit;
        for (n2 = 0; n2 < dArray.length && !(d2 <= dArray[n2]); ++n2) {
        }
        return ++n2;
    }

    private Translation getTranslation(XYProjection xYProjection, double d2, int n2) {
        Translation translation;
        block46: {
            block45: {
                if (d2 < 0.0) {
                    d2 += Math.PI * 2;
                }
                translation = new Translation();
                if (!this.parent.i_vertical) break block45;
                switch (this.getAnnoRotationCase(true, d2)) {
                    case 1: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round((double)n2 + xYProjection.x2));
                            translation.dy = (int)Math.round(-xYProjection.y1 / 2.0 - xYProjection.y2 - 1.0);
                        } else {
                            translation.dx = (int)Math.round(xYProjection.x1 + (double)n2 + 1.0);
                            translation.dy = (int)Math.round(-xYProjection.y1 / 2.0) - 1;
                        }
                        break block46;
                    }
                    case 2: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round((double)n2 + xYProjection.x2));
                            translation.dy = 1 - (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0 - xYProjection.y1);
                        } else {
                            translation.dx = (int)Math.round(xYProjection.x1 + xYProjection.x2 + (double)n2 + 1.0);
                            translation.dy = 1 - (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0 - xYProjection.y1);
                        }
                        break block46;
                    }
                    case 3: {
                        if (this.anchor == 2) {
                            translation.dx = -Math.round(n2);
                            translation.dy = 1 - (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0);
                        } else {
                            translation.dx = (int)Math.round(xYProjection.x1 + xYProjection.x2 + (double)n2 + 1.0);
                            translation.dy = (int)Math.round((xYProjection.y1 - xYProjection.y2) / 2.0);
                        }
                        break block46;
                    }
                    case 4: {
                        if (this.anchor == 2) {
                            translation.dx = -Math.round(n2 + 1);
                            translation.dy = (int)Math.round(xYProjection.y1 / 2.0);
                        } else {
                            translation.dx = (int)Math.round(xYProjection.x1 + xYProjection.x2 + (double)n2);
                            translation.dy = (int)Math.round(1.0 - xYProjection.y2 + xYProjection.y1 / 2.0);
                        }
                        break block46;
                    }
                    case 5: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round(xYProjection.x1 + (double)n2 + 1.0));
                            translation.dy = (int)Math.round(xYProjection.y1 / 2.0) + 1;
                        } else {
                            translation.dx = (int)Math.round(xYProjection.x2 + (double)n2 + 1.0);
                            translation.dy = (int)Math.round(xYProjection.y2 + xYProjection.y1 / 2.0) + 1;
                        }
                        break block46;
                    }
                    case 6: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round(xYProjection.x1 + (double)n2 + 1.0));
                            translation.dy = (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0 - xYProjection.y1);
                        } else {
                            translation.dx = Math.round(n2 + 1);
                            translation.dy = (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0 - xYProjection.y1) + 1;
                        }
                        break block46;
                    }
                    case 7: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round((double)n2 + xYProjection.x1 + xYProjection.x2));
                            translation.dy = (int)Math.round((xYProjection.y1 + xYProjection.y2) / 2.0);
                        } else {
                            translation.dx = Math.round(n2);
                            translation.dy = (int)Math.round((xYProjection.y2 + xYProjection.y1) / 2.0);
                        }
                        break block46;
                    }
                    case 8: {
                        if (this.anchor == 2) {
                            translation.dx = -((int)Math.round((double)n2 + xYProjection.x1 + xYProjection.x2));
                            translation.dy = (int)Math.round(xYProjection.y2 - xYProjection.y1 / 2.0 - 1.0);
                        } else {
                            translation.dx = Math.round(n2 + 1);
                            translation.dy = -((int)Math.round(xYProjection.y1 / 2.0 + 1.0));
                        }
                        break block46;
                    }
                    default: {
                        throw new RuntimeException("Invalid rotation case for vertical axis");
                    }
                }
            }
            switch (this.getAnnoRotationCase(false, d2)) {
                case 1: {
                    if (this.anchor == 16) {
                        translation.dx = 1 - (int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0);
                        translation.dy = -((int)Math.round(xYProjection.y1 + xYProjection.y2 + (double)n2 + 2.0));
                        break;
                    }
                    translation.dx = 1 - (int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0);
                    translation.dy = Math.round(n2 + 1);
                    break;
                }
                case 2: {
                    if (this.anchor == 16) {
                        translation.dx = 1 - (int)Math.round(xYProjection.x2 - xYProjection.x1 / 2.0);
                        translation.dy = -((int)Math.round(xYProjection.y1 + xYProjection.y2 + (double)n2 + 2.0));
                        break;
                    }
                    translation.dx = (int)Math.round(xYProjection.x1 / 2.0 + 1.0);
                    translation.dy = Math.round(n2 + 1);
                    break;
                }
                case 3: {
                    if (this.anchor == 16) {
                        translation.dx = (int)Math.round(xYProjection.x2 + xYProjection.x1 / 2.0);
                        translation.dy = -((int)Math.round(xYProjection.y2 + (double)n2 + 1.0));
                        break;
                    }
                    translation.dx = (int)Math.round(xYProjection.x1 / 2.0);
                    translation.dy = (int)Math.round(xYProjection.y1 + (double)n2 + 2.0);
                    break;
                }
                case 4: {
                    if (this.anchor == 16) {
                        translation.dx = (int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0 - xYProjection.x1);
                        translation.dy = -((int)Math.round(xYProjection.y2 + (double)n2 + 1.0));
                        break;
                    }
                    translation.dx = (int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0 - xYProjection.x1);
                    translation.dy = (int)Math.round(xYProjection.y1 + (double)n2 + 2.0);
                    break;
                }
                case 5: {
                    if (this.anchor == 16) {
                        translation.dx = (int)Math.round((xYProjection.x2 - xYProjection.x1) / 2.0);
                        translation.dy = -Math.round(n2 + 1);
                        break;
                    }
                    translation.dx = (int)Math.round((xYProjection.x2 - xYProjection.x1) / 2.0);
                    translation.dy = (int)Math.round(xYProjection.y1 + xYProjection.y2 + (double)n2 + 2.0);
                    break;
                }
                case 6: {
                    if (this.anchor == 16) {
                        translation.dx = -((int)Math.round(xYProjection.x1 / 2.0 + 1.0));
                        translation.dy = -Math.round(n2 + 1);
                        break;
                    }
                    translation.dx = (int)Math.round(-xYProjection.x1 / 2.0 + xYProjection.x2) - 1;
                    translation.dy = (int)Math.round(xYProjection.y1 + xYProjection.y2 + (double)n2 + 1.0);
                    break;
                }
                case 7: {
                    if (this.anchor == 16) {
                        translation.dx = -((int)Math.round(xYProjection.x1 / 2.0 + 1.0));
                        translation.dy = -((int)Math.round(xYProjection.y1 + (double)n2 + 2.0));
                        break;
                    }
                    translation.dx = -((int)Math.round(xYProjection.x2 + xYProjection.x1 / 2.0));
                    translation.dy = (int)Math.round(xYProjection.y2 + (double)n2);
                    break;
                }
                case 8: {
                    if (this.anchor == 16) {
                        translation.dx = -((int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0));
                        translation.dy = -((int)Math.round(xYProjection.y1 + (double)n2 + 2.0));
                        break;
                    }
                    translation.dx = -((int)Math.round((xYProjection.x1 + xYProjection.x2) / 2.0));
                    translation.dy = (int)Math.round(xYProjection.y2 + (double)n2);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid rotation case for horizontal axis");
                }
            }
        }
        return translation;
    }

    private int getRotatedAnnoMinorExtent(double d2, int n2) {
        int n3 = 0;
        int n4 = this.firstVisibleLabel();
        int n5 = this.lastVisibleLabel();
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n6;
            int n7;
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            chartText.recalc();
            double d3 = jCValueLabel.getValue();
            if (!chartText.isVisible() || d3 < this.parent.getMin() || d3 > this.parent.getMax()) continue;
            XYProjection xYProjection = this.getXYProjection(chartText.width.value, chartText.height.value, d2);
            Translation translation = this.getTranslation(xYProjection, d2, n2);
            if (this.parent.i_vertical) {
                n7 = this.parent.toPixel(d3) + this.parent.pixelStart();
                if (n7 < 0) continue;
                switch (this.getAnnoRotationCase(true, d2)) {
                    case 1: 
                    case 2: {
                        n6 = Math.round(-translation.dy) - n7;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n6 = (int)Math.round((double)(-translation.dy) + xYProjection.y1) - n7;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n6 = (int)Math.round((double)(-translation.dy) + xYProjection.y1 + xYProjection.y2) - n7;
                        break;
                    }
                    case 7: 
                    case 8: {
                        n6 = (int)Math.round((double)(-translation.dy) + xYProjection.y2) - n7;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid annotation rotation case for vertical axis");
                    }
                }
            } else {
                n7 = this.parent.toPixel(d3) - this.parent.pixelStart();
                if (n7 < 0) continue;
                switch (this.getAnnoRotationCase(false, d2)) {
                    case 1: 
                    case 2: {
                        n6 = (int)Math.round((double)(-translation.dx) + xYProjection.x1) - n7;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n6 = (int)Math.round((double)(-translation.dx) + xYProjection.x1 + xYProjection.x2) - n7;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n6 = (int)Math.round((double)(-translation.dx) + xYProjection.x2) - n7;
                        break;
                    }
                    case 7: 
                    case 8: {
                        n6 = Math.round(-translation.dx) - n7;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid annotation rotation case for horizontal axis");
                    }
                }
            }
            n3 = Math.max(n6, n3);
        }
        return n3;
    }

    private int getRotatedAnnoMajorExtent(int n2, double d2, int n3) {
        int n4 = 0;
        int n5 = this.firstVisibleLabel();
        int n6 = this.lastVisibleLabel();
        for (int i2 = n5; i2 <= n6; ++i2) {
            int n7;
            int n8;
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            chartText.recalc();
            double d3 = jCValueLabel.getValue();
            if (!chartText.isVisible() || d3 < this.parent.getMin() || d3 > this.parent.getMax()) continue;
            XYProjection xYProjection = this.getXYProjection(chartText.width.value, chartText.height.value, d2);
            Translation translation = this.getTranslation(xYProjection, d2, n3);
            if (this.parent.i_vertical) {
                n8 = this.parent.isReversed() ? -this.parent.pixelStart() + this.parent.pixelLength() - this.parent.toPixel(d3) : n2 + this.parent.pixelLength() - this.parent.toPixel(d3);
                if (n8 < 0) continue;
                switch (this.getAnnoRotationCase(true, d2)) {
                    case 1: 
                    case 2: {
                        n7 = (int)Math.round((double)translation.dy + xYProjection.y1 + xYProjection.y2) - n8;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n7 = (int)Math.round((double)translation.dy + xYProjection.y2) - n8;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n7 = Math.round(translation.dy) - n8;
                        break;
                    }
                    case 7: 
                    case 8: {
                        n7 = (int)Math.round((double)translation.dy + xYProjection.y1) - n8;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid annotation rotation case for horizontal axis");
                    }
                }
            } else {
                n8 = this.parent.toPixel(jCValueLabel.getValue()) - this.parent.pixelStart();
                if (n8 < 0) continue;
                switch (this.getAnnoRotationCase(false, d2)) {
                    case 1: 
                    case 2: {
                        n7 = (int)Math.round((double)(n8 + translation.dx) + xYProjection.x2) - this.parent.pixelLength();
                        break;
                    }
                    case 3: 
                    case 4: {
                        n7 = Math.round(n8 + translation.dx) - this.parent.pixelLength();
                        break;
                    }
                    case 5: 
                    case 6: {
                        n7 = (int)Math.round((double)(n8 + translation.dx) + xYProjection.x1) - this.parent.pixelLength();
                        break;
                    }
                    case 7: 
                    case 8: {
                        n7 = (int)Math.round((double)(n8 + translation.dx) + xYProjection.x1 + xYProjection.x2) - this.parent.pixelLength();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid annotation rotation case for vertical axis");
                    }
                }
            }
            n4 = Math.max(n7, n4);
        }
        return n4;
    }

    protected int getRotatedAnnoOrthoExtent(double d2, int n2) {
        int n3 = 0;
        int n4 = this.firstVisibleLabel();
        int n5 = this.lastVisibleLabel();
        for (int i2 = n4; i2 <= n5; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            chartText.recalc();
            double d3 = jCValueLabel.getValue();
            if (!chartText.isVisible() || d3 < this.parent.getMin() || d3 > this.parent.getMax()) continue;
            XYProjection xYProjection = this.getXYProjection(chartText.width.value, chartText.height.value, d2);
            int n6 = this.parent.i_vertical ? (int)Math.round((double)(n2 + 1) + xYProjection.x1 + xYProjection.x2) : (int)Math.round((double)(n2 + 1) + xYProjection.y1 + xYProjection.y2);
            n3 = Math.max(n6, n3);
        }
        return n3;
    }

    protected Dimension getMaxRotatedAnnoDimensions() {
        int n2 = 0;
        int n3 = 0;
        double d2 = this.parent.getAnnotationRotationAngle(2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        int n4 = this.firstVisibleLabel();
        int n5 = this.lastVisibleLabel();
        for (int i2 = n4; i2 <= n5; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            chartText.recalc();
            double d3 = jCValueLabel.getValue();
            if (!chartText.isVisible() || d3 < this.parent.getMin() || d3 > this.parent.getMax()) continue;
            XYProjection xYProjection = this.getXYProjection(chartText.width.value, chartText.height.value, d2);
            int n6 = this.parent.i_vertical ? (int)Math.round(xYProjection.x1 + xYProjection.x2) : this.calcRotatedAnnoSpacing(chartText.width.value, chartText.height.value, d2);
            int n7 = this.parent.i_vertical ? this.calcRotatedAnnoSpacing(chartText.width.value, chartText.height.value, d2) : (int)Math.round(xYProjection.y1 + xYProjection.y2);
            n2 = Math.max(n6, n2);
            n3 = Math.max(n7, n3);
        }
        return new Dimension(n2, n3);
    }

    private int calcVertRotatedAnnoSpacing(XYProjection xYProjection, double d2) {
        int n2;
        try {
            n2 = (int)Math.round(xYProjection.y1 + xYProjection.x1 / Math.tan(d2));
        }
        catch (ArithmeticException arithmeticException) {
            n2 = (int)Math.round(xYProjection.y1);
        }
        return n2;
    }

    private int calcHorizRotatedAnnoSpacing(XYProjection xYProjection, double d2) {
        int n2;
        try {
            n2 = (int)Math.round(xYProjection.x1 + xYProjection.y1 / Math.tan(d2));
        }
        catch (ArithmeticException arithmeticException) {
            n2 = (int)Math.round(xYProjection.x1);
        }
        return n2;
    }

    protected int calcRotatedAnnoSpacing(int n2, int n3, double d2) {
        int n4;
        int n5;
        block20: {
            XYProjection xYProjection;
            block19: {
                if (d2 < 0.0) {
                    d2 += Math.PI * 2;
                }
                xYProjection = this.getXYProjection(n2, n3, d2);
                int n6 = n5 = this.parent.i_vertical ? (int)Math.round(xYProjection.y1 + xYProjection.y2) : (int)Math.round(xYProjection.x1 + xYProjection.x2);
                if (!this.parent.i_vertical) break block19;
                switch (this.getAnnoRotationCase(true, d2)) {
                    case 1: {
                        n4 = this.calcVertRotatedAnnoSpacing(xYProjection, 1.5707963267948966 - d2);
                        break block20;
                    }
                    case 2: 
                    case 3: {
                        n4 = n5;
                        break block20;
                    }
                    case 4: {
                        n4 = this.calcVertRotatedAnnoSpacing(xYProjection, d2 - 1.5707963267948966);
                        break block20;
                    }
                    case 5: {
                        n4 = this.calcVertRotatedAnnoSpacing(xYProjection, 4.71238898038469 - d2);
                        break block20;
                    }
                    case 6: 
                    case 7: {
                        n4 = n5;
                        break block20;
                    }
                    case 8: {
                        n4 = this.calcVertRotatedAnnoSpacing(xYProjection, d2 - 4.71238898038469);
                        break block20;
                    }
                    default: {
                        throw new RuntimeException("Invalid rotational case for vertical axis");
                    }
                }
            }
            switch (this.getAnnoRotationCase(false, d2)) {
                case 1: {
                    n4 = n5;
                    break;
                }
                case 2: {
                    n4 = this.calcHorizRotatedAnnoSpacing(xYProjection, d2);
                    break;
                }
                case 3: {
                    n4 = this.calcHorizRotatedAnnoSpacing(xYProjection, Math.PI - d2);
                    break;
                }
                case 4: 
                case 5: {
                    n4 = n5;
                    break;
                }
                case 6: {
                    n4 = this.calcHorizRotatedAnnoSpacing(xYProjection, d2 - Math.PI);
                    break;
                }
                case 7: {
                    n4 = this.calcHorizRotatedAnnoSpacing(xYProjection, Math.PI * 2 - d2);
                    break;
                }
                case 8: {
                    n4 = n5;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid rotational case for horizontal axis");
                }
            }
        }
        if (n4 > n5) {
            n4 = n5;
        }
        return n4;
    }

    private void layout(ChartText chartText, int n2, int n3) {
        chartText.recalc();
        if (this.parent.getAnnotationRotation() == 4) {
            double d2 = this.parent.getAnnotationRotationAngle(2);
            XYProjection xYProjection = this.getXYProjection(chartText, d2);
            Translation translation = this.getTranslation(xYProjection, d2, n3);
            if (this.parent.i_vertical) {
                chartText.setLocation(this.parent.linePosition() + translation.dx, n2 + translation.dy);
            } else {
                chartText.setLocation(n2 + translation.dx, this.parent.linePosition() + translation.dy);
            }
            return;
        }
        if (this.parent.i_vertical) {
            switch (this.anchor) {
                case 2: {
                    chartText.setLocation(this.parent.getLeft() + this.parent.getWidth() - chartText.getWidth() - n3 - 1, n2 - chartText.getHeight() / 2);
                    break;
                }
                case 1: {
                    chartText.setLocation(this.parent.getLeft() + n3 + 1, n2 - chartText.getHeight() / 2);
                }
            }
        } else {
            switch (this.anchor) {
                case 16: {
                    chartText.setLocation(n2 - chartText.getWidth() / 2, this.parent.getTop() + this.parent.getHeight() - chartText.getHeight() - n3 - 1);
                    break;
                }
                default: {
                    chartText.setLocation(n2 - chartText.getWidth() / 2, this.parent.getTop() + n3 + 1);
                }
            }
        }
    }

    protected void draw(Graphics graphics) {
        if (!this.annotationVisible) {
            return;
        }
        int n2 = this.firstVisibleLabel();
        int n3 = this.lastVisibleLabel();
        if (n2 < 0 || n2 >= this.valueLabels.size() || n3 < 0 || n3 >= this.valueLabels.size()) {
            return;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            if (jCValueLabel == null || !jCValueLabel.drawLabel) continue;
            Mapper mapper = this.parent.getMapper();
            if (mapper != null) {
                mapper.setDataIndex(jCValueLabel.getDataIndex());
            }
            jCValueLabel.label.draw(graphics);
        }
    }

    protected void makeValueAnnotations(ChartDataView chartDataView) {
        this.valueLabels = new Vector();
        this.parent.makeTickLabels();
    }

    private ChartDataView getAssociatedDataView() {
        return ((JCChart)this.parent.chartArea.getParent()).findData(this.parent);
    }

    protected void makeAnnotations() {
        if (!this.annotationVisible) {
            return;
        }
        ChartDataView chartDataView = this.getAssociatedDataView();
        int n2 = this.parent.getAnnotationMethod();
        if (n2 == 1) {
            this.sortValueLabels();
            this.makeValueLabels(chartDataView);
        } else if (n2 == 2) {
            this.makeTimeLabels();
        } else if (n2 == 3) {
            if (chartDataView != null) {
                if (chartDataView.getChartType() == 13) {
                    this.makeTrackLabels(chartDataView);
                } else {
                    this.makePointLabels(chartDataView);
                }
            }
        } else if (n2 == 0) {
            this.makeValueAnnotations(chartDataView);
        }
    }

    protected int firstVisibleLabel() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible || chartText.text == null) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    protected int lastVisibleLabel() {
        int n2 = 0;
        for (int i2 = this.valueLabels.size() - 1; i2 >= 0; --i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible || chartText.text == null) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    protected int getMinVisibleLabel() {
        int n2 = Integer.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible || chartText.text == null || chartText.text.equals("") || !(JCChartUtil.precCorrect(6, jCValueLabel.value) >= JCChartUtil.precCorrect(6, this.parent.min.value)) || !(jCValueLabel.value < d2)) continue;
            d2 = jCValueLabel.value;
            n2 = i2;
        }
        return n2;
    }

    protected int getMaxVisibleLabel() {
        int n2 = Integer.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel = this.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible || chartText.text == null || chartText.text.equals("") || !(JCChartUtil.precCorrect(6, jCValueLabel.value) <= JCChartUtil.precCorrect(6, this.parent.max.value)) || !(jCValueLabel.value > d2)) continue;
            d2 = jCValueLabel.value;
            n2 = i2;
        }
        return n2;
    }

    protected void sortValueLabels() {
        Vector<JCValueLabel> vector = this.userValueLabels;
        this.userValueLabels = new Vector();
        for (JCValueLabel jCValueLabel : vector) {
            int n2;
            for (n2 = 0; n2 < this.userValueLabels.size(); ++n2) {
                JCValueLabel jCValueLabel2 = this.userValueLabels.elementAt(n2);
                if (jCValueLabel.value < jCValueLabel2.value) break;
            }
            this.userValueLabels.insertElementAt(jCValueLabel, n2);
        }
    }

    protected void makeValueLabels(ChartDataView chartDataView) {
        int n2 = 0;
        int n3 = this.userValueLabels.size() - 1;
        if (chartDataView != null && this.parent.isRadar() && !this.parent.i_vertical) {
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            if (nArray != null) {
                n2 = nArray[0];
                n3 = nArray[1];
            } else {
                return;
            }
        }
        this.valueLabels = new Vector();
        if (this.parent.useAnnoTicks) {
            this.parent.makeTickLabels();
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (i2 < 0 || i2 >= this.userValueLabels.size()) continue;
            JCValueLabel jCValueLabel = this.userValueLabels.elementAt(i2);
            String string = null;
            String string2 = jCValueLabel.label.text;
            if (string2 != null && !string2.equals(string = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), string2, this.maxAnnotationWidth, this.truncateMode, this.useEllipsisWhenTruncating, jCValueLabel.label.isHTML)) && jCValueLabel.label.shortText != null) {
                string = jCValueLabel.label.shortText;
                string = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), string, this.maxAnnotationWidth, 5, false, TextRenderer.isHTML(string));
            }
            JCValueLabel jCValueLabel2 = new JCValueLabel(jCValueLabel.value, string, string2, this.parent, jCValueLabel.drawTick, jCValueLabel.drawLabel, jCValueLabel.drawGrid);
            jCValueLabel2.label.setRotation(this.parent.annotationRotation);
            jCValueLabel2.label.setBackground(jCValueLabel.label.background);
            jCValueLabel2.label.setForeground(jCValueLabel.label.foreground);
            jCValueLabel2.label.setFont(jCValueLabel.label.font);
            if (!this.parent.useAnnoTicks) {
                jCValueLabel2.anno = this.parent.getDefaultTicks();
            }
            jCValueLabel2.setParent(this.parent);
            jCValueLabel2.setImageMapInfo(jCValueLabel.getImageMapInfo());
            this.valueLabels.insertElementAt(jCValueLabel2, i2 - n2);
        }
    }

    protected void makePointLabels(ChartDataView chartDataView) {
        this.valueLabels = new Vector();
        if (chartDataView != null) {
            ChartDataViewSeries chartDataViewSeries;
            try {
                chartDataViewSeries = chartDataView.getSeries(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            if (chartDataViewSeries != null) {
                int n2 = 0;
                int n3 = Math.min(chartDataView.getPointLabels().size(), chartDataViewSeries.maxXIndex()) - 1;
                if (this.parent.useAnnoTicks) {
                    this.parent.makeTickLabels();
                }
                for (int i2 = n2; i2 <= n3; ++i2) {
                    Object object;
                    String string = chartDataView.getPointLabels().get(i2);
                    if (string == null || string.equals("")) continue;
                    String string2 = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), string, this.maxAnnotationWidth, this.truncateMode, this.useEllipsisWhenTruncating, TextRenderer.isHTML(string));
                    if (!string.equals(string2) && chartDataView.getShortPointLabels().size() > i2 && (object = chartDataView.getShortPointLabel(i2)) != null) {
                        boolean bl = TextRenderer.isHTML((String)object);
                        string2 = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), (String)object, this.maxAnnotationWidth, 5, false, bl);
                    }
                    object = new JCValueLabel(chartDataViewSeries.getX(i2), string2, string, this.parent);
                    ((JCValueLabel)object).setDataIndex(new JCDataIndex(chartDataView, null, -1, i2));
                    if (!this.parent.useAnnoTicks) {
                        ((JCValueLabel)object).anno = this.parent.getDefaultTicks();
                    }
                    ((JCValueLabel)object).label.setRotation(this.parent.annotationRotation);
                    ((JCValueLabel)object).setParent(this.parent);
                    this.valueLabels.addElement((JCValueLabel)object);
                }
            }
        }
    }

    protected void makeTrackLabels(ChartDataView chartDataView) {
        this.valueLabels = new Vector();
        if (chartDataView != null) {
            if (this.parent.useAnnoTicks) {
                this.parent.makeTickLabels();
            }
            List<ChartDataViewSeries> list = chartDataView.getSeries();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ChartDataViewSeries chartDataViewSeries = list.get(i2);
                String string = chartDataViewSeries.getTrackLabel();
                String string2 = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), string, this.maxAnnotationWidth, this.truncateMode, this.useEllipsisWhenTruncating, TextRenderer.isHTML(string));
                JCValueLabel jCValueLabel = new JCValueLabel(i2, string2, this.parent);
                jCValueLabel.setParent(this.parent);
                if (!this.parent.useAnnoTicks) {
                    jCValueLabel.anno = this.parent.getDefaultTicks();
                }
                this.valueLabels.add(jCValueLabel);
            }
        }
    }

    private long getOffsetAdjustment(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar.get(16);
        gregorianCalendar.setTime(date2);
        int n5 = gregorianCalendar.get(16);
        long l2 = 0L;
        if (n5 < n4) {
            l2 += 3600000L;
        } else if (n5 > n4) {
            l2 -= 3600000L;
        }
        if (l2 != 0L) {
            date2 = new Date(date2.getTime() + l2);
        }
        gregorianCalendar.setTime(date2);
        int n6 = gregorianCalendar.get(2);
        if (gregorianCalendar.isLeapYear(n2) && n3 >= 2 && n6 <= 1) {
            l2 -= 86400000L;
        }
        return l2;
    }

    private void makeTimeLabels() {
        Object object;
        Object object2;
        Dimension dimension;
        this.valueLabels = new Vector();
        if (this.parent.useAnnoTicks) {
            this.parent.makeTickLabels();
        }
        if (this.parent.timeBase == null) {
            this.parent.timeBase = new Date();
        }
        long l2 = this.parent.getTimeUnit();
        double d2 = (this.parent.max.value - this.parent.min.value) * (double)l2;
        JCChartDateFormat jCChartDateFormat = this.getDateFormatter();
        if (this.parent.getTimeFormatIsDefault() || this.parent.getTimeFormat() == null || this.parent.getTimeFormat().equals("")) {
            this.parent.setTimeFormat(jCChartDateFormat.getDefaultTimeFormat(d2), false);
            this.parent.setTimeFormatIsDefault(true, false);
        }
        String string = this.parent.getTimeFormat();
        String string2 = jCChartDateFormat.getLargestTimeLabel(string);
        boolean bl = this.parent.getNumberLocalization();
        this.parent.setNumberLocalization(false);
        JCValueLabel jCValueLabel = new JCValueLabel(0.0, string2, this.parent);
        if (bl) {
            this.parent.setNumberLocalization(true);
        }
        int n2 = this.parent.annotationRotation;
        jCValueLabel.label.setRotation(n2);
        jCValueLabel.setParent(this.parent);
        if (n2 == 4) {
            dimension = new Dimension();
            this.calcOtherAngleAnnoSpacing(jCValueLabel.label, dimension);
        } else {
            dimension = jCValueLabel.label.calcSize();
        }
        Dimension dimension2 = n2 == 4 ? new Dimension(dimension) : (n2 == 0 || n2 == 2 ? new Dimension(dimension.width, dimension.height) : new Dimension(dimension.height, dimension.width));
        int n3 = this.parent.gap * 2;
        int n4 = this.parent.i_vertical ? this.parent.getHeight() / (dimension2.height + n3) : this.parent.getWidth() / (dimension2.width + n3);
        n4 = Math.max(n4, 2);
        long l3 = (long)(d2 / (double)n4);
        l3 = jCChartDateFormat.niceInc(l3 / 2L, string);
        n4 = (int)(d2 / (double)l3) + 3;
        Date date = this.parent.timeBase;
        long l4 = JCChartDateFormat.getMinTime().getTime();
        long l5 = JCChartDateFormat.getMaxTime().getTime();
        date.setTime(JCChartUtil.clamp(date.getTime(), l4, l5));
        Date date2 = new Date(date.getTime());
        jCChartDateFormat.roundTime(date2, l3, JCChartDateFormat.AdjustType.ZERO);
        long l6 = date.getTime() - date2.getTime();
        if ((l6 += this.getOffsetAdjustment(date, date2)) < 0L) {
            l6 += 3600000L;
        }
        boolean bl2 = this.parent.hasTimeExclusions();
        ICalendar iCalendar = JCChartUtil.getGregorianCalendar(bl2, this.parent.getTimeZone(), this.parent.getLocale());
        iCalendar.setTime(date);
        int n5 = iCalendar.get(5);
        long l7 = JCChartDateFormat.timeIncUnits(l3);
        double d3 = (double)l3 / (double)l7;
        date2 = this.dataToTime(this.parent.min.value, l2);
        double d4 = this.timeToData(date2, l7);
        long l8 = (long)(d4 / d3);
        d4 = d3 * (double)l8;
        if (bl2 && l7 == 86400000L && this.parent.isValueExcluded(d4)) {
            Date date3 = this.dataToTime(d4, l7);
            for (JCTimeExclusion jCTimeExclusion : this.parent.getTimeExclusions()) {
                if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable() || jCTimeExclusion.getRecurrencePattern() != JCTimeExclusion.RecurrencePattern.Daily || !jCTimeExclusion.isTimeExcluded(date3)) continue;
                date3 = jCTimeExclusion.getNextAvailableTime(date3);
            }
            d4 = this.timeToData(date3, l7);
        }
        long l9 = l4;
        long l10 = l5;
        try {
            object2 = this.dataToTime(this.parent.min.value, l2);
            if (object2 != null) {
                Date date4 = new Date(((Date)object2).getTime());
                jCChartDateFormat.roundTime(date4, l3, JCChartDateFormat.AdjustType.ZERO);
                l9 = date4.getTime() - this.getOffsetAdjustment((Date)object2, date4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = this.parent.getAxisHandler();
        try {
            Date date5;
            double d5 = this.parent.max.value;
            if (bl2) {
                d5 = ((AxisHandler)object2).adjustValueBackward(this.parent.max.value, this.parent.min.value);
            }
            if ((date5 = this.dataToTime(d5, l2)) != null) {
                object = new Date(date5.getTime());
                jCChartDateFormat.roundTime((Date)object, l3, JCChartDateFormat.AdjustType.POSITIVE);
                l10 = ((Date)object).getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl3 = false;
        Date date6 = new Date();
        int n6 = 0;
        while (n6 < n4) {
            block27: {
                try {
                    date2 = this.dataToTime(d4, l7);
                    if (date2 == null) break block27;
                    long l11 = date2.getTime() - l6;
                    iCalendar.setTime(date2);
                    int n7 = iCalendar.get(5);
                    if (l7 == 2678400000L && n5 != n7 && n5 > n7) {
                        l11 += (long)(n5 - n7) * 86400000L;
                    }
                    date6.setTime(l11);
                    if (l4 > (l11 += this.getOffsetAdjustment(date2, date6)) || l5 < l11) {
                        bl3 = true;
                        --n4;
                        --n6;
                        break block27;
                    }
                    if (l9 > l11 || l10 < l11) {
                        --n4;
                        --n6;
                        break block27;
                    }
                    date2.setTime(l11);
                    if (bl2 && ((AxisHandler)object2).isTimeExcluded(date2)) break block27;
                    object = jCChartDateFormat.timeLabel(string, date2);
                }
                catch (Exception exception) {
                    JCChart jCChart = (JCChart)this.parent.chartArea.getParent();
                    if (jCChart != null) {
                        jCChart.getErrorLog().logErrorMessage("makeTimeLabels", exception);
                    }
                    object = JCChartBundle.string("com.klg.jclass.chart.Key31", this.parent.locale);
                }
                double d6 = this.timeToData(date2, l2);
                this.parent.setNumberLocalization(false);
                JCValueLabel jCValueLabel2 = new JCValueLabel(d6, (String)object, this.parent);
                if (bl) {
                    this.parent.setNumberLocalization(true);
                }
                jCValueLabel2.label.setRotation(n2);
                if (!this.parent.useAnnoTicks) {
                    jCValueLabel2.anno = this.parent.getDefaultTicks();
                }
                jCValueLabel2.setParent(this.parent);
                this.valueLabels.addElement(jCValueLabel2);
            }
            ++n6;
            d4 += d3;
        }
        if (bl3) {
            JCChart jCChart;
            JCChart jCChart2 = jCChart = this.parent != null ? this.parent.getParentChart() : null;
            if (jCChart != null) {
                object = JCChartBundle.string("com.klg.jclass.chart.Key118", this.parent.locale);
                jCChart.getErrorLog().logErrorMessage((String)object);
            }
        }
    }

    private JCValueLabel findBiggestLabel() {
        JCValueLabel jCValueLabel = null;
        int n2 = 0;
        for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
            int n3;
            JCValueLabel jCValueLabel2 = this.valueLabels.elementAt(i2);
            String string = jCValueLabel2.getChartText().getText();
            if (string == null || (n3 = string.length()) <= n2) continue;
            n2 = n3;
            jCValueLabel = jCValueLabel2;
        }
        return jCValueLabel;
    }

    private void timeLabelExtents(Dimension dimension) {
        if (this.parent.annotationRotation == 4 && !this.parent.isPolar() && !this.parent.isRadar()) {
            this.otherAngleLabelExtents(dimension);
        } else {
            this.verticalHorizontalLabelExtents(dimension);
        }
    }

    private void calcOtherAngleAnnoSpacing(ChartText chartText, Dimension dimension) {
        double d2 = this.parent.getAnnotationRotationAngle(2);
        Dimension dimension2 = chartText.calcSize();
        int n2 = this.calcRotatedAnnoSpacing(dimension2.width, dimension2.height, d2);
        if (this.parent.i_vertical) {
            dimension.height = n2;
        } else {
            dimension.width = n2;
        }
    }

    private void otherAngleLabelExtents(Dimension dimension) {
        JCValueLabel jCValueLabel = this.findBiggestLabel();
        if (jCValueLabel != null) {
            this.calcOtherAngleAnnoSpacing(jCValueLabel.getChartText(), dimension);
        }
    }

    private void verticalHorizontalLabelExtents(Dimension dimension) {
        boolean bl;
        JCValueLabel jCValueLabel = this.findBiggestLabel();
        if (jCValueLabel == null) {
            return;
        }
        Dimension dimension2 = jCValueLabel.getChartText().calcSize();
        int n2 = this.parent.getAnnotationRotation();
        boolean bl2 = bl = n2 == 1 || n2 == 3;
        if (bl) {
            dimension.width = dimension2.height;
            dimension.height = dimension2.width;
        } else {
            dimension.width = dimension2.width;
            dimension.height = dimension2.height;
        }
    }

    protected void setValueLabelParent(JCChart jCChart) {
        JCValueLabel jCValueLabel;
        int n2;
        if (this.valueLabels != null) {
            for (n2 = 0; n2 < this.valueLabels.size(); ++n2) {
                jCValueLabel = this.valueLabels.elementAt(n2);
                jCValueLabel.getChartText().setParentChart(jCChart);
            }
        }
        if (this.userValueLabels != null) {
            for (n2 = 0; n2 < this.userValueLabels.size(); ++n2) {
                jCValueLabel = this.userValueLabels.elementAt(n2);
                jCValueLabel.getChartText().setParentChart(jCChart);
            }
        }
    }

    public Vector<JCValueLabel> getValueLabels() {
        return this.valueLabels;
    }

    protected JCPickItem pick(Point point) {
        JCPickItem jCPickItem = null;
        for (JCValueLabel jCValueLabel : this.valueLabels) {
            ChartText chartText;
            if (jCValueLabel == null || !jCValueLabel.isDrawLabel() || !(chartText = jCValueLabel.getChartText()).isVisible() || !chartText.contains(point)) continue;
            jCPickItem = new JCPickItem(jCValueLabel, this.parent.chartArea, 0);
            break;
        }
        return jCPickItem;
    }

    private class Translation {
        int dx = 0;
        int dy = 0;

        private Translation() {
        }
    }
}

