/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.renderers;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.cell.Utilities;
import com.klg.jclass.util.swing.JCWordWrap;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class JCWordWrapCellRenderer
implements JCLightCellRenderer {
    protected Utilities utilities = new Utilities();
    protected boolean drawClipArrowOutline = true;

    public void draw(Graphics graphics, JCCellInfo jCCellInfo, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        Rectangle rectangle = jCCellInfo.getDrawingArea();
        graphics.setFont(jCCellInfo.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(bl ? jCCellInfo.getSelectedForeground() : jCCellInfo.getForeground());
        int n2 = jCCellInfo.getHorizontalAlignment();
        int n3 = jCCellInfo.getVerticalAlignment();
        string = JCWordWrap.wrapText(JCWordWrap.replace(string, "\n", " "), fontMetrics, rectangle.width, "\n", n2 != 4);
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        int n6 = n4 - 4;
        if (string.indexOf(10) != -1) {
            int n7 = this.getHeight(fontMetrics, string);
            if (n3 == 0) {
                n6 += (rectangle.height - n7) / 2;
            } else if (n3 == 3) {
                n6 += rectangle.height - n7;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (n2 == 0) {
                    n5 = (rectangle.width - fontMetrics.stringWidth(string2)) / 2;
                } else if (n2 == 4) {
                    n5 = rectangle.width - fontMetrics.stringWidth(string2);
                }
                graphics.drawString(string2, n5, n6);
                n6 += n4;
            }
        } else {
            if (n2 == 4) {
                n5 += rectangle.width - fontMetrics.stringWidth(string);
            } else if (n2 == 0) {
                n5 += (rectangle.width - fontMetrics.stringWidth(string)) / 2;
            }
            if (n3 == 0) {
                n6 += (rectangle.height - fontMetrics.getHeight()) / 2;
            } else if (n3 == 3) {
                n6 += rectangle.height - fontMetrics.getHeight();
            }
            graphics.drawString(string, n5, n6);
        }
        Dimension dimension = this.getPreferredSize(graphics, jCCellInfo, string);
        if ((dimension.width > rectangle.width || dimension.height > rectangle.height) && jCCellInfo.getClipHints() != 0) {
            Utilities.drawClipArrows(graphics, jCCellInfo, dimension, 4, this.drawClipArrowOutline);
        }
    }

    public int getHeight(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = 1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '\n') continue;
            ++n2;
        }
        return fontMetrics.getHeight() * n2;
    }

    public int getWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.indexOf(10) != -1) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(10, n2)) != -1) {
                n4 = Math.max(n4, fontMetrics.stringWidth(string.substring(n2, n3)));
                n2 = n3 + 1;
            }
            return Math.max(n4, fontMetrics.stringWidth(string.substring(n2, string.length())));
        }
        return fontMetrics.stringWidth(string);
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        String string;
        if (object == null) {
            return null;
        }
        Font font = jCCellInfo.getFont();
        if (graphics != null && font != null) {
            graphics.setFont(font);
        }
        if ((string = object.toString()) == null || string.length() == 0) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = jCCellInfo.getDrawingArea().width;
        int n3 = jCCellInfo.getHorizontalAlignment();
        string = JCWordWrap.wrapText(JCWordWrap.replace(string, "\n", " "), fontMetrics, n2, "\n", n3 != 4);
        return new Dimension(this.getWidth(fontMetrics, string), this.getHeight(fontMetrics, string));
    }
}

