/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class JCComboBoxCellEditor
extends JComboBox
implements JCCellEditor,
KeyListener {
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected int[] values;
    protected boolean ignoreEnterKey = false;
    private AWTEvent initialEvent;
    private boolean showPopupLater = false;
    protected Object originalValue = null;
    protected JCKeyModifier[] key_modifiers = new JCKeyModifier[]{new JCKeyModifier(40, 16), new JCKeyModifier(38, 16)};

    public JCComboBoxCellEditor() {
        this.addKeyListener(this);
    }

    public JCComboBoxCellEditor(Object[] objectArray) {
        this(objectArray, null);
    }

    public JCComboBoxCellEditor(Object[] objectArray, int[] nArray) {
        super(objectArray);
        this.values = nArray;
        this.addKeyListener(this);
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        if (aWTEvent != null && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 10) {
            this.ignoreEnterKey = true;
        }
        this.initialEvent = aWTEvent;
        if (this.values != null && object instanceof Integer) {
            this.setSelectedIndex(this.getIndexFromValue((Integer)object));
        } else {
            this.setSelectedItem(object);
        }
        this.originalValue = object;
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        if (jCCellInfo.isEditable()) {
            this.setBackground(jCCellInfo.getBackground().brighter());
        }
        this.showPopupLater = !this.isEditable() && aWTEvent != null && aWTEvent instanceof MouseEvent && aWTEvent.getID() == 502;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.showPopupLater) {
            this.showPopupLater = false;
            SwingUtilities.invokeLater(new PopupInvoker());
        }
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        if (this.values == null) {
            return this.getSelectedItem();
        }
        return new Integer(this.values[this.getSelectedIndex()]);
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.originalValue == null) {
            return object != null;
        }
        return !this.originalValue.equals(object);
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.key_modifiers;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
        } else if (keyEvent.getKeyCode() == 10 && !this.ignoreEnterKey) {
            this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
        }
        this.ignoreEnterKey = false;
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    private int getIndexFromValue(int n2) {
        if (this.values == null) {
            return n2;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public void addNotify() {
        super.addNotify();
        if (this.initialEvent != null) {
            if (this.isVisible()) {
                try {
                    this.setPopupVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.initialEvent = null;
        }
    }

    private class PopupInvoker
    implements Runnable {
        private PopupInvoker() {
        }

        public void run() {
            if (JCComboBoxCellEditor.this.isShowing() && !JCComboBoxCellEditor.this.isPopupVisible()) {
                JCComboBoxCellEditor.this.showPopup();
            }
        }
    }
}

