/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCCellTextEditor;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.JCValidateInterface;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.cell.validate.ValidateSupport;
import com.klg.jclass.util.JCEnvironment;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.FocusManager;
import javax.swing.JTextField;

public class BaseCellEditor
extends JTextField
implements JCCellTextEditor,
JCValidateInterface,
KeyListener,
MouseListener,
FocusListener {
    protected Object data;
    protected int caretPosition;
    protected AWTEvent initialEvent;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean selectAll = false;
    protected JCKeyModifier[] reservedKeys = null;
    protected ValidateSupport validate_support = new ValidateSupport();

    public BaseCellEditor() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.setDoubleBuffered(true);
        if (this.reservedKeys == null) {
            this.reservedKeys = new JCKeyModifier[4];
            this.reservedKeys[0] = new JCKeyModifier(37);
            this.reservedKeys[1] = new JCKeyModifier(39);
            this.reservedKeys[2] = new JCKeyModifier(36);
            this.reservedKeys[3] = new JCKeyModifier(35);
        }
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.initialEvent = aWTEvent;
        this.data = object;
        this.selectAll = jCCellInfo.getSelectAll();
        this.setEditable(jCCellInfo.isEditable());
        if (!this.isEditable()) {
            this.selectAll = false;
        }
        this.caretPosition = aWTEvent instanceof KeyEvent && this.data != null ? this.data.toString().length() : -1;
        this.initData();
        this.selectAllText();
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        if (jCCellInfo.isEditable() && jCCellInfo.getBackground() != null) {
            this.setBackground(jCCellInfo.getBackground().brighter());
        }
        this.setSelectedTextColor(SystemColor.textHighlightText);
        this.setSelectionColor(SystemColor.textHighlight);
        this.setFont(jCCellInfo.getFont());
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        return this.getCellEditorText();
    }

    public String getCellEditorText() {
        return this.getText();
    }

    public void setCellEditorText(String string) {
        this.caretPosition = string == null ? 0 : string.length();
        this.setText(string);
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.data == null || this.data.equals("")) {
            return object != null && !object.equals("");
        }
        return !this.data.equals(object);
    }

    protected boolean fireValidated(JCValidateEvent jCValidateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(jCValidateEvent);
        if (bl) {
            this.setVisible(true);
        }
        return bl;
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        JCValidateEvent jCValidateEvent = new JCValidateEvent(this, this.data, string, true);
        return this.fireValidated(jCValidateEvent);
    }

    public void cancelCellEditing() {
        this.initData();
        this.caretPosition = this.data == null ? 0 : this.data.toString().length();
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        return this.getPreferredSize();
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.reservedKeys;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            return;
        }
        String string = this.getText();
        if (string == null) {
            return;
        }
        if (this.caretPosition == -1) {
            this.caretPosition = string.length();
            if (this.initialEvent != null && this.initialEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)this.initialEvent;
                Component component = (Component)mouseEvent.getSource();
                Component component2 = this.getComponent();
                Point point = new Point(0, 0);
                if (component2 != component) {
                    Container container = this.getParent();
                    point.setLocation(component2.getLocation());
                    while (container != null && container != component) {
                        point.translate(container.getLocation().x, container.getLocation().y);
                        component2 = container;
                        container = component2.getParent();
                    }
                    if (container == null) {
                        point.setLocation(0, 0);
                    }
                }
                this.caretPosition = this.viewToModel(new Point(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y));
            }
        }
        this.caretPosition = Math.min(this.caretPosition, string.length());
        this.select(this.caretPosition, this.caretPosition);
        this.selectAllText();
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isVisible()) {
            if (JCEnvironment.getJavaVersion() >= 140) {
                super.processKeyEvent(keyEvent);
            } else {
                FocusManager focusManager = FocusManager.getCurrentManager();
                FocusManager.disableSwingFocusManager();
                super.processKeyEvent(keyEvent);
                FocusManager.setCurrentManager(focusManager);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 10: {
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void initData() {
        String string = this.data == null ? "" : this.data.toString();
        this.setText(string);
    }

    public void selectAllText() {
        if (this.getSelectAll() && this.isDisplayable()) {
            try {
                this.setCaretPosition(0);
                this.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selectAll();
        }
    }

    public void addValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.addValidateListener(jCValidateListener);
    }

    public void removeValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.removeValidateListener(jCValidateListener);
    }

    public void requestFocus() {
        super.requestFocus();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

