/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.AbstractBeanEditor;
import com.klg.jclass.beans.JCBeanInfo;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class LocaleEditor
extends AbstractBeanEditor {
    protected static final String[] languages = new String[]{"ab - Abkhazian", "aa - Afar", "af - Afrikaans", "sq - Albanian", "am - Amharic", "ar - Arabic", "hy - Armenian", "as - Assamese", "ay - Aymara", "az - Azerbaijani", "ba - Bashkir", "eu - Basque", "bn - Bengali", "dz - Bhutani", "bh - Bihari", "bi - Bislama", "br - Breton", "bg - Bulgarian", "my - Burmese", "be - Byelorussian", "km - Cambodian", "ca - Catalan", "zh - Chinese", "co - Corsican", "hr - Croatian", "cs - Czech", "da - Danish", "nl - Dutch", "en - English", "eo - Esperanto", "et - Estonian", "fo - Faeroese", "fj - Fiji", "fi - Finnish", "fr - French", "fy - Frisian", "gl - Galician", "ka - Georgian", "de - German", "el - Greek", "kl - Greenlandic", "gn - Guarani", "gu - Gujarati", "ha - Hausa", "he - Hebrew", "iw - Hebrew", "hi - Hindi", "hu - Hungarian", "is - Icelandic", "id - Indonesian", "in - Indonesian", "ia - Interlingua", "ie - Interlingue", "iu - Inukitut", "ik - Inupiak", "ga - Irish", "it - Italian", "ja - Japanese", "jw - Javanese", "kn - Kannada", "ks - Kashmiri", "kk - Kazakh", "rw - Kinyarwanda", "ky - Kirghiz", "rn - Kirundi", "ko - Korean", "ku - Kurdish", "lo - Laothian", "la - Latin", "lv - Latvian (Lettish)", "ln - Lingala", "lt - Lithuanian", "mk - Macedonian", "mg - Malagasy", "ms - Malay", "ml - Malayalam", "mt - Maltese", "mi - Maori", "mr - Marathi", "mo - Moldavian", "mn - Mongolian", "na - Nauru", "ne - Nepali", "no - Norwegian", "oc - Occitan", "or - Oriya", "om - Oromo (Afan)", "ps - Pashto (Pushto)", "fa - Persian", "pl - Polish", "pt - Portuguese", "pa - Punjabi", "qu - Quechua", "rm - Rhaeto-Romance", "ro - Romanian", "ru - Russian", "sm - Samoan", "sg - Sangro", "sa - Sanskrit", "gd - Scots Gaelic", "sr - Serbian", "sh - Serbo-Croatian", "st - Sesotho", "tn - Setswana", "sn - Shona", "sd - Sindhi", "si - Singhalese", "ss - Siswati", "sk - Slovak", "sl - Slovenian", "so - Somali", "es - Spanish", "su - Sundanese", "sw - Swahili", "sv - Swedish", "tl - Tagalog", "tg - Tajik", "ta - Tamil", "tt - Tatar", "te - Telugu", "th - Thai", "bo - Tibetan", "ti - Tigrinya", "to - Tonga", "ts - Tsonga", "tr - Turkish", "tk - Turkmen", "tw - Twi", "ug - Uighur", "uk - Ukrainian", "ur - Urdu", "uz - Uzbek", "vi - Vietnamese", "vo - Volapuk", "cy - Welsh", "wo - Wolof", "xh - Xhosa", "ji - Yiddish", "yi - Yiddish", "yo - Yoruba", "za - Zhuang", "zu - Zulu"};
    protected static final String[] countries = new String[]{"AF - Afghanistan", "AL - Albania", "DZ - Algeria", "AD - Andorra", "AO - Angola", "AI - Anguilla", "AR - Argentina", "AM - Armenia", "AW - Aruba", "AU - Australia", "AT - Austria", "AZ - Azerbaijan", "BS - Bahamas", "BH - Bahrain", "BD - Bangladesh", "BB - Barbados", "BY - Belarus", "BE - Belgium", "BZ - Belize", "BJ - Benin", "BM - Bermuda", "BT - Bhutan", "BO - Bolivia", "BA - Bosnia and Herzegovina", "BW - Botswana", "BR - Brazil", "BN - Brunei", "BG - Bulgaria", "BF - Burkina Faso", "BI - Burundi", "KH - Cambodia", "CM - Cameroon", "CA - Canada", "CV - Cape Verde", "CF - Central African Republic", "TD - Chad", "CL - Chile", "CN - China", "CO - Colombia", "KM - Comoros", "CG - Congo", "CR - Costa Rica", "CI - C\u00f4te d'Ivoire", "HR - Croatia", "CU - Cuba", "CY - Cyprus", "CZ - Czech Republic", "DK - Denmark", "DJ - Djibouti", "DM - Dominica", "DO - Dominican Republic", "TP - East Timor", "EC - Ecuador", "EG - Egypt", "SV - El Salvador", "GQ - Equatorial Guinea", "ER - Eritrea", "EE - Estonia", "ET - Ethiopia", "FJ - Fiji", "FI - Finland", "FR - France", "GF - French Guiana", "PF - French Polynesia", "TF - French Southern Territories", "GA - Gabon", "GM - Gambia", "GE - Georgia", "DE - Germany", "GH - Ghana", "GR - Greece", "GP - Guadeloupe", "GT - Guatemala", "GN - Guinea", "GW - Guinea-Bissau", "GY - Guyana", "HT - Haiti", "HN - Honduras", "HK - Hong Kong", "HU - Hungary", "IS - Iceland", "IN - India", "ID - Indonesia", "IR - Iran", "IQ - Iraq", "IE - Ireland", "IL - Israel", "IT - Italy", "JM - Jamaica", "JP - Japan", "JO - Jordan", "KZ - Kazakhstan", "KE - Kenya", "KI - Kiribati", "KP - North Korea", "KR - South Korea", "KW - Kuwait", "KG - Kyrgyzstan", "LA - Laos", "LV - Latvia", "LB - Lebanon", "LS - Lesotho", "LR - Liberia", "LY - Libya", "LI - Liechtenstein", "LT - Lithuania", "LU - Luxembourg", "MK - Macedonia", "MG - Madagascar", "MY - Malaysia", "ML - Mali", "MT - Malta", "MQ - Martinique", "MR - Mauritania", "MU - Mauritius", "YT - Mayotte", "MX - Mexico", "FM - Micronesia", "MD - Moldova", "MC - Monaco", "MN - Mongolia", "MS - Montserrat", "MA - Morocco", "MZ - Mozambique", "MM - Myanmar", "NA - Namibia", "NP - Nepal", "NL - Netherlands", "AN - Netherlands Antilles", "NC - New Caledonia", "NZ - New Zealand", "NI - Nicaragua", "NE - Niger", "NG - Nigeria", "NU - Niue", "NO - Norway", "OM - Oman", "PK - Pakistan", "PA - Panama", "PG - Papua New Guinea", "PY - Paraguay", "PE - Peru", "PH - Philippines", "PL - Poland", "PT - Portugal", "PR - Puerto Rico", "QA - Qatar", "RO - Romania", "RU - Russia", "RW - Rwanda", "SA - Saudi Arabia", "SN - Senegal", "SP - Serbia", "SC - Seychelles", "SL - Sierra Leone", "SG - Singapore", "SK - Slovakia", "SI - Slovenia", "SO - Somalia", "ZA - South Africa", "ES - Spain", "LK - Sri Lanka", "SD - Sudan", "SR - Suriname", "SZ - Swaziland", "SE - Sweden", "CH - Switzerland", "SY - Syria", "TW - Taiwan", "TJ - Tajikistan", "TZ - Tanzania", "TH - Thailand", "TG - Togo", "TK - Tokelau", "TO - Tonga", "TT - Trinidad and Tobago", "TN - Tunisia", "TR - Turkey", "TM - Turkmenistan", "UG - Uganda", "UA - Ukraine", "AE - United Arab Emirates", "GB - United Kingdom", "US - United States", "UY - Uruguay", "UZ - Uzbekistan", "VU - Vanuatu", "VA - Vatican", "VE - Venezuela", "VN - Vietnam", "VG - British Virgin Islands", "VI - U.S. Virgin Islands", "EH - Western Sahara", "YE - Yemen", "YU - Yugoslavia", "ZR - Zaire", "ZM - Zambia", "ZW - Zimbabwe"};
    protected static final String[] variants = new String[]{"EURO", "NY"};
    protected JComboBox language;
    protected JComboBox country;
    protected JComboBox variant;
    protected JPanel panel;
    protected Locale locale;

    public LocaleEditor() {
        super("com.klg.jclass.beans.resource.LocaleInfo", "????", "?????");
    }

    public Component getEditorComponent() {
        if (this.panel != null) {
            int n2;
            this.language = new JComboBox();
            for (n2 = 0; n2 < languages.length; ++n2) {
                this.language.addItem(languages[n2] + " - " + this.getName(languages[n2]));
            }
            this.country = new JComboBox();
            for (n2 = 0; n2 < countries.length; ++n2) {
                this.country.addItem(countries[n2] + " - " + this.getName(countries[n2]));
            }
            this.variant = new JComboBox();
            for (n2 = 0; n2 < variants.length; ++n2) {
                this.variant.addItem(variants[n2] + " - " + this.getName(variants[n2]));
            }
            this.panel = new JPanel();
            this.panel.add(this.language);
            this.panel.add(this.country);
            this.panel.add(this.variant);
        }
        return this.panel;
    }

    protected String getName(String string) {
        String string2 = JCBeanInfo.getLocaleManager().getString(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    protected String getLanguage() {
        String string = (String)this.language.getSelectedItem();
        if (string == null || string.length() == 0 || string.length() == 1) {
            return "";
        }
        return string.substring(0, 2);
    }

    protected String getCountry() {
        String string = (String)this.country.getSelectedItem();
        if (string == null || string.length() == 0 || string.length() == 1) {
            return "";
        }
        return string.substring(0, 2);
    }

    protected String getVariant() {
        String string = (String)this.variant.getSelectedItem();
        if (string == null || string.length() == 0 || string.length() == 1) {
            return "";
        }
        return string;
    }

    public String getJavaInitializationString() {
        return "new Locale(\"" + this.getLanguage() + "\", \"" + this.getCountry() + "\", \"" + this.getVariant() + "\")";
    }

    public Object getValue() {
        return new Locale(this.getLanguage(), this.getCountry(), this.getVariant());
    }

    protected String getValueAsText() {
        Locale locale = new Locale(this.getLanguage(), this.getCountry(), this.getVariant());
        return locale.toString();
    }

    public void setValue(Object object) {
        this.locale = (Locale)object;
        this.editorString = this.locale.toString();
    }
}

