/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.AbstractBeanEditor;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCColumnLayout;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCRowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public abstract class AbstractListEditor
extends AbstractBeanEditor {
    protected JList list;
    protected JTextField text;

    public AbstractListEditor(String string, String string2, String string3) {
        super(string, string2, string3);
        ListCellRenderer listCellRenderer;
        if (this.hasListCellRenderer() && (listCellRenderer = this.getCellRenderer()) != null) {
            this.list.setCellRenderer(listCellRenderer);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 280);
    }

    public Component getEditorComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JCRowLayout());
        this.list = new JList(new DefaultListModel());
        this.list.setVisibleRowCount(10);
        this.list.setBorder(new TitledBorder("Current list:"));
        this.list.setToolTipText("Current list of values");
        this.list.setFixedCellWidth(120);
        this.list.setFixedCellHeight(15);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new JCColumnLayout(0));
        jPanel2.add(JCBrace.createVerticalBrace(10));
        jPanel2.add(new JLabel("Enter a value:"));
        this.text = new JTextField(9);
        jPanel2.add((Component)this.text, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
        this.text.setToolTipText("Enter new value:");
        this.text.addActionListener(new Add());
        jPanel2.add(JCBrace.createVerticalBrace(10));
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new Add());
        jButton.setToolTipText("Adds the new value to list");
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new Remove());
        jButton2.setToolTipText("Removes selected items from the list");
        jPanel2.add((Component)jButton, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
        jPanel2.add(JCBrace.createVerticalBrace(10));
        jPanel2.add((Component)jButton2, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
        jPanel2.add(JCBrace.createVerticalBrace(10));
        jPanel.add((Component)jScrollPane, JCElasticLayout.COMPLETELY_ELASTIC_CONSTRAINT);
        jPanel.add(JCBrace.createHorizontalBrace(25));
        jPanel.add(jPanel2);
        jPanel.add(JCBrace.createHorizontalBrace(20));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        return jPanel;
    }

    protected abstract Object parse(String var1);

    protected abstract boolean hasListCellRenderer();

    protected ListCellRenderer getCellRenderer() {
        return null;
    }

    protected String getValueAsText() {
        return null;
    }

    public Object[] toArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        return defaultListModel.toArray();
    }

    public class Remove
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            DefaultListModel defaultListModel = (DefaultListModel)AbstractListEditor.this.list.getModel();
            int[] nArray = AbstractListEditor.this.list.getSelectedIndices();
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                defaultListModel.removeElementAt(nArray[n2]);
            }
            AbstractListEditor.this.list.requestFocus();
            if (nArray.length > 0) {
                n2 = defaultListModel.getSize();
                if (nArray[0] >= n2) {
                    AbstractListEditor.this.list.setSelectedIndex(n2 - 1);
                } else {
                    AbstractListEditor.this.list.setSelectedIndex(nArray[0]);
                }
            }
            AbstractListEditor.this.support.firePropertyChange(null, null, null);
        }
    }

    public class Add
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)AbstractListEditor.this.list.getModel();
            Object object = AbstractListEditor.this.parse(AbstractListEditor.this.text.getText());
            if (object != null && !defaultListModel.contains(object)) {
                defaultListModel.addElement(object);
            }
            AbstractListEditor.this.text.setText("");
            AbstractListEditor.this.text.requestFocus();
            AbstractListEditor.this.support.firePropertyChange(null, null, null);
        }
    }
}

