/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public final class WindowsTreeUI
extends com.sun.java.swing.plaf.windows.WindowsTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent b2) {
        return new WindowsTreeUI();
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.updateLineStyle(c2.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        c2.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent c2) {
        c2.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(c2);
    }

    protected void paintVerticalLine(Graphics g2, JComponent c2, int x, int top, int bottom) {
        if (this.linesEnabled) {
            super.paintVerticalLine(g2, c2, x, top, bottom);
        }
    }

    protected void paintHorizontalLine(Graphics g2, JComponent c2, int y, int left, int right) {
        if (this.linesEnabled) {
            super.paintHorizontalLine(g2, c2, y, left, right);
        }
    }

    protected void drawCentered(Component c2, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c2, graphics, x - icon.getIconWidth() / 2 - 1, y - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object lineStyle) {
        this.linesEnabled = !"None".equals(lineStyle);
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            Object value = e2.getNewValue();
            if (name.equals("JTree.lineStyle")) {
                WindowsTreeUI.this.updateLineStyle(value);
            }
        }
    }
}

