/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class PlasticInternalFrameUI
extends BasicInternalFrameUI {
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    public static final String IS_PALETTE = "JInternalFrame.isPalette";
    private static final String PALETTE_FRAME = "palette";
    private static final String OPTION_DIALOG = "optionDialog";
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private PlasticInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;

    public PlasticInternalFrameUI(JInternalFrame b2) {
        super(b2);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new PlasticInternalFrameUI((JInternalFrame)c2);
    }

    @Override
    public void installUI(JComponent c2) {
        this.frame = (JInternalFrame)c2;
        this.paletteListener = new PaletteListener(this);
        this.contentPaneListener = new ContentPaneListener();
        c2.addPropertyChangeListener(this.paletteListener);
        c2.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(c2);
        Object paletteProp = c2.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        Container content = this.frame.getContentPane();
        PlasticInternalFrameUI.stripContentBorder(content);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        JComponent content;
        this.frame = (JInternalFrame)c2;
        c2.removePropertyChangeListener(this.paletteListener);
        c2.removePropertyChangeListener(this.contentPaneListener);
        Container cont = ((JInternalFrame)c2).getContentPane();
        if (cont instanceof JComponent && (content = (JComponent)cont).getBorder() == EMPTY_BORDER) {
            content.setBorder(null);
        }
        super.uninstallUI(c2);
    }

    @Override
    protected void installDefaults() {
        Color bg;
        super.installDefaults();
        JComponent contentPane = (JComponent)this.frame.getContentPane();
        if (contentPane != null && (bg = contentPane.getBackground()) instanceof UIResource) {
            contentPane.setBackground(null);
        }
        this.frame.setBackground(UIManager.getLookAndFeelDefaults().getColor("control"));
    }

    @Override
    protected void installKeyboardActions() {
    }

    @Override
    protected void uninstallKeyboardActions() {
    }

    private static void stripContentBorder(Object c2) {
        JComponent contentComp;
        Border contentBorder;
        if (c2 instanceof JComponent && ((contentBorder = (contentComp = (JComponent)c2).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentComp.setBorder(EMPTY_BORDER);
        }
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new PlasticInternalFrameTitlePane(w);
        return this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        String key = isPalette ? "InternalFrame.paletteBorder" : "InternalFrame.border";
        LookAndFeel.installBorder(this.frame, key);
        this.titlePane.setPalette(isPalette);
    }

    private void setFrameType(String frameType) {
        boolean hasPalette = frameType.equals(PALETTE_FRAME);
        String key = frameType.equals(OPTION_DIALOG) ? "InternalFrame.optionDialogBorder" : (hasPalette ? "InternalFrame.paletteBorder" : "InternalFrame.border");
        LookAndFeel.installBorder(this.frame, key);
        this.titlePane.setPalette(hasPalette);
    }

    private static final class ContentPaneListener
    implements PropertyChangeListener {
        private ContentPaneListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            if (name.equals("contentPane")) {
                PlasticInternalFrameUI.stripContentBorder(e2.getNewValue());
            }
        }
    }

    private static final class PaletteListener
    implements PropertyChangeListener {
        private final PlasticInternalFrameUI ui;

        private PaletteListener(PlasticInternalFrameUI ui) {
            this.ui = ui;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            Object value = e2.getNewValue();
            if (name.equals(PlasticInternalFrameUI.FRAME_TYPE)) {
                if (value instanceof String) {
                    this.ui.setFrameType((String)value);
                }
            } else if (name.equals(PlasticInternalFrameUI.IS_PALETTE)) {
                this.ui.setPalette(Boolean.TRUE.equals(value));
            }
        }
    }
}

