/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBumps;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public final class PlasticInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private PlasticBumps paletteBumps;
    private final PlasticBumps activeBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControl());
    private final PlasticBumps inactiveBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getControlHighlight(), PlasticLookAndFeel.getControlDarkShadow(), PlasticLookAndFeel.getControl());

    public PlasticInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    @Override
    public void paintPalette(Graphics g2) {
        boolean leftToRight = PlasticUtils.isLeftToRight(this.frame);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlInfo(), PlasticLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource background = PlasticLookAndFeel.getPrimaryControlShadow();
        ColorUIResource darkShadow = PlasticLookAndFeel.getControlDarkShadow();
        g2.setColor(background);
        g2.fillRect(0, 0, width, height);
        g2.setColor(darkShadow);
        g2.drawLine(0, height - 1, width, height - 1);
        int buttonsWidth = this.getButtonsWidth();
        int xOffset = leftToRight ? 4 : buttonsWidth + 4;
        int bumpLength = width - buttonsWidth - 8;
        int bumpHeight = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(bumpLength, bumpHeight);
        this.paletteBumps.paintIcon(this, g2, xOffset, 2);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int bumpXOffset;
        int bumpLength;
        PlasticBumps bumps;
        if (this.isPalette) {
            this.paintPalette(g2);
            return;
        }
        boolean leftToRight = PlasticUtils.isLeftToRight(this.frame);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorUIResource background = null;
        ColorUIResource foreground = null;
        ColorUIResource shadow = null;
        if (isSelected) {
            background = PlasticLookAndFeel.getWindowTitleBackground();
            foreground = PlasticLookAndFeel.getWindowTitleForeground();
            bumps = this.activeBumps;
        } else {
            background = PlasticLookAndFeel.getWindowTitleInactiveBackground();
            foreground = PlasticLookAndFeel.getWindowTitleInactiveForeground();
            bumps = this.inactiveBumps;
        }
        shadow = PlasticLookAndFeel.getControlDarkShadow();
        g2.setColor(background);
        g2.fillRect(0, 0, width, height);
        g2.setColor(shadow);
        g2.drawLine(0, height - 1, width, height - 1);
        g2.drawLine(0, 0, 0, 0);
        g2.drawLine(width - 1, 0, width - 1, 0);
        int titleLength = 0;
        int xOffset = leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g2, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        if (frameTitle != null) {
            int titleW;
            Font f2 = this.getFont();
            g2.setFont(f2);
            FontMetrics fm = g2.getFontMetrics();
            g2.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= SwingUtilities.computeStringWidth(fm, frameTitle);
            }
            titleLength = SwingUtilities.computeStringWidth(fm, frameTitle);
            g2.drawString(frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
        int buttonsWidth = this.getButtonsWidth();
        if (leftToRight) {
            bumpLength = width - buttonsWidth - xOffset - 5;
            bumpXOffset = xOffset;
        } else {
            bumpLength = xOffset - buttonsWidth - 5;
            bumpXOffset = buttonsWidth + 5;
        }
        int bumpYOffset = 3;
        int bumpHeight = this.getHeight() - 2 * bumpYOffset;
        bumps.setBumpArea(bumpLength, bumpHeight);
        bumps.paintIcon(this, g2, bumpXOffset, bumpYOffset);
    }

    @Override
    protected String getTitle(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "\u2026";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    private int getButtonsWidth() {
        int spacing;
        boolean leftToRight = PlasticUtils.isLeftToRight(this.frame);
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int buttonWidth = this.closeButton.getIcon().getIconWidth();
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                spacing = 3;
                x += leftToRight ? -spacing - (buttonWidth + 2) : spacing;
                if (!leftToRight) {
                    x += buttonWidth + 2;
                }
            } else {
                spacing = 4;
                x += leftToRight ? -spacing - buttonWidth : spacing;
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            spacing = this.frame.isClosable() ? 10 : 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            spacing = this.frame.isMaximizable() ? 2 : (this.frame.isClosable() ? 10 : 4);
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        return leftToRight ? w - x : x;
    }
}

