/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;

    public static ComponentUI createUI(JComponent b2) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get("Button.borderPaintsFocus"));
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            AbstractButton b2 = (AbstractButton)c2;
            if (this.isToolBarButton(b2)) {
                c2.setOpaque(false);
            } else if (b2.isContentAreaFilled()) {
                g2.setColor(c2.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
                if (this.is3D(b2)) {
                    Rectangle r2 = new Rectangle(1, 1, c2.getWidth() - 2, c2.getHeight() - 1);
                    PlasticUtils.add3DEffekt(g2, r2);
                }
            }
        }
        this.paint(g2, c2);
    }

    @Override
    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.borderPaintsFocus) {
            return;
        }
        boolean isDefault = b2 instanceof JButton && ((JButton)b2).isDefaultButton();
        int topLeftInset = isDefault ? 3 : 2;
        int width = b2.getWidth() - 1 - topLeftInset * 2;
        int height = b2.getHeight() - 1 - topLeftInset * 2;
        g2.setColor(this.getFocusColor());
        g2.drawRect(topLeftInset, topLeftInset, width - 1, height - 1);
    }

    protected boolean isToolBarButton(AbstractButton b2) {
        Container parent = b2.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton b2) {
        if (PlasticUtils.force3D(b2)) {
            return true;
        }
        if (PlasticUtils.forceFlat(b2)) {
            return false;
        }
        ButtonModel model = b2.getModel();
        return PlasticUtils.is3D("Button.") && b2.isBorderPainted() && model.isEnabled() && (!model.isPressed() || !model.isArmed());
    }
}

