/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class KunststoffProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent x) {
        return new KunststoffProgressBarUI();
    }

    public void paint(Graphics g2, JComponent c2) {
        super.paint(g2, c2);
        JProgressBar prog = (JProgressBar)c2;
        if (prog.getOrientation() == 0) {
            ColorUIResource colorShadow;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle rect = new Rectangle(0, 0, c2.getWidth(), c2.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rect, true);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle rect = new Rectangle(0, c2.getHeight() / 2, c2.getWidth(), c2.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rect, true);
            }
        } else {
            ColorUIResource colorShadow;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle rect = new Rectangle(0, 0, c2.getWidth() / 2, c2.getHeight());
                KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rect, false);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle rect = new Rectangle(c2.getWidth() / 2, 0, c2.getWidth() / 2, c2.getHeight());
                KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rect, false);
            }
        }
    }
}

