/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.table;

import com.agentpp.util.table.TableGregorianRenderer;
import com.agentpp.util.table.TableSorter;
import com.agentpp.util.table.ToolTipTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TablePanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    protected JFrame myFrame = null;
    protected JTable tableView = null;
    protected TableSorter sorter = null;
    protected JScrollPane scrollpane = null;
    protected TableModel data = null;
    protected int sortedColumn = -1;
    public static boolean SORT_MODE_ONCE = true;
    public static boolean SORT_MODE_ALWAYS = false;
    protected boolean sortmode = SORT_MODE_ONCE;

    public TablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tableView = new JTable();
        this.scrollpane = new JScrollPane(this.tableView);
        this.scrollpane.setBackground(this.getBackground());
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setHorizontalScrollBarPolicy(32);
        this.add((Component)this.scrollpane, "Center");
    }

    public void setRendererForTable() {
        TableGregorianRenderer gregor = new TableGregorianRenderer();
        this.tableView.setDefaultRenderer(GregorianCalendar.class, gregor);
        this.tableView.setDefaultRenderer(String.class, new ToolTipTableCellRenderer());
    }

    public void setSortedColumn(int i2) {
        this.sortedColumn = i2;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void setSortMode(boolean mode) {
        this.sortmode = mode;
    }

    public boolean getSortMode() {
        return this.sortmode;
    }

    public void setTableModel(TableModel model) {
        this.data = model;
    }

    public void setFrame(JFrame f2) {
        this.myFrame = f2;
    }

    public void setModel(TableModel m2) {
        this.data = m2;
    }

    public void updateSort() {
        if (this.sortmode == SORT_MODE_ALWAYS && this.sortedColumn != -1) {
            this.sort(this.sortedColumn);
        }
    }

    public void create() {
        if (this.data != null) {
            this.sorter = new TableSorter(this.data);
            this.tableView.setModel(this.sorter);
            this.tableView.getTableHeader().setReorderingAllowed(false);
            this.tableView.setSelectionMode(2);
            this.setRendererForTable();
            this.tableView.createDefaultColumnsFromModel();
            this.tableView.tableChanged(new TableModelEvent(this.sorter));
            this.addMouseListenerToHeaderInTable(this.tableView);
            this.updateSort();
        } else {
            this.sorter = new TableSorter(this.data);
            this.tableView.setModel(this.sorter);
            this.setRendererForTable();
            this.tableView.createDefaultColumnsFromModel();
            this.tableView.tableChanged(new TableModelEvent(this.sorter));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        this.tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                TablePanel.this.clearSelection();
                TableColumnModel columnModel = TablePanel.this.tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e2.getX());
                int column = TablePanel.this.tableView.convertColumnIndexToModel(viewColumn);
                if (e2.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e2.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TablePanel.this.sorter.sortByColumn(column, ascending);
                    TablePanel.this.sortedColumn = column;
                }
            }
        };
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void clearSelection() {
        TableCellEditor ed = this.tableView.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        this.tableView.clearSelection();
    }

    public void sort(int n2) {
        this.sorter.sortByColumn(n2);
        this.sortedColumn = n2;
    }

    public int getSelectedRow() {
        if (this.tableView != null) {
            return this.tableView.getSelectedRow();
        }
        return -1;
    }

    public int getRowInTableModel(int r2) {
        return this.sorter.getRowInTableModel(r2);
    }

    public int getRowInView(int r2) {
        if (this.sorter == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.sorter.getRowCount(); ++i2) {
            if (this.getRowInTableModel(i2) != r2) continue;
            return i2;
        }
        return -1;
    }

    public int getSelectedRowInTableModel() {
        int r2 = this.getSelectedRow();
        if (r2 < 0) {
            return r2;
        }
        return this.sorter.getRowInTableModel(r2);
    }

    public int[] getSelectedRowsInTableModel() {
        int[] i2 = null;
        boolean len = false;
        if (this.tableView != null && this.sorter != null && this.data != null) {
            int[] s = this.tableView.getSelectedRows();
            i2 = new int[s.length];
            for (int j2 = 0; j2 < s.length; ++j2) {
                if (s[j2] == -1) continue;
                i2[j2] = this.sorter.getRowInTableModel(s[j2]);
            }
            return i2;
        }
        return null;
    }

    public int[] getSelectedRows() {
        if (this.tableView != null) {
            return this.tableView.getSelectedRows();
        }
        return null;
    }

    public void setSelectedRow(int r2) {
        if (this.tableView != null && r2 >= 0 && r2 < this.tableView.getRowCount()) {
            this.tableView.setRowSelectionInterval(r2, r2);
        }
    }

    public void addSelectedRow(int r2) {
        if (this.tableView != null && r2 >= 0 && r2 < this.tableView.getRowCount()) {
            this.tableView.addRowSelectionInterval(r2, r2);
        }
    }

    public JTable getJTable() {
        return this.tableView;
    }

    public void setColumnsToFit() {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        for (int i2 = 0; i2 < this.data.getColumnCount(); ++i2) {
            column = this.tableView.getColumnModel().getColumn(i2);
            TableCellRenderer defaultRenderer = column.getHeaderRenderer();
            if (defaultRenderer == null) {
                JTableHeader th = this.tableView.getTableHeader();
                try {
                    Method m2 = th.getClass().getMethod("getDefaultRenderer", null);
                    defaultRenderer = (TableCellRenderer)m2.invoke((Object)th, (Object[])null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (defaultRenderer != null) {
                comp = defaultRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            }
            headerWidth = comp.getPreferredSize().width;
            cellWidth = 0;
            for (int j2 = 0; j2 < this.data.getRowCount(); ++j2) {
                comp = this.tableView.getDefaultRenderer(this.data.getColumnClass(i2)).getTableCellRendererComponent(this.tableView, this.data.getValueAt(j2, i2), false, false, 0, i2);
                if (comp.getPreferredSize().width <= cellWidth) continue;
                cellWidth = comp.getPreferredSize().width;
            }
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public void removeSelectedRows() {
        if (!(this.data instanceof DefaultTableModel)) {
            return;
        }
        int[] rows = this.getSelectedRowsInTableModel();
        if (rows == null) {
            return;
        }
        this.clearSelection();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            ((DefaultTableModel)this.data).removeRow(rows[i2]);
            for (int j2 = i2 + 1; j2 < rows.length; ++j2) {
                if (rows[j2] <= rows[i2]) continue;
                int n2 = j2;
                rows[n2] = rows[n2] - 1;
            }
        }
    }

    public void addTableModelListener(TableModelListener l2) {
        this.sorter.addTableModelListener(l2);
    }

    public Vector sortVectorByView(Vector modelVector) {
        if (this.sorter.getRowCount() != modelVector.size()) {
            return modelVector;
        }
        Vector v = new Vector(modelVector.size() + 1);
        for (int i2 = 0; i2 < this.sorter.getRowCount(); ++i2) {
            v.addElement(modelVector.elementAt(this.sorter.getRowInTableModel(i2)));
        }
        return v;
    }
}

