/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.UserConfigFile;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.CipherPool;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.OctetString;

public class PropertyEncrypter {
    private Random _$5457 = new Random();
    private AuthHMAC192SHA256 _$5458 = new AuthHMAC192SHA256();
    protected CipherPool cipherPool;
    private UserConfigFile _$5460;
    private static final int _$5461 = 16;

    public PropertyEncrypter(UserConfigFile config) {
        this._$5460 = config;
        this.cipherPool = new CipherPool();
    }

    public static OctetString makeOctetStringFromHEX(String s) {
        return s == null ? null : OctetString.fromHexString(s);
    }

    public byte[] decrypt(byte[] payload, OctetString salt) {
        OctetString masterPassword;
        if (payload == null) {
            return null;
        }
        if (this._$5460.getMasterKey() != null && (masterPassword = new OctetString(this._$5460.getMasterKey())) != null && masterPassword.length() >= 8 && salt != null && salt.length() > 0) {
            try {
                byte[] decryptionKey = SecurityProtocols.getInstance().passwordToKey(PrivAES128.ID, AuthHMAC192SHA256.ID, masterPassword, salt.toByteArray());
                Cipher alg = this.cipherPool.reuseCipher();
                if (alg == null) {
                    alg = Cipher.getInstance("AES/CFB/NoPadding");
                }
                SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, 16, "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(salt.getValue());
                alg.init(2, (Key)key, ivSpec);
                byte[] decryptedData = alg.doFinal(payload);
                this.cipherPool.offerCipher(alg);
                return decryptedData;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return payload;
    }

    public byte[] encrypt(byte[] payload, OctetString salt, boolean throwExceptionIfNotEncrypted) {
        if (payload == null) {
            return null;
        }
        if (this._$5460.getMasterKey() != null) {
            OctetString masterPassword = new OctetString(this._$5460.getMasterKey());
            if (masterPassword != null && masterPassword.length() >= 8 && salt != null) {
                byte[] newSalt = new byte[16];
                this._$5457.nextBytes(newSalt);
                salt.setValue(newSalt);
                try {
                    byte[] encryptionKey = SecurityProtocols.getInstance().passwordToKey(PrivAES128.ID, AuthHMAC192SHA256.ID, masterPassword, newSalt);
                    Cipher alg = this.cipherPool.reuseCipher();
                    if (alg == null) {
                        alg = Cipher.getInstance("AES/CFB/NoPadding");
                    }
                    SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, 16, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(salt.getValue());
                    alg.init(1, (Key)key, ivSpec);
                    byte[] encryptedData = alg.doFinal(payload);
                    this.cipherPool.offerCipher(alg);
                    return encryptedData;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (throwExceptionIfNotEncrypted) {
                throw new RuntimeException("No master password provided");
            }
        } else if (throwExceptionIfNotEncrypted) {
            throw new RuntimeException("No master password provided");
        }
        return payload;
    }
}

