/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.PropertyEncrypter;
import com.agentpp.util.UserConfigFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.snmp4j.smi.OctetString;

public class EncryptedUserConfigFile
extends UserConfigFile {
    private static final String _$5433 = "\n..E";
    private static final String _$5434 = "01|";
    private PropertyEncrypter _$5435;

    public EncryptedUserConfigFile(PropertyEncrypter encrypter) {
        this._$5435 = encrypter;
    }

    public EncryptedUserConfigFile(PropertyEncrypter encrypter, boolean allowZeroLengthValues) {
        super(allowZeroLengthValues);
        this._$5435 = encrypter;
    }

    protected void load(InputStream is) throws IOException {
        InputStream dis = is;
        if (!is.markSupported()) {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            dis = new ByteArrayInputStream(buffer.toByteArray());
        }
        is.mark(8);
        byte[] magicString = new byte[_$5433.length()];
        int read = dis.read(magicString, 0, magicString.length);
        if (read < _$5433.length() || !Arrays.equals(_$5433.getBytes(), magicString)) {
            dis.reset();
            super.load(dis);
        } else {
            int nRead;
            if (this.getMasterKey() == null || this.getMasterKey().length < 8) {
                throw new IOException("Configuration file is encrypted, but master password not given or shorter than 8 characters!");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] payload = buffer.toByteArray();
            int posSaltStart = _$5433.length() + 1 + _$5434.length();
            int posSaltEnd = EncryptedUserConfigFile._$5455(payload, (byte)10, _$5433.length() + 1);
            if (posSaltEnd < posSaltStart) {
                throw new IOException("Wrong encryption format, checksum hash not found");
            }
            byte[] salt = Arrays.copyOfRange(payload, posSaltStart, posSaltEnd);
            byte[] cryptedProperties = Arrays.copyOfRange(payload, posSaltEnd + 1, payload.length);
            byte[] properties = this._$5435.decrypt(cryptedProperties, new OctetString(salt));
            super.load(new ByteArrayInputStream(properties));
        }
    }

    private static int _$5455(byte[] bytes, byte searchByte, int startPos) {
        for (int i2 = startPos; i2 < bytes.length; ++i2) {
            if (bytes[i2] != searchByte) continue;
            return i2;
        }
        return -1;
    }

    protected void saveAs(File f2) {
        if (this.getMasterKey() != null && this.getMasterKey().length >= 8) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                this.properties.store(buffer, "Config File of: " + System.getProperty("user.name"));
                OctetString salt = new OctetString();
                byte[] propertyBytes = this._$5435.encrypt(buffer.toByteArray(), salt, true);
                FileOutputStream fos = new FileOutputStream(f2);
                fos.write(_$5433.getBytes());
                fos.write(_$5434.getBytes());
                fos.write(salt.toHexString().getBytes());
                fos.write(10);
                fos.write(propertyBytes);
                fos.flush();
                fos.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            super.saveAs(f2);
        }
    }
}

