/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.snmp.SimpleStatistics;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.RequestStatistics;

public class TargetStatistics {
    public static final int PDU_SIZE_CLASS_LIMIT = 5;
    private Map<Integer, RequestStats> requestStatsMap = new TreeMap<Integer, RequestStats>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CommandResponderEvent responderEvent) {
        PduHandle pduHandle = responderEvent.getPduHandle();
        if (pduHandle instanceof RequestStatistics) {
            int[] reponseClasses;
            RequestStatistics requestStatistics = (RequestStatistics)((Object)pduHandle);
            int pduSize = responderEvent.getPDU().size();
            int respClass = pduSize / 5 + 1;
            for (int responseClass : reponseClasses = new int[]{-1, respClass}) {
                RequestStats requestStats = this.requestStatsMap.get(responseClass);
                if (requestStats == null) {
                    requestStats = new RequestStats();
                    Map<Integer, RequestStats> map = this.requestStatsMap;
                    synchronized (map) {
                        this.requestStatsMap.put(responseClass, requestStats);
                    }
                }
                requestStats.getTotalMessages().add(requestStatistics.getTotalMessagesSent());
                requestStats.getResponseMessageIndex().add(requestStatistics.getIndexOfMessageResponded());
                requestStats.getRuntimes().add(requestStatistics.getResponseRuntimeNanos() / 1000000L);
            }
        }
    }

    public Collection<Integer> getStatisticsKeys() {
        return this.requestStatsMap.keySet();
    }

    public RequestStats getStatistics(Integer key) {
        return this.requestStatsMap.get(key);
    }

    public String toString() {
        return "TargetStatistics{requestStatsMap=" + this.requestStatsMap + '}';
    }

    public static class RequestStats {
        private SimpleStatistics runtimes = new SimpleStatistics();
        private SimpleStatistics totalMessages = new SimpleStatistics();
        private SimpleStatistics responseMessageIndex = new SimpleStatistics();

        public SimpleStatistics getRuntimes() {
            return this.runtimes;
        }

        public SimpleStatistics getTotalMessages() {
            return this.totalMessages;
        }

        public SimpleStatistics getResponseMessageIndex() {
            return this.responseMessageIndex;
        }

        public String toString() {
            return "RequestStats{runtimes=" + this.runtimes + ", totalMessages=" + this.totalMessages + ", responseMessageIndex=" + this.responseMessageIndex + '}';
        }
    }
}

