/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.snmp.ValueConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.ArgumentParser;

public class SerializableMIBInstance
implements Serializable {
    static final long serialVersionUID = -4679662995055824125L;
    private ValueConverter valueConverter;
    private Object value;
    private ObjectID oid;

    public SerializableMIBInstance() {
    }

    public SerializableMIBInstance(ValueConverter vc, ObjectID oid, Serializable value) {
        this.valueConverter = vc;
        this.value = value;
        this.oid = oid;
    }

    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public ObjectID getOid() {
        return this.oid;
    }

    public void setOid(ObjectID oid) {
        this.oid = oid;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("+h", "-in[s] -out[s]");
        Map<String, List<?>> commandLineParameters = null;
        try {
            commandLineParameters = parser.parse(args);
            if (commandLineParameters.containsKey("h")) {
                SerializableMIBInstance.printUsage();
                System.exit(0);
            }
            String in = (String)ArgumentParser.getValue(commandLineParameters, "in", 0);
            String out = (String)ArgumentParser.getValue(commandLineParameters, "out", 0);
            FileInputStream fis = new FileInputStream(new File(in));
            ObjectInputStream ois = new ObjectInputStream(fis);
            List l2 = (List)ois.readObject();
            ArrayList<VariableBinding> v = new ArrayList<VariableBinding>(l2.size());
            for (Object o2 : l2) {
                if (!(o2 instanceof SerializableMIBInstance)) continue;
                SerializableMIBInstance si = (SerializableMIBInstance)o2;
                ValueConverter vc = si.getValueConverter();
                Variable var = vc.fromNative(si.getValue());
                v.add(new VariableBinding(new OID(si.getOid().asIntArray()), var));
            }
            FileOutputStream file = new FileOutputStream(new File(out));
            ObjectOutputStream output = new ObjectOutputStream(file);
            output.writeObject(v);
            output.flush();
            output.close();
        }
        catch (ParseException pex) {
            SerializableMIBInstance.printUsage();
            System.exit(1);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ObjectIDFormatException ex) {
            ex.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("java -jar SnapshotConv.jar [-h] <mibexplorer-snaphost-file> <snmp4j-snapshot-file>");
    }
}

