/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public class ParseException
extends Exception
implements FileError {
    private boolean next = true;
    protected static ResourceBundle res = null;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public int errorType = 1000;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        ParseException.initResources();
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        ParseException.initResources();
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, int errorType) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.errorType = errorType;
        this.next = false;
        ParseException.initResources();
    }

    public ParseException(String message, Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, int errorType, boolean next) {
        super(message);
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.errorType = errorType;
        this.next = next;
        ParseException.initResources();
    }

    public ParseException() {
        this.specialConstructor = false;
        ParseException.initResources();
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public void freeUnusedTokens() {
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize >= this.expectedTokenSequences[i2].length) continue;
                maxSize = this.expectedTokenSequences[i2].length;
            }
        }
        if (this.next) {
            ++maxSize;
        }
        Token tok = this.currentToken;
        for (int i3 = 0; i3 < maxSize && tok != null; ++i3) {
            tok.specialToken = null;
            tok = tok.next;
        }
        if (tok != null) {
            tok.next = null;
            tok.specialToken = null;
        }
    }

    public Token getToken() {
        if (this.next) {
            return this.currentToken.next;
        }
        return this.currentToken;
    }

    public int getErrorType() {
        return this.errorType;
    }

    private static void initResources() {
        if (res == null) {
            Locale locale = Locale.getDefault();
            res = ResourceBundle.getBundle(DefaultRepositoryManager.getResourceClassName(), new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        }
    }

    private String getEntcountered(int maxSize, boolean shortMessage) {
        String format;
        String string = format = shortMessage ? res.getString("txtEncounteredShort") : res.getString("txtEncountered");
        if (!shortMessage && super.getMessage().length() > 0) {
            format = res.getString("txtEncounteredAsDetailText");
        }
        StringBuffer txt = new StringBuffer();
        Token tok = this.getToken();
        for (int i2 = 0; i2 < maxSize && tok != null; ++i2) {
            if (i2 != 0) {
                txt.append(" ");
            }
            if (tok.kind == 0) {
                txt.append(this.tokenImage[0]);
                break;
            }
            txt.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        return MessageFormat.format(format, txt);
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize < this.expectedTokenSequences[i2].length) {
                    maxSize = this.expectedTokenSequences[i2].length;
                }
                for (int j2 = 0; j2 < this.expectedTokenSequences[i2].length; ++j2) {
                    expected = expected + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
                }
                if (this.expectedTokenSequences[i2][this.expectedTokenSequences[i2].length - 1] != 0) {
                    expected = expected + "...";
                }
                expected = expected + this.eol + "  ";
            }
        } else if (this.tokenImage != null && this.tokenImage.length > 0) {
            maxSize = 1;
            for (String expectedToken : this.tokenImage) {
                expected = expected + "\"" + expectedToken + "\"" + " ";
            }
        } else {
            maxSize = 1;
        }
        switch (this.errorType) {
            case 1001: 
            case 1002: 
            case 1010: 
            case 1020: {
                Token tok = this.getToken();
                if (tok != null) {
                    String formatLocation = res.getString("txtLocation");
                    return MessageFormat.format(formatLocation, super.getMessage(), tok.beginLine, tok.beginColumn);
                }
            }
            case 1102: 
            case 1811: 
            case 4010: {
                return super.getMessage();
            }
        }
        String formatLocation = res.getString("txtLocationWithExpected");
        String encountered = this.getEntcountered(maxSize, false);
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return MessageFormat.format(formatLocation, super.getMessage(), encountered, tok.beginLine, tok.beginColumn, maxSize, expected);
    }

    public String getShortMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize < this.expectedTokenSequences[i2].length) {
                    maxSize = this.expectedTokenSequences[i2].length;
                }
                for (int j2 = 0; j2 < this.expectedTokenSequences[i2].length; ++j2) {
                    expected = expected + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
                }
                if (this.expectedTokenSequences[i2][this.expectedTokenSequences[i2].length - 1] != 0) {
                    expected = expected + "...";
                }
                expected = expected + this.eol + "  ";
            }
        } else if (this.tokenImage != null && this.tokenImage.length > 0) {
            maxSize = 1;
            for (String expectedToken : this.tokenImage) {
                expected = expected + "\"" + expectedToken + "\"" + " ";
            }
        } else {
            maxSize = 1;
        }
        switch (this.errorType) {
            case 1001: 
            case 1002: 
            case 1010: 
            case 1020: {
                Token tok = this.getToken();
                if (tok != null) {
                    String formatLocation = res.getString("txtShort");
                    return MessageFormat.format(formatLocation, super.getMessage(), tok.beginLine, tok.beginColumn);
                }
            }
            case 1102: 
            case 1811: 
            case 4010: {
                return super.getMessage();
            }
        }
        String formatLocation = res.getString("txtShortWithExpected");
        String encountered = this.getEntcountered(maxSize, true);
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return MessageFormat.format(formatLocation, super.getMessage(), encountered, tok.beginLine, tok.beginColumn, maxSize, expected);
    }

    public String[] getExpected() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        String[] expected = new String[len];
        if (len == 0) {
            return expected;
        }
        expected[0] = "";
        for (int i2 = 0; i2 < len; ++i2) {
            expected[i2] = new String();
            for (int j2 = 0; j2 < this.expectedTokenSequences[i2].length; ++j2) {
                int n2 = i2;
                expected[n2] = expected[n2] + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
            }
            if (this.expectedTokenSequences[i2][this.expectedTokenSequences[i2].length - 1] == 0) continue;
            int n3 = i2;
            expected[n3] = expected[n3] + "...";
        }
        return expected;
    }

    public String[] getExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        String[] expected = new String[len];
        if (len == 0) {
            return expected;
        }
        expected[0] = "";
        for (int i2 = 0; i2 < len; ++i2) {
            expected[i2] = new String();
            for (int j2 = 0; j2 < this.expectedTokenSequences[i2].length; ++j2) {
                int n2 = i2;
                expected[n2] = expected[n2] + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
            }
        }
        return expected;
    }

    private int getMaxExpectedTokenSequenceLength() {
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        int max = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.expectedTokenSequences[i2].length <= max) continue;
            max = this.expectedTokenSequences[i2].length;
        }
        return max;
    }

    public String[] getLastExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int len = 0;
        if (this.expectedTokenSequences != null) {
            len = this.expectedTokenSequences.length;
        }
        ArrayList<String> expected = new ArrayList<String>(len);
        if (len == 0) {
            return new String[0];
        }
        int max = this.getMaxExpectedTokenSequenceLength();
        for (int i2 = 0; i2 < len; ++i2) {
            String s = "";
            if (this.expectedTokenSequences[i2].length >= max) {
                for (int j2 = max - 1; j2 < this.expectedTokenSequences[i2].length; ++j2) {
                    s = s + this.tokenImage[this.expectedTokenSequences[i2][j2]] + " ";
                }
            }
            expected.add(s);
        }
        return expected.toArray(new String[0]);
    }

    public String getFoundTokenImage() {
        switch (this.errorType) {
            case 1020: {
                return super.getMessage();
            }
        }
        String found = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize >= this.expectedTokenSequences[i2].length) continue;
                maxSize = this.expectedTokenSequences[i2].length;
            }
        }
        Token tok = this.getToken();
        for (int i3 = 0; i3 < maxSize && tok != null; ++i3) {
            if (i3 != 0) {
                found = found + " ";
            }
            if (tok.kind == 0) {
                found = found + this.tokenImage[0];
                break;
            }
            found = found + tok.image;
            tok = tok.next;
        }
        return found;
    }

    public String getFound() {
        switch (this.errorType) {
            case 1020: 
            case 1102: 
            case 4010: {
                return super.getMessage();
            }
        }
        String found = "";
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize >= this.expectedTokenSequences[i2].length) continue;
                maxSize = this.expectedTokenSequences[i2].length;
            }
        }
        Token tok = this.getToken();
        for (int i3 = 0; i3 < maxSize && tok != null; ++i3) {
            if (i3 != 0) {
                found = found + " ";
            }
            if (tok.kind == 0) {
                found = found + this.tokenImage[0];
                break;
            }
            found = found + this.add_escapes(tok.image);
            tok = tok.next;
        }
        return found;
    }

    public int getLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.beginLine;
    }

    public Token getEndToken() {
        Token tok = this.getLastToken();
        if (tok == null) {
            tok = this.getToken();
        }
        return tok;
    }

    private Token getLastToken() {
        Token tok;
        switch (this.errorType) {
            case 1020: {
                return this.getToken();
            }
        }
        int maxSize = 0;
        if (this.expectedTokenSequences != null) {
            for (int i2 = 0; i2 < this.expectedTokenSequences.length; ++i2) {
                if (maxSize >= this.expectedTokenSequences[i2].length) continue;
                maxSize = this.expectedTokenSequences[i2].length;
            }
        }
        Token endtok = tok = this.getToken();
        for (int i3 = 0; i3 < maxSize && tok != null && tok.kind != 0; ++i3) {
            endtok = tok;
            tok = tok.next;
        }
        return endtok;
    }

    public int getLastEndPosition() {
        Token tok = this.getLastToken();
        return tok.endPos;
    }

    public int getEndPosition() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.endPos;
    }

    public int getColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token tok = this.getToken();
        if (tok == null) {
            tok = this.currentToken;
        }
        return tok.beginColumn;
    }

    public int getEndLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        if (this.getEndToken() == null) {
            return this.getLine();
        }
        return this.getEndToken().endLine;
    }

    public int getEndColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        if (this.getEndToken() == null) {
            return this.getColumn();
        }
        return this.getEndToken().endColumn;
    }

    public String toString() {
        return this.getMessage();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i2 = 0; i2 < str.length(); ++i2) {
            switch (str.charAt(i2)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i2);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileError) {
            FileError pex = (FileError)obj;
            return pex.getErrorType() == this.getErrorType() && pex.getEndPosition() == this.getEndPosition() && pex.getToken() == pex.getToken();
        }
        return false;
    }
}

