/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.TokenMgrError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TextFileRepositoryManager
extends DefaultRepositoryManager {
    private boolean lenientParseMode = false;
    private int maxCacheEntries = 50;
    private Map repCache = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= TextFileRepositoryManager.this.maxCacheEntries;
        }
    };

    protected MIBModule loadModuleFromFile(String moduleName, boolean moduleOnly) throws IOException, ClassNotFoundException {
        MIBModule m2;
        RepositoryEvent event = new RepositoryEvent(this, moduleName);
        this.fireReadModule(event);
        InputStream file = null;
        String fname = moduleName;
        boolean cachable = true;
        if (event.getInputStream() == null) {
            if (event.isUseDefaults()) {
                File f2 = new File(this.path.getPath(), moduleName);
                if (f2.exists()) {
                    file = new FileInputStream(f2);
                } else {
                    f2 = this.getModuleFile(moduleName);
                    file = new FileInputStream(f2);
                }
                if (file != null) {
                    fname = f2.getPath();
                }
                if ((m2 = this.getModuleFromCache(moduleName, f2.lastModified())) != null) {
                    return m2;
                }
            }
            if (file == null) {
                cachable = false;
                String resourceName = "modules/" + moduleName + ".cmib";
                file = IModule.class.getResourceAsStream(resourceName);
                if (file == null) {
                    throw new FileNotFoundException(moduleName);
                }
            }
        } else {
            file = event.getInputStream();
        }
        try {
            MIBRepository rep = this.parse(file, fname, this, this.lenientParseMode);
            m2 = rep.getModule(moduleName);
            this.fireAfterReadModule(event);
            if (cachable) {
                this.repCache.put(m2.getModuleName(), new RepositoryCacheEntry(null, m2));
            }
            return m2;
        }
        catch (SMIParseException pex) {
            throw new IOException(pex.getMessage());
        }
    }

    private MIBModule getModuleFromCache(String moduleName, long lastModifiedOnDisk) {
        RepositoryCacheEntry e2 = (RepositoryCacheEntry)this.repCache.get(moduleName);
        if (e2 != null) {
            if (e2.lastUpdate > lastModifiedOnDisk) {
                return (MIBModule)e2.module.getClone();
            }
            if (this.verbose) {
                System.out.println("MIB module '" + moduleName + "' changed on disk");
            }
            this.repCache.remove(moduleName);
        }
        return null;
    }

    private synchronized Integer getModuleID(String moduleName, boolean createIfMissing) throws IOException {
        Properties index = this.getModuleIndex();
        String id = index.getProperty(moduleName + ".id");
        if (id != null) {
            return new Integer(id);
        }
        if (createIfMissing) {
            Integer i2 = this.createModuleID(moduleName);
            index.setProperty(moduleName + ".id", "" + i2);
            this.setModuleIndex(index);
        }
        return null;
    }

    private MIBRepository parse(InputStream fi, String path, ImportModuleListener importer, boolean lenient) throws SMIParseException {
        MIBRepository rep = null;
        if (this.verbose) {
            System.out.print("Loading MIB file [" + path + "]...");
        }
        SMIParser parser = new SMIParser(fi);
        if (lenient) {
            parser.setLenient(1);
        }
        parser.setMaxErrors(this.maxErrors);
        SMIRepository tree = null;
        try {
            tree = parser.Input(path);
            tree.setImporter(importer);
            tree.createOids();
        }
        catch (ParseException ex) {
            block25: {
                if (this.verbose) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
                try {
                    fi.close();
                }
                catch (IOException ioex) {
                    if (!this.verbose) break block25;
                    ioex.printStackTrace();
                }
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            nex.setErrorList(parser.getErrors());
            throw nex;
        }
        catch (Throwable t) {
            if (this.verbose) {
                System.out.println(t.getMessage());
                t.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(t.getMessage(), null, 50, (TokenMgrError)t);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            t.printStackTrace();
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (parser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException pex = (SMIParseException)parser.getErrors().get(0);
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            rep = this.getRepository(tree, parser.getErrors(), lenient);
        }
        catch (SMIParseException pex) {
            if (this.verbose) {
                System.out.println(pex.getMessage());
                pex.printStackTrace();
                System.out.println(", failed.");
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            fi.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return rep;
    }

    protected MIBRepository getRepository(SMIRepository rep, List parseErrors, boolean lenient) throws SMIParseException {
        SMI2Java visitor = lenient ? new LenientSMI2Java(rep, this.options) : new SMI2Java(rep, this.options);
        visitor.setErrors(parseErrors);
        visitor.setMaxErrors(this.maxErrors);
        Vector v = new Vector();
        try {
            rep.jjtAccept(visitor, v);
        }
        catch (Exception ex) {
            if (visitor.getErrors().size() > 0) {
                SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
                pex.setErrorList(visitor.getErrors());
                throw pex;
            }
            ex.printStackTrace();
            throw new SMIParseException(ex.getMessage(), 0);
        }
        if (visitor.getErrors().size() > 0) {
            SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
            pex.setErrorList(visitor.getErrors());
            throw pex;
        }
        MIBRepository r2 = visitor.getRepository();
        r2.structureChanged();
        if (lenient) {
            Iterator<MIBModule> it = r2.modulesIterator();
            while (it.hasNext()) {
                MIBModule m2 = it.next();
                m2.setParseMode(1);
            }
        }
        return r2;
    }

    protected File getModuleFile(String moduleName) throws IOException {
        Properties prop = this.getModuleIndex();
        String fname = prop.getProperty(moduleName + ".path", moduleName);
        return new File(fname);
    }

    private Properties getModuleIndex() throws IOException {
        Properties prop = new Properties();
        try {
            FileInputStream is = new FileInputStream(new File(this.path, "module-index.properties"));
            prop.load(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return prop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized boolean saveModulesFromRepository(MIBRepository rep) throws IOException {
        boolean added = true;
        Properties index = this.getModuleIndex();
        Iterator<MIBModule> modules = rep.modulesIterator();
        while (modules.hasNext()) {
            MIBModule m2 = modules.next();
            RepositoryEvent event = new RepositoryEvent(this, m2.getModuleName(), m2);
            this.fireWriteModule(event);
            OutputStream output = event.getOutputStream();
            File f2 = new File(this.path.getPath() + File.separatorChar + m2.getModuleName());
            if (output == null) {
                if (!event.isUseDefaults()) return false;
                String p2 = m2.getFileName();
                if (p2 != null) {
                    f2 = new File(this.path.getPath(), new File(p2).getName());
                }
                if (f2.exists()) {
                    added = false;
                }
                this.repCache.put(m2.getModuleName(), new RepositoryCacheEntry(f2, m2));
                FileOutputStream file = new FileOutputStream(f2);
                output = file;
            } else {
                this.repCache.put(m2.getModuleName(), new RepositoryCacheEntry(f2, m2));
            }
            output.write(m2.toSMI(1, rep, MIBObject.getLineSeparator()).getBytes());
            output.flush();
            output.close();
            index.setProperty(m2.getModuleName() + ".file", f2.getPath());
            index.setProperty(m2.getModuleName() + ".id", "" + m2.getModuleID());
        }
        this.setModuleIndex(index);
        return added;
    }

    private void setModuleIndex(Properties index) throws IOException {
        FileOutputStream os = new FileOutputStream(new File(this.path, "module-index.properties"));
        index.store(os, "Text MIB Repository - Last Update: " + new Date());
        os.flush();
        ((OutputStream)os).close();
    }

    public String[] getModuleNames() throws IOException {
        String[] files = super.getModuleNames();
        HashSet<String> f2 = new HashSet<String>(Arrays.asList(files));
        Properties index = this.getModuleIndex();
        for (Map.Entry<Object, Object> e2 : index.entrySet()) {
            String key = (String)e2.getKey();
            if (!key.endsWith(".file")) continue;
            String name = key.substring(0, key.length() - 5);
            File file = new File((String)e2.getValue());
            if (!file.exists() || !file.isFile()) continue;
            f2.add(name);
        }
        return f2.toArray(new String[f2.size()]);
    }

    public boolean isModuleAvailable(String moduleName) {
        boolean isAvailable = super.isModuleAvailable(moduleName);
        if (!isAvailable) {
            try {
                Properties index = this.getModuleIndex();
                String fname = index.getProperty(moduleName + ".file");
                if (fname != null) {
                    File f2 = new File(fname);
                    return f2.exists() && f2.isFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setLenientParseMode(boolean lenientParseMode) {
        this.lenientParseMode = lenientParseMode;
    }

    public boolean isLenientParseMode() {
        return this.lenientParseMode;
    }

    class RepositoryCacheEntry {
        private long lastUpdate;
        private MIBModule module;

        public RepositoryCacheEntry(File file, MIBModule module) {
            this.module = module;
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

