/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.notepad;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.print.SmiTextPrintable;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBModule;
import com.agentpp.notepad.ElementTreePanel;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class SMIEditorPanel
extends JPanel
implements JCSelectListener {
    private static final String _$18242 = "agentpp.notepad.searchExpression";
    private static final String _$18243 = "agentpp.notepad.substitution";
    private static ResourceBundle _$18244;
    private FlexListTable _$18245 = new FlexListTable();
    private JCVectorDataSource _$15136 = new JCVectorDataSource();
    private TableSorter _$18246;
    private JScrollPane _$18247;
    JFrame myFrame;
    String lastSearch = "";
    private MIBImporter _$15140 = null;
    private UserConfigFile _$2173 = new UserConfigFile();
    PatternMatcher matcher = new Perl5Matcher();
    PatternCompiler compiler = new Perl5Compiler();
    Pattern lastPattern;
    PatternMatcherInput input;
    MatchResult result;
    JSplitPane splitPane = new JSplitPane(0);
    private String _$2629 = "";
    private MIBModule _$18253;
    private JDialog _$18254;
    private LinkedList _$18258 = new LinkedList();
    static final String[] COLUMN_NAMES;
    static final int COL_NR = 0;
    static final int COL_ERROR = 1;
    static final int COL_TEXT = 2;
    private JEditorPane _$2440;
    private Hashtable _$9700;
    private Hashtable _$18276;
    private JToolBar _$18340;
    protected StatusBar status;
    private JFrame _$18318;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String accelSuffix = "Accelerator";
    public static final String tipSuffix = "Tooltip";
    public static final String printAction = "print";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction _$18343 = new UndoAction();
    private RedoAction _$18344 = new RedoAction();
    private ImportAction _$18375 = new ImportAction();
    private Action[] _$12991 = new Action[]{new FindAction(), new ReplaceAction(), this._$18375, new CheckAccurateAction(), new FindNextAction(), new PrintAction(), this._$18343, this._$18344, new PasteAction(), new CutAction()};
    private int _$18361;
    private int _$18406 = 8;

    public SMIEditorPanel(JFrame frame) {
        this.myFrame = frame;
        try {
            this._$302();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._$37001();
    }

    public void setTitle(String title) {
        this._$2629 = title;
    }

    public String getTitle() {
        return this._$2629;
    }

    public void setLookupModule(MIBModule lookup) {
        this._$18253 = lookup;
    }

    public void setConfig(UserConfigFile config) {
        this._$2173 = config;
        SmiContext s = ((SmiEditorKit)this.getEditor().getEditorKit()).getStylePreferences();
        Vector v = SmiContext.getStyles(config);
        s.setSyntaxHighlighting(SmiContext.loadSyntaxHighlighting(config));
        s.setStyles(v);
    }

    private void _$302() {
        this.createErrorTable();
        this.setLayout(new BorderLayout());
        this._$2440 = this.createEditor();
        this._$2440.setFont(new Font("monospaced", 0, 12));
        this._$2440.getDocument().addUndoableEditListener(this.undoHandler);
        this._$9700 = new Hashtable();
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            Action a2 = actions[i2];
            this._$9700.put(a2.getValue("Name"), a2);
        }
        this._$18247 = new JScrollPane();
        JViewport port = this._$18247.getViewport();
        port.add(this._$2440);
        port.setScrollMode(1);
        this._$18276 = new Hashtable();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this._$18280());
        panel.add("Center", this.splitPane);
        this.splitPane.setBottomComponent(this._$18247);
        this.splitPane.setTopComponent(this._$18245);
        this.splitPane.setOneTouchExpandable(true);
        this.add("Center", panel);
        this.status = this.createStatusbar();
        this._$2440.addCaretListener(this.status);
        this.add("South", this.status);
        panel.setPreferredSize(new Dimension(600, 600));
        this.splitPane.setDividerLocation(0.2);
    }

    public SMIEditorPanel(JFrame f2, String text, int row, int col, int sel) {
        this(f2);
        this.setText(text, row, col, sel);
    }

    public int getCaretPosition() {
        return this.getEditor().getCaretPosition();
    }

    public boolean replace(Pattern pattern, String s) {
        int numSubs = 1;
        Perl5Substitution substitution = new Perl5Substitution(s);
        int r2 = -1;
        int start = -1;
        int stop = -1;
        block8: while (r2 != 1 && this.searchPattern(pattern)) {
            start = this.getEditor().getSelectionStart();
            stop = this.getEditor().getSelectionEnd();
            StringBuffer buf = new StringBuffer();
            String[] text = new String[]{"Replace?"};
            Object[] options = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            r2 = JOptionPane.showOptionDialog(this, text, "Confirm Substitution", 1, 3, null, options, options[0]);
            switch (r2) {
                case 0: {
                    break;
                }
                case 1: {
                    stop = ((SmiDocument)this._$2440.getDocument()).getEndPosition().getOffset();
                    numSubs = -1;
                    break;
                }
                case 2: {
                    continue block8;
                }
                case 3: {
                    return false;
                }
            }
            SmiDocument doc = (SmiDocument)this._$2440.getDocument();
            int length = stop - start;
            Segment seg = new Segment();
            try {
                doc.getText(start, length, seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.input = new PatternMatcherInput(new String(seg.array, seg.offset, seg.count));
            Util.substitute(buf, this.matcher, pattern, (Substitution)substitution, this.input, numSubs);
            this.getEditor().setSelectionStart(start);
            this.getEditor().setSelectionEnd(stop);
            this.getEditor().replaceSelection(buf.toString());
            this.getEditor().setCaretPosition(start + buf.toString().length());
        }
        if (r2 == 0 || r2 == 1) {
            this.setCaretPosition(start);
        }
        return true;
    }

    public boolean searchPattern(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        this.lastPattern = pattern;
        int start = 0;
        if (this.getEditor().getCaretPosition() > 0) {
            start = this.getEditor().getCaretPosition();
        }
        SmiDocument doc = (SmiDocument)this._$2440.getDocument();
        int length = doc.getEndPosition().getOffset() - start;
        Segment seg = new Segment();
        try {
            doc.getText(start, length, seg);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        this.input = new PatternMatcherInput(new String(seg.array, seg.offset, length));
        if (this.matcher.contains(this.input, pattern)) {
            int pos = this.input.getMatchBeginOffset() + start;
            int len = this.input.getMatchEndOffset() - this.input.getMatchBeginOffset();
            this._$2440.getCaret().setSelectionVisible(true);
            this._$2440.setCaretPosition(pos);
            this._$2440.moveCaretPosition(pos + len);
            return true;
        }
        this.status.setText("Search complete!");
        return false;
    }

    private Pattern _$18303(String s, boolean quite) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this.compiler.compile(s);
            }
            catch (MalformedPatternException e2) {
                if (quite) break block2;
                JOptionPane.showMessageDialog(this, e2.getMessage(), "Malformed Expression", 0);
            }
        }
        return pattern;
    }

    public boolean searchString(String s) {
        Pattern p2 = this._$18303(s, true);
        if (p2 != null) {
            return this.searchPattern(p2);
        }
        return false;
    }

    public void setCaretPosition(int pos) {
        this.getEditor().setCaretPosition(pos);
    }

    public boolean setCaretPosition(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            this._$2440.setCaretPosition(smidoc.getLineStartOffset(row - 1) + col - 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public boolean setSelectionEnd(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            int startPos = this._$2440.getCaret().getDot();
            int endPos = smidoc.getLineStartOffset(row - 1) + col - 1;
            this.setSelectionLength(endPos - startPos + 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public void setSelectionLength(int sel) {
        this._$2440.getCaret().setSelectionVisible(true);
        int len = sel;
        while (true) {
            try {
                this._$2440.moveCaretPosition(this._$2440.getCaretPosition() + len);
            }
            catch (IllegalArgumentException iaex) {
                if (--len > 0) continue;
            }
            break;
        }
    }

    public void setText(String text, int row, int col, int sel) {
        this.setEnabled(false);
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
        Document doc = this._$2440.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException ex1) {
            // empty catch block
        }
        try {
            this.setCaretPosition(row, col);
            this.setSelectionLength(sel);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (this._$18318 != null) {
            this.elementTreePanel.setEditor(this.getEditor());
        }
        doc.addUndoableEditListener(this.undoHandler);
        this.status.removeAll();
        this.status.revalidate();
        this.resetUndoManager();
        this.setEnabled(true);
    }

    public Action[] getActions() {
        return TextAction.augmentList(this._$2440.getActions(), this._$12991);
    }

    protected void createErrorTable() {
        this._$15136.setNumColumns(COLUMN_NAMES.length);
        this._$15136.setNumRows(0);
        this._$15136.setColumnLabels(COLUMN_NAMES);
        this._$18246 = new TableSorter(this._$18245, this._$15136);
        this._$18245.setDataSource(this._$15136);
        this._$18245.setPixelHeight(-997, 33001);
        this._$18245.setRowLabelDisplay(false);
        for (int i2 = 0; i2 < this._$15136.getNumColumns(); ++i2) {
            this._$18245.setPixelWidth(i2, 33001);
        }
        this._$18245.addSelectListener(this);
    }

    protected JEditorPane createEditor() {
        try {
            final JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKit(kit);
            editor.setBackground(Color.white);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            editor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e2) {
                }

                public void keyReleased(KeyEvent e2) {
                    if (SMIEditorPanel.this._$15140 != null && editor.isEditable() && e2.getModifiers() == 2) {
                        if (e2.getKeyCode() == 90) {
                            if (SMIEditorPanel.this.undo.canUndo()) {
                                SMIEditorPanel.this._$18343.undo();
                            }
                        } else if (e2.getKeyCode() == 89 && SMIEditorPanel.this.undo.canRedo()) {
                            SMIEditorPanel.this._$18344.redo();
                        }
                    }
                }

                public void keyTyped(KeyEvent e2) {
                    if (SMIEditorPanel.this._$15140 != null && editor.isEditable() && (e2.getModifiers() & 2) != 0) {
                        if (e2.getKeyChar() == ' ') {
                            SMIEditorPanel.this.codeCompletion();
                        } else if (e2.getKeyCode() == 27 && SMIEditorPanel.this._$18254 != null) {
                            SMIEditorPanel.this._$18323();
                        }
                    }
                }
            });
            return editor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JEditorPane getEditor() {
        return this._$2440;
    }

    private void _$18323() {
        this._$18254.setVisible(false);
        this._$18254.dispose();
        this._$18254 = null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        String sstr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((sstr = this.getResourceString(cmd + accelSuffix)) != null) {
            mi.setAccelerator(KeyStroke.getKeyStroke(sstr));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a2 = this.getAction(astr);
        if (a2 != null) {
            mi.addActionListener(a2);
            a2.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a2.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this._$18276.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this._$18276.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this._$9700.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = _$18244.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected Container getToolbar() {
        return this._$18340;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this._$18343.update();
        this._$18344.update();
    }

    private Component _$18280() {
        this._$18340 = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i2 = 0; i2 < toolKeys.length; ++i2) {
            if (toolKeys[i2].equals("-")) {
                this._$18340.add(Box.createHorizontalStrut(5));
                continue;
            }
            this._$18340.add(this.createTool(toolKeys[i2]));
        }
        this._$18340.add(Box.createHorizontalGlue());
        ToolBarUtils.setMinimumButtonSize(this._$18340);
        return this._$18340;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a2;
        URL url = this.getResource(key + imageSuffix);
        JButton b2 = new JButton((Icon)new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b2.setRequestFocusEnabled(false);
        b2.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a2 = this.getAction(astr)) != null) {
            b2.setActionCommand(astr);
            a2.addPropertyChangeListener(this.createActionChangeListener(b2));
            b2.addActionListener(a2);
            b2.setEnabled(a2.isEnabled());
        } else {
            b2.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b2.setToolTipText(tip);
        }
        return b2;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i2 = 0; i2 < cmd.length; ++i2) {
            cmd[i2] = (String)v.elementAt(i2);
        }
        return cmd;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b2) {
        ActionChangedListener listener = new ActionChangedListener(b2);
        this._$18258.add(listener);
        return listener;
    }

    protected PropertyChangeListener createActionChangeListener(JButton b2) {
        ButtonActionChangedListener listener = new ButtonActionChangedListener(b2);
        this._$18258.add(listener);
        return listener;
    }

    public void setImporter(MIBImporter newImporter) {
        this._$15140 = newImporter;
        this._$37001();
    }

    private void _$37001() {
        if (this._$15140 == null) {
            this._$2440.setEditable(false);
            this._$37014(false);
        } else {
            this._$2440.setEditable(true);
            this._$37014(true);
            this._$18344.setEnabled(this.undo.canRedo());
            this._$18343.setEnabled(this.undo.canUndo());
            this._$18375.setEnabled(this.undo.canUndo());
        }
    }

    private void _$37014(boolean enabled) {
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            if (!(actions[i2] instanceof ModifyAction)) continue;
            actions[i2].setEnabled(enabled);
        }
    }

    public MIBImporter getImporter() {
        return this._$15140;
    }

    public void setParserMode(int newParserMode) {
        this._$18361 = newParserMode;
    }

    public int getParserMode() {
        return this._$18361;
    }

    private boolean _$18375() {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getDocumentBytes());
        try {
            this._$15140.importMIB(this, bis, "", this._$18361);
            bis.close();
            this.clearErrors();
            this.status.setText("SMI saved.");
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
        catch (SMIParseException pex) {
            this.setError(pex);
            this._$37021(pex);
            return false;
        }
    }

    public void setSelectionColor(Color c2) {
        this._$2440.setSelectionColor(c2);
    }

    public int checkText() {
        try {
            this.clearErrors();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.getDocumentBytes());
            this._$15140.checkMIB(this, bis, 1);
            bis.close();
            this.status.setText("SMI check OK.");
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (SMIParseException pex) {
            this.setError(pex);
            return this._$37021(pex);
        }
    }

    private int _$37021(SMIParseException pex) {
        int errCount = pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1;
        this.status.setText("Detected " + errCount + " SMI syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
        return errCount;
    }

    public void clearErrors() {
        this._$15136.setNumRows(0);
        this.splitPane.setDividerLocation(0.0);
    }

    public boolean hasUncommitedChanges() {
        return this.undo.canUndo();
    }

    public void setError(SMIParseException pex) {
        this._$15136.setNumRows(0);
        int n2 = 0;
        if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
            int i2 = 0;
            for (SMIParseException lpex : pex.getErrorList()) {
                if (lpex == pex) {
                    n2 = i2;
                }
                this.addRow(lpex);
                ++i2;
            }
        } else {
            this.addRow(pex);
        }
        this._$18245.setRowSelection(n2, n2);
        this.splitPane.setDividerLocation(0.2);
    }

    protected void setCurrentErrorLocation(int rowIndex) {
        SMIParseException pex = (SMIParseException)this._$15136.getTableRowLabel(rowIndex);
        if (pex.hasLocationInfo()) {
            this.setCaretPosition(pex.fileError.getLine(), pex.fileError.getColumn());
            this.setSelectionEnd(pex.fileError.getEndLine(), pex.fileError.getEndColumn());
        } else if (pex.objects != null) {
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (!this.searchString(((Vector)pex.objects).firstElement().toString())) {
                this.setCaretPosition(pos);
            }
        } else {
            StringTokenizer st = new StringTokenizer(pex.getMessage(), ", ");
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (st.hasMoreTokens() && !this.searchString(st.nextToken())) {
                this.setCaretPosition(pos);
            }
        }
    }

    public void print() {
        SmiContext ctx = new SmiContext();
        ctx.setSyntaxHighlighting(true);
        ctx.setStyles(ctx.getDefaultStyles());
        SmiTextPrintable smiPrintable = new SmiTextPrintable((SmiDocument)this.getEditor().getDocument(), new Font("SansSerif", 0, 10), this._$2173.getBoolean("print.header", true) ? this.getTitle() : null, this._$2173.getBoolean("print.footer", true) ? this._$2173.get("print.footerText", "{0} -- page {1}") : null, this._$2173.getBoolean("print.colored", false), this._$2173.getBoolean("print.lineNumbers", true), ctx, this.getTabSize());
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(this.getTitle());
        PageFormat pf = new PageFormat();
        pj.pageDialog(pf);
        pj.setPrintable(smiPrintable, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }

    protected byte[] getDocumentBytes() {
        Segment s = new Segment();
        SmiDocument doc = (SmiDocument)this._$2440.getDocument();
        try {
            doc.getText(0, doc.getLength(), s);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        return String.valueOf(s.array, 0, doc.getLength()).getBytes();
    }

    public void setTabSize(int tabSize) {
        this._$18406 = tabSize;
    }

    public int getTabSize() {
        return this._$18406;
    }

    public String getText() {
        SmiDocument doc = (SmiDocument)this._$2440.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected void addRow(SMIParseException pex) {
        Vector<Object> row = new Vector<Object>(COLUMN_NAMES.length);
        row.add(new Integer(this._$15136.getNumRows() + 1));
        row.add(new Integer(pex.errorType));
        row.add(DefaultRepositoryManager.getErrorText(pex, false).replace('\r', ' '));
        this._$15136.addRow(Integer.MAX_VALUE, pex, row);
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int row = TableUtils.getFirstSelectedRow(this._$18245);
        if (row >= 0) {
            this.setCurrentErrorLocation(row);
        }
    }

    public boolean importText() {
        boolean importOK = this._$18375();
        if (importOK) {
            this.undo.discardAllEdits();
            this._$18343.update();
            this._$18344.update();
            this._$18375.update();
        }
        return importOK;
    }

    private static boolean _$18458(char c2) {
        return Character.isWhitespace(c2) || c2 == ',';
    }

    private SMIParseException _$18459(String text, int maxLength) {
        try {
            int size = Math.min(maxLength, this.getCaretPosition());
            for (int i2 = size - 1; i2 >= 0; --i2) {
                if (Character.isWhitespace(text.charAt(i2))) continue;
                size = i2 + 1;
                break;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(text.substring(0, size).getBytes());
            this._$15140.checkMIB(this, bis, 1);
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (SMIParseException pex) {
            return pex;
        }
    }

    public void codeCompletion() {
        SMIParseException pex;
        String text = this.getText();
        int startPos = this.getCaretPosition();
        for (int i2 = startPos - 1; i2 >= 1; --i2) {
            if (SMIEditorPanel._$18458(text.charAt(i2))) {
                this._$2440.setCaretPosition(i2 + 1);
                break;
            }
            if (i2 != 1) continue;
            this._$2440.setCaretPosition(1);
            break;
        }
        if ((pex = this._$18459(text, this._$2440.getDocument().getLength())) != null) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                boolean found = false;
                for (SMIParseException ip : pex.getErrorList()) {
                    if (!ip.hasLocationInfo() || ip.fileError.getEndPosition() < this.getCaretPosition()) continue;
                    pex = ip;
                    found = true;
                    break;
                }
                if (!found) {
                    pex = pex.getErrorList().get(0);
                }
            }
            if (pex == null || pex.fileError == null) {
                return;
            }
            if (pex.hasLocationInfo()) {
                for (int i3 = startPos; i3 < text.length(); ++i3) {
                    if (!SMIEditorPanel._$18458(text.charAt(i3))) continue;
                    this._$2440.moveCaretPosition(i3);
                    break;
                }
            } else {
                return;
            }
            HashSet completions = new HashSet();
            String[] exp = pex.fileError.getLastExpectedImages();
            for (int i4 = 0; i4 < exp.length; ++i4) {
                String s = exp[i4];
                StringTokenizer st = new StringTokenizer(s, "\"", true);
                boolean lastWasQuote = false;
                StringBuffer buf = new StringBuffer(s.length());
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("\"".equals(token)) {
                        if (!lastWasQuote) continue;
                        lastWasQuote = true;
                    } else {
                        lastWasQuote = false;
                    }
                    buf.append(token);
                }
                this._$18469(buf.toString(), completions);
            }
            if (this._$18254 != null) {
                this._$18254.setVisible(false);
                this._$18254.dispose();
            }
            if (completions.isEmpty()) {
                return;
            }
            if (completions.size() == 1) {
                boolean addSpace = false;
                this._$18471((String)completions.iterator().next(), addSpace);
            } else {
                this._$18254 = new JDialog(this.myFrame);
                this._$18254.setTitle("SMI Completion");
                Vector completionVector = new Vector(completions);
                Collections.sort(completionVector);
                this._$18254.getContentPane().setLayout(new BorderLayout(5, 5));
                JScrollPane spane = new JScrollPane(20, 31);
                JList completionSelection = new JList(completionVector){

                    public void setSelectedIndex(int selectionIndex) {
                        super.setSelectedIndex(selectionIndex);
                        super.ensureIndexIsVisible(selectionIndex);
                    }
                };
                completionSelection.setSelectedIndex(0);
                boolean addSpace = false;
                CodeCompletionListener ccl = new CodeCompletionListener(pex, this._$18254, completionSelection, addSpace);
                completionSelection.addMouseListener(ccl);
                completionSelection.addKeyListener(ccl);
                spane.getViewport().add(completionSelection);
                this._$18254.getContentPane().add((Component)spane, "Center");
                Rectangle pos = null;
                try {
                    pos = this._$2440.modelToView(this.getCaretPosition());
                    Point loc = pos.getLocation();
                    loc.translate(this._$2440.getLocationOnScreen().x, this._$2440.getLocationOnScreen().y + 12);
                    this._$18254.setLocation(loc);
                }
                catch (BadLocationException ex1) {
                    ex1.printStackTrace();
                }
                this._$18254.pack();
                this._$18254.setVisible(true);
            }
        }
    }

    private void _$18471(String replacement, boolean addSpace) {
        String r2 = addSpace ? " " : "";
        r2 = r2 + replacement;
        this._$2440.replaceSelection(r2);
    }

    private static boolean _$18484(String s, int id) {
        return s.startsWith(SMIParserConstants.tokenImage[id]);
    }

    private void _$18469(String string, Set completions) {
        if (string.trim().length() == 0) {
            return;
        }
        if (this._$18253 != null) {
            if (SMIEditorPanel._$18484(string, 120)) {
                completions.addAll(this._$18253.getLowerCaseNames());
                return;
            }
            if (SMIEditorPanel._$18484(string, 119)) {
                completions.addAll(this._$18253.getUpperCaseNames());
                return;
            }
        } else {
            if (SMIEditorPanel._$18484(string, 120)) {
                completions.add("lowerCaseName");
                return;
            }
            if (SMIEditorPanel._$18484(string, 119)) {
                completions.add("UpperCaseName");
                return;
            }
        }
        if (SMIEditorPanel._$18484(string, 8)) {
            completions.add("OBJECT IDENTIFIER");
        } else if (SMIEditorPanel._$18484(string, 9)) {
            completions.add("OCTET STRING");
        } else if (SMIEditorPanel._$18484(string, 11)) {
            completions.add("''h");
        } else if (SMIEditorPanel._$18484(string, 10)) {
            completions.add("''b");
        } else if (SMIEditorPanel._$18484(string, 16)) {
            completions.add("-1");
        } else if (SMIEditorPanel._$18484(string, 15)) {
            completions.add("1");
        } else if (SMIEditorPanel._$18484(string, 13)) {
            completions.add("\"\"");
        } else if (SMIEditorPanel._$18484(string, 12)) {
            completions.add("\"\"");
        } else {
            completions.add(string);
        }
    }

    static {
        COLUMN_NAMES = new String[]{"Number", "Error", "Description"};
        try {
            _$18244 = ResourceBundle.getBundle("com.agentpp.notepad.SMIEditorPanel", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Notepad.properties not found");
        }
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private SMIParseException _$2236;
        private JDialog _$7128;
        private JList _$2206;
        private boolean _$18470;

        public CodeCompletionListener(SMIParseException pex, JDialog popup, JList list, boolean addSpace) {
            this._$2236 = pex;
            this._$7128 = popup;
            this._$2206 = list;
            this._$18470 = addSpace;
        }

        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                this._$6957();
            }
        }

        public void mouseEntered(MouseEvent e2) {
        }

        public void mouseExited(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
        }

        public void mouseReleased(MouseEvent e2) {
        }

        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                this._$6957();
            } else if (e2.getKeyCode() == 27) {
                this._$7128.setVisible(false);
                this._$7128.dispose();
            }
        }

        public void keyReleased(KeyEvent e2) {
        }

        public void keyTyped(KeyEvent e2) {
        }

        private void _$6957() {
            String s = (String)this._$2206.getSelectedValue();
            if (s == null) {
                return;
            }
            SMIEditorPanel.this._$18471(s, this._$18470);
            this._$7128.setVisible(false);
            this._$7128.dispose();
        }
    }

    static interface ModifyAction {
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(SMIEditorPanel.printAction);
        }

        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.print();
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(SMIEditorPanel.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e2) {
            if (SMIEditorPanel.this._$18318 == null) {
                try {
                    String title = _$18244.getString("ElementTreeFrameTitle");
                    SMIEditorPanel.this._$18318 = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    SMIEditorPanel.this._$18318 = new JFrame();
                }
                SMIEditorPanel.this._$18318.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent weeee) {
                        SMIEditorPanel.this._$18318.setVisible(false);
                    }
                });
                Container fContentPane = SMIEditorPanel.this._$18318.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                SMIEditorPanel.this.elementTreePanel = new ElementTreePanel(SMIEditorPanel.this.getEditor());
                fContentPane.add(SMIEditorPanel.this.elementTreePanel);
                SMIEditorPanel.this._$18318.pack();
            }
            SMIEditorPanel.this._$18318.setVisible(true);
        }
    }

    class CheckAccurateAction
    extends AbstractAction {
        CheckAccurateAction() {
            super("CheckAccurate");
        }

        CheckAccurateAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e2) {
            if (SMIEditorPanel.this._$15140 != null) {
                int errCount = SMIEditorPanel.this.checkText();
                if (errCount == 0) {
                    SMIEditorPanel.this.status.setText("SMI check OK.");
                } else {
                    SMIEditorPanel.this.status.setText("Detected " + errCount + " SMI syntax error" + (errCount > 1 ? "s" : "") + ", see error list above for details.");
                }
            }
        }
    }

    static class PasteAction
    extends TextAction
    implements ModifyAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.paste();
            }
        }
    }

    public static class CutAction
    extends TextAction
    implements ModifyAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public void actionPerformed(ActionEvent e2) {
            JTextComponent target = this.getTextComponent(e2);
            if (target != null) {
                target.cut();
            }
        }
    }

    class ImportAction
    extends AbstractAction
    implements ModifyAction {
        ImportAction() {
            super("Import");
        }

        ImportAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.importText();
        }

        public void update() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            super("FindNext");
        }

        public void actionPerformed(ActionEvent e2) {
            SMIEditorPanel.this.searchPattern(SMIEditorPanel.this.lastPattern);
        }
    }

    class ReplaceAction
    extends AbstractAction
    implements ModifyAction {
        ReplaceAction() {
            super("Replace");
        }

        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(true);
            sp.setSearchExpressions(SMIEditorPanel.this._$2173.getArray(SMIEditorPanel._$18242));
            sp.setSubstitutionStrings(SMIEditorPanel.this._$2173.getArray(SMIEditorPanel._$18243));
            StandardDialog sd = new StandardDialog((Frame)SMIEditorPanel.this.myFrame, "Replace", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SMIEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SMIEditorPanel.this._$18303(sp.getSearchExpression(), false)) == null) continue;
                SMIEditorPanel.this._$2173.putArray(SMIEditorPanel._$18242, sp.getSearchExpressions());
                SMIEditorPanel.this._$2173.putArray(SMIEditorPanel._$18243, sp.getSubstitutionStrings());
                SMIEditorPanel.this.replace(p2, sp.getSubstitutionString());
                break;
            } while (sd.getResult() == 0);
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
            super("Find");
        }

        private String _$18416() {
            if (SMIEditorPanel.this.getEditor().getSelectedText() != null) {
                return SMIEditorPanel.this.getEditor().getSelectedText();
            }
            return null;
        }

        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(false);
            Vector v = SMIEditorPanel.this._$2173.getArray(SMIEditorPanel._$18242);
            if (this._$18416() != null) {
                v.insertElementAt(this._$18416(), 0);
            }
            sp.setSearchExpressions(v);
            StandardDialog sd = new StandardDialog((Frame)SMIEditorPanel.this.myFrame, "Find", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(SMIEditorPanel.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = SMIEditorPanel.this._$18303(sp.getSearchExpression(), false)) == null) continue;
                SMIEditorPanel.this._$2173.putArray(SMIEditorPanel._$18242, sp.getSearchExpressions());
                SMIEditorPanel.this.searchPattern(p2);
                break;
            } while (sd.getResult() == 0);
        }
    }

    class RedoAction
    extends AbstractAction
    implements ModifyAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            this.redo();
        }

        public void redo() {
            if (SMIEditorPanel.this.undo.canRedo()) {
                try {
                    SMIEditorPanel.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SMIEditorPanel.this._$18343.update();
            SMIEditorPanel.this._$18375.update();
        }

        protected void update() {
            if (SMIEditorPanel.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", SMIEditorPanel.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction
    implements ModifyAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            this.undo();
        }

        protected void update() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", SMIEditorPanel.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public void undo() {
            if (SMIEditorPanel.this.undo.canUndo()) {
                try {
                    SMIEditorPanel.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            SMIEditorPanel.this._$18344.update();
            SMIEditorPanel.this._$18375.update();
        }
    }

    class StatusBar
    extends JLabel
    implements CaretListener {
        public StatusBar() {
            super(" ");
            this.setLayout(new BoxLayout(this, 0));
        }

        public void caretUpdate(CaretEvent e2) {
            int dot = e2.getDot();
            SmiDocument smidoc = (SmiDocument)SMIEditorPanel.this._$2440.getDocument();
            int line = smidoc.getLineOfOffset(dot) + 1;
            int col = dot + 1 - smidoc.getLineStartOffset(smidoc.getLineOfOffset(dot));
            this.setText(line + ":" + col);
            this.setToolTipText("Cursor is located at row " + line + ", column " + col);
        }

        public void paint(Graphics g2) {
            super.paint(g2);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e2) {
            SMIEditorPanel.this.undo.addEdit(e2.getEdit());
            SMIEditorPanel.this._$18343.update();
            SMIEditorPanel.this._$18344.update();
            SMIEditorPanel.this._$18375.update();
        }
    }

    private class ButtonActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ButtonActionChangedListener(JButton b2) {
            this.button = b2;
        }

        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (e2.getPropertyName().equals("Name")) {
                String text = (String)e2.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }
}

