/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBVariation;

public class PIBComplianceObject
extends MIBException {
    public static final long serialVersionUID = 1000L;

    public PIBComplianceObject(String name) {
        super(name, "");
    }

    public String toSMI(int mode, MIBRepository rep, MIBVariation c2, String lineSeparator) {
        Object cs;
        StringBuffer buf = new StringBuffer();
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "OBJECT ");
        MIBObject.addString(mode, buf, this.getVariation(), c2 == null ? null : c2.getVariation());
        buf.append(lineSeparator);
        if (this.getSyntax() != null) {
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "SYNTAX ");
            cs = null;
            if (c2 != null) {
                cs = c2.getSyntax() != null ? c2.getSyntax() : new MIBSyntax();
            }
            buf.append(this.getSyntax().toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.getAccess() != null) {
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "PIB-MIN-ACCESS ");
            cs = null;
            if (c2 != null) {
                cs = c2.getAccess() != null ? c2.getAccess() : "";
            }
            MIBObject.addString(mode, buf, this.getAccess(), (String)cs);
            buf.append(lineSeparator);
        }
        buf.append("\t  ");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION ");
        buf.append(lineSeparator);
        MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.getDescription()), c2 == null ? null : MIBObject.formatLines("\t\t", c2.getDescription()));
        return buf.toString();
    }
}

