/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBModule2PDF {
    private static final String _$28505 = "Comments";
    private static final String _$28506 = "Keywords";
    private static final String _$28507 = "Identifier";
    private static final String _$28508 = "Values";
    private static final String _$28509 = "Types";
    private static final String _$28510 = "Clauses";
    private static final String _$28511 = "Text";
    private static final int _$28512 = 160;
    private static final int _$28513 = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat _$28515 = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository _$419;
    private Vector _$19752;
    private int _$18406 = 8;
    private int _$28516 = 2;
    private int _$2492 = 160;
    private float _$28517 = 11.0f;
    private float _$28518 = 10.0f;
    private String _$935 = "";
    private Rectangle _$25513;
    private Date _$28519;
    private Font _$25628 = FontFactory.getFont("Courier", this._$28518, 0);
    private Hashtable _$28522 = new Hashtable();
    private boolean _$28523;
    private boolean _$28524;
    private boolean _$28525 = true;
    private boolean _$28526 = true;
    private Vector _$28527 = new Vector();
    private int _$28528 = 0;
    private boolean _$28529;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this._$419 = rep;
        this._$19752 = fontStyles;
        this._$18406 = tabSize;
        this._$28530(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this._$25628.setSize(fontSize);
    }

    private void _$28530(Vector fontStyles) {
        for (int i2 = 0; i2 < fontStyles.size(); ++i2) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i2);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f2 = FontFactory.getFont(this._$25628.getFamilyname(), this._$25628.getSize(), s, style.getColor());
            this._$28522.put(style.getName(), f2);
        }
    }

    private String _$27082(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i2 = 0; i2 < num * this._$18406; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m2, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this._$28519 = new Date();
        this._$28516 = m2.getSMIVersion();
        this._$935 = m2.getModuleName();
        this._$25513 = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m2.getModuleName() + ", " + (m2.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", " + "MIB specification");
        doc.addTitle(m2.getModuleName());
        doc.addCreator(creator);
        this._$28542(m2);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent(events);
        doc.open();
        if (m2.hasCopyrightComment()) {
            this._$28527.add(null);
            doc.add(new Paragraph(this._$28517, m2.getCopyrightComment(), (Font)this._$28522.get(_$28505)));
        }
        doc.add(this._$28547("\n"));
        this._$28548(doc, m2);
        if (m2.hasCopyrightCommentEnd()) {
            this._$28527.add(null);
            doc.add(new Paragraph(this._$28517, m2.getCopyrightCommentEnd(), (Font)this._$28522.get(_$28505)));
        }
        try {
            doc.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void _$28542(MIBModule m2) {
        this._$28527 = new Vector(m2.size() + 1);
        this._$28528 = 0;
    }

    private Chunk _$28549(String keyword) {
        return new Chunk(keyword, (Font)this._$28522.get(_$28506));
    }

    private Chunk _$28547(String text) {
        return new Chunk(text, this._$25628);
    }

    private Chunk _$15809(String text) {
        return new Chunk(text, (Font)this._$28522.get(_$28505));
    }

    private Chunk _$2093(String text) {
        return new Chunk(text, (Font)this._$28522.get(_$28511));
    }

    private Phrase _$2093(int ident, String lines) {
        String prefix = this._$27082(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this._$28522.get(_$28511));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p2 = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p2.add(this._$2093(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p2.add(this._$2093(prefix + s));
        }
        return p2;
    }

    private Chunk _$28554(String text) {
        return new Chunk(text, (Font)this._$28522.get(_$28510));
    }

    private Chunk _$9371(String text) {
        return new Chunk(text, (Font)this._$28522.get(_$28509));
    }

    private Chunk _$63(String value) {
        return new Chunk(value, (Font)this._$28522.get(_$28508));
    }

    private Chunk _$20653(String value) {
        return new Chunk(value, (Font)this._$28522.get(_$28507));
    }

    private Chunk _$28555(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this._$28522.get(_$28507));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void _$28558(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this._$63(range.getUpper().toString()));
        } else {
            doc.add(this._$63(range.getLower().toString()));
            doc.add(this._$28547(".."));
            doc.add(this._$63(range.getUpper().toString()));
        }
    }

    private void _$28559(Paragraph doc, IEnum enumeration) {
        doc.add(this._$20653(enumeration.getLabel()));
        doc.add(this._$28547("("));
        doc.add(this._$63(enumeration.getValue()));
        doc.add(this._$28547(")"));
    }

    private void _$25302(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this._$28549("SEQUENCE OF "));
                doc.add(this._$63(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this._$419.getObject(syn.getSyntax()) != null) {
                    doc.add(this._$28555(syn.getSyntax()));
                } else {
                    doc.add(this._$9371(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this._$419.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this._$28547(" ("));
                    doc.add(this._$28549("SIZE"));
                }
                doc.add(this._$28547(" ("));
                Enumeration<MIBRange> en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this._$28558(doc, en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this._$28547(" | "));
                }
                doc.add(this._$28547(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this._$28547(")"));
            }
        }
        if (syn.hasEnums()) {
            this._$28562(doc, syn.getEnumsVector());
        }
    }

    private void _$28562(Paragraph doc, List<MIBEnum> enums) {
        doc.add(this._$28547(" {\n" + this._$27082(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this._$28559(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add(this._$28547(","));
                } else {
                    doc.add(this._$28547(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add(this._$28547(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add(this._$15809(this._$27082(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add(this._$28547("\n" + this._$27082(4) + MIBObject.space(max)));
                        doc.add(this._$15809(st.nextToken()));
                    }
                }
                doc.add(this._$28547("\n" + this._$27082(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add(this._$28547(",\n" + this._$27082(3)));
                continue;
            }
            doc.add(this._$28547(" "));
        }
        doc.add(this._$28547("}"));
    }

    private void _$28564(Paragraph doc, MIBObject o2) {
        doc.add(this._$28547(this._$27082(1)));
        doc.add(this._$28554("STATUS      "));
        if (!o2.hasStatus()) {
            doc.add(this._$28547("current"));
        } else {
            doc.add(this._$28547(o2.getStatus()));
        }
        doc.add(this._$28547("\n" + this._$27082(1)));
        doc.add(this._$28554("DESCRIPTION"));
        if (!o2.hasDescription()) {
            doc.add(this._$2093(" \"\"\n"));
        } else {
            doc.add(this._$28547("\n"));
            doc.add(this._$2093(2, o2.getDescription()));
            doc.add(this._$28547("\n"));
        }
        if (o2 instanceof PIBObjectType) {
            doc.add(this._$28547(this._$27082(1)));
            doc.add(this._$28554("INSTALL-ERRORS"));
            this._$28562(doc, ((PIBObjectType)o2).getInstallErrors());
            doc.add(this._$28547("\n"));
        }
        if (o2.hasReference()) {
            doc.add(this._$28547(this._$27082(1)));
            doc.add(this._$28554("REFERENCE"));
            doc.add(this._$2093(2, o2.getReference()));
            doc.add(this._$28547("\n"));
        }
    }

    private void _$28566(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this._$28547("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add(this._$28555(qualified + "." + parent.getName()));
                } else {
                    doc.add(this._$28555(parent.getName()));
                }
            }
            doc.add(this._$28547(" "));
            for (int i2 = oid.size() - diff; i2 < oid.size(); ++i2) {
                String oname = null;
                if (i2 + 1 < oid.size()) {
                    this._$419.getObjectName(oid.getPrefix(i2 + 1));
                }
                if (oname != null) {
                    doc.add(this._$20653(oname));
                    doc.add(this._$28547("("));
                    doc.add(this._$63(oid.getSubID(i2)));
                    doc.add(this._$28547(")"));
                } else {
                    doc.add(this._$63(oid.getSubID(i2)));
                }
                doc.add(this._$28547(" "));
            }
            doc.add(this._$28547("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this._$28547("{ " + oid.toString() + " }"));
        }
    }

    private void _$28570(Paragraph doc, MIBObject o2, MIBObject parent) {
        MIBObject[] parents = this._$419.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this._$28566(doc, o2.getOid(), parent, null);
        } else {
            String m2 = this._$419.getModuleName(parent.getModuleID());
            if (m2 == null) {
                this._$28566(doc, o2.getOid(), parent, null);
            } else {
                this._$28566(doc, o2.getOid(), parent, m2);
            }
        }
    }

    private void _$28572(Paragraph doc, MIBObject o2) {
        if ((this._$2492 & 0x20) > 0) {
            if ((this._$2492 & 0x400) > 0) {
                doc.add(this._$15809(" -- " + o2.getPrintableOid() + " --  "));
            } else {
                doc.add(this._$28547(this._$27082(1)));
                doc.add(this._$15809("-- " + o2.getPrintableOid()));
                doc.add(this._$28547("\n"));
                doc.add(this._$28547(this._$27082(1)));
            }
        } else {
            doc.add(this._$28547(this._$27082(1)));
        }
        doc.add(this._$28549("::= "));
        MIBObject parent = this._$419.getParent(o2);
        if (parent == null) {
            doc.add(this._$28547(o2.getOid().toSMI()));
        } else if (o2 instanceof MIBModule && parent.getModuleID() == o2.getModuleID()) {
            while (parent != null && parent.getModuleID() == o2.getModuleID()) {
                parent = this._$419.getParent(parent);
            }
            if (parent == null) {
                this._$28566(doc, o2.getOid(), parent, null);
            } else {
                this._$28570(doc, o2, parent);
            }
        } else {
            this._$28570(doc, o2, parent);
        }
    }

    private void _$28573(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add(this._$28554("PIB-INDEX "));
            } else {
                doc.add(this._$28554("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add(this._$28554("EXTENDS "));
        } else {
            doc.add(this._$28554("AUGMENTS "));
        }
        doc.add(this._$28547("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$28547(this._$27082(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this._$28549("IMPLIED "));
            }
            doc.add(this._$28555(element));
            if (en.hasMoreElements()) {
                doc.add(this._$28547(",\n"));
                continue;
            }
            doc.add(this._$28547("\n"));
        }
        doc.add(this._$28547(this._$27082(1) + "}\n"));
    }

    private void _$28575(Document doc, MIBObject o2) throws DocumentException {
        Paragraph para = this._$28577(doc, o2);
        if (o2.getType() == 0 && o2.hasStatus()) {
            para.add(this._$28549(" OBJECT-IDENTITY\n"));
            this._$28564(para, o2);
        } else {
            para.add(this._$28549(" OBJECT IDENTIFIER"));
        }
        para.add(this._$28547("\n"));
        this._$28572(para, o2);
        doc.add(para);
    }

    private void _$28578(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p2 = this._$28577(doc, ot);
        p2.add(this._$28549(" OBJECT-TYPE"));
        p2.add(this._$28547("\n" + this._$27082(1)));
        p2.add(this._$28554("SYNTAX      "));
        this._$25302(p2, ot.getSyntax());
        p2.add(this._$28547("\n"));
        if (ot.hasUnits()) {
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p2.add(this._$28547("\n"));
                p2.add(this._$2093(2, ot.getUnits()));
            } else {
                p2.add(this._$2093(ot.getUnits()));
            }
            p2.add(this._$28547("\n"));
        }
        p2.add(this._$28547(this._$27082(1)));
        if (ot.getAccess() != null) {
            if (this._$28516 == 1) {
                p2.add(this._$28554("ACCESS      "));
            } else {
                p2.add(this._$28554("MAX-ACCESS  "));
            }
            p2.add(this._$28547(ot.getAccess()));
            p2.add(this._$28547("\n"));
        }
        this._$28564(p2, ot);
        if (ot.hasIndexPart()) {
            p2.add(this._$28547(this._$27082(1)));
            this._$28573(p2, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p2.add(this._$28547(this._$27082(1)));
            this._$28573(p2, ((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p2.add(this._$28547(this._$27082(1)));
                p2.add(this._$28554("UNIQUENESS  "));
                p2.add("{\n");
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    doc.add(this._$28547(this._$27082(2)));
                    doc.add(this._$28555(element));
                    if (it.hasNext()) {
                        doc.add(this._$28547(",\n"));
                        continue;
                    }
                    doc.add(this._$28547("\n"));
                }
                doc.add(this._$28547(this._$27082(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("DEFVAL      "));
            p2.add(this._$28547("{ "));
            p2.add(this._$63(ot.getDefaultValue()));
            p2.add(this._$28547(" }\n"));
        }
        this._$28572(p2, ot);
        if (this._$419 != null && ot.isTable()) {
            p2.add(this._$28547("\n\n"));
            p2.add(this._$20653(ot.getSyntax().getSyntax()));
            p2.add(this._$28547(" ::= "));
            p2.add(this._$28549("SEQUENCE"));
            p2.add(this._$28547(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p2.add(this._$28547(this._$27082(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p2.add(this._$28547(this._$27082(2)));
                p2.add(this._$28555(s));
                p2.add(this._$28547(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o2 = (MIBObjectType)this._$419.getObject(s);
                if (o2 == null) continue;
                p2.add(this._$20653(o2.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p2.add(this._$28547(",\n"));
                    continue;
                }
                p2.add(this._$28547("\n" + this._$27082(1) + "}\n"));
            }
            p2.add(this._$28547("\n"));
        }
        doc.add(p2);
    }

    private Paragraph _$28577(Document doc, MIBObject o2) throws DocumentException {
        if (o2.hasComment()) {
            this._$28527.add(null);
            doc.add(new Paragraph(this._$28517, this._$15809(o2.getComment())));
        }
        Chunk chunk = new Chunk(o2.getName(), (Font)this._$28522.get(_$28507));
        chunk.setLocalDestination(o2.getName());
        this._$28527.add(o2);
        Paragraph para = new Paragraph(this._$28517, "\n");
        para.add(chunk);
        para.setKeepTogether(this._$28523);
        return para;
    }

    private Phrase _$28583(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$28547(this._$27082(indent)));
            if (link) {
                doc.add(this._$28555(element));
            } else {
                doc.add(this._$20653(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this._$28547(",\n"));
                continue;
            }
            doc.add(this._$28547("\n"));
        }
        return doc;
    }

    private void _$28585(Document doc, MIBNotifyType o2) throws DocumentException {
        Paragraph p2 = this._$28577(doc, o2);
        if (o2.isV1Trap()) {
            p2.add(this._$28549(" TRAP-TYPE"));
            p2.add(this._$28547("\n" + this._$27082(1)));
            p2.add(this._$28554("ENTERPRISE "));
            p2.add(this._$28547(o2.getEnterprise() + "\n"));
            if (o2.hasVariables()) {
                p2.add(this._$28547(this._$27082(1)));
                p2.add(this._$28554("VARIABLES"));
                p2.add(this._$28547(" {\n"));
                p2.add(this._$28583(2, o2.getVariablesVector().elements(), true));
                p2.add(this._$28547(this._$27082(1) + "}\n"));
            }
            if (o2.hasDescription()) {
                p2.add(this._$28547("\n" + this._$27082(1)));
                p2.add(this._$28554("DESCRIPTION "));
                p2.add(this._$28547("\n"));
                if (!o2.hasDescription()) {
                    p2.add(this._$2093(" \"\"\n"));
                } else {
                    p2.add(this._$28547("\n"));
                    p2.add(this._$2093(2, o2.getDescription()));
                    p2.add(this._$28547("\n"));
                }
            }
        } else {
            p2.add(this._$28554(" NOTIFICATION-TYPE"));
            p2.add(this._$28547("\n"));
            if (o2.hasVariables()) {
                p2.add(this._$28547(this._$27082(1)));
                p2.add(this._$28554("OBJECTS"));
                p2.add(this._$28547(" {\n"));
                p2.add(this._$28583(2, o2.getVariablesVector().elements(), true));
                p2.add(this._$28547(this._$27082(1) + "}\n"));
            }
            this._$28564(p2, o2);
        }
        if (o2.isV1Trap()) {
            try {
                p2.add(this._$28547(" ::= "));
                p2.add(this._$63("" + o2.getOid().getLastSubID()));
                p2.add(this._$28547("\n"));
            }
            catch (ObjectIDFormatException oex) {}
        } else {
            this._$28572(p2, o2);
        }
        doc.add(p2);
    }

    private void _$28591(Document doc, MIBGroup o2) throws DocumentException {
        Paragraph p2 = this._$28577(doc, o2);
        p2.add(this._$28549(" " + SMI.ENTRY_TYPES[o2.getType()]));
        p2.add(this._$28547("\n"));
        if (o2.getType() == 7) {
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("NOTIFICATIONS"));
            p2.add(this._$28547(" {\n"));
        } else {
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("OBJECTS"));
            p2.add(this._$28547(" {\n"));
        }
        p2.add(this._$28583(2, o2.getObjectsVector().elements(), true));
        p2.add(this._$28547(this._$27082(1) + "}\n"));
        this._$28564(p2, o2);
        this._$28572(p2, o2);
        doc.add(p2);
    }

    private void _$28592(Paragraph p2, MIBVariation o2) {
        p2.add(this._$28547(this._$27082(1)));
        if (o2 instanceof MIBException) {
            p2.add(this._$28554("OBJECT         "));
        } else {
            p2.add(this._$28554("VARIATION      "));
        }
        p2.add(this._$28547(o2.getVariation()));
        if (o2.hasSyntax()) {
            p2.add(this._$28547("\n" + this._$27082(1) + "  "));
            p2.add(this._$28554("SYNTAX       "));
            this._$25302(p2, o2.getSyntax());
        }
        if (o2.hasWriteSyntax()) {
            p2.add(this._$28547("\n" + this._$27082(1) + "  "));
            p2.add(this._$28554("WRITE-SYNTAX "));
            this._$25302(p2, o2.getWriteSyntax());
        }
        if (o2.hasAccess()) {
            p2.add(this._$28547("\n" + this._$27082(1) + "  "));
            if (o2 instanceof MIBException) {
                if (o2 instanceof PIBComplianceObject) {
                    p2.add(this._$28554("PIB-MIN-ACCESS "));
                } else {
                    p2.add(this._$28554("MIN-ACCESS   "));
                }
            } else {
                p2.add(this._$28554("ACCESS       "));
            }
            p2.add(this._$28547(o2.getAccess()));
        }
        if (o2.hasCreationRequires()) {
            p2.add(this._$28547("\n" + this._$27082(1) + "  "));
            p2.add(this._$28554("CREATION-REQUIRES"));
            p2.add(this._$28547(" {\n"));
            p2.add(this._$28583(3, o2.getCreationRequiresVector().elements(), false));
            p2.add(this._$28547(" }"));
        }
        if (o2.hasDefaultValue()) {
            p2.add(this._$28547("\n" + this._$27082(1) + "  "));
            p2.add(this._$28554("DEFVAL       "));
            p2.add(this._$28547(" { "));
            p2.add(this._$28547(o2.getDefval()));
            p2.add(this._$28547(" }"));
        }
        p2.add(this._$28547("\n" + this._$27082(1) + "  "));
        p2.add(this._$28554("DESCRIPTION "));
        if (o2.getDescription() != null) {
            p2.add(this._$28547("\n"));
            p2.add(this._$2093(2, o2.getDescription()));
        } else {
            p2.add(this._$2093("\"\""));
        }
        p2.add(this._$28547("\n"));
    }

    private void _$28593(Paragraph p2, MIBComplianceModule o2) {
        p2.add(this._$28547(this._$27082(1)));
        p2.add(this._$28554("MODULE "));
        if (o2.hasModuleName()) {
            p2.add(this._$20653(o2.getModuleName()));
        }
        p2.add(this._$28547("\n"));
        if (o2.hasMandatory()) {
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("MANDATORY-GROUPS"));
            p2.add(this._$28547(" {\n"));
            p2.add(this._$28583(3, o2.getMandatoryVector().elements(), false));
            p2.add(this._$28547(this._$27082(1) + "}\n"));
        }
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$28592(p2, v);
            }
        }
    }

    private void _$28594(Document doc, MIBCompliance o2) throws DocumentException {
        if (this._$28516 > 1) {
            Paragraph p2 = this._$28577(doc, o2);
            p2.add(this._$28549(" MODULE-COMPLIANCE"));
            p2.add(this._$28547("\n"));
            this._$28564(p2, o2);
            Enumeration<MIBComplianceModule> en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this._$28593(p2, en.nextElement());
            }
            this._$28572(p2, o2);
            doc.add(p2);
        }
    }

    private void _$28595(Paragraph p2, MIBSupportedModule o2) {
        p2.add(this._$28547("\n\n" + this._$27082(1)));
        p2.add(this._$28554("SUPPORTS "));
        p2.add(this._$28547(o2.getSupports()));
        p2.add(this._$28547("\n" + this._$27082(1)));
        p2.add(this._$28554("INCLUDES"));
        p2.add(this._$28547(" {\n"));
        p2.add(this._$28583(2, o2.getIncludes().elements(), false));
        p2.add(this._$28547(this._$27082(1) + "}\n"));
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$28592(p2, v);
            }
        }
    }

    private void _$28596(Document doc, MIBAgentCaps o2) throws DocumentException {
        if (this._$28516 > 1) {
            Paragraph p2 = this._$28577(doc, o2);
            p2.setKeepTogether(false);
            p2.add(this._$28549(" AGENT-CAPABILITIES"));
            p2.add(this._$28547("\n\n" + this._$27082(1)));
            p2.add(this._$28554("PRODUCT-RELEASE"));
            p2.add(this._$28547("\n"));
            p2.add(this._$2093(2, o2.getProductRelease()));
            p2.add(this._$28547("\n"));
            this._$28564(p2, o2);
            Enumeration en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this._$28595(p2, (MIBSupportedModule)en.nextElement());
            }
            this._$28572(p2, o2);
            doc.add(p2);
        }
    }

    private void _$28597(Document doc, MIBTextualConvention o2) throws DocumentException {
        Paragraph p2 = this._$28577(doc, o2);
        if (!o2.hasStatus() || SMI.statusType(o2.getStatus()) == 0) {
            p2.add(this._$28547(" ::= "));
            this._$25302(p2, o2.getSyntax());
        } else {
            p2.add(this._$28547(" ::= "));
            p2.add(this._$28549("TEXTUAL-CONVENTION"));
            p2.add(this._$28547("\n"));
            if (o2.hasDisplayHint()) {
                p2.add(this._$28547(this._$27082(1)));
                p2.add(this._$28554("DISPLAY-HINT "));
                p2.add(this._$2093(o2.getDisplayHint()));
                p2.add(this._$28547("\n"));
            }
            this._$28564(p2, o2);
            p2.add(this._$28547(this._$27082(1)));
            p2.add(this._$28554("SYNTAX      "));
            this._$25302(p2, o2.getSyntax());
        }
        doc.add(p2);
    }

    private void writeObject(Document doc, MIBObject o2) throws DocumentException {
        if (o2 instanceof MIBObjectType) {
            this._$28578(doc, (MIBObjectType)o2);
        } else if (o2 instanceof MIBTextualConvention) {
            this._$28597(doc, (MIBTextualConvention)o2);
        } else if (o2 instanceof MIBNotifyType) {
            this._$28585(doc, (MIBNotifyType)o2);
        } else if (o2 instanceof MIBGroup) {
            this._$28591(doc, (MIBGroup)o2);
        } else if (o2 instanceof MIBCompliance) {
            this._$28594(doc, (MIBCompliance)o2);
        } else if (o2 instanceof MIBAgentCaps) {
            this._$28596(doc, (MIBAgentCaps)o2);
        } else {
            this._$28575(doc, o2);
        }
    }

    private void _$18693(Document doc, MIBModule m2) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this._$2492));
        Enumeration en = m2.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o2 : orderedObjects.values()) {
            if (!(o2 instanceof MIBModule)) {
                this.writeObject(doc, o2);
                continue;
            }
            if (!(o2 instanceof MIBModule) || m2.getSMIVersion() != 1 || !o2.getOid().isValid()) continue;
            this.writeObject(doc, o2);
        }
    }

    private Chunk _$28599(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this._$28522.get(_$28507));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this._$28522.get(_$28507));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void _$28600(Paragraph doc, MIBImport imports) {
        Enumeration<String> en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this._$28547(this._$27082(1)));
            String name = en.nextElement().toString();
            MIBObject[] o2 = this._$419.getObjectsByName(name);
            if (o2 != null && o2.length > 1) {
                doc.add(this._$28599(imports.getSource(), name));
            } else {
                doc.add(this._$28599(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this._$28547(",\n"));
        }
        doc.add(this._$28547("\n" + this._$27082(2)));
        doc.add(this._$28549("FROM "));
        doc.add(this._$20653(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this._$28547(this._$27082(2)));
            doc.add(this._$15809(imports.getComment()));
        }
    }

    private void _$28601(Document doc, MIBModule o2) throws DocumentException {
        if (this._$28516 > 1 && o2.getOid().size() > 0) {
            String d2;
            Paragraph p2 = this._$28577(doc, o2);
            p2.add(this._$28549(" MODULE-IDENTITY"));
            if (o2 instanceof PIBModule) {
                p2.add(this._$28547("\n" + this._$27082(1)));
                p2.add(this._$28554("SUBJECT-CATEGORIES {"));
                p2.add(this._$28547("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o2).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p2.add(this._$28547(this._$27082(2)));
                    this._$28559(p2, element);
                    if (it.hasNext()) {
                        p2.add(this._$28547(",\n"));
                        continue;
                    }
                    p2.add(this._$28547("\n"));
                }
                p2.add(this._$28547(this._$27082(1) + "}\n"));
            }
            p2.add(this._$28547("\n" + this._$27082(1)));
            p2.add(this._$28554("LAST-UPDATED "));
            p2.add(this._$2093(o2.getLastUpdated()));
            if ((this._$2492 & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o2.getLastUpdated()))) != null) {
                p2.add(this._$28547(this._$27082(1)));
                p2.add(this._$15809("-- " + d2));
            }
            p2.add(this._$28547("\n" + this._$27082(1)));
            p2.add(this._$28554("ORGANIZATION "));
            p2.add(this._$2093(o2.getOrganization()));
            p2.add(this._$28547("\n" + this._$27082(1)));
            p2.add(this._$28554("CONTACT-INFO"));
            p2.add(this._$28547("\n"));
            p2.add(this._$2093(2, o2.getContactInfo()));
            p2.add(this._$28547("\n" + this._$27082(1)));
            p2.add(this._$28554("DESCRIPTION"));
            p2.add(this._$28547("\n"));
            p2.add(this._$2093(2, o2.getDescription()));
            p2.add(this._$28547("\n"));
            if (o2.hasRevisions()) {
                Enumeration en = o2.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d3;
                    MIBRevision r2 = (MIBRevision)en.nextElement();
                    p2.add(this._$28547("\n" + this._$27082(1)));
                    p2.add(this._$28554("REVISION "));
                    p2.add(this._$2093(r2.getRevision()));
                    if ((this._$2492 & 0x20) > 0 && (d3 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r2.getRevision()))) != null) {
                        p2.add(this._$28547(this._$27082(1)));
                        p2.add(this._$15809("-- " + d3));
                    }
                    p2.add(this._$28547("\n" + this._$27082(1)));
                    p2.add(this._$28554("DESCRIPTION"));
                    p2.add(this._$28547("\n"));
                    p2.add(this._$2093(2, r2.getDescription()));
                    p2.add(this._$28547("\n"));
                }
            }
            this._$28572(p2, o2);
            doc.add(p2);
        }
    }

    private void _$28548(Document doc, MIBModule m2) throws DocumentException {
        this._$28527.add(m2.getModuleName());
        Paragraph top = new Paragraph(this._$28517, this._$28547(m2.getModuleName()));
        if (m2 instanceof PIBModule) {
            top.add(this._$28549(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add(this._$28549(" DEFINITIONS ::= BEGIN"));
        }
        top.add(this._$28547("\n\n"));
        doc.add(top);
        if (m2.hasImports()) {
            this._$28527.add("IMPORTS");
            Paragraph p2 = new Paragraph(this._$28517, "IMPORTS\n", (Font)this._$28522.get(_$28506));
            Enumeration<MIBImport> en = m2.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = en.nextElement();
                this._$28600(p2, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p2.add(this._$28547("\n"));
            }
            p2.add(this._$28547(";"));
            doc.add(p2);
        }
        this._$28601(doc, m2);
        this._$18693(doc, m2);
        doc.add(this._$28547("\n"));
        this._$28527.add("END");
        doc.add(new Paragraph("END", (Font)this._$28522.get(_$28506)));
    }

    public void setDefaultFont(Font defaultFont) {
        this._$25628 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$25628;
    }

    public void setLeading(float leading) {
        this._$28517 = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this._$28523 = keepTogether;
    }

    public boolean isKeepTogether() {
        return this._$28523;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this._$28524 = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this._$28524;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this._$28525 = outlineTree;
        if (outlineTree) {
            this._$2492 = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this._$28525;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this._$28526 = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this._$28526;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this._$28529 = displayCurrentDate;
    }

    public void setMode(int mode) {
        this._$2492 = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this._$28529;
    }

    public int getMode() {
        return this._$2492;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this._$28527.elementAt(MIBModule2PDF.this._$28528) == null) {
                    MIBModule2PDF.this._$28528++;
                    return;
                }
                MIBObject o2 = null;
                if (MIBModule2PDF.this._$28527.elementAt(MIBModule2PDF.this._$28528) instanceof MIBObject) {
                    o2 = (MIBObject)MIBModule2PDF.this._$28527.elementAt(MIBModule2PDF.this._$28528);
                    title = o2.getName();
                    MIBObject parent = MIBModule2PDF.this._$419.getParent(o2);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this._$28527.elementAt(MIBModule2PDF.this._$28528).toString();
                }
                if (!MIBModule2PDF.this._$28525 || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o2 != null) {
                    o2.userObject = outline;
                }
                MIBModule2PDF.this._$28528++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont("Courier", "Cp1252", false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException de) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this._$28524) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this._$25513.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this._$25513.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this._$935);
            this.cb.endText();
            if (MIBModule2PDF.this._$28529) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = _$28515.format(MIBModule2PDF.this._$28519);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this._$25513.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

