/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObjectID;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectID
implements Serializable,
SMIObjectID,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected String oid;
    protected int hash = -1;
    protected int size = -1;
    protected long[] subIDs = null;

    public ObjectID() {
        this.oid = "";
        this.size = 0;
        this.hash = 0;
    }

    public ObjectID(String oid) {
        this.set(oid);
    }

    public ObjectID(ObjectID other) {
        this.oid = other.oid;
        if (other.subIDs != null) {
            this.subIDs = new long[other.subIDs.length];
            System.arraycopy(other.subIDs, 0, this.subIDs, 0, other.subIDs.length);
            this.size = this.subIDs.length;
            this.hash = other.hash;
        }
    }

    public ObjectID(IObjectID other) {
        this(((Object)other).toString());
    }

    public ObjectID(long[] newOid) {
        this.subIDs = newOid;
        this.oid = ObjectID.fromLongArray(newOid);
        this.size = newOid.length;
    }

    public ObjectID(int[] newOid) {
        this.subIDs = new long[newOid.length];
        for (int i2 = 0; i2 < newOid.length; ++i2) {
            this.subIDs[i2] = 0xFFFFFFFFFFFFFFFFL & (long)newOid[i2];
        }
        this.oid = ObjectID.fromLongArray(this.subIDs);
        this.size = newOid.length;
    }

    public String get() {
        return this.oid;
    }

    public void set(String oid) {
        this.oid = oid == null ? "" : oid;
        this.hashCode();
        this.size = -1;
        this.subIDs = null;
    }

    public int size() {
        if (this.size == -1) {
            StringTokenizer st = new StringTokenizer(this.oid, ".", false);
            this.size = st.countTokens();
        }
        return this.size;
    }

    private void needLongArray() throws ObjectIDFormatException {
        if (this.subIDs == null) {
            this.subIDs = ObjectID.toLongArray(this.oid);
            this.size = this.subIDs.length;
        }
    }

    public void append(long subid) throws ObjectIDFormatException {
        this.needLongArray();
        if (this.subIDs != null) {
            long[] copy = new long[++this.size];
            System.arraycopy(this.subIDs, 0, copy, 0, this.size - 1);
            copy[this.size - 1] = subid;
            this.subIDs = copy;
        }
        this.oid = this.oid.length() == 0 ? "" + subid : this.oid + "." + subid;
    }

    public void append(ObjectID other) {
        if (other == null || other.size() == 0) {
            return;
        }
        if (this.subIDs != null && other.subIDs != null) {
            long[] copy = new long[this.size + other.subIDs.length];
            System.arraycopy(this.subIDs, 0, copy, 0, this.subIDs.length);
            System.arraycopy(other.subIDs, 0, copy, this.subIDs.length, other.subIDs.length);
            this.subIDs = copy;
            this.size = copy.length;
        }
        this.oid = this.oid.length() == 0 ? other.oid : this.oid + "." + other.oid;
    }

    public ObjectID getPrefix(int len) throws ObjectIDFormatException {
        if (len <= 0) {
            return new ObjectID();
        }
        this.needLongArray();
        long[] array = new long[len];
        System.arraycopy(this.subIDs, 0, array, 0, len);
        return new ObjectID(array);
    }

    public ObjectID getSuffix(int len) throws ObjectIDFormatException {
        this.needLongArray();
        if (this.subIDs.length - len <= 0) {
            return new ObjectID();
        }
        long[] array = new long[len];
        System.arraycopy(this.subIDs, this.subIDs.length - len, array, 0, len);
        return new ObjectID(array);
    }

    public void setSubID(int n2, String subid) {
        StringTokenizer st = new StringTokenizer(this.oid, ".", false);
        String[] id = new String[st.countTokens()];
        if (n2 >= id.length) {
            return;
        }
        StringBuffer newValue = new StringBuffer();
        for (int i2 = 0; i2 < n2 && i2 < id.length; ++i2) {
            newValue.append(st.nextToken());
            newValue.append(".");
        }
        newValue.append(subid);
        st.nextToken();
        while (st.hasMoreTokens()) {
            newValue.append(".");
            newValue.append(st.nextToken());
        }
        this.oid = newValue.toString();
    }

    public void setSubID(int n2, long id) {
        if (this.subIDs != null) {
            this.subIDs[n2] = id;
            this.oid = ObjectID.fromLongArray(this.subIDs);
        } else {
            this.setSubID(n2, "" + id);
        }
    }

    public String getSubID(int n2) {
        StringTokenizer st = new StringTokenizer(this.oid, ".", false);
        if (n2 >= st.countTokens()) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            st.nextToken();
        }
        return st.nextToken();
    }

    public long getSubIDAsLong(int n2) throws ObjectIDFormatException {
        this.needLongArray();
        return this.subIDs[n2];
    }

    public static String fromArray(String[] array) {
        StringBuffer buf = new StringBuffer(64);
        for (int i2 = 0; i2 < array.length; ++i2) {
            buf.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public static String fromArrayToSMI(String[] array) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < array.length; ++i2) {
            buf.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String fromLongArray(long[] array) {
        StringBuffer buf = new StringBuffer(array.length * 3);
        for (int i2 = 0; i2 < array.length; ++i2) {
            buf.append(array[i2]);
            if (i2 + 1 >= array.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public long[] toLongArray() throws ObjectIDFormatException {
        return ObjectID.toLongArray(this.oid);
    }

    public long[] getLongArray() {
        try {
            return this.toLongArray();
        }
        catch (ObjectIDFormatException ex) {
            return null;
        }
    }

    public static String[] toArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ".", false);
        String[] id = new String[st.countTokens()];
        for (int i2 = 0; i2 < id.length; ++i2) {
            id[i2] = st.nextToken();
        }
        return id;
    }

    public static long[] toLongArray(String s) throws ObjectIDFormatException {
        StringTokenizer st = new StringTokenizer(s, ".", true);
        int size = st.countTokens();
        long[] value = new long[size];
        size = 0;
        StringBuffer buf = null;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (buf == null && t.startsWith("'")) {
                buf = new StringBuffer();
                t = t.substring(1);
            }
            if (buf != null && t.endsWith("'")) {
                buf.append(t.substring(0, t.length() - 1));
                ObjectID o2 = ObjectID.asOID(buf.toString());
                long[] h2 = value;
                value = new long[st.countTokens() + h2.length + o2.size()];
                System.arraycopy(h2, 0, value, 0, size);
                System.arraycopy(o2.getLongArray(), 0, value, size, o2.size());
                size += o2.size();
                buf = null;
                continue;
            }
            if (buf != null) {
                buf.append(t);
                continue;
            }
            if (".".equals(t)) continue;
            try {
                value[size++] = Long.parseLong(t);
            }
            catch (NumberFormatException e2) {
                throw new ObjectIDFormatException();
            }
        }
        if (size < value.length) {
            long[] h3 = value;
            value = new long[size];
            System.arraycopy(h3, 0, value, 0, size);
        }
        return value;
    }

    public static String trim(String s) {
        int index = s.lastIndexOf(".");
        if (index >= 0) {
            return s.substring(0, index);
        }
        return "";
    }

    public static ObjectID trim(ObjectID id) {
        int index = id.toString().lastIndexOf(46);
        if (index >= 0) {
            return new ObjectID(id.toString().substring(0, index));
        }
        return new ObjectID();
    }

    public IObjectID trim() {
        return ObjectID.trim(this);
    }

    public static String toNumSeq(String oid) {
        String s = new String(oid);
        return s.replace('.', '0');
    }

    public long getLastSubID() throws ObjectIDFormatException {
        this.needLongArray();
        return this.subIDs[this.subIDs.length - 1];
    }

    public static String getLastSubID(String oid) {
        int index = oid.lastIndexOf(".");
        if (index >= 0) {
            return oid.substring(index + 1);
        }
        return oid;
    }

    public static ObjectID getLastSubID(ObjectID oid) {
        int index = oid.toString().lastIndexOf(".");
        if (index >= 0) {
            return new ObjectID(oid.toString().substring(index + 1));
        }
        return oid;
    }

    public static long longHashCode(String oid) throws ObjectIDFormatException {
        BigInteger big;
        String seq = ObjectID.toNumSeq(oid);
        if (seq.length() == 0) {
            return 0L;
        }
        try {
            big = new BigInteger(ObjectID.toNumSeq(oid));
        }
        catch (NumberFormatException nfe) {
            throw new ObjectIDFormatException();
        }
        return big.mod(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    public static int intHashCode(String oid) throws ObjectIDFormatException {
        BigInteger big;
        String seq = ObjectID.toNumSeq(oid);
        if (seq.length() == 0) {
            return 0;
        }
        try {
            big = new BigInteger(ObjectID.toNumSeq(oid));
        }
        catch (NumberFormatException nfe) {
            throw new ObjectIDFormatException();
        }
        return big.mod(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    public int hashCode() {
        if (this.hash >= 0) {
            return this.hash;
        }
        try {
            this.hash = ObjectID.intHashCode(this.oid);
        }
        catch (ObjectIDFormatException e2) {
            return 0;
        }
        return this.hash;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof ObjectID) {
            return this.oid.equals(((ObjectID)o2).oid);
        }
        return false;
    }

    public boolean isLessThan(ObjectID o2) throws ObjectIDFormatException {
        this.needLongArray();
        o2.needLongArray();
        int min = this.subIDs.length > o2.subIDs.length ? o2.subIDs.length : this.subIDs.length;
        for (int i2 = 0; i2 < min; ++i2) {
            if (this.subIDs[i2] == o2.subIDs[i2]) continue;
            return this.subIDs[i2] < o2.subIDs[i2];
        }
        return this.subIDs.length < o2.subIDs.length;
    }

    public boolean isLessThan(IObjectID oid) {
        try {
            return this.isLessThan((ObjectID)oid);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.oid.length() == 0 || this.oid.equals(".");
    }

    public boolean isParentOf(IObjectID id) {
        return id.size() - 1 == this.size() && ((Object)id).toString().startsWith(this.oid + ".");
    }

    public boolean isRootOf(IObjectID id) {
        return ((Object)id).toString().startsWith(this.oid + ".");
    }

    public boolean isDescendantOf(IObjectID id, int level) {
        return id.size() + level == this.size() && this.oid.startsWith(((Object)id).toString() + ".");
    }

    public boolean isChildOf(IObjectID id) {
        return this.isDescendantOf(id, 1);
    }

    public static boolean compare(ObjectID a2, ObjectID b2) {
        return ObjectIDPredicate.instance.execute(a2, b2);
    }

    public int compareTo(Object o2) {
        if (o2 instanceof ObjectID) {
            if (this.oid.equals(((ObjectID)o2).oid)) {
                return 0;
            }
            if (ObjectID.compare(this, (ObjectID)o2)) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public ObjectID nextPeer() throws ObjectIDFormatException {
        return this.nextPeer(1);
    }

    public ObjectID nextPeer(int increment) throws ObjectIDFormatException {
        this.needLongArray();
        long[] o2 = new long[this.subIDs.length];
        System.arraycopy(this.subIDs, 0, o2, 0, this.subIDs.length);
        o2[this.subIDs.length - 1] = o2[this.subIDs.length - 1] + (long)increment;
        return new ObjectID(o2);
    }

    public boolean isValid() {
        if (this.oid == null || this.oid.trim().length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.oid.length(); ++i2) {
            if (Character.isDigit(this.oid.charAt(i2)) || this.oid.charAt(i2) == '.') continue;
            if (this.oid.indexOf(39) >= 0) {
                try {
                    this.needLongArray();
                    return true;
                }
                catch (ObjectIDFormatException oidfe) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public String getFirstUnresolvedSubId() {
        StringTokenizer st = new StringTokenizer(this.oid, ".", false);
        while (st.hasMoreTokens()) {
            String sid = st.nextToken();
            if (sid.length() <= 0 || Character.isDigit(sid.charAt(0))) continue;
            return sid;
        }
        return null;
    }

    public ObjectID getValidPrefix() {
        StringTokenizer st = new StringTokenizer(this.oid, ".", false);
        Vector<Long> v = new Vector<Long>();
        while (st.hasMoreTokens()) {
            String sid = st.nextToken();
            for (int i2 = 0; i2 < sid.length() && Character.isDigit(sid.charAt(i2)); ++i2) {
            }
            try {
                long l2 = Long.parseLong(sid);
                v.addElement(new Long(l2));
            }
            catch (NumberFormatException e2) {
                break;
            }
        }
        long[] ll = new long[v.size()];
        for (int i3 = 0; i3 < ll.length; ++i3) {
            ll[i3] = (Long)v.elementAt(i3);
        }
        return new ObjectID(ll);
    }

    public String toSMI() {
        StringBuffer buf = new StringBuffer("{");
        StringTokenizer st = new StringTokenizer(this.oid, ".", false);
        while (st.hasMoreTokens()) {
            buf.append(" " + st.nextToken() + " ");
        }
        buf.append("}");
        return buf.toString();
    }

    public String toSMI(String parent) {
        StringBuffer buf = new StringBuffer("{ ");
        buf.append(parent + " ");
        buf.append(this.oid.substring(this.oid.lastIndexOf(".") + 1));
        buf.append(" }");
        return buf.toString();
    }

    public String toSMI(MIBRepository rep, int mode, MIBObject parent, String qualified) {
        try {
            this.needLongArray();
            int diff = this.size - parent.getOid().size();
            StringBuffer buf = new StringBuffer("{ ");
            if (qualified != null) {
                MIBObject.addObjectLink(mode, buf, qualified + "." + parent.getName());
            } else {
                MIBObject.addObjectLink(mode, buf, parent.getName());
            }
            buf.append(' ');
            for (int i2 = this.size - diff; i2 < this.size; ++i2) {
                String oname = null;
                if (i2 + 1 < this.size) {
                    rep.getObjectName(this.getPrefix(i2 + 1));
                }
                if (oname != null) {
                    buf.append(oname);
                    buf.append('(');
                    buf.append(this.subIDs[i2]);
                    buf.append(')');
                } else {
                    buf.append(this.subIDs[i2]);
                }
                buf.append(' ');
            }
            buf.append('}');
            return buf.toString();
        }
        catch (ObjectIDFormatException ex) {
            return "{ " + this.oid + " }";
        }
    }

    public String toSMI(int mode, MIBObject parent, String qualified) {
        try {
            this.needLongArray();
            int diff = this.size - parent.getOid().size();
            StringBuffer buf = new StringBuffer("{ ");
            if (qualified != null) {
                MIBObject.addObjectLink(mode, buf, qualified + "." + parent.getName());
            } else {
                MIBObject.addObjectLink(mode, buf, parent.getName());
            }
            buf.append(' ');
            for (int i2 = this.size - diff; i2 < this.size; ++i2) {
                buf.append(this.subIDs[i2]);
                buf.append(' ');
            }
            buf.append('}');
            return buf.toString();
        }
        catch (ObjectIDFormatException ex) {
            return "{ " + this.oid + " }";
        }
    }

    public String toString() {
        return this.oid;
    }

    public static boolean isIdentifier(String lastName) {
        if (lastName.length() <= 0 || !Character.isLetter(lastName.charAt(0)) || lastName.indexOf("--") >= 0) {
            return false;
        }
        char[] a2 = lastName.toCharArray();
        for (int i2 = 1; i2 < a2.length; ++i2) {
            if (Character.isLetterOrDigit(a2[i2]) || i2 < a2.length && a2[i2] == '-') continue;
            return false;
        }
        return true;
    }

    public static ObjectID asOID(String aString) {
        long[] l2 = new long[aString.length()];
        for (int i2 = 0; i2 < aString.length(); ++i2) {
            l2[i2] = aString.charAt(i2) & 0xFF;
        }
        return new ObjectID(l2);
    }

    public static ObjectID asOID(byte[] aString) {
        long[] l2 = new long[aString.length];
        for (int i2 = 0; i2 < aString.length; ++i2) {
            l2[i2] = aString[i2] & 0xFF;
        }
        return new ObjectID(l2);
    }

    public String asString() throws ObjectIDFormatException {
        this.needLongArray();
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            buf.append((char)this.subIDs[i2]);
        }
        return buf.toString();
    }

    public byte[] asByteArray() throws ObjectIDFormatException {
        this.needLongArray();
        byte[] b2 = new byte[this.subIDs.length];
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            b2[i2] = (byte)this.subIDs[i2];
        }
        return b2;
    }

    public int[] asIntArray() throws ObjectIDFormatException {
        this.needLongArray();
        int[] b2 = new int[this.subIDs.length];
        for (int i2 = 0; i2 < this.subIDs.length; ++i2) {
            b2[i2] = (int)this.subIDs[i2] & 0xFFFFFFFF;
        }
        return b2;
    }

    public boolean isPeerOf(ObjectID other) {
        if (this.size() == other.size()) {
            if (this.size <= 1) {
                return true;
            }
            for (int i2 = 0; i2 < this.size - 1; ++i2) {
                if (this.subIDs[i2] == other.subIDs[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List getSubIdentifiers() {
        StringTokenizer st = new StringTokenizer(this.oid, ".");
        Vector<String> v = new Vector<String>(st.countTokens() + 1);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public String getLastSubIdentifier() {
        if (this.subIDs != null) {
            try {
                return "" + this.getLastSubID();
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (this.size() > 0) {
            return ObjectID.getLastSubID(this.oid);
        }
        return null;
    }
}

