/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smi.ext.SMIVariation;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBVariation
implements Serializable,
SMIVariation {
    public static final long serialVersionUID = 1000L;
    private MIBSyntax syntax = null;
    private MIBSyntax writeSyntax = null;
    private String variation = null;
    private String access = null;
    private Vector creationRequires = new Vector();
    private String defval = null;
    private String description = null;
    private transient Object userObject = null;

    public MIBVariation() {
    }

    public MIBVariation(String variation, String descr) {
        this.variation = variation;
        this.description = descr;
    }

    public MIBVariation(MIBVariation other) {
        this.variation = other.variation;
        if (other.hasSyntax()) {
            this.syntax = new MIBSyntax(other.syntax);
        }
        if (other.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(other.writeSyntax);
        }
        if (other.hasAccess()) {
            this.access = new String(other.access);
        }
        if (other.hasDefaultValue()) {
            this.defval = new String(other.defval);
        }
        if (other.hasCreationRequires()) {
            Enumeration en = other.creationRequires.elements();
            while (en.hasMoreElements()) {
                this.creationRequires.addElement(en.nextElement());
            }
        }
        this.description = other.description;
    }

    public MIBSyntax getSyntax() {
        return this.syntax;
    }

    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    public ISyntax getWriteSyntaxDef() {
        return this.writeSyntax;
    }

    public boolean hasSyntax() {
        return this.syntax != null;
    }

    public boolean hasWriteSyntax() {
        return this.writeSyntax != null;
    }

    public boolean hasAccess() {
        return this.access != null;
    }

    public boolean hasDefaultValue() {
        return this.defval != null;
    }

    public void setSyntaxDef(SMISyntax newSyntax) {
        this.syntax = (MIBSyntax)newSyntax;
    }

    public void setSyntax(MIBSyntax newSyntax) {
        this.syntax = newSyntax;
    }

    public void setWriteSyntax(MIBSyntax newWriteSyntax) {
        this.writeSyntax = newWriteSyntax;
    }

    public void setWriteSyntaxDef(SMISyntax newWriteSyntax) {
        this.writeSyntax = (MIBSyntax)newWriteSyntax;
    }

    public MIBSyntax getWriteSyntax() {
        return this.writeSyntax;
    }

    public void setVariation(String newVariation) {
        this.variation = newVariation;
    }

    public String getVariation() {
        return this.variation;
    }

    public void setAccess(String newAccess) {
        this.access = newAccess;
    }

    public String getAccess() {
        return this.access;
    }

    public boolean hasCreationRequires() {
        return this.creationRequires != null && this.creationRequires.size() > 0;
    }

    public void setCreationRequires(String[] newCreationRequires) {
        this.creationRequires = new Vector<String>(Arrays.asList(newCreationRequires));
    }

    public void setCreationRequires(Vector newCreationRequires) {
        this.creationRequires = newCreationRequires;
    }

    public Vector getCreationRequiresVector() {
        return this.creationRequires;
    }

    public String[] getCreationRequires() {
        Object[] s = new String[this.creationRequires.size()];
        this.creationRequires.copyInto(s);
        return s;
    }

    public void setDefval(String newDefval) {
        this.defval = newDefval;
    }

    public String getDefval() {
        return this.defval;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public String toSMI(int mode, MIBRepository rep, MIBVariation c2, String lineSeparator) {
        Object cs;
        StringBuffer buf = new StringBuffer(lineSeparator + "\t");
        MIBObject.addKeyWord(mode, buf, "VARIATION ");
        MIBObject.addString(mode, buf, this.variation, c2 == null ? null : c2.variation);
        if (this.syntax != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "SYNTAX   ");
            cs = null;
            if (c2 != null) {
                cs = c2.syntax != null ? c2.syntax : new MIBSyntax();
            }
            buf.append(this.syntax.toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.writeSyntax != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "WRITE-SYNTAX ");
            cs = null;
            if (c2 != null) {
                cs = c2.writeSyntax != null ? c2.writeSyntax : new MIBSyntax();
            }
            buf.append(this.writeSyntax.toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.access != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "ACCESS ");
            cs = null;
            if (c2 != null) {
                cs = c2.access != null ? c2.access : "";
            }
            MIBObject.addString(mode, buf, this.access, (String)cs);
            buf.append(lineSeparator);
        }
        if (this.creationRequires != null && this.creationRequires.size() > 0) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "CREATION-REQUIRES");
            buf.append(" {");
            buf.append(lineSeparator);
            cs = null;
            if (c2 != null) {
                cs = c2.creationRequires != null && c2.creationRequires.size() > 0 ? MIBObject.formatObjectRefs(mode, "\t\t\t", c2.creationRequires.iterator(), lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t\t", this.creationRequires.iterator(), lineSeparator), (String)cs);
            buf.append(" }");
        }
        if (this.defval != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "DEFVAL");
            buf.append(" { ");
            cs = null;
            if (c2 != null) {
                cs = c2.defval != null ? c2.defval : "";
            }
            MIBObject.addString(mode, buf, this.defval, (String)cs);
            buf.append(" }");
        }
        buf.append(lineSeparator);
        buf.append("\t  ");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION");
        if (this.description != null) {
            buf.append(lineSeparator);
            cs = null;
            if (c2 != null) {
                cs = c2.description != null && c2.description.length() > 0 ? MIBObject.formatLines("\t\t", c2.description) : "";
            }
            MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.description), (String)cs);
        } else {
            MIBObject.addText(lineSeparator, mode, buf, "\"\"");
        }
        return buf.toString();
    }

    public String toString() {
        return this.variation;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBVariation) {
            MIBVariation other = (MIBVariation)o2;
            return MIBObject.saveCompare(this.syntax, other.syntax) && MIBObject.saveCompare(this.writeSyntax, other.writeSyntax) && MIBObject.saveCompare(this.variation, other.variation) && MIBObject.saveCompare(this.access, other.access) && MIBObject.saveCompare(this.creationRequires, other.creationRequires) && MIBObject.saveCompare(this.defval, other.defval) && MIBObject.saveCompare(this.description, other.description);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasSyntax()) {
            this.syntax.userObject = null;
        }
        if (this.hasWriteSyntax()) {
            this.writeSyntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

