/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIRevision;
import java.io.Serializable;

public class MIBRevision
implements Serializable,
SMIRevision {
    public static final long serialVersionUID = 1000L;
    protected String revision = null;
    protected String description = null;

    public MIBRevision() {
    }

    public MIBRevision(String r2, String d2) {
        this.revision = r2;
        this.description = d2;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String toSMI(int mode, MIBRevision c2, String lineSeparator) {
        String d2;
        StringBuffer buf = new StringBuffer("\t");
        MIBObject.addKeyWord(mode, buf, "REVISION ");
        MIBObject.addText(lineSeparator, mode, buf, this.revision, c2 == null ? null : c2.revision);
        if ((mode & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(this.revision))) != null) {
            buf.append("\t");
            MIBObject.addComment(mode, buf, "-- " + d2, lineSeparator);
        }
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION");
        buf.append(lineSeparator);
        MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.description), c2 == null ? null : MIBObject.formatLines("\t\t", c2.description));
        buf.append(lineSeparator);
        return buf.toString();
    }

    public String toString() {
        return this.revision;
    }

    public String toDetailedString() {
        return this.revision + "(" + this.description + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof MIBRevision) {
            MIBRevision r2 = (MIBRevision)other;
            return r2.revision.equals(this.revision);
        }
        return false;
    }
}

