/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.INotificationType;
import com.agentpp.smi.IObject;
import com.agentpp.smi.ISyntax;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBRepository
implements Serializable {
    public static final long serialVersionUID = 100L;
    private transient ConcurrentHashMap<String, MIBModule> modules = null;
    private transient ConcurrentHashMap<Integer, MIBModule> moduleIDs = null;
    private transient ConcurrentHashMap<Integer, String> importedModuleIDs = null;
    private transient OrderedMap onames = null;
    private transient OrderedMap oids = null;
    private transient Vector listenerList;

    public MIBRepository() {
        this.init(false);
    }

    public MIBRepository(boolean addIETFObjects) {
        this.init(addIETFObjects);
    }

    public MIBRepository(MIBObject[] objects) {
        this.init(false);
        this.addAllObjects(objects);
    }

    public Object clone() {
        MIBRepository r2 = new MIBRepository();
        r2.oids = (OrderedMap)this.oids.clone();
        r2.onames = (OrderedMap)this.onames.clone();
        r2.modules = new ConcurrentHashMap<String, MIBModule>(this.modules);
        r2.moduleIDs = new ConcurrentHashMap<Integer, MIBModule>(this.moduleIDs);
        r2.importedModuleIDs = new ConcurrentHashMap<Integer, String>(this.importedModuleIDs);
        return r2;
    }

    private void init(boolean withIETF) {
        this.listenerList = new Vector(5);
        this.oids = new OrderedMap(ObjectIDPredicate.instance, true);
        this.onames = new OrderedMap(LexicographicPredicate.instance, true);
        this.modules = new ConcurrentHashMap(150);
        this.moduleIDs = new ConcurrentHashMap(150);
        this.importedModuleIDs = new ConcurrentHashMap(100);
        if (withIETF) {
            this.addIETFObjectIDs();
        }
        this.structureChanged();
    }

    public int size() {
        return this.oids.size();
    }

    public int moduleCount() {
        return this.modules.size();
    }

    protected void addIETFObjectIDs() {
        for (int i2 = 0; i2 < SMI.rootOids.length; ++i2) {
            MIBObject o2 = new MIBObject(new ObjectID(SMI.rootOids[i2][1]), SMI.rootOids[i2][0]);
            this.oids.add(o2.getOid(), o2);
            this.onames.add(o2.getName(), o2);
        }
    }

    private void addModule(MIBModule o2) {
        this.modules.put(o2.getModuleName(), o2);
        this.moduleIDs.put(o2.getModuleID(), o2);
    }

    public synchronized void addObject(MIBObject o2) {
        this.removeObject(o2.getModuleID(), o2);
        if (o2.getOid().size() > 0) {
            this.oids.add(o2.getOid(), o2);
        }
        this.onames.add(o2.getName(), o2);
        if (o2 instanceof MIBModule) {
            this.addModule((MIBModule)o2);
            ((MIBModule)o2).add(o2);
        } else {
            MIBModule m2 = this.moduleIDs.get(o2.getModuleID());
            if (m2 != null) {
                m2.add(o2);
            }
        }
    }

    public synchronized void addObject(MIBObject o2, boolean addModuleObjects) {
        this.addObject(o2);
        if (o2 instanceof MIBModule) {
            MIBModule m2 = (MIBModule)o2;
            for (MIBObject obj : m2.objects.values()) {
                this.addObject(obj);
            }
        }
    }

    public void addAllObjects(MIBObject[] objects) {
        for (int i2 = 0; i2 < objects.length; ++i2) {
            this.addObject(objects[i2]);
        }
        this.structureChanged();
    }

    public String getObjectName(ObjectID oid) {
        MIBObject o2 = (MIBObject)this.oids.get(oid);
        if (o2 != null) {
            return o2.getName();
        }
        return null;
    }

    public String getUniqueObjectName(MIBObject o2) {
        MIBObject[] objs = this.getObjectsByName(o2.getName());
        if (objs == null || objs.length <= 1) {
            return o2.getName();
        }
        String m2 = this.getModuleName(o2.getModuleID());
        if (m2 == null) {
            return o2.getName();
        }
        return m2 + "." + o2.getName();
    }

    public ObjectID getObjectID(String name) {
        MIBObject o2 = (MIBObject)this.onames.get(name);
        if (o2 != null) {
            return o2.getOid();
        }
        return null;
    }

    public ObjectID getObjectID(String moduleName, String name) {
        MIBModule m2 = this.getModule(moduleName);
        if (m2 == null) {
            return null;
        }
        MIBObject o2 = m2.getObjectByName(name);
        if (o2 != null) {
            return o2.getOid();
        }
        return null;
    }

    public MIBObject getObject(String moduleName, String name) {
        MIBModule m2 = this.getModule(moduleName);
        if (m2 == null) {
            MIBObject[] o2 = this.getObjectsByName(name);
            for (int i2 = 0; i2 < o2.length; ++i2) {
                if (!moduleName.equals(this.getModuleName(o2[i2].getModuleID()))) continue;
                return o2[i2];
            }
            return null;
        }
        return m2.getObjectByName(name);
    }

    public MIBObject getScopedObject(String moduleName, String name) {
        if (name.length() == 0) {
            return null;
        }
        if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            return this.getObject(name);
        }
        MIBModule m2 = this.getModule(moduleName);
        if (m2 == null) {
            MIBObject[] o2 = this.getObjectsByName(name);
            for (int i2 = 0; i2 < o2.length; ++i2) {
                if (!moduleName.equals(this.getModuleName(o2[i2].getModuleID()))) continue;
                return o2[i2];
            }
            return null;
        }
        String source = m2.getImportSource(name);
        if (source != null) {
            return this.getObject(source, name);
        }
        return m2.getObjectByName(name);
    }

    public Vector<? extends MIBObject> getChildren(String objectName) {
        MIBObject o2 = (MIBObject)this.onames.get(objectName);
        if (o2 == null) {
            return null;
        }
        return this.getChildren(o2);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid) {
        return this.getChildren(oid, true);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid, boolean uniqueOIDs) {
        Vector<MIBObject> retval = new Vector<MIBObject>();
        OrderedMapIterator it = this.oids.find(oid);
        if (it.atEnd()) {
            return retval;
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().equals(oid)) {
            return retval;
        }
        it.advance();
        while (!it.atEnd()) {
            block7: {
                MIBObject child;
                block9: {
                    MIBObject o2;
                    block8: {
                        child = (MIBObject)((Pair)it.get()).second;
                        if (child.getOid().equals(oid) || uniqueOIDs && retval.size() > 0 && child.getOid().equals(((MIBObject)retval.lastElement()).getOid())) break block7;
                        if (!child.getOid().isChildOf(oid)) break block8;
                        retval.add(child);
                        break block9;
                    }
                    if (!oid.isRootOf(child.getOid())) break block9;
                    if (retval.size() > 0 && (o2 = (MIBObject)retval.lastElement()).getOid().isRootOf(child.getOid())) break block7;
                    retval.addElement(child);
                }
                if (!oid.isRootOf(child.getOid())) {
                    return retval;
                }
            }
            it.advance();
        }
        return retval;
    }

    public Vector<? extends MIBObject> getChildren(MIBObject o2) {
        return this.getChildren(o2.getOid());
    }

    public void removeChildren(MIBObject o2) {
        Vector<? extends MIBObject> v = this.getChildren(o2);
        if (v == null) {
            return;
        }
        Enumeration<? extends MIBObject> en = v.elements();
        while (en.hasMoreElements()) {
            MIBObject obj = en.nextElement();
            this.removeObject(obj);
        }
    }

    public Vector<? extends MIBObject> getDescendants(MIBObject o2) {
        Vector<MIBObject> v = new Vector<MIBObject>(10, 10);
        Vector<? extends MIBObject> childs = this.getChildren(o2);
        if (childs == null) {
            return v;
        }
        Enumeration<? extends MIBObject> e2 = childs.elements();
        while (e2.hasMoreElements()) {
            MIBObject current = e2.nextElement();
            v.addElement(current);
            Vector<? extends MIBObject> desc = this.getDescendants(current);
            Enumeration<? extends MIBObject> d2 = desc.elements();
            while (d2.hasMoreElements()) {
                v.addElement(d2.nextElement());
            }
        }
        return v;
    }

    public boolean hasDescendants(MIBObject o2) {
        if (o2.getOid() == null) {
            return false;
        }
        ObjectID oid = o2.getOid();
        OrderedMapIterator it = this.oids.find(oid);
        if (it.atEnd()) {
            return false;
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().equals(oid)) {
            return false;
        }
        it.advance();
        while (!it.atEnd()) {
            MIBObject child = (MIBObject)((Pair)it.get()).second;
            if (!child.getOid().equals(oid)) {
                if (child.getOid().isChildOf(oid)) {
                    return true;
                }
                if (oid.isRootOf(child.getOid())) {
                    return true;
                }
                if (!oid.isRootOf(child.getOid())) {
                    return false;
                }
            }
            it.advance();
        }
        return false;
    }

    public MIBObject getParent(String objectName) {
        MIBObject o2 = (MIBObject)this.onames.get(objectName);
        if (o2 == null) {
            return null;
        }
        return this.getParent(o2);
    }

    public MIBObject getNextParent(ObjectID oid) {
        if (oid.size() <= 1 || this.oids.find(oid) == null) {
            return null;
        }
        MIBObject ro = null;
        ObjectID id = ObjectID.trim(oid);
        while (ro == null && id.size() >= 1) {
            ro = (MIBObject)this.oids.get(id);
            id = ObjectID.trim(id);
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public MIBObject getParent(MIBObject o2) {
        if (this.oids.find(o2.getOid()) == null || o2.getOid().size() == 0) {
            return null;
        }
        ObjectID id = ObjectID.trim(o2.getOid());
        MIBObject ro = null;
        while (ro == null && id.size() >= 1) {
            ro = (MIBObject)this.oids.get(id);
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public MIBObject getParentInSameModule(MIBObject o2) {
        if (this.oids.find(o2.getOid()) == null || o2.getOid().size() == 0) {
            return null;
        }
        ObjectID id = ObjectID.trim(o2.getOid());
        MIBObject ro = null;
        while (id.size() >= 1) {
            MIBObject[] pList;
            for (MIBObject mibObject : pList = this.getObjectsByOid(id)) {
                if (!mibObject.getModuleID().equals(o2.getModuleID())) continue;
                ro = mibObject;
                break;
            }
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public Pair getSplittedObjectID(ObjectID oid) throws ObjectIDFormatException {
        Pair pair = new Pair();
        OrderedMapIterator it = this.oids.lowerBound(oid);
        if (it.atEnd()) {
            return new Pair(oid, new ObjectID());
        }
        if (((Pair)it.get()).first.equals(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        it.retreat();
        if (it.atBegin() || it.get() == null) {
            return new Pair(oid, new ObjectID());
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().isRootOf(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        pair.first = parent.getOid();
        pair.second = oid.getSuffix(oid.size() - parent.getOid().size());
        return pair;
    }

    public ObjectID[] getIndexObjectIDs(ObjectID oid) {
        try {
            Pair p2 = this.getSplittedObjectID(oid);
            ObjectID entry = ObjectID.trim((ObjectID)p2.first);
            ObjectID index = (ObjectID)p2.second;
            MIBObjectType ot = (MIBObjectType)this.getObject(entry);
            if (ot == null || !ot.hasIndexPart()) {
                return null;
            }
            IndexStruct[] is = ot.getIndexPart().getIndexStruct(this);
            return this.getIndexObjectIDs(index, is);
        }
        catch (ObjectIDFormatException oife) {
            return null;
        }
    }

    public ObjectID[] getIndexObjectIDs(ObjectID index, IndexStruct[] is) {
        try {
            ObjectID[] r2 = new ObjectID[is.length];
            for (int i2 = 0; i2 < is.length; ++i2) {
                if (is[i2].impliedLength) {
                    r2[i2] = index;
                    break;
                }
                r2[i2] = !is[i2].impliedLength && is[i2].minLength != is[i2].maxLength ? index.getPrefix((int)index.getSubIDAsLong(0) + 1) : index.getPrefix(is[i2].maxLength);
                index = index.getSuffix(index.size() - r2[i2].size());
            }
            return r2;
        }
        catch (ObjectIDFormatException oife) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException ax) {
            return null;
        }
    }

    public MIBObject[] getObjectsByName(String name) {
        MIBObject[] objs = new MIBObject[this.onames.count(name)];
        if (objs.length == 0) {
            return objs;
        }
        OrderedMapIterator it = this.onames.lowerBound(name);
        for (int i2 = 0; !it.atEnd() && i2 < objs.length; ++i2) {
            objs[i2] = (MIBObject)((Pair)it.get()).second;
            it.advance();
        }
        return objs;
    }

    public MIBObject[] getObjectsByNamePrefix(String namePrefix, int maxCount) {
        MIBObject o2;
        ArrayList<MIBObject> objs = new ArrayList<MIBObject>();
        OrderedMapIterator it = this.onames.lowerBound(namePrefix);
        for (int i2 = 0; !it.atEnd() && (maxCount > 0 || i2 < maxCount) && (o2 = (MIBObject)((Pair)it.get()).second).getName().startsWith(namePrefix); ++i2) {
            objs.add(o2);
            it.advance();
        }
        return objs.toArray(new MIBObject[objs.size()]);
    }

    public MIBObject[] getObjectsByOid(ObjectID oid) {
        MIBObject[] objs = new MIBObject[this.oids.count(oid)];
        if (objs.length == 0) {
            return objs;
        }
        OrderedMapIterator it = this.oids.lowerBound(oid);
        for (int i2 = 0; !it.atEnd() && i2 < objs.length; ++i2) {
            objs[i2] = (MIBObject)((Pair)it.get()).second;
            it.advance();
        }
        return objs;
    }

    public synchronized void remove(MIBModule m2) {
        MIBObject o2;
        this.modules.remove(m2.getModuleName());
        this.moduleIDs.remove(m2.getModuleID());
        OrderedMapIterator it = this.oids.begin();
        while (!it.atEnd()) {
            o2 = (MIBObject)((Pair)it.get()).second;
            if (o2 != null && o2.getModuleID().equals(m2.getModuleID())) {
                this.oids.remove(it);
                it = this.oids.lowerBound(o2.getOid());
                continue;
            }
            it.advance();
        }
        it = this.onames.begin();
        while (!it.atEnd()) {
            o2 = (MIBObject)((Pair)it.get()).second;
            if (o2 != null && o2.getModuleID().equals(m2.getModuleID())) {
                this.onames.remove(it);
                it = this.onames.lowerBound(o2.getName());
                continue;
            }
            it.advance();
        }
    }

    public void removeObject(Object moduleID, MIBObject o2) {
        MIBObject obj;
        MIBModule m2;
        if (moduleID != null && (m2 = this.moduleIDs.get(moduleID)) != null) {
            m2.remove(o2);
        }
        if (o2.getOid().size() > 0) {
            OrderedMapIterator it = this.oids.lowerBound(o2.getOid());
            while (!it.atEnd() && (obj = (MIBObject)((Pair)it.get()).second).getOid().equals(o2.getOid())) {
                if (obj.getModuleID().equals(moduleID) && obj.getName().equals(o2.getName())) {
                    this.oids.remove(it);
                    break;
                }
                it.advance();
            }
        }
        OrderedMapIterator nit = this.onames.lowerBound(o2.getName());
        while (!nit.atEnd() && (obj = (MIBObject)((Pair)nit.get()).second).getName().equals(o2.getName())) {
            if (obj.getModuleID().equals(moduleID) && (o2.getOid() == null && obj.getOid() == null || o2.getOid() != null && o2.getOid().equals(obj.getOid()))) {
                this.onames.remove(nit);
                break;
            }
            nit.advance();
        }
        if (o2 instanceof MIBModule) {
            this.modules.remove(((MIBModule)o2).getModuleName());
            this.moduleIDs.remove(o2.getModuleID());
        }
    }

    public void removeObject(MIBObject o2) {
        if (o2.getModuleID() != null) {
            this.removeObject(o2.getModuleID(), o2);
        } else {
            this.oids.remove(o2.getOid());
            this.onames.remove(o2.getName());
        }
    }

    public synchronized boolean removeModule(String name) {
        MIBModule o2 = this.modules.get(name);
        if (o2 != null) {
            this.remove(o2);
            return true;
        }
        return false;
    }

    public MIBModule getModule(String moduleName) {
        return this.modules.get(moduleName);
    }

    public MIBModule getModule(Object id) {
        return this.moduleIDs.get(id);
    }

    public MIBObject getObject(String name) {
        String[] names = MIBRepository.splitObjectName(name);
        if (names[0] != null) {
            return this.getObject(names[0], names[1]);
        }
        return (MIBObject)this.onames.get(names[1]);
    }

    private static String[] splitObjectName(String name) {
        if (name != null && name.length() > 2 && Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            String moduleName = name.substring(0, name.indexOf(46));
            String objectName = name.substring(name.indexOf(46) + 1);
            return new String[]{moduleName, objectName};
        }
        return new String[]{null, name};
    }

    public MIBObject getObject(ObjectID oid) {
        return (MIBObject)this.oids.get(oid);
    }

    public Enumeration<String> modules() {
        return new EnumerationIterator(this.modules.values().iterator());
    }

    public Iterator<MIBModule> modulesIterator() {
        return this.modules.values().iterator();
    }

    public Enumeration<? extends MIBModule> getModulesSortedByName() {
        OrderedMap map = new OrderedMap(LexicographicPredicate.instance);
        Enumeration<String> e2 = this.modules();
        while (e2.hasMoreElements()) {
            MIBModule module = (MIBModule)((Object)e2.nextElement());
            map.put(module.getModuleName(), module);
        }
        return map.elements();
    }

    public Vector<String> getModuleNames() {
        Vector<String> v = new Vector<String>(this.modules.size() + 1);
        for (MIBModule m2 : this.modules.values()) {
            v.add(m2.getModuleName());
        }
        return v;
    }

    public Enumeration<? extends MIBObject> objects() {
        return this.oids.elements();
    }

    public Enumeration<? extends MIBObject> objectsByName() {
        return this.onames.elements();
    }

    public OrderedMapIterator find(ObjectID oid) {
        return this.oids.find(oid);
    }

    public OrderedMapIterator firstOID() {
        return this.oids.begin();
    }

    private void addToModule(MIBObject o2) throws ObjectIDFormatException {
        MIBObjectType ot;
        MIBModule m2 = this.moduleIDs.get(o2.getModuleID());
        if (m2 != null) {
            m2.add(o2);
        }
        if (o2 instanceof MIBObjectType && (ot = (MIBObjectType)o2).isTable()) {
            Object[] cols = ot.getTableEntries();
            Arrays.sort(cols);
            Vector<? extends MIBObject> children = this.getChildren(o2);
            for (MIBObject mIBObject : children) {
                MIBObjectType c2;
                if (!(mIBObject instanceof MIBObjectType)) continue;
                c2.setColumnarObject(Arrays.binarySearch(cols, (c2 = (MIBObjectType)mIBObject).getName()) >= 0);
            }
        }
    }

    public synchronized void structureChanged() {
        Enumeration e2 = this.oids.elements();
        while (e2.hasMoreElements()) {
            MIBObject o2 = (MIBObject)e2.nextElement();
            try {
                this.addToModule(o2);
            }
            catch (ObjectIDFormatException ofe) {
                System.out.println("Repository: could not add object " + o2.getName() + " because of invalid oid " + o2.getOid().toString() + ".");
            }
        }
        MIBObject dummy = new MIBObject();
        Enumeration e3 = this.onames.elements();
        while (e3.hasMoreElements()) {
            MIBObject o3 = (MIBObject)e3.nextElement();
            if (!(o3 instanceof MIBTextualConvention) && !o3.getClass().equals(dummy.getClass())) continue;
            try {
                this.addToModule(o3);
            }
            catch (ObjectIDFormatException ofe) {
                System.out.println("Repository: could not add object " + o3.getName() + " because of invalid oid " + o3.getOid().toString() + ".");
            }
        }
    }

    public String getPath(ObjectID oid, boolean withID) {
        StringBuffer oidbuf = new StringBuffer();
        StringBuffer namebuf = new StringBuffer();
        if (oid == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(oid.toString(), ".", false);
        int length = st.countTokens();
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 > 0) {
                oidbuf.append(".");
                namebuf.append(".");
            }
            String subid = st.nextToken();
            oidbuf.append(subid);
            String oidStr = oidbuf.toString();
            String name = this.getObjectName(new ObjectID(oidStr));
            if (name == null && "1".equals(oidStr)) {
                name = "iso";
            }
            if (name == null) {
                namebuf.append(subid);
                continue;
            }
            if (withID) {
                namebuf.append(name);
                namebuf.append('(');
                namebuf.append(subid);
                namebuf.append(')');
                continue;
            }
            namebuf.append(name);
        }
        return namebuf.toString();
    }

    public String getPath(ObjectID oid) {
        return this.getPath(oid, false);
    }

    public String getPathSuffix(ObjectID oid) {
        return this.getPathSuffix(oid, false);
    }

    public String getPathSuffix(ObjectID oid, boolean unique) {
        String m2;
        MIBObject[] objs;
        MIBObject o2;
        StringBuffer oidbuf = new StringBuffer();
        StringBuffer namebuf = new StringBuffer();
        if (oid == null) {
            return "";
        }
        ObjectID lastObjectID = null;
        StringTokenizer st = new StringTokenizer(oid.toString(), ".", false);
        int length = st.countTokens();
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 > 0) {
                oidbuf.append(".");
                namebuf.append(".");
            }
            String subid = st.nextToken();
            oidbuf.append(subid);
            ObjectID subOID = new ObjectID(oidbuf.toString());
            String name = this.getObjectName(subOID);
            if (name == null) {
                namebuf.append(subid);
                continue;
            }
            namebuf = new StringBuffer(name);
            lastObjectID = subOID;
        }
        if (unique && lastObjectID != null && (o2 = this.getObject(lastObjectID)) != null && (objs = this.getObjectsByName(o2.getName())) != null && objs.length > 1 && (m2 = this.getModuleName(o2.getModuleID())) != null) {
            namebuf = new StringBuffer(m2 + "." + namebuf.toString());
        }
        return namebuf.toString();
    }

    public static MIBRepository loadFromFile(File path) {
        MIBRepository rep = null;
        try {
            FileInputStream file = new FileInputStream(path);
            ObjectInputStream input = new ObjectInputStream(file);
            rep = new MIBRepository();
            int sz = input.readInt();
            for (int i2 = 0; i2 < sz; ++i2) {
                MIBObject obj = (MIBObject)input.readObject();
                if (obj instanceof MIBModule) {
                    ((MIBModule)obj).reinit();
                }
                rep.addObject(obj);
            }
            input.close();
            rep.structureChanged();
        }
        catch (FileNotFoundException ex) {
            System.out.println("MIB repository " + path + " not found.");
        }
        catch (StreamCorruptedException sce) {
            System.out.println("MIB repository " + path + " corrupted.");
        }
        catch (IOException ioe) {
            System.out.println("IO error while reading MIB repository " + path + ".");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Class not found (" + cnfe.getMessage() + ") while reading MIB repository " + path + ".");
        }
        return rep;
    }

    public static boolean saveToFile(MIBRepository rep, File path) {
        try {
            FileOutputStream file = new FileOutputStream(path);
            ObjectOutputStream output = new ObjectOutputStream(file);
            Vector<? extends MIBTextualConvention> v = rep.getTextualConventions();
            output.writeInt(rep.oids.size() + v.size());
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                output.writeObject(e2.nextElement());
            }
            e2 = rep.oids.elements();
            while (e2.hasMoreElements()) {
                output.writeObject(e2.nextElement());
            }
            output.flush();
            output.close();
        }
        catch (Exception e3) {
            System.out.println(e3.getMessage());
            return false;
        }
        return true;
    }

    public Vector<? extends MIBTextualConvention> getTextualConventions() {
        return this.getNonOidObjects(true);
    }

    public Vector<? extends MIBObject> getNonOidObjects(boolean textualConventionsOnly) {
        Vector<MIBObject> v = new Vector<MIBObject>(this.onames.size() / 50, 50);
        Enumeration e2 = this.onames.elements();
        while (e2.hasMoreElements()) {
            MIBObject o2 = (MIBObject)e2.nextElement();
            if ((textualConventionsOnly || o2.getOid().size() != 0) && !(o2 instanceof MIBTextualConvention)) continue;
            v.add(o2);
        }
        return v;
    }

    public MIBSyntax resolveTC(String name) {
        MIBObject o2;
        MIBSyntax syn = null;
        while ((o2 = (MIBObject)this.onames.get(name)) != null) {
            if (o2 instanceof MIBTextualConvention) {
                MIBTextualConvention tc = (MIBTextualConvention)o2;
                if (tc.getSyntax().getType() == 3) {
                    syn = tc.getSyntax();
                    name = tc.getSyntax().getSyntax();
                    continue;
                }
                return tc.getSyntax();
            }
            return syn;
        }
        return syn;
    }

    public ObjectID resolveOID(ObjectID oid) {
        String name = oid.getFirstUnresolvedSubId();
        if (name == null) {
            return oid;
        }
        ObjectID id = this.getObjectID(name);
        if (id != null) {
            int start = oid.toString().indexOf(name) + name.length();
            String r2 = id.toString();
            if (start >= 0 && start < oid.toString().length()) {
                r2 = r2 + oid.toString().substring(start);
            }
            return new ObjectID(r2);
        }
        return null;
    }

    public MIBSyntax getBaseSyntax(MIBSyntax syntax) {
        MIBSyntax s = syntax;
        if (s.getType() == 3) {
            try {
                MIBTextualConvention tc = (MIBTextualConvention)this.getObject(s.getSyntax());
                if (tc != null) {
                    s = tc.getSyntax();
                }
            }
            catch (ClassCastException cce) {
                return s;
            }
        }
        return s;
    }

    private MIBObject getBestObject(String syntax) {
        Range r2 = this.onames.equalRange(syntax);
        if (r2 == null || r2.begin.atEnd()) {
            return null;
        }
        MIBObject best = null;
        MIBObject second = null;
        while (r2.begin.hasMoreElements()) {
            if (((Pair)r2.begin.get()).first.equals(syntax)) {
                MIBObject o2 = (MIBObject)((Pair)r2.begin.get()).second;
                MIBModule m2 = this.getModule(o2.getModuleID());
                if (m2 != null && m2.getSMIVersion() > 1) {
                    best = o2;
                    break;
                }
                second = o2;
            }
            r2.begin.advance();
        }
        return best != null ? best : second;
    }

    public MIBTextualConvention getEffectiveSyntax(MIBSyntax syntax) {
        return this.getEffectiveSyntax((ISyntax)syntax);
    }

    public MIBTextualConvention getEffectiveSyntax(ISyntax syntax) {
        MIBObject o2;
        MIBSyntax effectiveSyntax = new MIBSyntax();
        ISyntax syn = syntax;
        MIBTextualConvention eTC = new MIBTextualConvention();
        if (syntax.hasEnums()) {
            effectiveSyntax.setEnums((MIBEnum[])syn.getEnums());
        }
        if (syntax.hasRanges()) {
            effectiveSyntax.setRanges((MIBRange[])syn.getRanges());
        }
        eTC.setSyntax(effectiveSyntax);
        while ((o2 = this.getBestObject(syn.getSyntax())) != null) {
            if (o2 instanceof MIBTextualConvention) {
                Enumeration<Serializable> en;
                MIBTextualConvention tc = (MIBTextualConvention)o2;
                if (eTC.getName() == null) {
                    eTC.setName(tc.getName());
                }
                if (tc.hasDisplayHint()) {
                    eTC.setDisplayHint(tc.getDisplayHint());
                }
                if (tc.getSyntax().hasEnums()) {
                    en = tc.getSyntax().getEnumsVector().elements();
                    while (en.hasMoreElements()) {
                        MIBEnum e2 = en.nextElement();
                        if (!effectiveSyntax.hasEnums()) {
                            effectiveSyntax.addEnum(new MIBEnum(e2));
                            continue;
                        }
                        effectiveSyntax.getEnumsVector().removeElement(e2);
                        effectiveSyntax.addEnum(new MIBEnum(e2));
                    }
                } else if (tc.getSyntax().hasRanges()) {
                    en = tc.getSyntax().getRangesVector().elements();
                    while (en.hasMoreElements()) {
                        MIBRange r2 = (MIBRange)en.nextElement();
                        if (effectiveSyntax.containsRange(r2) || !effectiveSyntax.isRestrictiveRange(r2)) continue;
                        effectiveSyntax.addRange(r2);
                    }
                }
                if (tc.getSyntax().getType() == 3) {
                    syn = tc.getSyntax();
                    continue;
                }
                effectiveSyntax.setSyntax(tc.getSyntax().getSyntax());
                effectiveSyntax.setType(tc.getSyntax().getType());
                return eTC;
            }
            return eTC;
        }
        effectiveSyntax.setSyntax(syn.getSyntax());
        effectiveSyntax.setType(syn.getType());
        return eTC;
    }

    public boolean isReferencedBy(String objectName, MIBModule module, MIBComplianceModule complianceModule) {
        MIBGroup group;
        IObject o2;
        String[] names = MIBRepository.splitObjectName(objectName);
        String moduleName = names[0];
        String oname = names[1];
        if (moduleName != null && (module.getModuleName() != null ? !moduleName.equals(module.getModuleName()) : !moduleName.equals(module.getModuleName()))) {
            return false;
        }
        MIBModule m2 = module;
        if (complianceModule.hasMandatory()) {
            for (String groupName : complianceModule.getMandatoryVector()) {
                o2 = m2.getObject(groupName);
                if (!(o2 instanceof MIBGroup) || !(group = (MIBGroup)o2).contains(oname)) continue;
                return true;
            }
        }
        if (complianceModule.hasVariations()) {
            for (MIBVariation v : complianceModule.getVariationsVector()) {
                if (!(v instanceof MIBCondGroup) || !((o2 = m2.getObject(v.getVariation())) instanceof MIBGroup) || !(group = (MIBGroup)o2).contains(oname)) continue;
                return true;
            }
        }
        return false;
    }

    public String printModule(String moduleName) {
        MIBModule m2 = this.getModule(moduleName);
        if (m2 == null) {
            return "";
        }
        return m2.toSMI(1, this, MIBObject.getLineSeparator());
    }

    public static Vector buildVector(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(objects.length > 0 ? objects.length : 1);
        for (int i2 = 0; i2 < objects.length; ++i2) {
            v.add(objects[i2]);
        }
        return v;
    }

    public static String buildStringEnumeration(Enumeration en, String prefix) {
        StringBuffer buf = new StringBuffer();
        while (en.hasMoreElements()) {
            buf.append(prefix + en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            buf.append(",\n");
        }
        return buf.toString();
    }

    public static String buildStringEnumeration(Iterator it, String prefix) {
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            buf.append(prefix + it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(",\n");
        }
        return buf.toString();
    }

    public static String buildStringEnumeration(Enumeration en) {
        StringBuffer buf = new StringBuffer();
        while (en.hasMoreElements()) {
            buf.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void renameModule(MIBModule oldModule, String newModuleName) {
        this.modules.remove(oldModule.getModuleName());
        oldModule.setModuleName(newModuleName);
        this.modules.put(newModuleName, oldModule);
    }

    public void renameObject(MIBObject oldObject, ObjectID newObjectID, String newObjectName) {
        if (!oldObject.getName().equals(newObjectName)) {
            if (oldObject.getModuleID() != null) {
                MIBModule m2 = this.moduleIDs.get(oldObject.getModuleID());
                if (m2 != null) {
                    m2.remove(oldObject);
                    if (!oldObject.getName().equals(newObjectName)) {
                        m2.changeObjectReferences(oldObject.getName(), newObjectName);
                    }
                }
                OrderedMapIterator it = this.onames.begin();
                while (it.hasMoreElements()) {
                    MIBObject o2 = (MIBObject)((Pair)it.get()).second;
                    if (o2.equals(oldObject)) {
                        this.onames.remove(it);
                        break;
                    }
                    it.advance();
                }
            }
            oldObject.setName(newObjectName);
            this.onames.add(newObjectName, oldObject);
        }
        if (!oldObject.getOid().equals(newObjectID)) {
            OrderedMapIterator it = this.oids.begin();
            while (it.hasMoreElements()) {
                MIBObject o3 = (MIBObject)((Pair)it.get()).second;
                if (o3 == oldObject) {
                    this.oids.remove(it);
                    break;
                }
                it.advance();
            }
            oldObject.setOid(newObjectID);
            this.oids.add(newObjectID, oldObject);
        }
    }

    public Vector<MIBObjectType> getColumnarObjectsOfTable(MIBModule m2, MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        Object o2;
        if (ot == null || !ot.isTable()) {
            return null;
        }
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        if (m2 == null) {
            return null;
        }
        if (includeIndex) {
            MIBObjectType iot = ot;
            if (ot.getIndexPart().isAugment()) {
                int i2;
                o2 = this.getObjectsByName(ot.getIndexPart().getIndexPart()[0]);
                Object found = null;
                for (i2 = 0; i2 < ((MIBObject[])o2).length; ++i2) {
                    if (!((MIBObject)o2[i2]).getModuleID().equals(ot.getModuleID())) continue;
                    found = o2[i2];
                    break;
                }
                if (found == null) {
                    for (i2 = 0; i2 < ((Object)o2).length; ++i2) {
                        String mi = this.getModuleName(((MIBObject)o2[i2]).getModuleID());
                        if (mi == null || !m2.imports(((MIBObject)o2[i2]).getName(), mi)) continue;
                        found = o2[i2];
                        break;
                    }
                } else if (((Object)o2).length == 1) {
                    found = o2[0];
                }
                iot = (MIBObjectType)found;
            }
            if (iot != null && iot.hasIndexPart()) {
                Enumeration en = iot.getIndexPart().getIndexPartVector().elements();
                while (en.hasMoreElements()) {
                    MIBObject[] o3 = this.getObjectsByName((String)en.nextElement());
                    MIBObject found = null;
                    if (o3.length > 1) {
                        int i3;
                        for (i3 = 0; i3 < o3.length; ++i3) {
                            if (!o3[i3].getModuleID().equals(ot.getModuleID()) || !(o3[i3] instanceof MIBObjectType)) continue;
                            found = o3[i3];
                            break;
                        }
                        if (found == null) {
                            for (i3 = 0; i3 < o3.length; ++i3) {
                                MIBModule mi = this.getModule(o3[i3].getModuleID());
                                if (mi == null || !m2.imports(o3[i3].getName(), mi.getModuleName()) || !(o3[i3] instanceof MIBObjectType)) continue;
                                found = o3[i3];
                                break;
                            }
                        }
                    } else if (o3.length == 1) {
                        found = o3[0];
                    }
                    if (found == null) continue;
                    v.add((MIBObjectType)found);
                }
            } else {
                return null;
            }
        }
        if (includeColumns) {
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                o2 = (MIBObjectType)this.getObject(m2.getModuleName(), (String)en.nextElement());
                if (o2 == null || SMI.accessType(((MIBObjectType)o2).getAccess()) == 0) continue;
                v.add((MIBObjectType)o2);
            }
        }
        return v;
    }

    public Vector<? extends MIBObjectType> getColumnarObjectsOfTable(MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        MIBModule m2 = this.getModule(ot.getModuleID());
        return this.getColumnarObjectsOfTable(m2, ot, includeIndex, includeColumns);
    }

    public List<? extends MIBNotifyType> getNotificatioObjects(INotificationType nt) {
        MIBModule m2 = this.getModule(nt.getModuleID());
        return this.getNotificatioObjects(m2, nt);
    }

    public List<? extends MIBNotifyType> getNotificatioObjects(MIBModule module, INotificationType nt) {
        ArrayList<MIBObject> result = new ArrayList<MIBObject>();
        if (nt.getVariablesVector() == null) {
            return result;
        }
        Iterator it = nt.getVariablesVector().iterator();
        while (it.hasNext()) {
            MIBObject[] o2 = this.getObjectsByName((String)it.next());
            MIBObject found = null;
            if (o2.length > 1) {
                int i2;
                for (i2 = 0; i2 < o2.length; ++i2) {
                    if (!o2[i2].getModuleID().equals(nt.getModuleID())) continue;
                    found = o2[i2];
                    break;
                }
                if (found == null) {
                    for (i2 = 0; i2 < o2.length; ++i2) {
                        MIBModule mi = this.getModule(o2[i2].getModuleID());
                        if (mi == null || !module.imports(o2[i2].getName(), mi.getModuleName())) continue;
                        found = o2[i2];
                        break;
                    }
                }
            } else if (o2.length == 1) {
                found = o2[0];
            }
            if (found != null) {
                result.add(found);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public Vector<? extends MIBObjectType> getAugmentingTables(MIBObjectType table) {
        MIBModule module = this.getModule(table.getModuleID());
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> en = this.objects();
        while (en.hasMoreElements()) {
            MIBObjectType ot;
            MIBObject o2 = en.nextElement();
            if (!(o2 instanceof MIBObjectType) || !(ot = (MIBObjectType)o2).isTable() || !ot.hasIndexPart() || !ot.getIndexPart().isAugment() || !ot.getIndexPart().getIndexPart()[0].equals(table.getName())) continue;
            MIBModule m2 = this.getModule(ot.getModuleID());
            if (module != null && m2 != null) {
                if (!m2.getModuleID().equals(module.getModuleID()) && !m2.imports(table.getName(), module.getModuleName())) continue;
                v.addElement(ot);
                continue;
            }
            v.addElement(ot);
        }
        return v;
    }

    public boolean isExpandingIndex(MIBIndexPart parent, MIBIndexPart expansion) {
        if (parent == null || expansion == null) {
            return false;
        }
        Vector parentIndex = parent.getIndexPartVector();
        Vector expansionIndex = expansion.getIndexPartVector();
        if (expansionIndex.size() < parentIndex.size()) {
            return false;
        }
        for (int i2 = 0; i2 < parentIndex.size(); ++i2) {
            if (parentIndex.elementAt(i2).equals(expansionIndex.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Vector<? extends MIBObjectType> getParentTables(MIBObjectType table) {
        MIBModule module = this.getModule(table.getModuleID());
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o2 = en.nextElement();
            if (!(o2 instanceof MIBObjectType)) continue;
            MIBObjectType ot = (MIBObjectType)o2;
            if (ot.isTable() && ot.hasIndexPart() && ot.getIndexPart().isAugment() && ot.getIndexPart().getIndexPart()[0].equals(table.getName())) {
                MIBModule m2 = this.getModule(ot.getModuleID());
                if (module != null && m2 != null) {
                    if (!m2.getModuleID().equals(module.getModuleID()) && !m2.imports(table.getName(), module.getModuleName())) continue;
                    v.addElement(ot);
                    continue;
                }
                v.addElement(ot);
                continue;
            }
            if (!ot.isTable() || !ot.hasIndexPart() || ot.getName().equals(table.getName()) || !this.isExpandingIndex(ot.getIndexPart(), table.getIndexPart())) continue;
            v.addElement(ot);
        }
        return v;
    }

    public MIBObjectType getObjectType(ObjectID instanceID) {
        try {
            Pair p2 = this.getSplittedObjectID(instanceID);
            if (p2 == null) {
                return null;
            }
            ObjectID oid = (ObjectID)p2.first;
            MIBObject o2 = this.getObject(oid);
            if (o2 instanceof MIBObjectType) {
                return (MIBObjectType)o2;
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return null;
    }

    public MIBObjectType getTableEntry(MIBObject o2) {
        if (o2 instanceof MIBObjectType) {
            MIBObjectType ot = (MIBObjectType)o2;
            if (ot.isTable()) {
                return ot;
            }
            Vector<? extends MIBObject> v = this.getChildren(ot);
            if (v.size() == 0) {
                return null;
            }
            MIBObject entry = v.firstElement();
            if (entry instanceof MIBObjectType && ((MIBObjectType)entry).isTable()) {
                return (MIBObjectType)entry;
            }
        }
        return null;
    }

    public MIBObject getNextObject(ObjectID oid) {
        OrderedMapIterator it = this.oids.lowerBound(oid);
        while (!it.atEnd()) {
            MIBObject obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid)) {
                return obj;
            }
            it.advance();
        }
        return null;
    }

    public MIBObject getPrevObject(ObjectID oid) {
        MIBObject obj;
        OrderedMapIterator it = this.oids.upperBound(oid);
        while (!(it.atBegin() || it.get() != null && (obj = (MIBObject)((Pair)it.get()).second).getOid().equals(oid))) {
            it.retreat();
        }
        while (!it.atEnd() && !it.atBegin()) {
            obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid)) {
                return obj;
            }
            it.retreat();
        }
        return null;
    }

    public MIBObject getNextSibblingObject(ObjectID oid) {
        OrderedMapIterator it = this.oids.lowerBound(oid);
        while (!it.atEnd()) {
            MIBObject obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid) && obj.getOid().isPeerOf(oid)) {
                return obj;
            }
            it.advance();
        }
        return null;
    }

    public MIBObject getPrevSibblingObject(ObjectID oid) {
        MIBObject obj;
        OrderedMapIterator it = this.oids.upperBound(oid);
        if (!it.atBegin() && it.atEnd()) {
            it.retreat();
        }
        while (!it.atBegin() && !(obj = (MIBObject)((Pair)it.get()).second).getOid().equals(oid)) {
            it.retreat();
        }
        while (!it.atBegin()) {
            obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid) && obj.getOid().isPeerOf(oid)) {
                return obj;
            }
            it.retreat();
        }
        return null;
    }

    private static Map inverse(Map h2) {
        HashMap inverse = new HashMap(h2.size());
        for (Object key : h2.keySet()) {
            inverse.put(h2.get(key), key);
        }
        return inverse;
    }

    public Map<Integer, String> getImportedModuleIDs() {
        return this.importedModuleIDs;
    }

    public Map<String, Integer> addImportedModuleIDsInverse(Map<Integer, String> moduleIDs) {
        Map h2 = MIBRepository.inverse(moduleIDs);
        this.addImportedModuleIDs(h2);
        return h2;
    }

    public void removeImportedModuleID(Object moduleID) {
        this.importedModuleIDs.remove(moduleID);
    }

    public void addImportedModuleIDs(Map<Integer, String> moduleIDs) {
        this.importedModuleIDs.putAll(moduleIDs);
    }

    public String getModuleName(Object moduleID) {
        MIBModule o2 = this.moduleIDs.get(moduleID);
        if (o2 != null) {
            return o2.getModuleName();
        }
        return this.importedModuleIDs.get(moduleID);
    }

    public void freeUserObjects() {
        Enumeration<? extends MIBObject> it = this.objectsByName();
        while (it.hasMoreElements()) {
            MIBObject o2 = it.nextElement();
            o2.freeUserObjects();
        }
    }
}

