/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMIRequirementsSpec;
import com.agentpp.smi.ext.SMIVariation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBComplianceModule
implements Serializable,
SMIRequirementsSpec {
    public static final long serialVersionUID = 1000L;
    protected String moduleName = null;
    protected Vector mandatory = null;
    protected Vector variations = new Vector();
    protected transient Object userObject = null;

    public MIBComplianceModule() {
    }

    public MIBComplianceModule(String moduleName) {
        this.moduleName = moduleName;
    }

    public MIBComplianceModule(MIBComplianceModule other) {
        Enumeration en;
        if (other.moduleName != null) {
            this.moduleName = new String(other.moduleName);
        }
        if (other.hasMandatory()) {
            this.mandatory = new Vector();
            en = other.mandatory.elements();
            while (en.hasMoreElements()) {
                this.mandatory.addElement(new String(en.nextElement().toString()));
            }
        }
        if (other.hasVariations()) {
            en = other.variations.elements();
            while (en.hasMoreElements()) {
                Object o2 = en.nextElement();
                if (o2 instanceof MIBCondGroup) {
                    this.variations.addElement(new MIBCondGroup((MIBCondGroup)o2));
                }
                if (!(o2 instanceof MIBException)) continue;
                this.variations.addElement(new MIBException((MIBException)o2));
            }
        }
    }

    public boolean hasMandatory() {
        return this.mandatory != null && this.mandatory.size() > 0;
    }

    public Vector getMandatoryVector() {
        return this.mandatory;
    }

    public String[] getMandatory() {
        Object[] s = new String[this.mandatory.size()];
        this.mandatory.copyInto(s);
        return s;
    }

    public final void setMandatory(String[] mandatory) {
        this.mandatory = new Vector<String>(Arrays.asList(mandatory));
    }

    public final void setMandatory(Vector newMandatory) {
        this.mandatory = newMandatory;
    }

    public boolean hasVariations() {
        return this.variations != null && this.variations.size() > 0;
    }

    public final void setVariations(SMIVariation[] variations) {
        this.variations = new Vector<SMIVariation>(Arrays.asList(variations));
    }

    public final void setVariations(Vector newVariations) {
        this.variations = newVariations;
    }

    public final Vector getVariationsVector() {
        return this.variations;
    }

    public final IVariation[] getVariations() {
        Object[] v = new MIBVariation[this.variations.size()];
        this.variations.copyInto(v);
        return v;
    }

    public final boolean hasModuleName() {
        return this.moduleName != null && this.moduleName.length() > 0;
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(String name) {
        this.moduleName = name;
    }

    public String toSMI(int mode, MIBRepository rep, MIBComplianceModule c2, String lineSeparator) {
        String cs;
        StringBuffer buf = new StringBuffer(lineSeparator + "\t");
        MIBObject.addKeyWord(mode, buf, "MODULE ");
        if (this.hasModuleName()) {
            cs = null;
            if (c2 != null) {
                cs = c2.hasModuleName() ? c2.moduleName : "";
            }
            MIBObject.addString(mode, buf, this.moduleName, cs);
        }
        buf.append(lineSeparator);
        if (this.hasMandatory()) {
            buf.append('\t');
            MIBObject.addKeyWord(mode, buf, "MANDATORY-GROUPS");
            buf.append(" {");
            buf.append(lineSeparator);
            cs = null;
            if (c2 != null) {
                cs = c2.hasMandatory() ? MIBObject.formatObjectRefs(mode, "\t\t\t", c2.mandatory.iterator(), lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t\t", this.mandatory.iterator(), lineSeparator), cs);
            buf.append(" }");
            buf.append(lineSeparator);
        }
        if (this.variations.size() > 0) {
            Enumeration cen = null;
            if (c2 != null) {
                cen = c2.variations != null && c2.variations.size() > 0 ? c2.variations.elements() : new Vector().elements();
            }
            Enumeration en = this.variations.elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                MIBVariation cv = null;
                if (cen != null) {
                    cv = cen.hasMoreElements() ? (MIBVariation)cen.nextElement() : new MIBVariation();
                }
                buf.append(v.toSMI(mode, rep, cv, lineSeparator));
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.moduleName;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBComplianceModule) {
            MIBComplianceModule other = (MIBComplianceModule)o2;
            return MIBObject.saveCompare(this.mandatory, other.mandatory) && MIBObject.saveCompare(this.moduleName, other.moduleName) && MIBObject.saveCompare(this.variations, other.variations);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasVariations()) {
            for (MIBVariation v : this.variations) {
                v.freeUserObjects();
            }
        }
    }
}

