/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.io.ByteFilterInputStream;
import com.agentpp.common.xml.XMLUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.traps.TrapReceiverDialog;
import com.agentpp.explorer.traps.TrapTabbedPanel_openTrapHistory_actionAdapter;
import com.agentpp.explorer.traps.TrapTabbedPanel_saveAsTrapHistory_actionAdapter;
import com.agentpp.mib.ObjectID;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractElement;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.VariableBinding;
import org.w3c.dom.NodeList;

public class TrapTabbedPanel
extends JPanel {
    private SimpleDateFormat _$29662 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    JButton openTrapHistory = new JButton();
    JButton saveAsTrapHistory = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    TrapReceiverDialog trapPanel;
    UserConfigFile config;

    public TrapTabbedPanel() {
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TrapTabbedPanel(UserConfigFile userConfigFile) {
        this();
        this.config = userConfigFile;
    }

    private void _$5265() throws Exception {
        this.setLayout(this.borderLayout1);
        this.openTrapHistory.setToolTipText("Open Trap History File");
        this.openTrapHistory.setHorizontalAlignment(2);
        this.openTrapHistory.setText("Open...");
        this.openTrapHistory.setIcon(MIBExplorerFrame.imageOpen16);
        this.openTrapHistory.addActionListener(new TrapTabbedPanel_openTrapHistory_actionAdapter(this));
        this.saveAsTrapHistory.setToolTipText("Save Trap History as File");
        this.saveAsTrapHistory.setHorizontalAlignment(2);
        this.saveAsTrapHistory.setText("Save As...");
        this.saveAsTrapHistory.setIcon(MIBExplorerFrame.imageSaveAs16);
        this.saveAsTrapHistory.addActionListener(new TrapTabbedPanel_saveAsTrapHistory_actionAdapter(this));
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.add((Component)this.jPanelButtons, "West");
        this.jPanelButtons.add(this.openTrapHistory);
        this.jPanelButtons.add(this.saveAsTrapHistory);
    }

    public void saveAsTrapHistory_actionPerformed(ActionEvent actionEvent) {
        this.saveTrapHistory(true);
    }

    public void openTrapHistory_actionPerformed(ActionEvent actionEvent) {
        this.loadTrapHistory();
    }

    public void setTrapPanel(TrapReceiverDialog trapReceiverDialog) {
        this.trapPanel = trapReceiverDialog;
        this.add((Component)trapReceiverDialog, "Center");
    }

    public void saveTrapHistory(File file) throws IOException {
        JCEditableVectorDataSource jCEditableVectorDataSource = this.trapPanel.getModel();
        jCEditableVectorDataSource.removeTableDataListener(this.trapPanel.getTableDataView());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        jCEditableVectorDataSource.addTableDataListener(this.trapPanel.getTableDataView());
        objectOutputStream.writeObject(jCEditableVectorDataSource);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public void saveTrapHistoryXML(File file) throws IOException {
        Object object;
        JCEditableVectorDataSource jCEditableVectorDataSource = this.trapPanel.getModel();
        DOMDocument dOMDocument = new DOMDocument();
        DOMElement dOMElement = new DOMElement("TrapHistory");
        DOMAttribute dOMAttribute = new DOMAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
        dOMElement.add(dOMAttribute);
        DOMAttribute dOMAttribute2 = new DOMAttribute(new QName("xsi:noNamespaceSchemaLocation"), "MIBExplorerCaptureFile.xsd");
        dOMElement.add(dOMAttribute2);
        dOMDocument.setRootElement(dOMElement);
        for (int i2 = 1; i2 < jCEditableVectorDataSource.getNumRows(); ++i2) {
            object = new DOMElement("Notification");
            ((AbstractElement)object).addAttribute("time", this._$29662.format((Date)jCEditableVectorDataSource.getTableRowLabel(i2)));
            ((AbstractElement)object).addAttribute("acknowledged", jCEditableVectorDataSource.getTableDataItem(i2, 0).toString());
            ((AbstractElement)object).addAttribute("source", (String)jCEditableVectorDataSource.getTableDataItem(i2, 2));
            ((AbstractElement)object).addAttribute("destination", (String)jCEditableVectorDataSource.getTableDataItem(i2, 3));
            ((AbstractElement)object).addAttribute("notificationID", jCEditableVectorDataSource.getTableDataItem(i2, 1).toString());
            ((AbstractElement)object).addAttribute("timestamp", "" + ((TimeTicks)jCEditableVectorDataSource.getTableDataItem(i2, 4)).getValue());
            ((AbstractElement)object).addAttribute("securityName", ((OctetString)jCEditableVectorDataSource.getTableDataItem(i2, 5)).toString(16));
            ((AbstractElement)object).addAttribute("securityNameEnc", "hex");
            ((AbstractElement)object).addAttribute("version", (String)jCEditableVectorDataSource.getTableDataItem(i2, 6));
            ((AbstractElement)object).addAttribute("contextName", ((OctetString)jCEditableVectorDataSource.getTableDataItem(i2, 7)).toString(16));
            ((AbstractElement)object).addAttribute("contextEngineID", ((OctetString)jCEditableVectorDataSource.getTableDataItem(i2, 7)).toString(16));
            Vector vector = (Vector)jCEditableVectorDataSource.getTableDataItem(i2, 9);
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                VariableBinding variableBinding = (VariableBinding)vector.get(i3);
                DOMElement dOMElement2 = new DOMElement("VariableBinding");
                dOMElement2.addAttribute("oid", variableBinding.getOid().toString());
                String string = AbstractVariable.getSyntaxString(variableBinding.getSyntax());
                DOMElement dOMElement3 = new DOMElement(string);
                switch (variableBinding.getSyntax()) {
                    case 2: 
                    case 6: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 70: {
                        if (variableBinding.getSyntax() == 6) {
                            dOMElement3 = new DOMElement("ObjectIdentifier");
                        }
                        dOMElement3.setText(((Object)variableBinding.getVariable()).toString());
                        break;
                    }
                    case 4: 
                    case 68: {
                        if (variableBinding.getSyntax() == 4) {
                            dOMElement3 = new DOMElement("OctetString");
                        }
                        dOMElement3.setText(((OctetString)variableBinding.getVariable()).toString(16));
                        break;
                    }
                    case 67: {
                        dOMElement3.setText("" + ((TimeTicks)variableBinding.getVariable()).getValue());
                    }
                }
                dOMElement2.addAttribute("syntax", "" + variableBinding.getSyntax());
                dOMElement2.add(dOMElement3);
                ((AbstractElement)object).add(dOMElement2);
            }
            dOMElement.add((Element)object);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object = new XMLWriter(fileOutputStream, new OutputFormat(" ", true));
        ((XMLWriter)object).write(dOMDocument);
        ((XMLWriter)object).flush();
        fileOutputStream.close();
    }

    public void loadTrapHistory(File file) throws Exception {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)objectInputStream.readObject();
            this.trapPanel.setModel(jCEditableVectorDataSource);
            objectInputStream.close();
        }
        catch (InvalidClassException invalidClassException) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteFilterInputStream byteFilterInputStream = new ByteFilterInputStream(fileInputStream, ByteFilterInputStream.serialVersionUIDPatternLiveTable5, ByteFilterInputStream.serialVersionUIDPatternLiveTable62);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteFilterInputStream);
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)objectInputStream.readObject();
            this.trapPanel.setModel(jCEditableVectorDataSource);
            objectInputStream.close();
        }
    }

    public void loadTrapHistoryXML(File file) throws Exception {
        DOMDocument dOMDocument = XMLUtils.readDOMDocument(new FileInputStream(file), DOMDocumentFactory.getInstance());
        JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource();
        jCEditableVectorDataSource.setNumColumns(10);
        jCEditableVectorDataSource.setNumRows(1);
        NodeList nodeList = dOMDocument.getElementsByTagName("Notification");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            DOMElement dOMElement = (DOMElement)nodeList.item(i2);
            Date date = this._$29662.parse(dOMElement.attributeValue("time"));
            Vector<Object> vector = new Vector<Object>(jCEditableVectorDataSource.getNumColumns());
            vector.add(Boolean.valueOf(dOMElement.attributeValue("acknowledged")));
            vector.add(new ObjectID(dOMElement.attributeValue("notificationID")));
            vector.add(dOMElement.attributeValue("source"));
            vector.add(dOMElement.attributeValue("destination"));
            vector.add(new TimeTicks(Long.parseLong(dOMElement.attributeValue("timestamp"))));
            String string = dOMElement.attributeValue("securityNameEnc");
            if (string != null && string.equals("hex")) {
                vector.add(OctetString.fromString(dOMElement.attributeValue("securityName"), 16));
            } else {
                vector.add(new OctetString(dOMElement.attributeValue("securityName")));
            }
            vector.add(dOMElement.attributeValue("version"));
            vector.add(OctetString.fromString(dOMElement.attributeValue("contextName"), 16));
            vector.add(OctetString.fromString(dOMElement.attributeValue("contextEngineID"), 16));
            NodeList nodeList2 = dOMElement.getElementsByTagName("VariableBinding");
            Vector<VariableBinding> vector2 = new Vector<VariableBinding>(nodeList2.getLength() + 1);
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                DOMElement dOMElement2 = (DOMElement)nodeList2.item(i3);
                VariableBinding variableBinding = new VariableBinding(new OID(dOMElement2.attributeValue("oid")));
                DOMElement dOMElement3 = (DOMElement)dOMElement2.elements().get(0);
                String string2 = dOMElement3.getName();
                if ("OctetString".equals(string2)) {
                    string2 = AbstractVariable.getSyntaxString(4);
                } else if ("ObjectIdentifier".equals(string2)) {
                    string2 = AbstractVariable.getSyntaxString(6);
                }
                int n2 = AbstractVariable.getSyntaxFromString(string2);
                variableBinding.setVariable(AbstractVariable.createFromSyntax(n2));
                switch (n2) {
                    case 6: {
                        variableBinding.setVariable(new OID(dOMElement3.getText()));
                        break;
                    }
                    case 64: {
                        variableBinding.setVariable(new IpAddress(dOMElement3.getText()));
                        break;
                    }
                    case 2: {
                        ((Integer32)variableBinding.getVariable()).setValue(Integer.parseInt(dOMElement3.getText()));
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 67: {
                        ((UnsignedInteger32)variableBinding.getVariable()).setValue(Long.parseLong(dOMElement3.getText()));
                        break;
                    }
                    case 70: {
                        ((Counter64)variableBinding.getVariable()).setValue(Long.parseLong(dOMElement3.getText()));
                        break;
                    }
                    case 4: 
                    case 68: {
                        ((OctetString)variableBinding.getVariable()).setValue(OctetString.fromString(dOMElement3.getText(), 16).getValue());
                    }
                }
                vector2.add(variableBinding);
            }
            vector.add(vector2);
            jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, date, vector);
        }
        this.trapPanel.setModel(jCEditableVectorDataSource);
    }

    public boolean loadTrapHistory() {
        File file = new File(this.config.get("mibexplorer.NotificationHistoryPath", ""));
        try {
            JFileChooser jFileChooser = new JFileChooser();
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            exampleFileFilter.addExtension("xml");
            exampleFileFilter.setDescription("MIB Explorer Trap History Files");
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setSelectedFile(new File(this.config.get("mibexplorer.NotificationHistoryPath", "")));
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showOpenDialog(this) == 0) {
                file = new File(jFileChooser.getSelectedFile().getPath());
                if (!file.getName().toUpperCase().endsWith(".XML")) {
                    file = new File(file.getParentFile(), file.getName() + ".xml");
                }
                this.loadTrapHistoryXML(file);
                JOptionPane.showMessageDialog(this, "Loaded trap history from " + file.getPath(), "Trap History Loaded", 1);
                this.config.put("mibexplorer.NotificationHistoryPath", file.getPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error while loading trap history: " + exception.getMessage(), "IO Error", 0);
            return false;
        }
        return true;
    }

    public boolean saveTrapHistory(boolean bl) {
        File file = new File(this.config.get("mibexplorer.NotificationHistoryPath", ""));
        try {
            if (bl) {
                JFileChooser jFileChooser = new JFileChooser();
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
                exampleFileFilter.addExtension("xml");
                exampleFileFilter.setDescription("MIB Explorer Trap History Files");
                jFileChooser.setFileFilter(exampleFileFilter);
                jFileChooser.setSelectedFile(new File(this.config.get("mibexplorer.NotificationHistoryPath", "")));
                jFileChooser.setFileSelectionMode(0);
                if (jFileChooser.showSaveDialog(this) == 0) {
                    file = new File(jFileChooser.getSelectedFile().getPath());
                    if (!file.getName().toUpperCase().endsWith(".XML")) {
                        file = new File(file.getParentFile(), file.getName() + ".xml");
                    }
                    if (file.exists() && this.isAskBeforeOverwrite() && JOptionPane.showConfirmDialog(this, "File '" + file + "' already exists! Overwrite it anyway?", "Confirm Overwrite", 0, 3) == 1) {
                        return false;
                    }
                    this.saveTrapHistoryXML(file);
                    JOptionPane.showMessageDialog(this, "Saved trap history to " + file.getPath(), "File Saved", 1);
                    this.config.put("mibexplorer.NotificationHistoryPath", file.getPath());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error while saving trap history: " + exception.getMessage(), "IO Error", 0);
            return false;
        }
        return true;
    }

    public boolean isAskBeforeOverwrite() {
        return Boolean.valueOf(this.config.get("mibexplorer.AskBeforeOverwritingFile", "true"));
    }
}

