/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.net.HostnameResolver;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.BrowsePanel;
import com.agentpp.explorer.MultiVariablePanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.monitor.MonitorConfigPanel;
import com.agentpp.explorer.traps.PrioritiesPanel;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.explorer.traps.TrapSelector;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.objectspace.jgl.Pair;
import com.snmp4j.smi.SmiManagerBridge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Level;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TrapReceiverDialog
extends JPanel
implements CommandResponder,
JCCellDisplayListener,
JCSelectListener {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private float _$25295 = 0.0f;
    private long _$34145 = Long.MAX_VALUE;
    private float _$20551 = 2000.0f;
    private float _$34146 = 2.0f;
    Border border1;
    private JCEditableVectorDataSource _$11754 = new JCEditableVectorDataSource();
    private static SimpleDateFormat _$30558 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String[] _$34147 = new String[]{"Acknowlegded", "Notification ID", "Originator", "Destination", "System Up Time", "Security Name", "Version", "Context", "Context Engine ID", "Variable Bindings"};
    static final int COL_VBS = 9;
    static final int COL_ACK = 0;
    static final int COL_NOTIFICATION_ID = 1;
    static final int COL_ORIGINATOR = 2;
    static final int COL_DESTINATION = 3;
    static final int COL_SYS_UPTIME = 4;
    static final int COL_SEC_NAME = 5;
    static final int COL_VERSION = 6;
    static final int COL_CONTEXT = 7;
    static final int COL_CONTEXT_ENGINE_ID = 8;
    private boolean _$28178;
    private TrapProxy _$31253;
    private MIBRepository _$20550;
    private TableSorter _$29674;
    BorderLayout borderLayout4 = new BorderLayout();
    private ChangeManager _$25705 = new ChangeManager();
    private JFrame _$25700;
    private int _$34148 = 0;
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    JSplitPane jSplitPane1 = new JSplitPane();
    BrowsePanel browsePanel = new BrowsePanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JCTable table = new ExtendedListTable(){

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column == -1 && jCCellPosition.row >= 0) {
                return TrapReceiverDialog.this._$21383(jCCellPosition.row).toString();
            }
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            int n2 = jCCellPosition.row;
            int n3 = jCCellPosition.column;
            Object object = TrapReceiverDialog.this._$11754.getTableDataItem(n2, n3);
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    };
    JToggleButton jToggleButtonHistory = new JToggleButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonAck = new JButton();
    JToolBar jToolBar = new JToolBar();
    JButton jButtonUndo = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonRedo = new JButton();
    JPanel jPanelNorth = new JPanel();
    JToolBar jToolBarStatus = new JToolBar();
    JLabel statusBar = new JLabel();
    JToggleButton jToggleButtonPause = new JToggleButton();
    private Vector _$34155 = new Vector(100, 50);
    private JButton _$34156 = new JButton();
    private UserConfigFile _$5250;
    private JButton _$33391 = new JButton();
    private JCCellStyle _$34157;
    private JCCellStyle _$34158;
    private JCCellStyle _$34159;
    private JCCellStyle _$20099;
    private JCCellStyle _$34160;
    private Map _$34161 = Collections.synchronizedMap(new Hashtable());
    private HostnameResolver _$33838;
    private StatusBar _$7264;
    private boolean _$34162;
    private boolean _$34163;
    private SmiManagerBridge _$34164;

    public TrapReceiverDialog(TrapProxy trapProxy, MIBRepository mIBRepository, JFrame jFrame, UserConfigFile userConfigFile) {
        this._$31253 = trapProxy;
        this._$20550 = mIBRepository;
        this._$25700 = jFrame;
        this._$5250 = userConfigFile;
        this._$34164 = new SmiManagerBridge(null, mIBRepository);
        this.browsePanel = new BrowsePanel(mIBRepository);
        this.browsePanel.setNumRows(5);
        this._$11754.setNumRows(0);
        this._$11754.setNumColumns(_$34147.length);
        for (int i2 = 0; i2 < _$34147.length; ++i2) {
            this._$11754.setColumnLabel(i2, _$34147[i2]);
        }
        this._$11754.addRow(Integer.MAX_VALUE, null, null);
        this.table.setDataSource(this._$11754);
        this._$29674 = new TableSorter(this.table, this._$11754);
        this.table.setRowHidden(0, true);
        this.table.setColumnHidden(_$34147.length - 1, true);
        this.table.setFrozenRows(1);
        this.table.setColumnLabelDisplay(true);
        this.table.setRowLabelDisplay(true);
        this.table.setCharWidth(-997, -999);
        this.table.setCharWidth(-1, 13);
        this.table.setResizeEven(false);
        this.table.setVariableEstimateCount(10);
        this.table.setVisibleRows(20);
        this.table.setAutoScroll(1);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this._$20099 = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$20099.setEditable(false);
        this._$20099.setBackground(Color.white);
        this.table.setCellStyle(-997, -997, this._$20099);
        this._$34160 = new JCCellStyle(this._$20099);
        this._$34160.setBackground(new Color(220, 220, 220));
        this.table.setCellStyle(-997, 1, this._$34160);
        this.table.setPixelWidth(1, 33002);
        JCCellStyle jCCellStyle = new JCCellStyle(this._$20099);
        jCCellStyle.setBackground(Color.white);
        this._$34158 = new JCCellStyle(this._$20099);
        this._$34157 = new JCCellStyle(this._$20099);
        this._$34159 = new JCCellStyle(this._$20099);
        this._$34158.setBackground(Color.orange);
        this._$34157.setBackground(Color.yellow);
        this._$34159.setBackground(Color.red);
        for (int i3 = 2; i3 < _$34147.length - 1; ++i3) {
            this.table.setCellStyle(-997, i3, jCCellStyle);
            this.table.setPixelWidth(i3, 33002);
        }
        this.table.setFrozenColumns(1);
        this.table.setColumnHidden(0, true);
        this.table.addCellDisplayListener(this);
        this.table.addSelectListener(this);
        this.table.setSelectionPolicy(2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateButtons();
        this._$33838 = new HostnameResolver(this._$34161);
        this._$33838.start();
        trapProxy.setHostnameResolver(this._$33838);
        this.updateConfig();
    }

    public TrapReceiverDialog() {
        this(null, null, null, null);
    }

    public void init() {
        this.browsePanel.clear();
        this.table.traverse(this._$11754.getNumRows() - 1, 0, false, false);
    }

    private Level _$21383(int n2) {
        ObjectID objectID = (ObjectID)this._$11754.getTableDataItem(n2, 1);
        return this._$31253.getLoggingLevel((ObjectID)objectID).level;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() != null && jCCellDisplayEvent.getRow() > 0) {
            if (!this._$28178 && jCCellDisplayEvent.getCellData() instanceof ObjectID) {
                ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                CellStyleModel cellStyleModel = this._$34167(objectID);
                if (cellStyleModel != null && this.table.getCellStyle(jCCellDisplayEvent.getRow(), 1) != cellStyleModel) {
                    this.table.setCellStyle(jCCellDisplayEvent.getRow(), 1, cellStyleModel);
                } else if (cellStyleModel == null && this.table.getCellStyle(jCCellDisplayEvent.getRow(), 1) != this._$34160) {
                    this.table.setCellStyle(jCCellDisplayEvent.getRow(), 1, this._$34160);
                }
                String string = this._$20550.getObjectName(objectID);
                if (string == null) {
                    string = this._$20550.getPathSuffix(objectID);
                }
                if (string != null) {
                    jCCellDisplayEvent.setDisplayData(string);
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                String string = _$30558.format((Date)jCCellDisplayEvent.getCellData());
                jCCellDisplayEvent.setDisplayData(string);
            } else if (jCCellDisplayEvent.getColumn() == 2) {
                String[] stringArray = HostnameResolver.getHostParts(jCCellDisplayEvent.getCellData().toString());
                String string = (String)this._$34161.get(stringArray[0]);
                if (string == null) {
                    this._$33838.add(stringArray[0]);
                } else {
                    jCCellDisplayEvent.setDisplayData(string + stringArray[1]);
                }
            } else if (jCCellDisplayEvent.getColumn() == 9) {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = ((Collection)jCCellDisplayEvent.getCellData()).iterator();
                while (iterator.hasNext()) {
                    VariableBinding variableBinding = (VariableBinding)iterator.next();
                    stringBuilder.append(this._$34164.format(variableBinding.getOid(), variableBinding.getVariable(), true));
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                jCCellDisplayEvent.setDisplayData(stringBuilder.toString());
            }
        }
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.border2 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border2, "Variables");
        this.border3 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(this.borderLayout4);
        this.browsePanel.setBorder(this.border3);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/History16.gif");
        this.jToggleButtonHistory.setIcon(new ImageIcon(uRL));
        this.jToggleButtonHistory.setToolTipText("Show notification history");
        this.jToggleButtonHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jToggleButtonHistory_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Remove16.gif");
        this.jButtonDelete.setIcon(new ImageIcon(uRL));
        this.jButtonDelete.setToolTipText("Remove selected traps");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonDelete_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Import16.gif");
        this.jButtonAck.setIcon(new ImageIcon(uRL));
        this.jButtonAck.setToolTipText("Acknowledge notification and store it in alarm history");
        this.jButtonAck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonAck_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Undo16.gif");
        this.jButtonUndo.setIcon(new ImageIcon(uRL));
        this.jButtonUndo.setToolTipText("Undo last change");
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonUndo_actionPerformed(actionEvent);
            }
        });
        this.flowLayout1.setAlignment(0);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Redo16.gif");
        this.jButtonRedo.setIcon(new ImageIcon(uRL));
        this.jButtonRedo.setToolTipText("Redo last change");
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonRedo_actionPerformed(actionEvent);
            }
        });
        this.jPanelNorth.setLayout(this.flowLayout1);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Pause16.gif");
        this.jToggleButtonPause.setIcon(new ImageIcon(uRL));
        this.jToggleButtonPause.setToolTipText("Pause auto scrolling");
        this.jToggleButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jToggleButtonPause_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif");
        this._$34156.setToolTipText("Save selected traps as PDUs");
        this._$34156.setIcon(new ImageIcon(uRL));
        this._$34156.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonSaveAsPDU_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Properties16.gif");
        this._$33391.setToolTipText("Set priorities dependent on trap OIDs");
        this._$33391.setIcon(new ImageIcon(uRL));
        this._$33391.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonPreferences_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.browsePanel, "bottom");
        this.jSplitPane1.add((Component)this.table, "top");
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jToolBar, null);
        this.jToolBar.add((Component)this.jButtonAck, null);
        this.jToolBar.add((Component)this._$34156, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jButtonDelete, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jButtonRedo, null);
        this.jToolBar.add((Component)this.jButtonUndo, null);
        this.jToolBar.add((Component)this._$33391, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jToggleButtonHistory, null);
        this.jToolBar.setName("Trap Receiver Tool Bar");
        this.jPanelNorth.add((Component)this.jToolBarStatus, null);
        this.jToolBarStatus.add((Component)this.jToggleButtonPause, null);
        this.jToolBarStatus.addSeparator();
        this.jToolBarStatus.add((Component)this.statusBar, null);
        this.jToolBarStatus.setName("Trap Receiver Status");
        ToolBarUtils.setMinimumButtonSize(this.jToolBarStatus);
        ToolBarUtils.setMinimumButtonSize(this.jToolBar);
        this.jSplitPane1.setDividerLocation(150);
    }

    public JCEditableVectorDataSource getModel() {
        return this._$11754;
    }

    public void setModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        this.table.resetSortedRows();
        this._$11754 = jCEditableVectorDataSource;
        this._$11754.setColumnLabels(_$34147);
        this.table.setDataSource(this._$11754);
        this._$29674 = new TableSorter(this.table, this._$11754);
        this.jToggleButtonHistory_actionPerformed(new ActionEvent(this, 0, null));
        this._$29674.sort();
        this._$34173();
    }

    public DataViewModel getTableDataView() {
        return this.table.getDataView();
    }

    private static IpAddress _$21811(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapAddress) || variableBindingArray[i2].getSyntax() != 64) continue;
            return (IpAddress)variableBindingArray[i2].getVariable();
        }
        return null;
    }

    public static TimeTicks getTimestamp(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < 2 && i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.sysUpTime)) continue;
            Variable variable = variableBindingArray[i2].getVariable();
            if (variable instanceof TimeTicks) {
                return (TimeTicks)variable;
            }
            return null;
        }
        return null;
    }

    public static OID getTrapOID(PDU pDU) {
        if (pDU instanceof PDUv1) {
            return TrapReceiverDialog.getTrapOID((PDUv1)pDU);
        }
        VariableBinding[] variableBindingArray = pDU.toArray();
        if (variableBindingArray == null) {
            return null;
        }
        return TrapReceiverDialog.getTrapOID(variableBindingArray);
    }

    public static OID getTrapOID(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < 2 && i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapOID)) continue;
            Variable variable = variableBindingArray[i2].getVariable();
            if (variable instanceof OID) {
                return (OID)variable;
            }
            return null;
        }
        return null;
    }

    public static OID getTrapOID(PDUv1 pDUv1) {
        OID oID;
        if (pDUv1.getGenericTrap() != 6) {
            oID = new OID("1.3.6.1.6.3.1.1.5");
            oID.append(pDUv1.getGenericTrap() + 1);
        } else {
            oID = new OID(pDUv1.getEnterprise().toString());
            oID.append(0);
            oID.append(pDUv1.getSpecificTrap());
        }
        return oID;
    }

    private CellStyleModel _$34167(ObjectID objectID) {
        Level level = this._$31253.getLoggingLevel((ObjectID)objectID).level;
        switch (level.toInt()) {
            case 40000: {
                return this._$34158;
            }
            case 30000: {
                return this._$34157;
            }
            case 50000: {
                return this._$34159;
            }
        }
        return null;
    }

    public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
        OID oID;
        TimeTicks timeTicks;
        Object object;
        PDU pDU = commandResponderEvent.getPDU();
        VariableBinding[] variableBindingArray = pDU.getVariableBindings().toArray(new VariableBinding[0]);
        String string = commandResponderEvent.getSource() instanceof TrapSelector ? ((TrapSelector)commandResponderEvent.getSource()).getSourceAddress() : (commandResponderEvent.getSource() instanceof MonitorConfigPanel ? "MIB Explorer" : "unknown");
        if (commandResponderEvent.getPDU() instanceof PDUv1) {
            object = (VariableBinding[])pDU;
            timeTicks = new TimeTicks(((PDUv1)object).getTimestamp());
            oID = TrapReceiverDialog.getTrapOID((PDUv1)object);
        } else {
            oID = TrapReceiverDialog.getTrapOID(variableBindingArray);
            timeTicks = TrapReceiverDialog.getTimestamp(variableBindingArray);
            if (oID != null && timeTicks != null) {
                object = new VariableBinding[variableBindingArray.length - 2];
                System.arraycopy(variableBindingArray, 2, object, 0, variableBindingArray.length - 2);
                variableBindingArray = object;
            } else {
                SnmpLogger.cTrapRcv.error("SNMPv2c/v3 trap encoding error: missing sysUpTime or trapOID variable binding");
                return;
            }
        }
        if (!this.jToggleButtonPause.isSelected()) {
            this.table.resetSortedRows();
        }
        object = new Vector(_$34147.length);
        ((Vector)object).addElement(new Boolean(false));
        ((Vector)object).addElement(new ObjectID(oID.toString()));
        if (pDU instanceof PDUv1) {
            ((Vector)object).addElement(((PDUv1)pDU).getAgentAddress().toString());
        } else if (commandResponderEvent.getPeerAddress() != null) {
            ((Vector)object).addElement(commandResponderEvent.getPeerAddress().toString());
        } else {
            ((Vector)object).addElement(((MonitorConfigPanel)commandResponderEvent.getSource()).getTitle());
        }
        ((Vector)object).addElement(string);
        ((Vector)object).addElement(timeTicks);
        ((Vector)object).addElement(new OctetString(commandResponderEvent.getSecurityName()));
        ((Vector)object).addElement(GenTarget.getVersionString(commandResponderEvent.getMessageProcessingModel()));
        if (commandResponderEvent.getMessageProcessingModel() == 3) {
            ((Vector)object).addElement(new OctetString(((ScopedPDU)pDU).getContextName()));
            ((Vector)object).addElement(new OctetString(((ScopedPDU)pDU).getContextEngineID()).toHexString());
        } else {
            ((Vector)object).addElement(new OctetString());
            ((Vector)object).addElement("");
        }
        Vector<VariableBinding> vector = new Vector<VariableBinding>(variableBindingArray.length + 1);
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            vector.addElement(variableBindingArray[i2]);
        }
        ((Vector)object).addElement(vector);
        ++this._$34148;
        if (!this.jToggleButtonPause.isSelected()) {
            this._$11754.addRow(Integer.MAX_VALUE, new Date(), (Vector)object);
            this._$29674.sort();
            this.table.traverse(this._$11754.getNumRows() - 1, 0, false, false);
        } else {
            this._$34155.addElement(new Pair(new Date(), object));
        }
        this._$34178();
        this._$34173();
    }

    public void setDisplayOID(boolean bl) {
        this._$28178 = bl;
    }

    public boolean isDisplayOID() {
        return this._$28178;
    }

    public void undo() {
        this.table.cancelEdit(true);
        this._$25705.undo();
        this.updateButtons();
    }

    public void redo() {
        this.table.cancelEdit(true);
        this._$25705.redo();
        this.updateButtons();
    }

    void jButtonAck_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (int i2 = 0; i2 < jCCellRangeArray.length; ++i2) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[i2]);
            if (jCCellRangeArray[i2].start_row >= this._$11754.getNumRows()) continue;
            for (int i3 = jCCellRangeArray[i2].start_row; i3 <= jCCellRangeArray[i2].end_row; ++i3) {
                if (this.table.isRowHidden(i3)) continue;
                this.table.setRowHidden(i3, true);
                --this._$34148;
                boolean bl = (Boolean)this.table.getDataView().getTableDataItem(i3, 0);
                this.table.getDataView().setTableDataItem(new Boolean(!bl), i3, 0);
                this._$25705.addEdit(new HistoryEdit(i3));
            }
        }
        this.table.clearSelection();
        this.updateButtons();
    }

    public void updateButtons() {
        this.jButtonUndo.setEnabled(this._$25705.canUndo());
        this.jButtonRedo.setEnabled(this._$25705.canRedo());
        this.jButtonAck.setEnabled(!this.jToggleButtonHistory.isSelected() && TableUtils.getFirstSelectedRow(this.table) >= 0);
        this._$34173();
    }

    private void _$34173() {
        int n2 = this._$34155.size();
        int n3 = this._$11754.getNumRows() - 1 + n2;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this._$34148);
        stringBuffer.append(" New | ");
        stringBuffer.append(n3 - this._$34148);
        stringBuffer.append(" Acknowledged | ");
        stringBuffer.append(n2);
        stringBuffer.append(" Hidden | ");
        stringBuffer.append(n3);
        stringBuffer.append(" Total");
        this.statusBar.setText(stringBuffer.toString());
        if (this._$7264 != null) {
            this._$7264.setMessage("Traps (" + this._$34148 + " New)");
        }
    }

    private void _$34178() {
        if (this._$34146 == 0.0f || this.isPaused()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this._$34145 <= 0L) {
            this._$25295 = 0.0f;
            this._$34145 = l2;
        } else {
            long l3 = l2 - this._$34145;
            this._$25295 -= (float)l3 / this._$20551 * this._$34146;
            this._$25295 += 1.0f;
            if (this._$25295 < 0.0f) {
                this._$25295 = 0.0f;
            }
            this._$34145 = l2;
        }
        if (this._$25295 > this._$34146) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TrapReceiverDialog.this.jToggleButtonPause.setSelected(true);
                }
            });
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getSelectedRows(this.table);
        Arrays.sort(nArray);
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2] - i2;
            Vector<Object> vector = new Vector<Object>();
            vector.add(new Integer(n2));
            vector.addElement(this._$11754.getTableRowLabel(n2));
            for (int i3 = 0; i3 <= this._$11754.getNumColumns(); ++i3) {
                vector.addElement(this._$11754.getTableDataItem(n2, i3));
            }
            arrayList.add(vector);
            this._$11754.deleteRows(n2, 1);
        }
        for (Vector vector : arrayList) {
            int n3 = (Integer)vector.firstElement();
            vector.remove(0);
            Object e2 = vector.firstElement();
            vector.remove(0);
            this._$25705.addEdit(new RowAddEdit(n3, false, e2, vector));
            boolean bl = (Boolean)vector.firstElement();
            if (bl) continue;
            --this._$34148;
        }
        this.table.clearSelection();
        this.updateButtons();
    }

    void jButtonUndo_actionPerformed(ActionEvent actionEvent) {
        this.undo();
    }

    void jButtonRedo_actionPerformed(ActionEvent actionEvent) {
        this.redo();
    }

    void jToggleButtonHistory_actionPerformed(ActionEvent actionEvent) {
        this._$34148 = 0;
        boolean bl = this.jToggleButtonHistory.isSelected();
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            boolean bl2 = (Boolean)this._$11754.getTableDataItem(i2, 0);
            if (!bl2) {
                ++this._$34148;
            }
            this.table.setRowHidden(i2, bl2 != bl);
        }
        this.updateButtons();
        this.browsePanel.clear();
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int n2 = jCSelectEvent.getStartRow();
        this.browsePanel.clear();
        Object object = this._$11754.getTableDataItem(n2, 9);
        if (!(object instanceof Vector)) {
            return;
        }
        Vector vector = (Vector)object;
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        vector = this.browsePanel.makeRow(null, (VariableBinding[])objectArray);
        this.browsePanel.set(vector, 0, 0);
        this.updateButtons();
    }

    public void setDividerLocation(int n2) {
        this.jSplitPane1.setDividerLocation(n2);
    }

    public int getDividerLocation() {
        return this.jSplitPane1.getDividerLocation();
    }

    public boolean isPaused() {
        return this.jToggleButtonPause.isSelected();
    }

    synchronized void jToggleButtonPause_actionPerformed(ActionEvent actionEvent) {
        if (!this.jToggleButtonPause.isSelected()) {
            this._$25295 = 0.0f;
            this.table.setRepaintEnabled(false);
            Enumeration enumeration = this._$34155.elements();
            while (enumeration.hasMoreElements()) {
                Pair pair = (Pair)enumeration.nextElement();
                this._$11754.addRow(Integer.MAX_VALUE, pair.first, (Vector)pair.second);
            }
            this._$34155.removeAllElements();
            this._$29674.sort();
            this.table.setRepaintEnabled(true);
            this.table.traverse(this._$11754.getNumRows() - 1, 0, false, false);
        }
        this._$34173();
    }

    public void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this.browsePanel.removeMIBObjectListener(mIBObjectListener);
    }

    public void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this.browsePanel.addMIBObjectListener(mIBObjectListener);
    }

    private ValueConverter _$24791(ObjectID objectID, Class clazz) {
        try {
            Pair pair = this._$20550.getSplittedObjectID(objectID);
            MIBObject mIBObject = this._$20550.getObject((ObjectID)pair.first);
            if (mIBObject != null && mIBObject instanceof MIBObjectType) {
                MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                MIBTextualConvention mIBTextualConvention = this._$20550.getEffectiveSyntax(mIBObjectType.getSyntax());
                return new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return new ValueConverter(clazz);
    }

    private JCEditableVectorDataSource _$33643(int n2) {
        Vector vector = (Vector)this._$11754.getTableDataItem(n2, 9);
        if (vector == null) {
            vector = new Vector(1);
        }
        String string = this._$11754.getTableDataItem(n2, 6).toString();
        int n3 = 2;
        if (string.equals(GenTarget.getVersionString(0))) {
            n3 = 3;
        }
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource();
        jCEditableVectorDataSource.setNumColumns(MultiVariablePanel.TITLES.length);
        jCEditableVectorDataSource.setNumRows(0);
        jCEditableVectorDataSource.setColumnLabels(MultiVariablePanel.TITLES);
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(0), null);
        Vector<Object> vector2 = new Vector<Object>(MultiVariablePanel.TITLES.length);
        ObjectID objectID = new ObjectID(SnmpConstants.sysUpTime.toString());
        vector2.add(objectID);
        vector2.add(new Integer(11));
        ValueConverter valueConverter = this._$24791(objectID, TimeTicks.class);
        vector2.add(valueConverter.toNative((TimeTicks)this._$11754.getTableDataItem(n2, 4)));
        vector2.add(valueConverter);
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(1), vector2);
        vector2 = new Vector(MultiVariablePanel.TITLES.length);
        objectID = new ObjectID(SnmpConstants.snmpTrapOID.toString());
        vector2.add(objectID);
        vector2.add(new Integer(2));
        vector2.add(this._$11754.getTableDataItem(n2, 1));
        vector2.add(this._$24791(objectID, OID.class));
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(2), vector2);
        if (n3 == 3) {
            vector2 = new Vector(MultiVariablePanel.TITLES.length);
            objectID = new ObjectID(SnmpConstants.snmpTrapAddress.toString());
            vector2.add(objectID);
            vector2.add(new Integer(9));
            valueConverter = this._$24791(objectID, IpAddress.class);
            vector2.add(valueConverter.toNative(new IpAddress(this._$11754.getTableDataItem(n2, 2).toString())));
            vector2.add(valueConverter);
            jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(3), vector2);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            vector2 = new Vector(MultiVariablePanel.TITLES.length);
            objectID = new ObjectID(((VariableBinding)objectArray[i2]).getOid().toString());
            valueConverter = this._$24791(objectID, ((VariableBinding)objectArray[i2]).getVariable().getClass());
            vector2.add(objectID);
            vector2.add(new Integer(valueConverter.getSMISyntax()));
            vector2.add(valueConverter.toNative(((VariableBinding)objectArray[i2]).getVariable()));
            vector2.add(valueConverter);
            jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(n3 + i2 + 1), vector2);
        }
        return jCEditableVectorDataSource;
    }

    public boolean saveSelected() {
        int n2 = TableUtils.getFirstSelectedRow(this.table);
        if (n2 < 0) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser(this._$5250.get("mibexplorer.PDUPath", ""));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("pdu");
        exampleFileFilter.setDescription("MIB Explorer PDU Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(this._$5250.get("mibexplorer.PDUPath", "")));
        int n3 = jFileChooser.showSaveDialog(this);
        if (n3 == 0) {
            this._$5250.put("mibexplorer.PDUPath", jFileChooser.getSelectedFile().getParent());
            try {
                Object[] objectArray;
                int n4;
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".PDU")) {
                    file = new File(file.getParentFile(), file.getName() + ".pdu");
                }
                if (Boolean.valueOf(this._$5250.get("mibexplorer.AskBeforeOverwritingFile", "true")).booleanValue() && file.exists() && (n4 = JOptionPane.showOptionDialog(this, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, objectArray = new Object[]{"Yes", "Cancel"}, objectArray[1])) == 1) {
                    return true;
                }
                objectArray = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)objectArray);
                objectOutputStream.writeObject(this._$33643(n2));
                objectOutputStream.flush();
                objectOutputStream.close();
                JOptionPane.showMessageDialog(this._$25700, "Saved PDU to " + file.getPath(), "Saved", 1);
                return true;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{"Error while saving PDU file:", exception.getMessage()};
                JOptionPane.showMessageDialog(this._$25700, stringArray, "IO Error", 0);
                return false;
            }
        }
        return false;
    }

    void jButtonSaveAsPDU_actionPerformed(ActionEvent actionEvent) {
        this.saveSelected();
    }

    void jButtonPreferences_actionPerformed(ActionEvent actionEvent) {
        PrioritiesPanel prioritiesPanel = new PrioritiesPanel(this._$5250, this._$20550);
        StandardDialog standardDialog = new StandardDialog((Frame)this._$25700, "Trap Severities", true, true);
        standardDialog.setCenterPanel(prioritiesPanel);
        standardDialog.setLocationRelativeTo(this);
        prioritiesPanel.load();
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            prioritiesPanel.save();
            this._$31253.loadPriorities();
            this.table.repaint();
        }
    }

    public Map getHostnames() {
        return this._$34161;
    }

    public void setMaxqueue(float f2) {
        this._$34146 = f2;
    }

    public float getMaxqueue() {
        return this._$34146;
    }

    public float getInterval() {
        return this._$20551;
    }

    public StatusBar getTitle() {
        return this._$7264;
    }

    public void setInterval(float f2) {
        this._$20551 = f2;
    }

    public void setTitle(StatusBar statusBar) {
        this._$7264 = statusBar;
    }

    public boolean isBring2FrontOnTrap() {
        return this._$34162;
    }

    public void updateConfig() {
        this._$34162 = this._$5250.getBoolean("mibexplorer.trap.toFront", false);
        this._$34163 = this._$5250.getBoolean("mibexplorer.trap.beep", false);
        this._$34146 = this._$5250.getInteger("mibexplorer.trap.autoinhibition.queue.size", 2);
    }

    public boolean isBeepOnTrap() {
        return this._$34163;
    }

    class HistoryEdit
    extends AbstractUndoableEdit {
        private int _$355;

        public HistoryEdit(int n2) {
            this._$355 = n2;
        }

        public void undo() {
            super.undo();
            boolean bl = TrapReceiverDialog.this.jToggleButtonHistory.isSelected();
            TrapReceiverDialog.this.table.getDataView().setTableDataItem(new Boolean(bl), this._$355, 0);
            TrapReceiverDialog.this.table.setRowHidden(this._$355, bl);
            TrapReceiverDialog.this._$34148++;
            TrapReceiverDialog.this._$34173();
        }

        public void redo() {
            super.redo();
            boolean bl = !TrapReceiverDialog.this.jToggleButtonHistory.isSelected();
            TrapReceiverDialog.this.table.getDataView().setTableDataItem(new Boolean(bl), this._$355, 0);
            TrapReceiverDialog.this.table.setRowHidden(this._$355, bl);
            TrapReceiverDialog.this._$34148--;
            TrapReceiverDialog.this._$34173();
        }
    }

    class RowAddEdit
    extends AbstractUndoableEdit {
        private int _$355;
        private boolean _$11903 = true;
        private Vector _$7187;
        private Object _$34187;

        public RowAddEdit(int n2, boolean bl, Object object, Vector vector) {
            this._$355 = n2;
            this._$11903 = bl;
            this._$7187 = vector;
            this._$34187 = object;
        }

        public void undo() {
            super.undo();
            if (this._$11903) {
                if (!TrapReceiverDialog.this._$11754.deleteRows(this._$355, 1)) {
                    throw new CannotUndoException();
                }
                if (!((Boolean)this._$7187.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$34148--;
                }
            } else {
                if (!TrapReceiverDialog.this._$11754.addRow(this._$355, this._$34187, this._$7187)) {
                    throw new CannotUndoException();
                }
                if (!((Boolean)this._$7187.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$34148++;
                }
            }
            TrapReceiverDialog.this._$34173();
        }

        public void redo() {
            super.redo();
            if (this._$11903) {
                if (!TrapReceiverDialog.this._$11754.addRow(this._$355, this._$34187, this._$7187)) {
                    throw new CannotRedoException();
                }
                if (!((Boolean)this._$7187.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$34148++;
                }
            } else {
                if (!TrapReceiverDialog.this._$11754.deleteRows(this._$355, 1)) {
                    throw new CannotRedoException();
                }
                if (!((Boolean)this._$7187.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$34148--;
                }
            }
            TrapReceiverDialog.this._$34173();
        }
    }
}

