/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.net.HostnameResolver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.script.MIBContext;
import com.agentpp.explorer.script.PduBean;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.explorer.script.UtilsContext;
import com.agentpp.explorer.traps.TrapReceiverDialog;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smi.IObjectID;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.UserConfigFile;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

public class TrapProxy
implements CommandResponder {
    private Snmp _$14889;
    private UserConfigFile _$5250;
    private transient Vector _$33835;
    private Vector _$33836 = new Vector();
    private Hashtable _$33837;
    private GenTarget _$30639;
    private Hashtable _$7365;
    private RepositoryManager _$31188;
    private MIBRepository _$20550 = new MIBRepository();
    private SnmpLogger _$30270;
    private HostnameResolver _$33838 = null;

    public TrapProxy(UserConfigFile userConfigFile, GenTarget genTarget, Hashtable hashtable, RepositoryManager repositoryManager, Snmp snmp) {
        this._$5250 = userConfigFile;
        this._$14889 = snmp;
        this._$30639 = genTarget;
        this._$7365 = hashtable;
        this._$31188 = repositoryManager;
        this._$30270 = new SnmpLogger(this._$20550);
    }

    public void loadConfig() {
        this.loadPriorities();
    }

    public synchronized void loadPriorities() {
        this._$33837 = new Hashtable();
        Vector vector = this._$5250.getArray("mibexplorer.trap.priorities.OID");
        Vector vector2 = this._$5250.getArray("mibexplorer.trap.priorities.level", vector.size());
        Vector vector3 = this._$5250.getArray("mibexplorer.trap.priorities.script", vector.size());
        Vector vector4 = this._$5250.getArray("mibexplorer.trap.priorities.comment", vector.size());
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string;
            File file = null;
            String string2 = null;
            if (vector3.size() > i2 && vector3.elementAt(i2) != null && !(file = new File((String)vector3.elementAt(i2))).isFile()) {
                SnmpLogger.cTrapRcv.warn("Trap script '" + file.getPath() + "' not found");
                file = null;
            }
            if (vector4.size() > i2) {
                string2 = (String)vector4.get(i2);
            }
            if ((string = (String)vector.elementAt(i2)) == null) {
                string = "";
            }
            this._$33837.put(new ObjectID(string), new TrapConfig(Level.toLevel(vector2.elementAt(i2).toString()), file, string2, null));
        }
    }

    public TrapConfig getLoggingLevel(ObjectID objectID) {
        if (objectID == null) {
            return new TrapConfig(Level.ERROR, null, null, null);
        }
        TrapConfig trapConfig = new TrapConfig(Level.INFO, null, null, objectID);
        while (objectID.size() > 0) {
            TrapConfig trapConfig2 = (TrapConfig)this._$33837.get(objectID);
            if (trapConfig2 != null) {
                return trapConfig2;
            }
            objectID = ObjectID.trim(objectID);
        }
        return trapConfig;
    }

    private TrapConfig _$33846(PDU pDU) {
        ObjectID objectID = null;
        if (pDU instanceof PDUv1) {
            objectID = new ObjectID(TrapReceiverDialog.getTrapOID((PDUv1)pDU).getValue());
        } else {
            OID oID = TrapReceiverDialog.getTrapOID(pDU.toArray());
            if (oID != null) {
                objectID = new ObjectID(oID.getValue());
            }
        }
        return this.getLoggingLevel(objectID);
    }

    public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
        TrapConfig trapConfig = this._$33846(commandResponderEvent.getPDU());
        SnmpLogger.logTrapReceived(commandResponderEvent, trapConfig.level);
        if (commandResponderEvent.getPDU().getType() == -90) {
            // empty if block
        }
        Object object = this._$33835.elements();
        while (object.hasMoreElements()) {
            CommandResponder commandResponder = (CommandResponder)object.nextElement();
            commandResponder.processPdu(commandResponderEvent);
        }
        if (trapConfig.script != null) {
            try {
                object = new ScriptThread(ScriptContext.getScriptText((String)trapConfig.script.getPath()), trapConfig.script, commandResponderEvent.getPDU(), commandResponderEvent.getPeerAddress(), trapConfig);
                ((ScriptThread)object).run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Vector getCurrentConfig() {
        return this._$33836;
    }

    public synchronized void removeTrapListener(CommandResponder commandResponder) {
        if (this._$33835 != null && this._$33835.contains(commandResponder)) {
            Vector vector = (Vector)this._$33835.clone();
            vector.removeElement(commandResponder);
            this._$33835 = vector;
        }
    }

    public synchronized void addTrapListener(CommandResponder commandResponder) {
        Vector vector;
        Vector vector2 = vector = this._$33835 == null ? new Vector(2) : (Vector)this._$33835.clone();
        if (!vector.contains(commandResponder)) {
            vector.addElement(commandResponder);
            this._$33835 = vector;
        }
    }

    public void saveCurrentConfig() {
        Vector<String> vector = new Vector<String>(this._$33836.size() + 1);
        int n2 = 0;
        Enumeration enumeration = this._$33836.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            vector.addElement(vector2.firstElement().toString());
            ++n2;
        }
        this._$5250.putArray("mibexplorer.TrapAddress", vector);
    }

    public Snmp getSession() {
        return this._$14889;
    }

    public void setTargets(Hashtable hashtable) {
        this._$7365 = hashtable;
    }

    public void setDefaultTarget(GenTarget genTarget) {
        this._$30639 = genTarget;
    }

    public void setHostnameResolver(HostnameResolver hostnameResolver) {
        this._$33838 = hostnameResolver;
    }

    class ScriptThread
    implements Runnable {
        private VelocityContext _$11930;
        private ScriptContext _$33548;
        private MIBContext _$33672;
        private String _$7330;
        private File _$33517;

        public ScriptThread(String string, File file, PDU pDU, Address address, TrapConfig trapConfig) {
            String[] stringArray;
            this._$7330 = string;
            this._$33517 = file;
            this._$11930 = new VelocityContext();
            if (pDU instanceof PDUv1) {
                stringArray = (String[])pDU;
                PDU pDU2 = new PDU();
                VariableBinding variableBinding = new VariableBinding(SnmpConstants.sysUpTime, new TimeTicks(stringArray.getTimestamp()));
                pDU2.add(variableBinding);
                variableBinding = stringArray.getGenericTrap() == 6 ? new VariableBinding(SnmpConstants.snmpTrapOID, new OID(stringArray.getEnterprise().toString() + ".0." + stringArray.getSpecificTrap())) : new VariableBinding(SnmpConstants.snmpTrapOID, new OID(SnmpConstants.snmpTraps.toString() + "." + stringArray.getGenericTrap()));
                pDU2.add(variableBinding);
                for (int i2 = 0; i2 < pDU.size(); ++i2) {
                    pDU2.add(pDU.get(i2));
                }
                pDU = pDU2;
            }
            this._$33548 = new ScriptContext(TrapProxy.this._$14889, TrapProxy.this._$5250, TrapProxy.this._$30639, TrapProxy.this._$7365, TrapProxy.this._$30270, TrapProxy.this._$20550, file.getPath(), new PduBean(TrapProxy.this._$20550, pDU, null));
            this._$33672 = new MIBContext(TrapProxy.this._$31188, TrapProxy.this._$20550);
            this._$11930.put("snmp", this._$33548);
            this._$11930.put("mib", this._$33672);
            this._$11930.put("utils", new UtilsContext());
            this._$11930.put("severity", trapConfig.level.toString());
            this._$11930.put("comment", trapConfig.comment);
            this._$11930.put("sourceAddress", address.toString());
            stringArray = HostnameResolver.getHostParts(address.toString());
            if (TrapProxy.this._$33838 != null) {
                this._$11930.put("sourceHost", TrapProxy.this._$33838.getHostname(stringArray[0]));
            } else {
                this._$11930.put("sourceHost", stringArray[0]);
            }
            this._$11930.put("sourcePort", stringArray[1]);
        }

        public void run() {
            try {
                this._$33548.reinit();
                SnmpLogger.cTrapRcv.debug("Executing '" + this._$33517.getPath() + "' trap/notification script");
                StringWriter stringWriter = new StringWriter();
                Velocity.evaluate((Context)this._$11930, (Writer)stringWriter, this._$33517.getPath(), this._$7330);
                stringWriter.flush();
                stringWriter.close();
                SnmpLogger.cTrapRcv.debug("Output of trap script '" + this._$33517.getPath() + "' is: " + stringWriter.toString());
                SnmpLogger.cTrapRcv.info("Trap script '" + this._$33517.getPath() + "' executed successfully.");
            }
            catch (Exception exception) {
                SnmpLogger.cTrapRcv.fatal("Trap script execution failed: " + exception.getMessage());
            }
        }
    }

    public class TrapConfig {
        public Level level;
        public File script;
        public String comment;
        private ObjectID _$803;

        public TrapConfig(Level level, File file, String string, ObjectID objectID) {
            this.level = level;
            this.script = file;
            this.comment = string;
            this._$803 = objectID;
        }

        public IObjectID getNotificationID() {
            return this._$803;
        }
    }
}

