/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.editors.cell.LogLevelCellEditor;
import com.agentpp.explorer.editors.cell.ObjectIDCellEditor;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.log4j.Level;

public class PrioritiesPanel
extends JPanel
implements ActionListener,
JCCellDisplayListener {
    private static final String[] _$1713 = new String[]{"Subtree", "Severity", "Script", "Comment"};
    private static final int[] _$14676 = new int[]{20, 12, 25, 10};
    private static final int _$25681 = 0;
    private static final int _$44586 = 1;
    private static final int _$44587 = 2;
    private static final int _$44588 = 3;
    private static final String _$1724 = "Add";
    private static final String _$30598 = "Remove";
    private static final String _$44589 = "Script...";
    private BorderLayout _$549 = new BorderLayout();
    private MIBRepository _$20550;
    private UserConfigFile _$5250;
    private ExtendedListTable _$274;
    private JCEditableVectorDataSource _$11754 = new JCEditableVectorDataSource();
    private JCCellStyle _$25703;
    private JCCellStyle _$26899;
    private TableSorter _$5245;
    private JPanel _$14335 = new JPanel();
    private JButton _$14336 = new JButton();
    private JButton _$14337 = new JButton();

    public PrioritiesPanel(UserConfigFile userConfigFile, MIBRepository mIBRepository) {
        this._$20550 = mIBRepository;
        this._$5250 = userConfigFile;
        this._$274 = new ExtendedListTable(){

            public String getToolTipText(MouseEvent mouseEvent) {
                JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
                if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                    return null;
                }
                int n2 = jCCellPosition.row;
                int n3 = jCCellPosition.column;
                Object object = PrioritiesPanel.this._$11754.getTableDataItem(n2, n3);
                if (object == null) {
                    return null;
                }
                return object.toString();
            }

            public boolean isPopupAllowed(int n2, int n3) {
                int n4 = TableUtils.getFirstSelectedRow(PrioritiesPanel.this._$274);
                TablePopupMenu tablePopupMenu = super.getPopupMenu();
                if (n4 >= 0) {
                    tablePopupMenu.getComponent(1).setEnabled(true);
                } else {
                    tablePopupMenu.getComponent(1).setEnabled(false);
                }
                return true;
            }
        };
        this._$11754.setNumRows(10);
        this._$11754.setNumColumns(_$1713.length);
        this._$11754.setColumnLabels(_$1713);
        this._$274.setDataSource(this._$11754);
        this._$274.setRowHidden(0, true);
        this._$274.setRowLabelDisplay(false);
        this._$274.setPopupMenuEnabled(true);
        this._$5245 = new TableSorter((JCTable)this._$274, (JCVectorDataSource)this._$11754, false);
        this._$5245.addSortColumn(0);
        TablePopupMenu tablePopupMenu = this._$274.getPopupMenu();
        tablePopupMenu.addItem(_$1724, this);
        tablePopupMenu.addItem(_$30598, this);
        tablePopupMenu.addItem(_$44589, this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$5268();
        this._$274.addCellDisplayListener(this);
    }

    public PrioritiesPanel() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n2 = TableUtils.getFirstSelectedRow(this._$274);
        if (actionEvent.getActionCommand().equals(_$1724)) {
            this.jButtonAdd_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(_$30598)) {
            this.jButtonRemove_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(_$44589)) {
            JFileChooser jFileChooser = new JFileChooser(this._$5250.get("mibexplorer.scriptsPath", "."));
            jFileChooser.setFileFilter(new ExampleFileFilter("vm", "MIB Explorer Script"));
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showOpenDialog(this) == 0) {
                this._$11754.setTableDataItem(jFileChooser.getSelectedFile().getPath(), n2, 2);
            }
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this._$549);
        this._$14336.setToolTipText("Add a new row");
        this._$14336.setText(_$1724);
        this._$14336.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrioritiesPanel.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$14337.setToolTipText("Remove selected rows");
        this._$14337.setText(_$30598);
        this._$14337.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrioritiesPanel.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$274, "Center");
        this.add((Component)this._$14335, "South");
        this._$14335.add((Component)this._$14336, null);
        this._$14335.add((Component)this._$14337, null);
    }

    private void _$25808() {
        this._$11754.setNumRows(1);
        Vector vector = this._$5250.getArray("mibexplorer.trap.priorities.OID");
        Vector vector2 = this._$5250.getArray("mibexplorer.trap.priorities.level", vector.size());
        Vector vector3 = this._$5250.getArray("mibexplorer.trap.priorities.script", vector.size());
        Vector vector4 = this._$5250.getArray("mibexplorer.trap.priorities.comment", vector.size());
        for (int i2 = 0; i2 < vector.size() && i2 < vector2.size(); ++i2) {
            Vector<Object> vector5 = new Vector<Object>(_$1713.length);
            String string = (String)vector.elementAt(i2);
            if (string == null) {
                string = "";
            }
            vector5.add(new ObjectID(string));
            vector5.add(new Integer(Level.toLevel(vector2.elementAt(i2).toString()).toInt()));
            if (i2 < vector3.size()) {
                vector5.add(vector3.elementAt(i2));
            } else {
                vector5.add("");
            }
            if (i2 < vector4.size()) {
                vector5.add(vector4.elementAt(i2));
            } else {
                vector5.add("");
            }
            this._$11754.addRow(Integer.MAX_VALUE, null, vector5);
        }
        this._$5245.sort();
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getRow() == -1 || jCCellDisplayEvent.getDisplayData() == null) {
            return;
        }
        switch (jCCellDisplayEvent.getColumn()) {
            case 0: {
                if (!(jCCellDisplayEvent.getCellData() instanceof ObjectID)) break;
                ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                String string = this._$20550.getObjectName(objectID);
                if (string == null) {
                    string = this._$20550.getPathSuffix(objectID);
                }
                if (string == null) break;
                jCCellDisplayEvent.setDisplayData(string);
                break;
            }
            case 1: {
                int n2 = ((Number)jCCellDisplayEvent.getCellData()).intValue();
                jCCellDisplayEvent.setDisplayData(Level.toLevel(n2).toString());
                break;
            }
        }
    }

    private void _$5268() {
        this._$25703 = new JCCellStyle(this._$274.getDefaultCellStyle());
        this._$25703.setEditable(true);
        this._$25703.setBackground(Color.blue);
        this._$25703.setForeground(Color.white);
        this._$26899 = new JCCellStyle(this._$25703);
        this._$26899.setCellEditor(new LogLevelCellEditor());
        this._$274.setCellStyle(-997, 1, this._$26899);
        for (int i2 = 0; i2 < _$14676.length; ++i2) {
            this._$274.setCharWidth(i2, _$14676[i2]);
        }
        this._$274.setCellEditor(ObjectID.class, new ObjectIDCellEditor(this._$20550));
    }

    public void setConfig(UserConfigFile userConfigFile) {
        this._$5250 = userConfigFile;
    }

    public UserConfigFile getConfig() {
        return this._$5250;
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        Vector<Object> vector = new Vector<Object>(_$1713.length);
        vector.add(new ObjectID());
        vector.add(new Integer(20000));
        vector.add("");
        vector.add("");
        this._$11754.addRow(Integer.MAX_VALUE, null, vector);
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        TableUtils.removeSelectedRows(this._$274, this._$11754);
    }

    public void load() {
        this._$25808();
    }

    public void save() {
        this._$5245.sort();
        Vector<String> vector = new Vector<String>(this._$11754.getNumRows() - 1);
        Vector<String> vector2 = new Vector<String>(this._$11754.getNumRows() - 1);
        Vector<Object> vector3 = new Vector<Object>(this._$11754.getNumRows() - 1);
        Vector<Object> vector4 = new Vector<Object>(this._$11754.getNumRows() - 1);
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            vector.add(this._$274.getDataView().getTableDataItem(i2, 0).toString());
            int n2 = ((Number)this._$274.getDataView().getTableDataItem(i2, 1)).intValue();
            vector2.add(Level.toLevel(n2).toString());
            vector3.add(this._$274.getDataView().getTableDataItem(i2, 2));
            vector4.add(this._$274.getDataView().getTableDataItem(i2, 3));
        }
        this._$5250.putArray("mibexplorer.trap.priorities.OID", vector);
        this._$5250.putArray("mibexplorer.trap.priorities.level", vector2);
        this._$5250.putArray("mibexplorer.trap.priorities.script", vector3);
        this._$5250.putArray("mibexplorer.trap.priorities.comment", vector4);
    }
}

