/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.topology;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.ToolPanelPlugin;
import com.agentpp.explorer.topology.DiscoveryModel;
import com.agentpp.explorer.topology.TopoItem;
import com.agentpp.explorer.topology.TopologyConfigPanel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.snmp4j.netscan.MonitoredVariableBinding;
import com.snmp4j.netscan.NetworkScanner;
import com.snmp4j.netscan.SNMPScanEntity;
import com.snmp4j.netscan.ScanListener;
import com.snmp4j.netscan.ScanOID;
import com.snmp4j.netscan.ScanTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;

public class TopologyPanel
extends JPanel
implements ToolPanelPlugin,
CommandResponder,
JCSelectListener {
    private static Logger _$12571 = Logger.getLogger("Discoverer");
    private static final String[] _$37472 = new String[]{"Repeater", "Bridge", "Gateway", "Host", "Application"};
    private static final String[] _$1713 = new String[]{"Address", "Hostname", "Ping", "Source", "Hops", "Last Contact", "Forwarding", "Interfaces", "Versions", "System Name", "Up Time", "Location", "Contact", "Description", "System ID", "Services"};
    private static final int _$15177 = 0;
    private static final int _$37473 = 1;
    private static final int _$30631 = 8;
    private static final int[] _$14676 = new int[]{10, 10, 4, 10, 5, 11, 5, 5, 5, 8, 10, 10, 15, 20, 10};
    BorderLayout borderLayout1 = new BorderLayout();
    private PopupListTable _$274 = new PopupListTable(){

        public boolean isEditable(int n2, int n3) {
            return false;
        }
    };
    private DiscoveryModel _$11754 = new DiscoveryModel();
    private NetworkScanner _$37474;
    private Hashtable _$7365;
    private JToolBar _$30025 = new JToolBar();
    private JButton _$37475 = new JButton();
    private JButton _$37476 = new JButton();
    private JButton _$37477 = new JButton();
    private UserConfigFile _$5250;
    private Vector _$37478 = new Vector(5);
    private Vector _$37479 = new Vector(5);
    private Vector _$37480 = new Vector();
    private GenTarget _$30639;
    private JScrollPane _$30640 = new JScrollPane();
    private JButton _$14336 = new JButton();
    private transient Vector _$37481;
    private TopologyConfigPanel _$5334;
    private Snmp _$14889;
    private TableSorter _$29674;
    private ScanTask _$37482;

    public TopologyPanel(UserConfigFile userConfigFile, MIBRepository mIBRepository, Snmp snmp, Hashtable hashtable) {
        this();
        this._$5250 = userConfigFile;
        this._$37474 = new NetworkScanner(snmp);
        this._$7365 = hashtable;
        this._$14889 = snmp;
        this._$37482 = new ScanTask();
        this._$11754.setRepository(mIBRepository);
        this._$37483();
        this._$10904();
        if (!this._$37474.isPingAvailable()) {
            this._$274.setColumnHidden(1, true);
        }
    }

    public TopologyPanel() {
        this._$11754.setNumRows(0);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$274.setRowLabelDisplay(false);
        this._$274.setDataSource(this._$11754);
        this._$274.addCellDisplayListener(this._$11754);
        this._$274.addSelectListener(this);
        for (int i2 = 0; i2 < _$14676.length; ++i2) {
            this._$274.setCharWidth(i2, _$14676[i2]);
        }
    }

    private String[] _$37483() {
        this._$37480.setSize(0);
        Vector<OID> vector = new Vector<OID>(Arrays.asList(TopoItem.SYS_OIDS));
        for (int i2 = 0; i2 < TopoItem.SYS_OIDS.length; ++i2) {
            this._$37480.add(new ScanOID(TopoItem.SYS_OIDS[i2], 0));
        }
        Vector vector2 = this._$5250.getArray("mibexplorer.topo.instance");
        Vector vector3 = this._$5250.getArray("mibexplorer.topo.instance.title");
        String[] stringArray = new String[_$1713.length + vector2.size()];
        System.arraycopy(_$1713, 0, stringArray, 0, _$1713.length);
        for (int i3 = 0; i3 < vector2.size(); ++i3) {
            stringArray[TopologyPanel._$1713.length + i3] = (String)vector3.get(i3);
            OID oID = new OID((String)vector2.get(i3));
            vector.add(oID);
            this._$37480.add(new ScanOID(oID, 0));
        }
        this._$11754.setColumnOIDs(vector);
        this._$11754.setNumColumns(stringArray.length);
        this._$11754.setColumnLabels(stringArray);
        this._$29674 = new TableSorter((JCTable)this._$274, (JCVectorDataSource)this._$11754, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof TransportIpAddress && object2 instanceof TransportIpAddress) {
                    byte[] byArray;
                    TransportIpAddress transportIpAddress = (TransportIpAddress)object;
                    TransportIpAddress transportIpAddress2 = (TransportIpAddress)object2;
                    byte[] byArray2 = transportIpAddress.getInetAddress().getAddress();
                    if (byArray2.length != (byArray = transportIpAddress2.getInetAddress().getAddress()).length) {
                        return byArray2.length - byArray.length;
                    }
                    for (int i2 = 0; i2 < byArray2.length; ++i2) {
                        int n2 = (byArray2[i2] & 0xFF) - (byArray[i2] & 0xFF);
                        if (n2 == 0) continue;
                        return n2;
                    }
                    return transportIpAddress.getPort() - transportIpAddress2.getPort();
                }
                if (object == null && object2 == null) {
                    return 0;
                }
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object.toString().compareTo(object2.toString());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        return stringArray;
    }

    private void _$10904() {
        this._$5334 = new TopologyConfigPanel(this._$5250, this._$11754.getRepository());
        this._$5334.setTargets(this._$7365);
        this._$5334.load();
        this.setScanItemsFromTargets(this._$5334.getSeedTargets());
        this._$37482.addScanListener((ScanListener)this._$11754);
        this._$37482.setMaxHops(this._$5250.getInteger("mibexplorer.topo.maxhops", 10));
        this._$37482.setRefreshInterval((long)(this._$5250.getInteger("mibexplorer.topo.refresh", 60) * 1000));
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this._$37475.setToolTipText("Start discovery process");
        this._$37475.setIcon(MIBExplorerFrame.imagePlay16);
        this._$37475.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.startButton_actionPerformed(actionEvent);
            }
        });
        this._$37476.setEnabled(false);
        this._$37476.setToolTipText("Stop discovery process");
        this._$37476.setIcon(MIBExplorerFrame.imageStop16);
        this._$37476.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.stopButton_actionPerformed(actionEvent);
            }
        });
        this._$37477.setToolTipText("Start here to configure seed targets for the discovery and other properties");
        this._$37477.setIcon(MIBExplorerFrame.imagePreferences16);
        this._$37477.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.configButton_actionPerformed(actionEvent);
            }
        });
        this._$14336.setToolTipText("Add selected target(s) to the MIB Explorer configuration/preferences");
        this._$14336.setIcon(MIBExplorerFrame.imageAdd16);
        this._$14336.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$274.setSelectionPolicy(3);
        this.add((Component)this._$274, "Center");
        this.add((Component)this._$30025, "North");
        this._$30025.add((Component)this._$37475, null);
        this._$30025.add((Component)this._$37476, null);
        this._$30025.addSeparator();
        this._$30025.add((Component)this._$14336, null);
        this._$30025.addSeparator();
        this._$30025.add((Component)this._$37477, null);
        this._$14336.setEnabled(false);
    }

    void stopButton_itemStateChanged(ItemEvent itemEvent) {
        this.stop();
    }

    void startButton_itemStateChanged(ItemEvent itemEvent) {
        this.restart();
    }

    void configButton_actionPerformed(ActionEvent actionEvent) {
        this._$5334.setTargets(this._$7365);
        this._$5334.load();
        if (JOptionPane.showConfirmDialog(this, this._$5334, "Discovery Preferences", 2, -1) == 0) {
            this._$5334.save();
            this.setScanItemsFromTargets(this._$5334.getSeedTargets());
            this._$37482.setRefreshInterval((long)(this._$5250.getInteger("mibexplorer.topo.refresh", 60) * 1000));
            this.restart();
        }
    }

    public void setScanItemsFromTargets(Vector vector) {
        this._$37478 = new Vector(vector.size() + 1);
        if (vector.size() == 0) {
            if (this._$30639 != null) {
                this._$37478.add(this._$30639.getTarget());
            }
        } else {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                GenTarget genTarget = (GenTarget)vector.get(i2);
                if (genTarget == null) continue;
                this._$37478.add(genTarget.getTarget());
            }
        }
    }

    public void restart() {
        this.stop();
        this._$11754.reset();
        this._$37483();
        this._$37482.getScannedEntities().clear();
        this.start();
    }

    public UserConfigFile getConfig() {
        return this._$5250;
    }

    public void start() {
        try {
            this._$37482.getSeeds().clear();
            Iterator iterator = this._$37478.iterator();
            while (iterator.hasNext()) {
                this._$37482.addSeed((Target)iterator.next());
            }
            this._$37482.setScanOIDs((Vector)this._$37480.clone());
            this._$37474.start(this._$37482);
            this._$37475.setEnabled(false);
            this._$37476.setEnabled(true);
            _$12571.info("Discovering started...");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$12571.error(exception);
        }
    }

    public void stop() {
        this._$37476.setEnabled(false);
        this._$37474.stop(this._$37482);
        _$12571.warn("Discoverer stopped, found " + this._$37482.getScannedEntities().size() + " NEs");
        this._$37475.setEnabled(true);
    }

    public void setTarget(GenTarget genTarget) {
        this._$30639 = genTarget;
    }

    public void setTargets(Hashtable hashtable) {
        this._$7365 = hashtable;
    }

    void startButton_actionPerformed(ActionEvent actionEvent) {
        this.restart();
    }

    void stopButton_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(){

            public void run() {
                TopologyPanel.this.stop();
            }
        };
        thread.start();
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        this._$14336.setEnabled(false);
        this.addTargets();
    }

    public void addTargets() {
        int[] nArray = TableUtils.getSelectedRows(this._$274);
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "No targets selected!", "No Selection", 2);
            this._$14336.setEnabled(true);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            MonitoredVariableBinding monitoredVariableBinding = (MonitoredVariableBinding)this._$11754.getTableDataItem(nArray[i2], 8);
            String string = "";
            if (monitoredVariableBinding == null || monitoredVariableBinding.getVariable() == null || !(monitoredVariableBinding.getVariable() instanceof OctetString)) {
                ++n3;
                continue;
            }
            string = ((OctetString)monitoredVariableBinding.getVariable()).toString();
            TopoItem topoItem = (TopoItem)this._$11754.getTableRowLabel(nArray[i2]);
            if (topoItem.getDiscoveredItem() instanceof SNMPScanEntity) {
                SNMPScanEntity sNMPScanEntity = (SNMPScanEntity)topoItem.getDiscoveredItem();
                GenTarget genTarget = new GenTarget(sNMPScanEntity.getScanTarget(), string);
                if (sNMPScanEntity.getScanTarget() instanceof UserTarget) {
                    UserTarget userTarget = (UserTarget)sNMPScanEntity.getScanTarget();
                    UsmUserEntry usmUserEntry = this._$14889.getUSM().getUser(genTarget.getEngineID(), userTarget.getSecurityName());
                    if (usmUserEntry == null) {
                        _$12571.warn("User " + userTarget.getSecurityName() + " not found in USM! Skipping target " + sNMPScanEntity.getScanTarget());
                        continue;
                    }
                    genTarget.setUser(new UserProfile(userTarget.getSecurityName().toString(), usmUserEntry.getUsmUser()));
                } else {
                    genTarget.setCommunity(((CommunityTarget)sNMPScanEntity.getScanTarget()).getCommunity());
                }
                this.fireTargetChanged(new GenTargetEvent(this, genTarget, 1));
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n3 == 0) {
            JOptionPane.showMessageDialog(this, "Added " + n2 + " target(s) successfully!", "Discovered Targets Added", 1);
        } else {
            JOptionPane.showMessageDialog(this, new String[]{"Added " + n2 + " target(s) successfully, but skipped ", "" + n3 + " because of insufficient information!"}, "Discovered Targets Added", 2);
        }
        this._$14336.setEnabled(true);
    }

    public synchronized void removeGenTargetListener(GenTargetListener genTargetListener) {
        if (this._$37481 != null && this._$37481.contains(genTargetListener)) {
            Vector vector = (Vector)this._$37481.clone();
            vector.removeElement(genTargetListener);
            this._$37481 = vector;
        }
    }

    public synchronized void addGenTargetListener(GenTargetListener genTargetListener) {
        Vector vector;
        Vector vector2 = vector = this._$37481 == null ? new Vector(2) : (Vector)this._$37481.clone();
        if (!vector.contains(genTargetListener)) {
            vector.addElement(genTargetListener);
            this._$37481 = vector;
        }
    }

    protected void fireTargetChanged(GenTargetEvent genTargetEvent) {
        if (this._$37481 != null) {
            Vector vector = this._$37481;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((GenTargetListener)vector.elementAt(i2)).targetChanged(genTargetEvent);
            }
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$14336.setEnabled(TableUtils.getSelectedRows(this._$274).length > 0);
    }

    public void processPdu(CommandResponderEvent commandResponderEvent) {
        if (this._$37482.getSeeds().size() > 0) {
            if (_$12571.isInfoEnabled()) {
                _$12571.info("Adding seed " + commandResponderEvent.getPeerAddress() + " received from notification: " + commandResponderEvent);
            }
            Target target = (Target)this._$37482.getSeeds().get(0);
            target = (Target)target.clone();
            target.setAddress(commandResponderEvent.getPeerAddress());
            this._$37482.addSeed(target);
        }
    }

    public boolean onExit() {
        return false;
    }
}

