/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.topology;

import com.agentpp.explorer.topology.TopoItem;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.snmp4j.netscan.MonitoredVariableBinding;
import com.snmp4j.netscan.SNMPScanEntity;
import com.snmp4j.netscan.ScanEntity;
import com.snmp4j.netscan.ScanEvent;
import com.snmp4j.netscan.ScanListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DiscoveryModel
extends JCEditableVectorDataSource
implements ScanListener,
JCCellDisplayListener {
    private static final Logger _$12571 = Logger.getLogger("Discovery");
    private static final String _$28744 = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat _$30558 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final String[] _$37472 = new String[]{"Repeater", "Bridge", "Gateway", "Host", "Application"};
    private Hashtable _$30560 = new Hashtable(25);
    private Hashtable _$37706 = new Hashtable(25);
    private Vector _$30562;
    private MIBRepository _$20550;
    private boolean _$28178 = false;

    protected void addRow(TopoItem topoItem) {
        Vector<Object> vector = new Vector<Object>(super.getNumColumns());
        Integer n2 = null;
        if (topoItem.getDiscoveredItem() != null) {
            StringBuffer stringBuffer;
            ScanEntity scanEntity = topoItem.getDiscoveredItem();
            n2 = (Integer)this._$37706.get(topoItem.getKey());
            vector.add(topoItem.getDiscoveredItem().getAddress());
            vector.add(scanEntity.getDns());
            vector.add(new Boolean(scanEntity.isReachable()));
            if (topoItem.getDiscoveredItem().getSource() != null) {
                vector.add(topoItem.getDiscoveredItem().getSource().getAddress());
            } else {
                vector.add(null);
            }
            vector.add(new Integer(scanEntity.getHopsFromRoot()));
            vector.add(new Date(scanEntity.getLastUpdateTime()));
            MonitoredVariableBinding monitoredVariableBinding = scanEntity.getVariable((OID)this._$30562.get(1));
            if (monitoredVariableBinding != null && monitoredVariableBinding.getVariable() instanceof Integer32) {
                int n3 = ((Integer32)monitoredVariableBinding.getVariable()).getValue();
                vector.add(n3 == 1 ? new Boolean(true) : new Boolean(false));
            } else {
                vector.add(null);
            }
            MonitoredVariableBinding monitoredVariableBinding2 = scanEntity.getVariable((OID)this._$30562.get(0));
            if (monitoredVariableBinding2 != null && monitoredVariableBinding2.getVariable() instanceof Integer32) {
                vector.add(monitoredVariableBinding2.getVariable());
            } else {
                vector.add("-");
            }
            if (!(scanEntity instanceof SNMPScanEntity)) {
                vector.add("?");
            } else {
                SNMPScanEntity sNMPScanEntity = (SNMPScanEntity)scanEntity;
                stringBuffer = new StringBuffer(10);
                if (sNMPScanEntity.isSNMPv1()) {
                    stringBuffer.append("v1");
                }
                if (sNMPScanEntity.isSNMPv2c()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("v2c");
                }
                if (sNMPScanEntity.isSNMPv3()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("v3");
                }
                vector.add(stringBuffer.toString());
            }
            for (int i2 = 2; i2 < this._$30562.size(); ++i2) {
                stringBuffer = scanEntity.getVariable((OID)this._$30562.get(i2));
                if (stringBuffer != null) {
                    vector.add(stringBuffer);
                    continue;
                }
                vector.add(null);
            }
        }
        if (n2 != null) {
            this._$30560.put(topoItem.getKey(), n2);
            this._$37706.put(topoItem.getKey(), n2);
            if (topoItem.getDiscoveredItem() != null) {
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    super.setTableDataItem(vector.get(i3), n2, i3);
                }
            }
        } else {
            n2 = new Integer(super.getNumRows());
            super.addRow(Integer.MAX_VALUE, topoItem, vector);
            this._$30560.put(topoItem.getKey(), n2);
            this._$37706.put(topoItem.getKey(), n2);
        }
    }

    private String _$23000(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < _$37472.length; ++i2) {
            if ((n2 & 1 << i2) <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(_$37472[i2]);
        }
        return stringBuffer.toString();
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() != null) {
            if (!this._$28178 && jCCellDisplayEvent.getDisplayData() instanceof MonitoredVariableBinding && ((MonitoredVariableBinding)jCCellDisplayEvent.getDisplayData()).getVariable() instanceof OID) {
                ObjectID objectID = new ObjectID(((Object)((MonitoredVariableBinding)jCCellDisplayEvent.getDisplayData()).getVariable()).toString());
                String string = this._$20550.getObjectName(objectID);
                if (string == null) {
                    string = this._$20550.getPathSuffix(objectID);
                }
                if (string != null) {
                    jCCellDisplayEvent.setDisplayData(string);
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof MonitoredVariableBinding) {
                MonitoredVariableBinding monitoredVariableBinding = (MonitoredVariableBinding)jCCellDisplayEvent.getCellData();
                Variable variable = monitoredVariableBinding.getVariable();
                if (monitoredVariableBinding.getOid().equals(TopoItem.SYS_OIDS[8])) {
                    if (variable instanceof Integer32) {
                        jCCellDisplayEvent.setDisplayData(this._$23000(((Integer32)variable).getValue()));
                    } else {
                        jCCellDisplayEvent.setDisplayData(((Object)variable).toString());
                    }
                } else {
                    jCCellDisplayEvent.setDisplayData(((Object)variable).toString());
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                jCCellDisplayEvent.setDisplayData(this._$30558.format((Date)jCCellDisplayEvent.getCellData()));
            }
        }
    }

    public void reset() {
        this._$30560.clear();
        this._$37706.clear();
        super.setNumRows(0);
    }

    public Vector getColumnOIDs() {
        return this._$30562;
    }

    public void setColumnOIDs(Vector vector) {
        this._$30562 = vector;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$20550 = mIBRepository;
    }

    public MIBRepository getRepository() {
        return this._$20550;
    }

    public void onScanEvent(ScanEvent scanEvent) {
        ScanEntity scanEntity = scanEvent.getScanEntity();
        if (scanEvent.getType() == 1) {
            _$12571.info("Network item discovered: " + scanEntity);
        }
        this.addRow(new TopoItem(scanEntity));
    }
}

