/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.common.WizardEvent;
import com.agentpp.common.WizardListener;
import com.agentpp.explorer.snapshots.SnapshotSelectionPanel_jButtonChooseFile_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotSelectionPanel_jRadioButtonFile_itemAdapter;
import com.agentpp.util.ExampleFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SnapshotSelectionPanel
extends JPanel {
    transient Vector wizardListeners = new Vector(1);
    public static final int SNAPSHOT_CANCEL = 0;
    public static final int SNAPSHOT_TREE = 1;
    public static final int SNAPSHOT_BROWSE = 2;
    public static final int SNAPSHOT_FILE = 3;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JRadioButton jRadioButtonTree = new JRadioButton();
    JRadioButton jRadioButtonBrowse = new JRadioButton();
    JRadioButton jRadioButtonFile = new JRadioButton();
    JTextField jTextFieldFile = new JTextField();
    JButton jButtonChooseFile = new JButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    private String _$39964 = "";
    private boolean _$39969;

    public synchronized void addWizardListener(WizardListener wizardListener) {
        this.wizardListeners.add(wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        this.wizardListeners.remove(wizardListener);
    }

    protected void fireUpdateWizardState(WizardEvent wizardEvent) {
        if (this.wizardListeners != null) {
            Vector vector = this.wizardListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((WizardListener)vector.elementAt(i2)).updateWizardState(wizardEvent);
            }
        }
    }

    protected void firePack() {
        if (this.wizardListeners != null) {
            Vector vector = this.wizardListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((WizardListener)vector.elementAt(i2)).pack();
            }
        }
    }

    public SnapshotSelectionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.jRadioButtonTree.setHorizontalAlignment(10);
        this.jRadioButtonTree.setText("Take Snapshot from MIB Tree");
        this.setLayout(this.gridBagLayout1);
        this.jRadioButtonBrowse.setHorizontalAlignment(2);
        this.jRadioButtonBrowse.setText("Take Snapshot from Browse Panel");
        this.jRadioButtonFile.setText("Load Snapshot from File:");
        this.jRadioButtonFile.addItemListener(new SnapshotSelectionPanel_jRadioButtonFile_itemAdapter(this));
        this.jTextFieldFile.setText("");
        this.jButtonChooseFile.setText("Choose...");
        this.jButtonChooseFile.addActionListener(new SnapshotSelectionPanel_jButtonChooseFile_actionAdapter(this));
        this.add((Component)this.jRadioButtonTree, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jRadioButtonBrowse, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jRadioButtonFile, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jTextFieldFile, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.jButtonChooseFile, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.buttonGroup.add(this.jRadioButtonTree);
        this.buttonGroup.add(this.jRadioButtonBrowse);
        this.buttonGroup.add(this.jRadioButtonFile);
        this.jRadioButtonFile.setSelected(true);
    }

    void jRadioButtonFile_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jTextFieldFile.setEnabled(true);
            this.jButtonChooseFile.setEnabled(true);
        } else {
            this.jTextFieldFile.setEnabled(false);
            this.jButtonChooseFile.setEnabled(false);
        }
        this.fireUpdateWizardState(new WizardEvent(this, this.isReady(), this.isFinishEnabled() && this.isReady()));
    }

    public boolean isReady() {
        File file;
        return this.getSelection() != 3 || (file = this.getSnapshotFile()).exists() && file.canRead();
    }

    public int getSelection() {
        if (this.jRadioButtonTree.isSelected()) {
            return 1;
        }
        if (this.jRadioButtonBrowse.isSelected()) {
            return 2;
        }
        return 3;
    }

    void jButtonChooseFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$39964);
        jFileChooser.setDialogTitle("Load Snapshot from File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("sf", "Snapshot Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jFileChooser.getSelectedFile().getPath());
            this._$39964 = jFileChooser.getSelectedFile().getParent();
        }
        this.fireUpdateWizardState(new WizardEvent(this, this.isReady(), this.isFinishEnabled() && this.isReady()));
    }

    public File getSnapshotFile() {
        return new File(this.jTextFieldFile.getText());
    }

    public String getSnapshotDir() {
        return this._$39964;
    }

    public boolean isFinishEnabled() {
        return this._$39969;
    }

    public void setSnapshotDir(String string) {
        this._$39964 = string;
    }

    public void setFinishEnabled(boolean bl) {
        this._$39969 = bl;
    }
}

