/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.StandardWizard;
import com.agentpp.common.WizardStepList;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.cfg.MIBExplorerConfig;
import com.agentpp.explorer.snapshots.SnapshotComparisonPanel;
import com.agentpp.explorer.snapshots.SnapshotModel;
import com.agentpp.explorer.snapshots.SnapshotPanel;
import com.agentpp.explorer.snapshots.SnapshotSelectionPanel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.UserConfigFile;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.snmp4j.Snmp;

public class SnapshotCompareWizard {
    private Snmp _$14889;
    private UserConfigFile _$5250;
    StandardWizard[] dialogs = new StandardWizard[3];
    SnapshotSelectionPanel[] selectionPanels = new SnapshotSelectionPanel[2];
    SnapshotComparisonPanel comparisonPanel = new SnapshotComparisonPanel();
    private MIBExplorerFrame _$25700;
    private MIBRepository _$20550;
    private GenTarget _$15220;
    private static final String[] _$25678 = new String[]{"Select First Snapshot", "Select Second Snapshot", "Comparison Parameters"};
    private static final String[] _$38040 = new String[]{"Choose the source of the first (left) snapshot between tree, browse panel, or file.", "Choose the source for the second (right) snapshot to be compared with the first between tree, browse panel, or file.", "Select which syntaxes to include in the comparison. Instances whose syntax is excluded from comparison will only be compared regarding their presence not by their values. In addition, please specify whether only instances present in both snapshots should be compared."};

    public SnapshotCompareWizard(MIBExplorerFrame mIBExplorerFrame, MIBRepository mIBRepository, Snmp snmp, UserConfigFile userConfigFile, GenTarget genTarget) {
        this._$25700 = mIBExplorerFrame;
        this._$14889 = snmp;
        this._$5250 = userConfigFile;
        this._$20550 = mIBRepository;
        this._$15220 = genTarget;
    }

    public boolean init() {
        this.comparisonPanel.setPreferredSize(MIBExplorerConfig.getStandardDialogDimension(this._$5250));
        for (int i2 = 0; i2 < 2; ++i2) {
            this.dialogs[i2] = new StandardWizard(this._$25700, _$25678[i2], true);
            this.dialogs[i2].setPrevButtonEnabled(i2 > 0);
            this.dialogs[i2].setFinishButtonEnabled(i2 == 1);
            this.dialogs[i2].setNextButtonEnabled(true);
            this.dialogs[i2].setLeftPanel(new WizardStepList(null, new Vector<String>(Arrays.asList(_$38040)), i2));
            this.selectionPanels[i2] = new SnapshotSelectionPanel();
            this.selectionPanels[i2].setSnapshotDir(this._$5250.get("mibexplorer.snapshot.dir", ""));
            this.selectionPanels[i2].setPreferredSize(new Dimension(500, 500));
            this.dialogs[i2].setCenterPanel(this.selectionPanels[i2]);
            this.selectionPanels[i2].addWizardListener(this.dialogs[i2]);
        }
        this.selectionPanels[1].setFinishEnabled(true);
        this.dialogs[2] = new StandardWizard(this._$25700, _$25678[2], true);
        this.dialogs[2].setPrevButtonEnabled(true);
        this.dialogs[2].setFinishButtonEnabled(true);
        this.dialogs[2].setNextButtonEnabled(false);
        this.dialogs[2].setLeftPanel(new WizardStepList(null, new Vector<String>(Arrays.asList(_$38040)), 2));
        this.dialogs[2].setCenterPanel(this.comparisonPanel);
        return true;
    }

    public void show() {
        this.dialogs[0].setCenterPanel(this.selectionPanels[0]);
        int n2 = 0;
        int n3 = 0;
        do {
            n3 = n2;
            this._$38044(n2);
            this.dialogs[n2].setLocationRelativeTo(this._$25700);
            this.dialogs[n2].setVisible(true);
            if (!this._$38045(n2, this.dialogs[n2].getResult())) continue;
            n2 += this.dialogs[n2].getResult();
        } while (this.dialogs[n3].getResult() != 2 && this.dialogs[n3].getResult() != 0);
        if (this.dialogs[n3].getResult() == 2) {
            this.compare();
        }
    }

    protected void compare() {
        SnapshotPanel snapshotPanel = new SnapshotPanel(this._$14889, this._$15220, this._$5250, true);
        SnapshotModel snapshotModel = new SnapshotModel();
        for (int i2 = 0; i2 < 2; ++i2) {
            List list = null;
            switch (this.selectionPanels[i2].getSelection()) {
                case 2: {
                    list = this._$25700.getBrowseSnapshot();
                    list = MIBExplorerFrame.convertToSerializableInstances(list);
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
                case 1: {
                    list = this._$25700.getTreeSnapshot();
                    list = MIBExplorerFrame.convertToSerializableInstances(list);
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
                case 3: {
                    File file = this.selectionPanels[i2].getSnapshotFile();
                    FileInputStream fileInputStream = null;
                    ObjectInputStream objectInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        try {
                            list = (List)objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this._$25700, new String[]{"The file '" + file.getPath() + "' is not a valid snapshot file!"}, "File Format Error", 0);
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this._$25700, new String[]{"The file '" + file.getPath() + "' cannot be read: ", iOException.getMessage()}, "File Format Error", 0);
                        return;
                    }
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
            }
            if (i2 == 0) {
                snapshotModel.setInstances(list);
                continue;
            }
            snapshotModel.setInstances2Compare(list);
        }
        snapshotModel.setCompareTuplesOnly(this.comparisonPanel.isCompareOnlyPresent());
        snapshotModel.setSyntaxes2Compare(this.comparisonPanel.getSelectedSyntaxes());
        snapshotModel.setRepository(this._$20550);
        snapshotModel.buildTree();
        snapshotPanel.setModel(snapshotModel);
        StandardDialog standardDialog = new StandardDialog((Frame)this._$25700, "Snapshot Comparison Browser - " + this._$15220.toString(), false, false);
        standardDialog.setCenterPanel(snapshotPanel);
        standardDialog.setSize(900, 600);
        standardDialog.setLocationRelativeTo(this._$25700);
        standardDialog.setVisible(true);
    }

    private boolean _$38045(int n2, int n3) {
        if (n3 != 1) {
            return true;
        }
        if (n2 == 0 || n2 == 1) {
            File file;
            if (!(this.selectionPanels[n2].getSelection() != 3 || (file = this.selectionPanels[n2].getSnapshotFile()).exists() && file.canRead())) {
                String[] stringArray = new String[]{"The snapshot file '" + file.getPath() + "' cannot be read or does not exists.", "Please choose a different file or snapshot source!"};
                JOptionPane.showMessageDialog(this._$25700, stringArray, "Snapshot File Error", 0);
                return false;
            }
        } else if (n2 == 2 && this.comparisonPanel.getSelectedSyntaxes().length == 0) {
            String[] stringArray = new String[]{"Please select at least one SMI base syntax to be compared!", "Otherwise a comparison does not make any sense, since an", "empty comparison tree would have to be displayed."};
            JOptionPane.showMessageDialog(this._$25700, stringArray, "Invalid Comparison", 0);
            return false;
        }
        return true;
    }

    private void _$38044(int n2) {
        File file;
        if (!(n2 != 0 && n2 != 1 || this.selectionPanels[n2].getSelection() != 3 || (file = this.selectionPanels[n2].getSnapshotFile()).exists() && file.canRead())) {
            this.dialogs[n2].setFinishButtonEnabled(false);
            this.dialogs[n2].setNextButtonEnabled(false);
            return;
        }
        if (n2 < 2) {
            this.dialogs[n2].setNextButtonEnabled(true);
        }
        if (n2 == 1) {
            this.dialogs[n2].setFinishButtonEnabled(true);
        }
    }
}

