/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.explorer.SMITableUtils;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.snapshots.SnapshotModel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ProgressMonitor;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.VariableBinding;

public class RefreshTask
implements Runnable {
    private static final Logger _$12571 = Logger.getLogger("Snapshots");
    private Snmp _$14889;
    private GenTarget _$15220;
    private SnapshotModel _$39799;
    private ProgressMonitor _$30269;
    private MIBRepository _$20550;
    private SnmpLogger _$30270;
    private int _$50182 = 0;
    private int _$39860 = 1;
    private Runnable _$50156;

    public RefreshTask(Snmp snmp, GenTarget genTarget, SnapshotModel snapshotModel, ProgressMonitor progressMonitor, Runnable runnable) {
        this._$14889 = snmp;
        this._$15220 = genTarget;
        this._$39799 = snapshotModel;
        this._$30269 = progressMonitor;
        this._$20550 = snapshotModel.getRepository();
        this._$30270 = new SnmpLogger(this._$20550);
        this._$50156 = runnable;
    }

    public void run() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._$39799.getRoot();
        TreeMap treeMap = new TreeMap();
        this._$30269.setMinimum(0);
        this._$30269.setMaximum(this._$39799.getRowCount());
        int n2 = 0;
        LinkedList<SnapshotModel.SnapshotNode> linkedList = new LinkedList<SnapshotModel.SnapshotNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements() && !this._$30269.isCanceled()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            SnapshotModel.SnapshotNode snapshotNode = (SnapshotModel.SnapshotNode)defaultMutableTreeNode2.getUserObject();
            if (snapshotNode == null) continue;
            snapshotNode.setStatus(null);
            if (snapshotNode.getInstance(this._$50182) == null) continue;
            this._$30269.setProgress(++n2);
            this._$30269.setNote(SMITableUtils.getPathSuffixWithIndex(this._$20550, snapshotNode.getOID()));
            linkedList.add(snapshotNode);
            if (linkedList.size() < this._$39860) continue;
            this._$9681(linkedList);
            linkedList.clear();
        }
        if (linkedList.size() > 0) {
            this._$9681(linkedList);
            linkedList.clear();
        }
        this._$39799.fireTableChanged(new TableModelEvent(this._$39799));
        this._$30269.close();
        this._$50156.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer32 _$9681(List list) {
        BERSerializable bERSerializable;
        Object object;
        Target target = this._$15220.getTarget();
        PDU pDU = this._$15220.makePDU();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SnapshotModel.SnapshotNode)object2.next();
            bERSerializable = new VariableBinding();
            bERSerializable.setOid(((SnapshotModel.SnapshotNode)object).getInstance(this._$50182).getOid());
            pDU.add((VariableBinding)bERSerializable);
        }
        object = object2 = new RespListener();
        synchronized (object) {
            try {
                this._$14889.get(pDU, target, null, (ResponseListener)object2);
            }
            catch (IOException iOException) {
                _$12571.error("Could not send refresh request: " + iOException.getMessage());
            }
            SnmpLogger.logRequest(pDU, this._$15220, false);
            try {
                object2.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bERSerializable = ((RespListener)object2).getEvent().getResponse();
            this._$30270.logResponse(((RespListener)object2).getEvent().getPeerAddress(), ((RespListener)object2).getEvent().getRequest(), (PDU)bERSerializable, false);
            return this._$50170((PDU)bERSerializable, list);
        }
    }

    private void _$50171(List list, String string) {
        for (SnapshotModel.SnapshotNode snapshotNode : list) {
            snapshotNode.setStatus(string);
        }
    }

    private Integer32 _$50170(PDU pDU, List list) {
        if (pDU == null) {
            this._$50171(list, "Timeout");
            return null;
        }
        if (pDU.getErrorStatus() != 0) {
            if (pDU.getErrorIndex() > 0) {
                int n2 = pDU.getErrorIndex() - 1;
                if (n2 >= 0 && n2 < list.size()) {
                    this._$50171(list, "Not Refreshed");
                    ((SnapshotModel.SnapshotNode)list.get(n2)).setStatus(pDU.getErrorStatusText());
                } else {
                    this._$50171(list, pDU.getErrorStatusText());
                }
            } else {
                this._$50171(list, pDU.getErrorStatusText());
            }
        } else {
            this._$50171(list, "Refreshed");
        }
        return new Integer32(pDU.getErrorStatus());
    }

    public void setSession(Snmp snmp) {
        this._$14889 = snmp;
    }

    public void setTarget(GenTarget genTarget) {
        this._$15220 = genTarget;
    }

    public void setSnapshotModel(SnapshotModel snapshotModel) {
        this._$39799 = snapshotModel;
    }

    public void setColumn2Update(int n2) {
        this._$50182 = n2;
    }

    public void setMaxVBsPerPDU(int n2) {
        this._$39860 = n2;
    }

    public Session getSession() {
        return this._$14889;
    }

    public GenTarget getTarget() {
        return this._$15220;
    }

    public SnapshotModel getSnapshotModel() {
        return this._$39799;
    }

    public int getColumn2Update() {
        return this._$50182;
    }

    public int getMaxVBsPerPDU() {
        return this._$39860;
    }

    class RespListener
    implements ResponseListener {
        private ResponseEvent _$539 = null;

        RespListener() {
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            this._$539 = responseEvent;
            this.notify();
        }

        public ResponseEvent getEvent() {
            return this._$539;
        }
    }
}

