/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor.db;

import com.agentpp.common.table.RoundRobinDataSource;
import com.agentpp.common.table.RoundRobinEvent;
import com.agentpp.common.table.RoundRobinListener;
import com.agentpp.explorer.MIBExplorerRemoteServer;
import com.agentpp.explorer.monitor.Monitor2XML;
import com.agentpp.explorer.monitor.MonitorObserver;
import com.agentpp.explorer.monitor.MonitorProperty;
import com.agentpp.explorer.monitor.MonitorServer;
import com.agentpp.slimdao.Parameter;
import com.agentpp.slimdao.ParameterRenderer;
import com.agentpp.slimdao.ParameterValue;
import com.agentpp.slimdao.SQLParameterRenderer;
import com.agentpp.slimdao.SlimDAO;
import com.agentpp.slimdao.SlimDAOImpl;
import com.agentpp.slimdao.SlimResult;
import com.agentpp.slimdao.SlimStatement;
import com.agentpp.slimdao.SlimUpdateResult;
import com.agentpp.slimdao.StatementRepository;
import com.agentpp.slimdao.parser.ParameterResolver;
import com.agentpp.slimdao.sql.PlaceholderParameter;
import com.agentpp.slimdao.xml.StatementCacheXML;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monitor2DB
implements RoundRobinListener,
MIBExplorerRemoteServer {
    private static final Logger _$12571 = Logger.getLogger("Monitor.DB");
    private Connection _$42391;
    private boolean _$42392 = true;
    private String _$14367;
    private String _$42385;
    private SlimDAO _$42393;
    private Map<String, SlimStatement> _$42394 = new HashMap<String, SlimStatement>(5);

    public Monitor2DB(String string, final String string2, String string3) {
        InputStream inputStream;
        String string4 = "internal storage";
        if (string3 == null || string3.trim().length() == 0) {
            inputStream = Monitor2DB.class.getResourceAsStream("Monitor2DB.xml");
        } else {
            try {
                inputStream = new FileInputStream(string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException.getMessage());
            }
            string4 = string3;
        }
        StatementCacheXML statementCacheXML = new StatementCacheXML(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        _$12571.info("DB configuration loaded from " + string4);
        this._$42393 = new SlimDAOImpl((StatementRepository)statementCacheXML, string, (ParameterRenderer)new SQLParameterRenderer(), new ParameterResolver(){

            public Parameter resolve(String string) {
                if ("SCHEMA".equals(string)) {
                    return new ParameterValue("SCHEMA", (Object)string2);
                }
                return new PlaceholderParameter(string);
            }
        });
    }

    public void connect(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException {
        this._$42385 = string2;
        this._$14367 = string;
        try {
            Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this._$42391 = DriverManager.getConnection(string, properties);
    }

    public void close() {
        try {
            this._$42391.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getSchemaVersion() {
        try {
            SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "check.schema");
            SlimResult slimResult = this._$42393.executeQuery(slimStatement);
            boolean bl = slimResult.getResultSet().next();
            if (bl) {
                return slimResult.getResultSet().getInt(1);
            }
            slimResult.close();
            slimStatement.close();
        }
        catch (SQLException sQLException) {
            _$12571.warn("SLQException while getting schema version: " + sQLException.getMessage(), sQLException);
        }
        return -1;
    }

    public void createSchema() throws SQLException {
        List list = this._$42393.createScript(this._$42391, "create.schema", Collections.emptyMap());
        for (SlimStatement slimStatement : list) {
            this._$42393.executeUpdate(slimStatement);
        }
    }

    public Long saveMonitorToDB(String string, Long l2, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, OutputStream outputStream) throws IOException, SQLException {
        if (l2 == null) {
            l2 = this._$11685("MONITOR");
        } else {
            this.deleteMonitor(l2);
        }
        monitorProperty.setId(l2);
        this._$42415(l2, string, monitorProperty, jCEditableVectorDataSource, " ");
        Properties properties = new Properties();
        properties.put("jdbc.url", this._$14367);
        properties.put("jdbc.driver", this._$42385);
        properties.put("monitor.name", string);
        properties.put("monitor.id", l2.toString());
        properties.store(outputStream, null);
        return l2;
    }

    public boolean updateMonitorNewStatus(Long l2, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("ID", l2);
        hashMap.put("NEXT_STATUS", string);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "update.next.status", hashMap);
        SlimUpdateResult slimUpdateResult = this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        return slimUpdateResult.updateCount() > 0;
    }

    public boolean updateMonitorStatus(Long l2, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("ID", l2);
        hashMap.put("STATUS", string);
        hashMap.put("NEXT_STATUS", " ");
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "update.monitor.status", hashMap);
        int n2 = this._$42393.executeUpdate(slimStatement).updateCount();
        slimStatement.close();
        if (_$12571.isDebugEnabled()) {
            _$12571.debug("Status update to " + string + " for id=" + l2 + " is " + n2);
        }
        return n2 > 0;
    }

    public void updateMonitor(Long l2, String string, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, String string2, boolean bl) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Monitor2XML.convert2XML((MonitorProperty)monitorProperty, (JCEditableVectorDataSource)jCEditableVectorDataSource, (OutputStream)byteArrayOutputStream, (boolean)false);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("NAME", string);
        hashMap.put("CONFIGXML", new ParameterValue("CONFIGXML", (Object)byteArrayInputStream, 2005, byteArrayOutputStream.size()));
        hashMap.put("NEXT_STATUS", string2);
        hashMap.put("ID", l2);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "update.monitor", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        if (bl) {
            this._$42423(l2);
            RoundRobinDataSource roundRobinDataSource = monitorProperty.getData();
            this._$42425(l2, null, roundRobinDataSource, 0);
            for (int i2 = 0; i2 < monitorProperty.getConsolidationConfig().size(); ++i2) {
                roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(i2);
                this._$42425(l2, null, roundRobinDataSource, i2 + 1);
            }
        }
    }

    private void _$42415(Long l2, String string, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, String string2) throws SQLException, IOException {
        boolean bl = false;
        if (l2 == null) {
            l2 = this._$11685("MONITOR");
            bl = true;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Monitor2XML.convert2XML((MonitorProperty)monitorProperty, (JCEditableVectorDataSource)jCEditableVectorDataSource, (OutputStream)byteArrayOutputStream, (boolean)false);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("ID", l2);
        hashMap.put("NAME", string);
        hashMap.put("CONFIGXML", new ParameterValue("CONFIGXML", (Object)byteArrayInputStream, 2005, byteArrayOutputStream.size()));
        hashMap.put("NEXT_STATUS", string2);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "insert.monitor", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        RoundRobinDataSource roundRobinDataSource = monitorProperty.getData();
        this._$42425(l2, bl ? null : roundRobinDataSource.getId(), roundRobinDataSource, 0);
        for (int i2 = 0; i2 < monitorProperty.getConsolidationConfig().size(); ++i2) {
            roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(i2);
            this._$42425(l2, bl ? null : roundRobinDataSource.getId(), roundRobinDataSource, i2 + 1);
        }
    }

    private Long _$42425(Long l2, Long l3, RoundRobinDataSource roundRobinDataSource, int n2) throws SQLException {
        SlimStatement slimStatement;
        SlimStatement[] slimStatementArray;
        if (l3 == null) {
            l3 = this._$42428(l2, roundRobinDataSource.getName(), n2);
            roundRobinDataSource.setId(l3);
        }
        if (l3 == null) {
            l3 = this._$11685("MONITORDATASET");
            roundRobinDataSource.setId(l3);
            slimStatementArray = roundRobinDataSource.getName();
            slimStatement = this._$42393.createStatement(this._$42391, "insert.monitor.dataset", new Parameter[]{new ParameterValue("ID", (Object)l3), new ParameterValue("MONITOR_ID", (Object)l2), new ParameterValue("NAME", slimStatementArray == null ? "" : slimStatementArray), new ParameterValue("DATATYPE", (Object)new Integer(n2))});
            this._$42393.executeUpdate(slimStatement);
            slimStatement.close();
        } else {
            slimStatementArray = roundRobinDataSource.getName();
            slimStatement = this._$42393.createStatement(this._$42391, "update.monitor.dataset", new Parameter[]{new ParameterValue("NAME", slimStatementArray == null ? "" : slimStatementArray), new ParameterValue("DATATYPE", (Object)new Integer(n2)), new ParameterValue("ID", (Object)l3)});
            this._$42393.executeUpdate(slimStatement);
            slimStatement.close();
            this.deleteDataSetRows(l3);
        }
        slimStatement = null;
        slimStatementArray = this._$42431();
        slimStatement = slimStatementArray[0];
        for (int i2 = 0; i2 < roundRobinDataSource.getNumRows(); ++i2) {
            this._$39312(l3, roundRobinDataSource, slimStatementArray, i2);
        }
        if (this._$42392) {
            this._$42393.executeBatch(slimStatement);
            this._$42393.executeBatch(slimStatementArray[1]);
        }
        List list = roundRobinDataSource.getLastSamples();
        int n3 = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        SlimStatement[] slimStatementArray2 = list.iterator();
        while (slimStatementArray2.hasNext()) {
            Long l4 = this._$11685("MONITORDATAROW");
            RoundRobinEvent roundRobinEvent = (RoundRobinEvent)slimStatementArray2.next();
            java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
            hashMap.put("MONITORDATAROW_ID", l4);
            hashMap.put("MONITORDATASET_ID", l3);
            hashMap.put("CTIME", new Timestamp(date.getTime()));
            hashMap.put("ROWTYPE", "S");
            this._$42432(slimStatement, hashMap);
            hashMap.clear();
            this._$39312(slimStatementArray[1], l4, roundRobinEvent.getRow());
            ++n3;
        }
        if (this._$42392) {
            this._$42393.executeBatch(slimStatement);
            this._$42393.executeBatch(slimStatementArray[1]);
        }
        for (SlimStatement slimStatement2 : slimStatementArray) {
            slimStatement2.close();
        }
        return l3;
    }

    private void _$39312(Long l2, RoundRobinDataSource roundRobinDataSource, SlimStatement[] slimStatementArray, int n2) throws SQLException {
        java.util.Date date = (java.util.Date)roundRobinDataSource.getTableRowLabel(n2);
        if (date == null) {
            return;
        }
        Long l3 = this._$11685("MONITORDATAROW");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        hashMap.put("MONITORDATAROW_ID", l3);
        hashMap.put("MONITORDATASET_ID", l2);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        hashMap.put("ROWTYPE", "R");
        this._$42432(slimStatementArray[0], hashMap);
        this._$39312(slimStatementArray[1], l3, roundRobinDataSource, n2);
    }

    private void _$39312(SlimStatement[] slimStatementArray, Long l2, java.util.Date date, List list, boolean bl, int n2) throws SQLException {
        this.deleteDataRow(l2, new Date(date.getTime()), bl ? "S" : "R");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        Long l3 = this._$11685("MONITORDATAROW");
        hashMap.put("MONITORDATAROW_ID", l3);
        hashMap.put("MONITORDATASET_ID", l2);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        hashMap.put("ROWTYPE", bl ? "S" : "R");
        this._$42432(slimStatementArray[0], hashMap);
        this._$39312(slimStatementArray[1], l3, list);
    }

    private Long _$42428(Long l2, String string, int n2) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("ID", l2);
        hashMap.put("NAME", string);
        hashMap.put("DATATYPE", n2);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.dataset.by.id", hashMap);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            long l3 = resultSet.getLong("ID");
            resultSet.close();
            slimStatement.close();
            return new Long(l3);
        }
        resultSet.close();
        slimStatement.close();
        return null;
    }

    private SlimStatement[] _$42431() throws SQLException {
        SlimStatement[] slimStatementArray = new SlimStatement[]{this._$42393.createStatement(this._$42391, "insert.monitor.row"), this._$42393.createStatement(this._$42391, "insert.monitor.value")};
        return slimStatementArray;
    }

    private void _$42432(SlimStatement slimStatement, Map map) throws SQLException {
        try {
            if (this._$42392) {
                if (_$12571.isDebugEnabled()) {
                    _$12571.debug("Adding batch " + slimStatement.getStatementSource() + "<-" + map);
                }
                slimStatement.setParameters(map);
                slimStatement.addBatch(map);
                if (slimStatement.getBatchSize() % 10 == 0) {
                    this._$42393.executeBatch(slimStatement);
                }
            } else {
                slimStatement.setParameters(map);
                this._$42393.executeUpdate(slimStatement);
            }
        }
        catch (SQLException sQLException) {
            _$12571.warn("SQL exception while executing statement '" + slimStatement.getStatementSource() + "<-" + map + ": " + Monitor2DB.getNestedExceptionMessage(sQLException));
        }
    }

    public static String getNestedExceptionMessage(SQLException sQLException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sQLException.getMessage());
        stringBuffer.append("\nNext exception is:\n");
        if (sQLException.getNextException() != null) {
            stringBuffer.append(Monitor2DB.getNestedExceptionMessage(sQLException.getNextException()));
        }
        return stringBuffer.toString();
    }

    private void _$39312(SlimStatement slimStatement, Long l2, RoundRobinDataSource roundRobinDataSource, int n2) throws SQLException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(5);
        for (int i2 = 0; i2 < roundRobinDataSource.getNumColumns(); ++i2) {
            hashMap.put("MONITORDATAROW_ID", l2);
            hashMap.put("COLINDEX", new Integer(i2));
            Object object = roundRobinDataSource.getTableDataItem(n2, i2);
            this._$42446(hashMap, object);
            this._$42432(slimStatement, hashMap);
            hashMap.clear();
        }
    }

    private void _$39312(SlimStatement slimStatement, Long l2, List list) throws SQLException {
        int n2 = 0;
        HashMap<String, Number> hashMap = new HashMap<String, Number>(5);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashMap.put("MONITORDATAROW_ID", l2);
            hashMap.put("COLINDEX", new Integer(n2));
            Object e2 = iterator.next();
            this._$42446(hashMap, e2);
            this._$42432(slimStatement, hashMap);
            hashMap.clear();
            ++n2;
        }
    }

    private void _$42446(HashMap hashMap, Object object) {
        if (object instanceof Number) {
            hashMap.put("DOUBLEVALUE", new Double(((Number)object).doubleValue()));
            hashMap.put("STRINGVALUE", new ParameterValue("STRINGVALUE", null, 12));
        } else if (object instanceof String) {
            hashMap.put("DOUBLEVALUE", new ParameterValue("DOUBLEVALUE", null, 8));
            hashMap.put("STRINGVALUE", object.toString());
        } else {
            hashMap.put("DOUBLEVALUE", new ParameterValue("DOUBLEVALUE", null, 8));
            hashMap.put("STRINGVALUE", new ParameterValue("STRINGVALUE", null, 12));
        }
    }

    private Long _$11685(String string) throws SQLException {
        ResultSet resultSet;
        SlimStatement slimStatement = this._$42394.get(string);
        if (slimStatement == null) {
            slimStatement = this._$42393.createStatement(this._$42391, "generate.id", Collections.singletonMap("TABLE_NAME", string));
            this._$42394.put(string, slimStatement);
        }
        if ((resultSet = this._$42393.executeQuery(slimStatement).getResultSet()).next()) {
            long l2 = resultSet.getLong(1);
            resultSet.close();
            return new Long(l2);
        }
        resultSet.close();
        return null;
    }

    public void deleteDataSet(Number number) throws SQLException {
        this.deleteDataSetRows(number);
        Map<String, Number> map = Collections.singletonMap("ID", number);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.datasets.by.id", map);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteDataSetRows(Number number) throws SQLException {
        this.deleteDataRow(number.longValue(), null, null);
    }

    public void deleteDataRow(Long l2, java.util.Date date, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("MONITORDATASET_ID", l2);
        if (date != null) {
            hashMap.put("CTIME", new Timestamp(date.getTime()));
        }
        if (string != null) {
            hashMap.put("ROWTYPE", string);
        }
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.values.by.dataset_id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.rows.by.dataset_id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteDataRowBefore(Long l2, java.util.Date date, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MONITORDATASET_ID", l2);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        if (string != null) {
            hashMap.put("ROWTYPE", string);
        }
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.rows.before", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.values.before", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteMonitor(Number number) throws SQLException {
        this._$42423(number);
        Map<String, Number> map = Collections.singletonMap("ID", number);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.by.id", map);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    private void _$42423(Number number) throws SQLException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("ID", number);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.values.by.id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.rows.by.id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.datasets.by.id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public Long getMonitorID(String string) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("NAME", string);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.id.by.name", hashMap);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            long l2 = resultSet.getLong(1);
            slimResult.close();
            slimStatement.close();
            return new Long(l2);
        }
        slimResult.close();
        slimStatement.close();
        return null;
    }

    public List listMonitors() throws SQLException, IOException {
        ArrayList<DBRemoteMonitor> arrayList = new ArrayList<DBRemoteMonitor>();
        if (_$12571.isInfoEnabled()) {
            _$12571.info("List monitors from " + this._$42391);
        }
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "list.monitors", new Parameter[0]);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            DBRemoteMonitor dBRemoteMonitor = new DBRemoteMonitor(new Long(resultSet.getLong("ID")), resultSet.getString("NAME"), "R".equals(resultSet.getString("STATUS")) || "R".equals(resultSet.getString("NEXT_STATUS")));
            if (_$12571.isInfoEnabled()) {
                _$12571.info(dBRemoteMonitor.toString());
            }
            arrayList.add(dBRemoteMonitor);
        }
        slimResult.close();
        slimStatement.close();
        return arrayList;
    }

    public List loadMonitor(Number number) throws SQLException, IOException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("ID", number);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.by.id", hashMap);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            int n2;
            InputStream inputStream = resultSet.getAsciiStream("CONFIGXML");
            Vector vector = Monitor2XML.readXML((InputStream)inputStream);
            inputStream.close();
            slimResult.close();
            slimStatement.close();
            MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
            monitorProperty.setId(new Long(number.longValue()));
            slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.dataset.by.id", hashMap);
            slimResult = this._$42393.executeQuery(slimStatement);
            resultSet = slimResult.getResultSet();
            boolean bl = false;
            while (resultSet.next()) {
                RoundRobinDataSource roundRobinDataSource;
                n2 = resultSet.getInt("DATATYPE");
                long l2 = resultSet.getLong("ID");
                if (n2 == 0) {
                    roundRobinDataSource = monitorProperty.getData();
                    bl = true;
                } else {
                    if (monitorProperty.getConsolidationConfig().size() <= n2 - 1) continue;
                    roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(n2 - 1);
                }
                JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)vector.get(0);
                if (jCEditableVectorDataSource != null) {
                    roundRobinDataSource.setNumColumns(jCEditableVectorDataSource.getNumRows() - 1);
                    for (int i2 = 1; i2 < jCEditableVectorDataSource.getNumRows(); ++i2) {
                        roundRobinDataSource.setColumnLabel(i2 - 1, jCEditableVectorDataSource.getTableDataItem(i2, 0));
                    }
                }
                roundRobinDataSource.setId(new Long(l2));
                this._$42461(l2, roundRobinDataSource);
            }
            slimResult.close();
            slimStatement.close();
            if (!bl) {
                this._$42425(monitorProperty.getId(), null, monitorProperty.getData(), 0);
            }
            for (n2 = 0; n2 < monitorProperty.getConsolidationConfig().size(); ++n2) {
                RoundRobinDataSource roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(n2);
                if (roundRobinDataSource.getId() == null) {
                    this._$42425(monitorProperty.getId(), null, roundRobinDataSource, n2 + 1);
                    continue;
                }
                this._$42461(roundRobinDataSource.getId(), roundRobinDataSource);
            }
            return vector;
        }
        slimStatement.close();
        return null;
    }

    private List _$42462(Long l2, java.util.Date date) throws SQLException {
        ArrayList<RoundRobinEvent> arrayList = new ArrayList<RoundRobinEvent>();
        HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>(5);
        hashMap.put("ID", l2);
        hashMap.put("CTIME", date);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.rows.by.date", hashMap);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        SlimStatement slimStatement2 = null;
        while (resultSet.next()) {
            String string = resultSet.getString("ROWTYPE");
            long l3 = resultSet.getLong("ID");
            hashMap = new HashMap(2);
            hashMap.put("ID", new Long(l3));
            Timestamp timestamp = resultSet.getTimestamp("CTIME");
            if (slimStatement2 == null) {
                slimStatement2 = this._$42393.createStatement(this._$42391, "select.monitor.values.by.row", hashMap);
            }
            RoundRobinEvent roundRobinEvent = new RoundRobinEvent(null, timestamp, new Vector(this._$42465(slimStatement2, hashMap)), "S".equals(string));
            arrayList.add(roundRobinEvent);
        }
        resultSet.close();
        if (slimStatement2 != null) {
            slimStatement2.close();
        }
        slimStatement.close();
        return arrayList;
    }

    private void _$42461(long l2, RoundRobinDataSource roundRobinDataSource) throws SQLException {
        Vector vector = new Vector();
        Vector<Timestamp> vector2 = new Vector<Timestamp>();
        Vector vector3 = roundRobinDataSource.getColumnLabels();
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.rows.by.dataset", new Parameter[]{new ParameterValue("ID", (Object)new Long(l2))});
        SlimStatement slimStatement2 = this._$42393.createStatement(this._$42391, "select.monitor.values.by.dataset", new Parameter[]{new ParameterValue("ID", (Object)new Long(l2))});
        ResultSet resultSet = this._$42393.executeQuery(slimStatement2).getResultSet();
        Map<Long, List> map = this._$42469(resultSet);
        resultSet.close();
        slimStatement2.close();
        ResultSet resultSet2 = this._$42393.executeQuery(slimStatement).getResultSet();
        ArrayList<RoundRobinEvent> arrayList = new ArrayList<RoundRobinEvent>();
        while (resultSet2.next()) {
            String string = resultSet2.getString("ROWTYPE");
            long l3 = resultSet2.getLong("ID");
            Timestamp timestamp = resultSet2.getTimestamp("CTIME");
            ArrayList arrayList2 = map.get(l3);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList(0);
            }
            if ("R".equals(string)) {
                vector2.add(timestamp);
                vector.add(new Vector(arrayList2));
                continue;
            }
            RoundRobinEvent roundRobinEvent = new RoundRobinEvent(roundRobinDataSource, timestamp, new Vector(arrayList2));
            arrayList.add(roundRobinEvent);
        }
        resultSet2.close();
        slimStatement.close();
        roundRobinDataSource.setData(0, vector.size(), vector3.size(), vector2, vector3, vector);
        roundRobinDataSource.setLastSamples(arrayList);
    }

    private Map<Long, List> _$42469(ResultSet resultSet) throws SQLException {
        HashMap<Long, List> hashMap = new HashMap<Long, List>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Long l2 = null;
        while (resultSet.next()) {
            Long l3 = resultSet.getLong("MONITORDATAROW_ID");
            if (l3 == null) continue;
            if (l2 != null && !l3.equals(l2)) {
                hashMap.put(l2, arrayList);
                arrayList = new ArrayList();
            }
            double d2 = resultSet.getDouble("DOUBLEVALUE");
            String string = resultSet.getString("STRINGVALUE");
            if (string != null) {
                arrayList.add(string);
            } else {
                arrayList.add(new Double(d2));
            }
            l2 = l3;
        }
        if (l2 != null) {
            hashMap.put(l2, arrayList);
        }
        return hashMap;
    }

    private List _$42465(SlimStatement slimStatement, Map map) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        slimStatement.setParameters(map);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            double d2 = resultSet.getDouble("DOUBLEVALUE");
            String string = resultSet.getString("STRINGVALUE");
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(new Double(d2));
        }
        resultSet.close();
        return arrayList;
    }

    @Override
    public void addDataPoint(RoundRobinEvent roundRobinEvent) {
        RoundRobinDataSource roundRobinDataSource = roundRobinEvent.getRRDS();
        Long l2 = roundRobinDataSource.getId();
        if (l2 != null) {
            try {
                SlimStatement[] slimStatementArray = this._$42431();
                Long l3 = this._$11685("MONITORDATAROW");
                java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
                if (date != null) {
                    HashMap hashMap = new HashMap(5);
                    hashMap.put("MONITORDATAROW_ID", l3);
                    hashMap.put("MONITORDATASET_ID", l2);
                    hashMap.put("CTIME", new Timestamp(date.getTime()));
                    int n2 = roundRobinEvent.isSample() ? 1 : 0;
                    hashMap.put("ROWTYPE", n2 != 0 ? "S" : "R");
                    slimStatementArray[0].setParameters((Map)hashMap);
                    this._$42393.executeUpdate(slimStatementArray[0]);
                    this._$39312(slimStatementArray[1], l3, roundRobinEvent.getRow());
                    if (this._$42392) {
                        this._$42393.executeBatch(slimStatementArray[1]);
                    }
                    if (n2 == 0 && roundRobinDataSource.getNumRows() >= roundRobinDataSource.getNumSamples() && roundRobinDataSource.getNumRows() > 0) {
                        this.deleteObsoleteRows(l2, (java.util.Date)roundRobinDataSource.getTableRowLabel(0));
                    }
                }
                for (SlimStatement slimStatement : slimStatementArray) {
                    slimStatement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
        }
    }

    public void deleteObsoleteRows(Long l2, java.util.Date date) throws SQLException {
        this.deleteDataRowBefore(l2, date, null);
    }

    private void _$42473(Long l2) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("MONITORDATASET_ID", l2);
        hashMap.put("ROWTYPE", "S");
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.values.by.dataset_id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.rows.by.dataset_id", hashMap);
        this._$42393.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void resetDataSeries(Long l2, RoundRobinDataSource roundRobinDataSource, int n2) throws SQLException {
        Long l3 = roundRobinDataSource.getId();
        this._$42425(l2, l3, roundRobinDataSource, n2);
    }

    public void deleteUnusedDataSeries(Long l2, List list) throws SQLException {
        List list2 = this.getDataSetIDs(l2);
        list2.removeAll(list);
        for (Long l3 : list2) {
            if (l3 == null) continue;
            this.deleteDataSet(l3);
        }
    }

    public List getDataSetIDs(Long l2) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Map<String, Long> map = Collections.singletonMap("MONITOR_ID", l2);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.dataset.id", map);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            long l3 = resultSet.getLong("ID");
            arrayList.add(new Long(l3));
        }
        slimResult.close();
        slimStatement.close();
        return arrayList;
    }

    @Override
    public void resetSamples(RoundRobinEvent roundRobinEvent) {
        try {
            this._$42473(roundRobinEvent.getRRDS().getId());
            SlimStatement[] slimStatementArray = this._$42431();
            if (roundRobinEvent.getRow() != null) {
                for (int i2 = 0; i2 < roundRobinEvent.getRow().size(); ++i2) {
                    this._$39312(slimStatementArray, roundRobinEvent.getRRDS().getId(), (java.util.Date)roundRobinEvent.getLabel(), (List)roundRobinEvent.getRow().get(i2), true, i2);
                }
                if (this._$42392) {
                    this._$42393.executeBatch(slimStatementArray[0]);
                    this._$42393.executeBatch(slimStatementArray[1]);
                }
            }
            for (SlimStatement slimStatement : slimStatementArray) {
                slimStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public void setUseBatch(boolean bl) {
        this._$42392 = bl;
    }

    public boolean isUseBatch() {
        return this._$42392;
    }

    public String getUrl() {
        return this._$14367;
    }

    public String getDriver() {
        return this._$42385;
    }

    @Override
    public Vector getRunningMonitors() throws RemoteException {
        try {
            List list = this.listMonitors();
            Vector<String> vector = new Vector<String>();
            for (DBRemoteMonitor dBRemoteMonitor : list) {
                if (!dBRemoteMonitor._$42483) continue;
                vector.add(dBRemoteMonitor._$46);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public MonitorServer getMonitor(String string) throws RemoteException {
        Long l2 = null;
        try {
            l2 = this.getMonitorID(string);
            if (l2 != null) {
                Map<String, Long> map = Collections.singletonMap("ID", l2);
                SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.keyValues.by.id", map);
                SlimResult slimResult = this._$42393.executeQuery(slimStatement);
                ResultSet resultSet = slimResult.getResultSet();
                if (resultSet.next()) {
                    DBRemoteMonitor dBRemoteMonitor = new DBRemoteMonitor(new Long(resultSet.getLong("ID")), resultSet.getString("NAME"), "R".equals(resultSet.getString("STATUS")));
                    slimResult.close();
                    slimStatement.close();
                    return dBRemoteMonitor;
                }
                slimResult.close();
                slimStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
        return null;
    }

    @Override
    public MonitorServer newMonitor(String string, Vector vector) throws RemoteException {
        Long l2 = null;
        try {
            l2 = this.getMonitorID(string);
            if (l2 == null) {
                this._$42415(null, string, (MonitorProperty)vector.get(1), (JCEditableVectorDataSource)vector.get(0), "R");
                return new DBRemoteMonitor(l2, string, true);
            }
            this.updateMonitor(l2, string, (MonitorProperty)vector.get(1), (JCEditableVectorDataSource)vector.get(0), "U", true);
            return new DBRemoteMonitor(l2, string, true);
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not start new DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
        catch (IOException iOException) {
            throw new RemoteException("Could not start new DB monitor '" + string + "':" + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void stopMonitor(String string) throws RemoteException {
        Long l2 = null;
        try {
            l2 = this.getMonitorID(string);
            if (l2 != null) {
                this.updateMonitorNewStatus(l2, "S");
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not stop DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Vector getAvailableMonitors() throws RemoteException {
        try {
            List list = this.listMonitors();
            Vector<String> vector = new Vector<String>();
            for (DBRemoteMonitor dBRemoteMonitor : list) {
                vector.add(dBRemoteMonitor._$46);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public MonitorServer runMonitor(String string) throws RemoteException {
        Long l2 = null;
        try {
            l2 = this.getMonitorID(string);
            if (l2 != null) {
                this.updateMonitorNewStatus(l2, "R");
                return new DBRemoteMonitor(l2, string, true);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not stop DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
    }

    public String[] getMonitorStatus(Long l2) throws SQLException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
        hashMap.put("ID", l2);
        SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "select.monitor.status.by.id", hashMap);
        SlimResult slimResult = this._$42393.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            String[] stringArray = new String[]{resultSet.getString("STATUS"), resultSet.getString("NEXT_STATUS")};
            slimResult.close();
            slimStatement.close();
            return stringArray;
        }
        slimResult.close();
        slimStatement.close();
        return null;
    }

    public int getRequiredSchemaVersion() {
        return 0;
    }

    @Override
    public void removeDataPoint(RoundRobinEvent roundRobinEvent) {
        RoundRobinDataSource roundRobinDataSource = roundRobinEvent.getRRDS();
        Long l2 = roundRobinDataSource.getId();
        if (l2 != null) {
            try {
                java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
                if (date != null) {
                    HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>(5);
                    hashMap.put("MONITORDATASET_ID", l2);
                    hashMap.put("CTIME", new Timestamp(date.getTime()));
                    SlimStatement slimStatement = this._$42393.createStatement(this._$42391, "delete.monitor.rows.by.date", hashMap);
                    SlimUpdateResult slimUpdateResult = this._$42393.executeUpdate(slimStatement);
                    if (_$12571.isInfoEnabled()) {
                        _$12571.info("Deleted " + slimUpdateResult.updateCount() + " data rows for '" + roundRobinDataSource.getName() + "' and timestamp " + date);
                    }
                }
            }
            catch (SQLException sQLException) {
                _$12571.error("Failed to delete data rows for '" + roundRobinDataSource.getName() + ", because: " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public class DBRemoteMonitor
    implements MonitorServer {
        private String _$46;
        private Long _$42487;
        private boolean _$42483;

        DBRemoteMonitor(Long l2, String string, boolean bl) {
            this._$46 = string;
            this._$42487 = l2;
            this._$42483 = bl;
        }

        public String toString() {
            return "DBRemoteMonitor[name=" + this._$46 + ",remoteMonitorID=" + this._$42487 + ",running=" + this._$42483 + "]";
        }

        public Vector getMonitor() throws RemoteException {
            if (this._$42487 != null) {
                List list = null;
                try {
                    list = Monitor2DB.this.loadMonitor(this._$42487);
                }
                catch (IOException iOException) {
                    throw new RemoteException("Cannot load remote DB monitor: " + iOException.getMessage(), iOException);
                }
                catch (SQLException sQLException) {
                    throw new RemoteException("Failed to load remote DB monitor: " + sQLException.getMessage(), sQLException);
                }
                if (list != null) {
                    return new Vector(list);
                }
            }
            return null;
        }

        public void setMonitor(Vector vector) throws RemoteException {
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)vector.get(0);
            MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
            try {
                Long l2 = monitorProperty.getId();
                if (!this._$42487.equals(l2)) {
                    throw new RuntimeException("DB Monitor could not be updated because IDs do not match: " + l2 + "<>" + this._$42487);
                }
                Monitor2DB.this.updateMonitor(l2, monitorProperty.getChartName(), monitorProperty, jCEditableVectorDataSource, "U", true);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("Could not update remote monitor because of DB error: " + sQLException.getMessage(), sQLException);
            }
            catch (IOException iOException) {
                throw new RemoteException("Could not update remote monitor because of IO error: " + iOException.getMessage(), iOException);
            }
        }

        public void addRemoteListener(MonitorObserver monitorObserver) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public void removeRemoteListener(MonitorObserver monitorObserver) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public Vector getRowsAfter(java.util.Date date) throws RemoteException {
            try {
                List list = Monitor2DB.this._$42462(this._$42487, date);
                return new Vector(list);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("Failed to load rows after '" + date + "': " + sQLException.getMessage(), sQLException);
            }
        }
    }
}

