/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor.alarm;

import com.agentpp.common.FilePanel;
import com.agentpp.common.TextInputPanel;
import com.agentpp.common.formula.FormulaParser;
import com.agentpp.common.formula.ParseException;
import com.agentpp.explorer.monitor.alarm.AlarmConfig;
import com.agentpp.explorer.monitor.parser.TemplateParser;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.Result;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AlarmConfigPanel
extends JPanel
implements ActionListener {
    private Border _$5548;
    private BorderLayout _$549 = new BorderLayout();
    private JPanel _$25254 = new JPanel();
    private GridBagLayout _$5529 = new GridBagLayout();
    private JLabel _$50836 = new JLabel();
    private JTextField _$50837 = new JTextField();
    private JLabel _$38444 = new JLabel();
    private JTextField _$42291 = new JTextField();
    private TitledBorder _$5553;
    private String _$44739;
    private MIBRepository _$20550;
    private JPanel _$25258 = new JPanel();
    private GridBagLayout _$5551 = new GridBagLayout();
    private JLabel _$31269 = new JLabel();
    private JComboBox _$15220 = new JComboBox();
    private JLabel _$50838 = new JLabel();
    private JComboBox _$33554 = new JComboBox();
    private Border _$25785;
    private TitledBorder _$50839;
    private static FormulaParser _$38169 = new FormulaParser();
    private static TemplateParser _$42295 = new TemplateParser();
    private static final Object[] _$50840 = new Object[]{Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
    private FilePanel _$50841 = new FilePanel();
    private JTabbedPane _$33673 = new JTabbedPane();
    private JPanel _$50842 = new JPanel();
    private JPanel _$50843 = new JPanel();
    private GridBagLayout _$26950 = new GridBagLayout();
    private JLabel _$50844 = new JLabel();
    private JTextField _$50845 = new JTextField();
    private FilePanel _$19387 = new FilePanel();
    private GridBagLayout _$42302 = new GridBagLayout();
    private static Logger _$5475 = Logger.getLogger("Monitor.Alarm");
    private static ExampleFileFilter _$28784 = new ExampleFileFilter("vm", "MIB Explorer Scripts");
    private JCheckBox _$50846 = new JCheckBox();
    private JButton _$50847 = new JButton();
    private TextInputPanel _$50848 = new TextInputPanel();
    private TextInputPanel _$50849 = new TextInputPanel();
    JCheckBox embedClearScript = new JCheckBox();
    JButton jButtonEditClearScript = new JButton();
    JButton jButtonTestClear = new JButton();
    JButton jButtonTestRaise = new JButton();
    private Runnable _$50853 = null;
    private Runnable _$50854 = null;

    public AlarmConfigPanel(UserConfigFile userConfigFile, Hashtable hashtable, MIBRepository mIBRepository) {
        this._$20550 = mIBRepository;
        int n2 = 0;
        this._$15220.addItem("MIB Explorer");
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this._$15220.addItem(enumeration.nextElement());
            ++n2;
        }
        this._$15220.setSelectedIndex(0);
        for (int i2 = 0; i2 < _$50840.length; ++i2) {
            this._$33554.addItem(_$50840[i2]);
        }
        this._$33554.setSelectedIndex(0);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$19387.addActionListener(this);
        this._$19387.setDefaultPath(userConfigFile.get("mibexplorer.scriptsPath", ""));
        this._$19387.setFilter(_$28784);
        this._$50841.addActionListener(this);
        this._$50841.setDefaultPath(userConfigFile.get("mibexplorer.scriptsPath", ""));
        this._$50841.setFilter(_$28784);
    }

    public AlarmConfigPanel() {
        this(null, null, null);
    }

    public void setTestClearAlarm(Runnable runnable) {
        this._$50853 = runnable;
    }

    public void setTestRaiseAlarm(Runnable runnable) {
        this._$50854 = runnable;
    }

    void jbInit() throws Exception {
        this._$5548 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$5553 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "Alarm Text");
        this._$25785 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$50839 = new TitledBorder(this._$25785, "Target");
        this.setLayout(this._$549);
        this._$25254.setLayout(this._$5529);
        this._$50836.setText("Condition:");
        this._$38444.setText("Value:");
        this._$42291.setToolTipText("Alarm text template which may be any string optionally containing value references enclosed in '{' and '}' brakets (e.g. \"Alarm value = {Z*100}\")");
        this._$42291.setText("Z");
        this._$25254.setBorder(this._$5553);
        this._$25258.setLayout(this._$5551);
        this._$31269.setText("Target:");
        this._$50838.setText("Log Severity:");
        this._$25258.setBorder(this._$50839);
        this._$50841.setLabelText("Script:");
        this._$50841.setToolTipText("Script to be executed if alarm is cleared (that is if clear condition is true and alarm is open)");
        this._$50842.setLayout(this._$26950);
        this._$50844.setText("Condition:");
        this._$19387.setToolTipText("Script to be executed if alarm is raised (that is if raise condition is true and clear condition is not present or alarm is not already raised)");
        this._$19387.setLabelText("Script:");
        this._$50843.setLayout(this._$42302);
        this._$50845.setToolTipText("Boolean expression which could reference any data from the primary table (e.g. \"Z > 100\" = raise alarm if last retrieved value > 100)");
        this._$50837.setToolTipText("Boolean expression which could reference any data from the primary table (e.g. \"Z \\< 90\" = clear alarm if last retrieved value \\< 90)");
        this._$15220.setToolTipText("Default target for Scripts. This target will be saved with this monitor and is thus independent from the MIB Explorer config");
        this._$33554.setToolTipText("The logging severity. Choose ERROR or FATAL if alarm should trigger an email");
        this._$50846.setToolTipText("If checked the supplied script will be copied into the alarm configuration instead referencing it at runtime through a file name");
        this._$50846.setText("Embed script");
        this._$50846.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlarmConfigPanel.this.embeddedScript_itemStateChanged(itemEvent);
            }
        });
        this._$50847.setEnabled(false);
        this._$50847.setToolTipText("Edit the embedded script with a text editor");
        this._$50847.setText("Edit...");
        this._$50847.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonEditScript_actionPerformed(actionEvent);
            }
        });
        this.embedClearScript.setToolTipText("If checked the supplied script will be copied into the alarm configuration instead referencing it at runtime through a file name");
        this.embedClearScript.setText("Embed Script");
        this.embedClearScript.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlarmConfigPanel.this.embedClearScript_itemStateChanged(itemEvent);
            }
        });
        this.jButtonEditClearScript.setEnabled(false);
        this.jButtonEditClearScript.setToolTipText("Edit the embedded script with a text editor");
        this.jButtonEditClearScript.setText("Edit...");
        this.jButtonEditClearScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonEditClearScript_actionPerformed(actionEvent);
            }
        });
        this.jButtonTestClear.setToolTipText("Execute the specified script as if the given condition would be true");
        this.jButtonTestClear.setText("Test");
        this.jButtonTestClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonTestClear_actionPerformed(actionEvent);
            }
        });
        this.jButtonTestRaise.setText("Test");
        this.jButtonTestRaise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonTestRaise_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$25254, "South");
        this._$25254.add((Component)this._$38444, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$25254.add((Component)this._$42291, new GridBagConstraints(1, 1, 1, 1, 0.2, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$25258, "North");
        this._$25258.add((Component)this._$31269, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this._$25258.add((Component)this._$15220, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$25258.add((Component)this._$50838, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$25258.add((Component)this._$33554, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$33673, "Center");
        this._$33673.add((Component)this._$50842, "Raise");
        this._$50842.add((Component)this._$50845, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$50842.add((Component)this._$19387, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 0, 10), 0, 0));
        this._$50842.add((Component)this._$50844, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$50842.add((Component)this._$50846, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this._$33673.add((Component)this._$50843, "Clear");
        this._$50843.add((Component)this._$50836, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$50843.add((Component)this._$50837, new GridBagConstraints(1, 0, 3, 1, 0.2, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$50843.add((Component)this._$50841, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 10, 10), 0, 0));
        this._$50843.add((Component)this.embedClearScript, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this._$50842.add((Component)this._$50847, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 10, 0), 0, 0));
        this._$50843.add((Component)this.jButtonEditClearScript, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$50843.add((Component)this.jButtonTestClear, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 20), 0, 0));
        this._$50842.add((Component)this.jButtonTestRaise, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 20), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            try {
                if (actionEvent.getSource().equals(this._$19387)) {
                    String string = this._$19387.getPath();
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        file = new File(this._$44739, string);
                    }
                    if (!file.isFile()) {
                        throw new FileNotFoundException(file.getPath());
                    }
                } else {
                    String string = this._$50841.getPath();
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        file = new File(this._$44739, string);
                    }
                    if (!file.isFile()) {
                        throw new FileNotFoundException(file.getPath());
                    }
                }
            }
            catch (Exception exception) {
                if (!actionEvent.getActionCommand().equals("FILE_SELECTED")) break block8;
                JOptionPane.showMessageDialog(this, "Cannot find script: " + exception.getMessage(), "Invalid PDU", 0);
            }
        }
    }

    public void setScriptDirectory(String string) {
        this._$44739 = string;
    }

    public String getScriptDirectory() {
        return this._$44739;
    }

    public void load(AlarmConfig alarmConfig) {
        this._$50846.setSelected(alarmConfig.isEmbeddedRaiseScript());
        if (alarmConfig.isEmbeddedRaiseScript()) {
            this._$50848.setText(alarmConfig.getRaiseScript());
            this._$50849.setText(alarmConfig.getClearScript());
        } else {
            this._$19387.setPath(alarmConfig.getRaiseScript());
            this._$50841.setPath(alarmConfig.getClearScript());
        }
        this._$50846.setSelected(alarmConfig.isEmbeddedRaiseScript());
        if (alarmConfig.isEmbeddedClearScript()) {
            this._$50849.setText(alarmConfig.getClearScript());
        } else {
            this._$50841.setPath(alarmConfig.getClearScript());
        }
        this._$50845.setText(alarmConfig.getRaiseFormula());
        this._$50837.setText(alarmConfig.getClearFormula());
        this._$33554.setSelectedItem(Level.toLevel(alarmConfig.getLogSeverity()));
        this._$42291.setText(alarmConfig.getValueFormula());
        if (alarmConfig.getTarget() == null) {
            this._$15220.setSelectedIndex(0);
        } else {
            this._$15220.setSelectedItem(alarmConfig.getTarget());
        }
        this.actionPerformed(new ActionEvent(this._$19387, 1001, "LOADED"));
        this.actionPerformed(new ActionEvent(this._$50841, 1001, "LOADED"));
    }

    public void save(AlarmConfig alarmConfig) {
        alarmConfig.setEmbeddedRaiseScript(this._$50846.isSelected());
        if (this._$50846.isSelected()) {
            alarmConfig.setRaiseScript(this._$50848.getText());
        } else {
            alarmConfig.setRaiseScript(this._$19387.getPath());
        }
        alarmConfig.setEmbeddedClearScript(this.embedClearScript.isSelected());
        if (this.embedClearScript.isSelected()) {
            alarmConfig.setClearScript(this._$50849.getText());
        } else {
            alarmConfig.setClearScript(this._$50841.getPath());
        }
        alarmConfig.setRaiseFormula(this._$50845.getText());
        alarmConfig.setLogSeverity(((Level)this._$33554.getSelectedItem()).toInt());
        alarmConfig.setClearFormula(this._$50837.getText());
        alarmConfig.setValueFormula(this._$42291.getText());
        if (this._$15220.getSelectedIndex() == 0) {
            alarmConfig.setTarget(null);
        } else {
            alarmConfig.setTarget((GenTarget)this._$15220.getSelectedItem());
        }
    }

    public static synchronized String getValueExpression(String string, TableDataModel tableDataModel, int n2, int n3, MIBRepository mIBRepository) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        AlarmConfigPanel._$38169.rep = mIBRepository;
        AlarmConfigPanel._$38169.tableModel = tableDataModel;
        AlarmConfigPanel._$38169.currentRow = n3;
        AlarmConfigPanel._$38169.currentCol = n2;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = _$42295.parseStream(stringReader);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (e2 instanceof StringBuffer) {
                    try {
                        Expression expression = _$38169.parseStream(new StringReader(e2.toString()), 2);
                        Result result = expression.evaluate();
                        stringBuffer.append(result);
                    }
                    catch (ParseException parseException) {
                        _$5475.error("Syntax error in alarm value formula of row " + (char)(64 + n2) + ": " + parseException.getMessage());
                        stringBuffer.append(e2.toString());
                    }
                    continue;
                }
                stringBuffer.append(e2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            _$5475.error("Syntax error in alarm value formula of row " + (char)(64 + n2) + ": " + exception.getMessage());
            return "";
        }
    }

    public static synchronized Expression getConditionalExpression(String string, TableDataModel tableDataModel, int n2, int n3) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        AlarmConfigPanel._$38169.currentRow = n3;
        AlarmConfigPanel._$38169.currentCol = n2;
        AlarmConfigPanel._$38169.tableModel = tableDataModel;
        return _$38169.parseStream(stringReader, 3);
    }

    public boolean isOK() {
        try {
            AlarmConfigPanel.getValueExpression(this._$42291.getText(), null, 0, 0, this._$20550);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in value formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        try {
            Expression expression = AlarmConfigPanel.getConditionalExpression(this._$50845.getText(), null, 0, 0);
            if (expression == null) {
                JOptionPane.showMessageDialog(this, "Alarm raising formula cannot be empty!", "Invalid Formula", 0);
                return false;
            }
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in raising formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        try {
            AlarmConfigPanel.getConditionalExpression(this._$50845.getText(), null, 0, 0);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in clearing formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        return this._$50863(this._$19387.getPath()) && this._$50863(this._$50841.getPath());
    }

    private boolean _$50863(String string) {
        File file;
        if (string != null && string.length() > 0 && !(file = new File(this._$19387.getPath())).isFile()) {
            JOptionPane.showMessageDialog(this, "Script not found: " + string, "Invalid Script", 0);
            return false;
        }
        return true;
    }

    void embeddedScript_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._$50847.setEnabled(true);
            String string = ScriptContext.getScriptText((String)this._$19387.getPath());
            if (string != null) {
                this._$50848.setText(string);
            }
            this._$19387.setPathTextEnabled(false);
        } else {
            this._$50847.setEnabled(false);
            this._$19387.setPathTextEnabled(true);
        }
    }

    void jButtonEditScript_actionPerformed(ActionEvent actionEvent) {
        String string = this._$50848.getText();
        if (JOptionPane.showOptionDialog(this, this._$50848, "Raise Alarm Script", 2, -1, null, new String[]{"Save", "Cancel"}, "Save") == 2) {
            this._$50848.setText(string);
        }
    }

    void embedClearScript_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jButtonEditClearScript.setEnabled(true);
            String string = ScriptContext.getScriptText((String)this._$50841.getPath());
            if (string != null) {
                this._$50849.setText(string);
            }
            this._$50841.setPathTextEnabled(false);
        } else {
            this.jButtonEditClearScript.setEnabled(false);
            this._$50841.setPathTextEnabled(true);
        }
    }

    void jButtonTestClear_actionPerformed(ActionEvent actionEvent) {
        if (this._$50853 != null) {
            this._$50853.run();
            JOptionPane.showMessageDialog(this, new String[]{"Alarm has been cleared for testing.", "Please check in the Log panel for entries of category", "'Monitor.Alarm' and 'Script' for details."}, "Alarm Test", 1);
        }
    }

    void jButtonTestRaise_actionPerformed(ActionEvent actionEvent) {
        if (this._$50854 != null) {
            this._$50854.run();
            JOptionPane.showMessageDialog(this, new String[]{"Alarm has been raised for testing.", "Please check in the Log panel for entries of category", "'Monitor.Alarm' and 'Script' for details."}, "Alarm Test", 1);
        }
    }

    void jButtonEditClearScript_actionPerformed(ActionEvent actionEvent) {
        String string = this._$50849.getText();
        if (JOptionPane.showOptionDialog(this, this._$50849, "Clear Alarm Script", 2, -1, null, new String[]{"Save", "Cancel"}, "Save") == 2) {
            this._$50849.setText(string);
        }
    }
}

