/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor;

import com.klg.jclass.util.swing.encode.JCEncodeComponent;
import java.io.File;
import java.io.Serializable;

public class ExportProperty
implements Serializable {
    public static final long serialVersionUID = -8820693811640417470L;
    public static final String[] CHART_EXTENSIONS = new String[]{".JPG", ".PNG", ".PDF", ".PS", ".EPS", ".PCL", ".GIF"};
    private static final JCEncodeComponent.Encoding[] CHART_ENCODINGS = new JCEncodeComponent.Encoding[]{JCEncodeComponent.JPEG, JCEncodeComponent.PNG, JCEncodeComponent.PDF, JCEncodeComponent.PS, JCEncodeComponent.EPS, JCEncodeComponent.PCL, JCEncodeComponent.GIF};
    private static final String[] MIME_TYPES = new String[]{"image/jpeg", "image/x-png", "application/pdf", "application/postscript", "image/x-eps", null, "image/gif"};
    public static final String EXTENSION_XLS = ".XLS";
    public static final String EXTENSION_CSV = ".CSV";
    public static final String[] DATA_EXTENSIONS = new String[]{".CSV", ".XLS"};
    public static final int CHART_TYPE_JPG = 0;
    public static final int CHART_TYPE_PNG = 1;
    public static final int CHART_TYPE_PDF = 2;
    public static final int CHART_TYPE_PS = 3;
    public static final int CHART_TYPE_EPS = 4;
    public static final int CHART_TYPE_PCL = 5;
    public static final int CHART_TYPE_GIF = 6;
    private File exportDirectory = new File("");
    private String chartExtension = CHART_EXTENSIONS[0];
    private String dataExtension = DATA_EXTENSIONS[0];
    private boolean autoSave = false;
    private boolean enabledDataExport;
    private boolean enabledChartExport;
    private int autoSaveInterval = 1;
    private int numBackupFiles = 1;

    public File getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(File exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    public void setChartExtension(String chartExtension) {
        this.chartExtension = chartExtension;
    }

    public String getChartExtension() {
        return this.chartExtension;
    }

    public void setDataExtension(String dataExtension) {
        this.dataExtension = dataExtension;
    }

    public String getDataExtension() {
        return this.dataExtension;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public static String getMimeType(String fileName) {
        String fName = fileName.toUpperCase();
        for (int i2 = 0; i2 < MIME_TYPES.length; ++i2) {
            if (MIME_TYPES[i2] == null || !fName.endsWith(MIME_TYPES[i2])) continue;
            return MIME_TYPES[i2];
        }
        return MIME_TYPES[1];
    }

    public static JCEncodeComponent.Encoding getChartEncoding(String fileName) {
        String fName = fileName.toUpperCase();
        for (int i2 = 0; i2 < CHART_ENCODINGS.length; ++i2) {
            if (!fName.endsWith(CHART_EXTENSIONS[i2])) continue;
            return CHART_ENCODINGS[i2];
        }
        return JCEncodeComponent.PNG;
    }

    public JCEncodeComponent.Encoding getChartEncoding() {
        for (int i2 = 0; i2 < CHART_ENCODINGS.length; ++i2) {
            if (!this.chartExtension.equals(CHART_EXTENSIONS[i2])) continue;
            return CHART_ENCODINGS[i2];
        }
        return JCEncodeComponent.PNG;
    }

    public int getChartEncodingType() {
        for (int i2 = 0; i2 < this.chartExtension.length(); ++i2) {
            if (!this.chartExtension.equals(CHART_EXTENSIONS[i2])) continue;
            return i2;
        }
        return -1;
    }

    public boolean isValid() {
        return this.exportDirectory != null && this.exportDirectory.isDirectory() && this.exportDirectory.canWrite();
    }

    public void setEnabledDataExport(boolean enabledDataExport) {
        this.enabledDataExport = enabledDataExport;
    }

    public boolean isEnabledDataExport() {
        return this.enabledDataExport;
    }

    public void setEnabledChartExport(boolean enabledChartExport) {
        this.enabledChartExport = enabledChartExport;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
    }

    public void setNumBackupFiles(int numBackupFiles) {
        this.numBackupFiles = numBackupFiles;
    }

    public boolean isEnabledChartExport() {
        return this.enabledChartExport;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public int getNumBackupFiles() {
        return this.numBackupFiles;
    }
}

