/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor;

import com.agentpp.explorer.monitor.LineStyleProperty;
import com.klg.jclass.chart3d.JCAxis;
import java.awt.Font;
import java.io.Serializable;

public class AxisProperty
implements Serializable {
    public static final long serialVersionUID = 6958787414561163626L;
    private String text;
    private boolean visible;
    private int placement;
    private int rotation;
    private boolean gridVisible;
    private double gridSpacing;
    private boolean gridSpacingIsDefault;
    private Font font;
    private boolean titleVisible;
    private LineStyleProperty lineStyle;

    public AxisProperty() {
    }

    public AxisProperty(com.klg.jclass.chart.JCAxis axis) {
        this.text = axis.getTitle().getText();
        this.titleVisible = axis.getTitle().isVisible();
        this.placement = axis.getTitle().getPlacement();
        this.rotation = axis.getTitle().getRotation();
        this.gridSpacing = axis.getGridSpacing();
        this.gridSpacingIsDefault = axis.getGridSpacingIsDefault();
        this.font = axis.getFont();
        this.gridVisible = axis.isGridVisible();
        this.lineStyle = new LineStyleProperty(axis.getGridStyle().getLineStyle());
    }

    public AxisProperty(JCAxis axis) {
        this.text = axis.getTitle();
        this.titleVisible = true;
        this.placement = 0;
        this.rotation = 0;
        this.gridSpacing = 0.0;
        this.gridSpacingIsDefault = true;
        this.font = axis.getAnnoFont();
        this.gridVisible = true;
        this.lineStyle = new LineStyleProperty(axis.getGridLines().getLineStyle());
    }

    public void getAxis(com.klg.jclass.chart.JCAxis axis) {
        if (axis == null) {
            return;
        }
        axis.getTitle().setText(this.text, this.titleVisible);
        axis.getTitle().setRotation(this.rotation);
        try {
            axis.getTitle().setPlacement(this.placement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        axis.setGridSpacing(this.gridSpacing);
        axis.setGridSpacingIsDefault(this.gridSpacingIsDefault);
        axis.setGridVisible(this.gridVisible);
        axis.setFont(this.font);
        this.lineStyle.getLineStyle(axis.getGridStyle().getLineStyle());
    }

    public void getAxis(JCAxis axis) {
        if (axis == null) {
            return;
        }
        axis.setTitle(this.text);
        axis.setAnnoFont(this.font);
        this.lineStyle.getLineStyle(axis.getGridLines().getLineStyle());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridSpacing(double gridSpacing) {
        this.gridSpacing = gridSpacing;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacingIsDefault(boolean gridSpacingIsDefault) {
        this.gridSpacingIsDefault = gridSpacingIsDefault;
    }

    public boolean isGridSpacingIsDefault() {
        return this.gridSpacingIsDefault;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setLineStyle(LineStyleProperty lineStyle) {
        this.lineStyle = lineStyle;
    }

    public LineStyleProperty getLineStyle() {
        return this.lineStyle;
    }
}

