/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.log;

import com.agentpp.explorer.RequestObserver;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.GenTarget;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpLogger {
    public static Logger cGetReq = Logger.getLogger("SNMP.GET.Request");
    public static Logger cGetResp = Logger.getLogger("SNMP.GET.Response");
    public static Logger cGetNextReq = Logger.getLogger("SNMP.GETNEXT.Request");
    public static Logger cGetNextResp = Logger.getLogger("SNMP.GETNEXT.Response");
    public static Logger cGetBulkReq = Logger.getLogger("SNMP.GETBULK.Request");
    public static Logger cGetBulkResp = Logger.getLogger("SNMP.GETBULK.Response");
    public static Logger cSetReq = Logger.getLogger("SNMP.SET.Request");
    public static Logger cSetResp = Logger.getLogger("SNMP.SET.Response");
    public static Logger cInformReq = Logger.getLogger("SNMP.INFORM.Request");
    public static Logger cInformResp = Logger.getLogger("SNMP.INFORM.Response");
    public static final Logger cTrapSnt = Logger.getLogger("SNMP.TRAP.Sent");
    public static final Logger cTrapRcv = Logger.getLogger("SNMP.TRAP.Received");
    private MIBRepository _$20550 = null;

    public SnmpLogger() {
    }

    public SnmpLogger(MIBRepository mIBRepository) {
        this._$20550 = mIBRepository;
    }

    public static void logTrap(CommandResponderEvent commandResponderEvent) {
        if (cTrapRcv.isInfoEnabled()) {
            PDU pDU = commandResponderEvent.getPDU();
            cTrapRcv.info(pDU.getRequestID() + " - " + commandResponderEvent.getPeerAddress() + "\t" + SnmpLogger.printPDU(pDU, true));
        }
    }

    public static void logTrapReceived(CommandResponderEvent commandResponderEvent, Level level) {
        if (cTrapRcv.isEnabledFor(level)) {
            PDU pDU = commandResponderEvent.getPDU();
            if (pDU != null && pDU.getType() == -90) {
                cInformReq.log(level, pDU.getRequestID() + " - " + commandResponderEvent.getPeerAddress() + "\t" + SnmpLogger.printPDU(pDU, true));
            } else {
                cTrapRcv.log(level, pDU.getRequestID() + " - " + commandResponderEvent.getPeerAddress() + "\t" + SnmpLogger.printPDU(pDU, true));
            }
        }
    }

    public static void logRequest(PDU pDU, GenTarget genTarget) {
        SnmpLogger.logRequest(pDU, genTarget, true);
    }

    public static void logRequest(PDU pDU, GenTarget genTarget, boolean bl) {
        Logger logger;
        switch (pDU.getType()) {
            case -91: {
                logger = cGetBulkReq;
                break;
            }
            case -95: {
                logger = cGetNextReq;
                break;
            }
            case -93: {
                logger = cSetReq;
                break;
            }
            case -92: 
            case -89: {
                logger = cTrapSnt;
                break;
            }
            case -90: {
                logger = cInformReq;
                break;
            }
            default: {
                logger = cGetReq;
            }
        }
        if (bl) {
            if (logger.isInfoEnabled()) {
                logger.info(pDU.getRequestID().getValue() + " - " + genTarget.toDetailedString() + "\t" + SnmpLogger.printPDU(pDU, true));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(pDU.getRequestID().getValue() + " - " + genTarget.toDetailedString() + "\t" + SnmpLogger.printPDU(pDU, true));
        }
    }

    public boolean logResponse(ResponseEvent responseEvent, RequestObserver requestObserver) {
        Logger logger;
        PDU pDU = responseEvent.getResponse();
        switch (responseEvent.getRequest().getType()) {
            case -91: {
                logger = cGetBulkResp;
                break;
            }
            case -95: {
                logger = cGetNextResp;
                break;
            }
            case -93: {
                logger = cSetResp;
                break;
            }
            case -90: {
                logger = cInformResp;
                break;
            }
            default: {
                logger = cGetResp;
            }
        }
        if (pDU == null) {
            logger.warn(responseEvent.getRequest().getRequestID() + " - Request timed out");
            if (requestObserver != null) {
                requestObserver.requestFinishedWithError("Request timed out.");
            }
            return false;
        }
        if (responseEvent.getResponse().getType() == -88) {
            String string = "SNMPv3 report: ";
            if (responseEvent.getResponse().size() > 0) {
                VariableBinding variableBinding = responseEvent.getResponse().get(0);
                String string2 = this._$20550 != null ? this._$20550.getPathSuffix(new ObjectID(variableBinding.getOid().toString())) : variableBinding.getOid().toString();
                string = string2 + " = " + ((Object)variableBinding.getVariable()).toString();
            }
            logger.error(pDU.getRequestID() + " - " + responseEvent.getPeerAddress().toString() + " - " + string);
            if (requestObserver != null) {
                requestObserver.requestFinishedWithError(string);
            }
            return false;
        }
        if (responseEvent.getResponse().getErrorStatus() != 0) {
            if (requestObserver != null) {
                requestObserver.requestFinishedWithError("SNMP error: " + responseEvent.getResponse().getErrorStatusText());
            }
            logger.warn(pDU.getRequestID() + " - " + responseEvent.getPeerAddress() + " (" + responseEvent.getResponse().getErrorStatusText() + "): " + SnmpLogger.printPDU(responseEvent.getResponse(), true));
            return false;
        }
        if (logger.isInfoEnabled()) {
            logger.info(pDU.getRequestID() + " - " + responseEvent.getPeerAddress() + ": " + SnmpLogger.printPDU(pDU, true));
        }
        return true;
    }

    public boolean logResponse(Address address, PDU pDU, PDU pDU2, boolean bl) {
        Logger logger;
        switch (pDU.getType()) {
            case -91: {
                logger = cGetBulkResp;
                break;
            }
            case -95: {
                logger = cGetNextResp;
                break;
            }
            case -93: {
                logger = cSetResp;
                break;
            }
            case -90: {
                logger = cInformResp;
                break;
            }
            default: {
                logger = cGetResp;
            }
        }
        if (pDU2 == null) {
            logger.warn(pDU.getRequestID() + " - Request timed out");
            return false;
        }
        if (pDU2.getType() == -88) {
            String string = "SNMPv3 report: ";
            if (pDU2.size() > 0) {
                String string2 = this._$20550 != null ? this._$20550.getPathSuffix(new ObjectID(pDU2.get(0).getOid().toString())) : pDU2.get(0).getOid().toString();
                string = string2 + " = " + ((Object)pDU2.get(0).getVariable()).toString();
            }
            logger.error(pDU2.getRequestID() + " - " + address.toString() + " - " + string);
            return false;
        }
        if (pDU2.getErrorStatus() != 0) {
            if (bl) {
                logger.error(pDU2.getRequestID() + " - " + address + " (" + pDU2.getErrorStatusText() + "): " + SnmpLogger.printPDU(pDU2, true));
            } else {
                logger.debug(pDU2.getRequestID() + " - " + address + " (" + pDU2.getErrorStatusText() + "): " + SnmpLogger.printPDU(pDU2, true));
            }
            return false;
        }
        if (bl) {
            if (logger.isInfoEnabled()) {
                logger.info(pDU2.getRequestID() + " - " + address + ": " + SnmpLogger.printPDU(pDU2, true));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(pDU2.getRequestID() + " - " + address + ": " + SnmpLogger.printPDU(pDU2, true));
        }
        return true;
    }

    public static String printTarget(Target target) {
        return target.getAddress() + " (version=" + target.getVersion() + ", timeout=" + target.getTimeout() + ", retries=" + target.getRetries() + ")";
    }

    public static String printPDU(PDU pDU, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type=");
        stringBuffer.append(Integer.toHexString(0xFF & pDU.getType()));
        stringBuffer.append(", err=" + pDU.getErrorStatus());
        stringBuffer.append(", errind=" + pDU.getErrorIndex());
        if (pDU.getType() == -92) {
            stringBuffer.append(", enterprise=" + ((PDUv1)pDU).getEnterprise());
            stringBuffer.append(", generic=" + ((PDUv1)pDU).getGenericTrap());
            stringBuffer.append(", specific=" + ((PDUv1)pDU).getSpecificTrap());
        }
        if (!bl) {
            return stringBuffer.toString();
        }
        for (int i2 = 0; i2 < pDU.size(); ++i2) {
            stringBuffer.append("\tVB[" + i2 + "] ");
            VariableBinding variableBinding = pDU.get(i2);
            stringBuffer.append(variableBinding.getOid().toString());
            if (variableBinding.getVariable() != null) {
                stringBuffer.append("(");
                stringBuffer.append(variableBinding.getSyntax());
                stringBuffer.append(")");
            }
            stringBuffer.append("=");
            Variable variable = variableBinding.getVariable();
            if (variable instanceof OctetString) {
                stringBuffer.append(((OctetString)variable).toHexString());
                continue;
            }
            if (variable instanceof TimeTicks) {
                stringBuffer.append(((TimeTicks)variable).getValue());
                continue;
            }
            if (variable != null) {
                stringBuffer.append(((Object)variable).toString());
                continue;
            }
            stringBuffer.append("<null>");
        }
        return stringBuffer.toString();
    }
}

