/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.grid;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBTableModel;
import com.agentpp.explorer.MIBTablePanel;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.grid.DisabledCellValueEditor;
import com.agentpp.explorer.grid.GridRowEvent;
import com.agentpp.explorer.grid.GridRowListener;
import com.agentpp.explorer.grid.Index;
import com.agentpp.explorer.grid.IndexComparator;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.Vector2Matrix;
import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeData;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MIBTreeData
extends TreeData
implements ResponseListener {
    static final String INDEX_COL_SUFFIX = "i";
    private static final Logger _$5475 = Logger.getLogger("GridTree");
    private SnmpLogger _$12571;
    private MIBGridTable _$20776;
    private Vector _$38571;
    private TreeMap _$38572;
    private MIBRepository _$7308;
    private Snmp _$14889;
    private GenTarget _$15220;
    private RequestObserverPanel _$29808;
    private int _$25787 = 20;
    private int _$29809 = 0;
    private int _$38573 = 10;
    protected DataModelListener dataModelListener = new DataModelAdapter();
    private Object _$18502 = new Object();
    private transient Vector _$38575;

    public MIBTreeData() {
    }

    public MIBTreeData(Snmp snmp, GenTarget genTarget, MIBRepository mIBRepository, Vector vector, RequestObserverPanel requestObserverPanel) {
        this._$7308 = mIBRepository;
        this._$12571 = new SnmpLogger(mIBRepository);
        this._$38571 = vector;
        this._$14889 = snmp;
        this._$15220 = genTarget;
        this._$29808 = requestObserverPanel;
        this._$38572 = new TreeMap(new IndexComparator(false));
        this.createMetaData();
    }

    protected void createMetaData() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object;
        this._$20776 = null;
        Cloneable cloneable3 = null;
        for (int i2 = 0; i2 < this._$38571.size(); ++i2) {
            Serializable serializable;
            Object object2;
            JCValueConverter[] jCValueConverterArray;
            MIBObjectType mIBObjectType = (MIBObjectType)this._$38571.get(i2);
            object = this._$7308.getColumnarObjectsOfTable(mIBObjectType, true, false);
            cloneable2 = new BaseMetaData(this);
            cloneable = this._$7308.getColumnarObjectsOfTable(mIBObjectType, true, true);
            Vector vector = MIBTableModel.getTitlesFromNames(mIBObjectType.getName(), (Vector)cloneable);
            Vector<JCValueConverter> vector2 = new Vector<JCValueConverter>(((Vector)cloneable).size());
            for (int i3 = 0; i3 < ((Vector)cloneable).size(); ++i3) {
                jCValueConverterArray = (JCValueConverter[])((Vector)cloneable).get(i3);
                this._$38579(mIBObjectType, (BaseMetaData)cloneable2, vector.get(i3).toString(), i3 < ((Vector)object).size(), (MIBObjectType)jCValueConverterArray);
                object2 = this._$7308.getEffectiveSyntax(jCValueConverterArray.getSyntax());
                serializable = new JCValueConverter((MIBObjectType)jCValueConverterArray, ((MIBTextualConvention)object2).getSyntax(), ((MIBTextualConvention)object2).getDisplayHint());
                vector2.addElement((JCValueConverter)serializable);
            }
            try {
                ((BaseMetaData)cloneable2).setCommitPolicy(1);
                ((BaseMetaData)cloneable2).setCacheChildren(true);
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
            IndexStruct[] indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this._$7308);
            jCValueConverterArray = new JCValueConverter[indexStructArray.length];
            for (int i4 = 0; i4 < jCValueConverterArray.length; ++i4) {
                jCValueConverterArray[i4] = (JCValueConverter)vector2.get(i4);
            }
            object2 = new Index(mIBObjectType, (Vector)object, (Vector)cloneable, vector2, indexStructArray, jCValueConverterArray);
            ((DefaultMutableTreeNode)cloneable2).setUserObject(object2);
            ((BaseMetaData)cloneable2).setDescription(mIBObjectType.getName());
            if (i2 == 0) {
                this._$20776 = new MIBGridTable((MetaDataModel)((Object)cloneable2), (Index)((DefaultMutableTreeNode)cloneable2).getUserObject());
                cloneable3 = cloneable2;
                ((DataSourceTreeModel)this.getMetaDataTree()).setRoot((TreeNode)((Object)cloneable3));
                ((DataSourceTreeModel)this.getDataTableTree()).setRoot(this._$20776);
                continue;
            }
            serializable = (Vector)this._$38572.get(object2);
            if (serializable != null) {
                ((Vector)serializable).add(cloneable2);
                continue;
            }
            serializable = new Vector(3);
            ((Vector)serializable).add(cloneable2);
            this._$38572.put(object2, serializable);
        }
        for (MIBObjectType mIBObjectType : this._$38572.keySet()) {
            int n2;
            object = (Index)((Object)mIBObjectType);
            cloneable2 = (Vector)this._$38572.get(object);
            cloneable = this._$10464((Index)object);
            if (cloneable == null) {
                for (n2 = 0; n2 < ((Vector)cloneable2).size(); ++n2) {
                    cloneable3.add((MutableTreeNode)((Vector)cloneable2).get(n2));
                }
                continue;
            }
            for (n2 = 0; n2 < ((Vector)cloneable2).size(); ++n2) {
                ((DefaultMutableTreeNode)cloneable).add((MutableTreeNode)((Vector)cloneable2).get(n2));
            }
        }
    }

    public MIBGridTable getTable(DataModelListener dataModelListener, ObjectID objectID, Index index, String string) throws DataModelException {
        if (((BaseMetaData)this._$20776.getMetaData()).getUserObject() == index) {
            return this._$20776;
        }
        return this._$20776.getTableForIndex(dataModelListener, objectID, index, string);
    }

    private void _$38579(MIBObjectType mIBObjectType, BaseMetaData baseMetaData, String string, boolean bl, MIBObjectType mIBObjectType2) {
        BaseColumn baseColumn = new BaseColumn();
        baseColumn.setColumnLabel(string);
        MIBTextualConvention mIBTextualConvention = this._$7308.getEffectiveSyntax(mIBObjectType2.getSyntax());
        ValueConverter valueConverter = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        baseColumn.setColumnClassName(valueConverter.getNativeExample().getClass().getName());
        baseColumn.setAutoIncrement(false);
        baseColumn.setSchemaName(mIBObjectType.getName());
        if (bl) {
            baseColumn.setColumnName(mIBObjectType2.getOid().toString() + INDEX_COL_SUFFIX);
        } else {
            baseColumn.setColumnName(mIBObjectType2.getOid().toString());
        }
        try {
            baseMetaData.addColumn(baseColumn);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    static boolean isColumnReadOnly(MIBObjectType mIBObjectType) {
        String string = mIBObjectType.getAccess();
        return string.equals(SMI.ACCESS[1]);
    }

    private BaseMetaData _$10464(Index index) {
        SortedMap sortedMap = this._$38572.headMap(index);
        IndexComparator indexComparator = new IndexComparator(false);
        try {
            Index index2 = sortedMap.lastKey();
            return (BaseMetaData)sortedMap.get(index2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void refresh(ObjectID objectID, ObjectID objectID2) {
        this._$20776.removeAll();
        Vector vector = this._$20776.getColumnIDs();
        Walker walker = new Walker(this._$20776, vector, this._$38573);
        walker.setIndexFrom(objectID);
        walker.setIndexTo(objectID2);
        walker.setRecursive(true);
        walker.next();
    }

    public Vector getTables() {
        return this._$38571;
    }

    protected void refreshFinished() {
        this.enableDataModelEvents(true);
        try {
            super.requeryAll(this.dataModelListener);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        this._$29809 = 0;
    }

    private boolean _$38598(ResponseEvent responseEvent, boolean bl) {
        boolean bl2 = true;
        MIBGridTable mIBGridTable = ((Walker)responseEvent.getUserObject()).getModel();
        if (!bl && responseEvent.getResponse() != null && responseEvent.getResponse().getType() != -88 && responseEvent.getResponse().getErrorStatus() != 0 && responseEvent.getUserObject() == null && responseEvent.getResponse().getErrorStatus() == 2) {
            mIBGridTable.removeRow(responseEvent.getRequest().get(0).getOid());
            return true;
        }
        if (bl) {
            Object[] objectArray = responseEvent.getResponse().toArray();
            this._$29809 += objectArray.length;
            if (responseEvent.getUserObject() instanceof Walker) {
                Walker walker = (Walker)responseEvent.getUserObject();
                Vector vector = walker.getLastSend();
                Vector vector2 = Vector2Matrix.getMatrix(objectArray, vector.size());
                for (int i2 = 0; i2 < vector2.size(); ++i2) {
                    Serializable serializable;
                    Vector vector3 = (Vector)vector2.elementAt(i2);
                    Vector vector4 = new Vector(vector3.size() + 1);
                    for (int i3 = 0; i3 < vector3.size(); ++i3) {
                        OID oID = (OID)vector.elementAt(i3);
                        serializable = (VariableBinding)vector3.elementAt(i3);
                        if (((VariableBinding)serializable).isException() || ((VariableBinding)serializable).getOid().leftMostCompare(oID.size(), oID) != 0) continue;
                        vector4.addElement(vector3.elementAt(i3));
                    }
                    Object[] objectArray2 = new VariableBinding[vector4.size()];
                    vector4.copyInto(objectArray2);
                    if (objectArray2.length <= 0) continue;
                    boolean bl3 = true;
                    if (walker.getIndexFrom() != null || walker.getIndexTo() != null) {
                        serializable = mIBGridTable.getIndex(((VariableBinding)objectArray2[0]).getOid());
                        if (serializable != null) {
                            if (walker.getIndexFrom() != null && ((ObjectID)serializable).compareTo(walker.getIndexFrom()) < 0) {
                                bl3 = false;
                            }
                            if (walker.getIndexTo() != null && ((ObjectID)serializable).compareTo(walker.getIndexTo()) > 0) {
                                bl3 = false;
                            }
                        } else {
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        mIBGridTable.refreshRow((VariableBinding[])objectArray2);
                    }
                    if (i2 + 1 < vector2.size() && objectArray2.length <= ((Vector)vector2.get(i2 + 1)).size()) continue;
                    try {
                        Cloneable cloneable;
                        Serializable serializable2;
                        boolean bl4 = true;
                        if (walker.getIndexTo() != null) {
                            serializable2 = mIBGridTable.getColumnIDs();
                            cloneable = new OID(((OID)((Vector)serializable2).firstElement()).getValue());
                            cloneable.append(walker.getIndexTo().toString());
                            if (cloneable.leftMostCompare(cloneable.size(), ((VariableBinding)objectArray2[0]).getOid()) <= 0) {
                                bl4 = false;
                            }
                        }
                        if (bl4) {
                            serializable2 = this._$15220.makePDU();
                            ((PDU)serializable2).addAll((VariableBinding[])objectArray2);
                            ((PDU)serializable2).setMaxRepetitions(this._$25787);
                            walker.setLastSend(vector);
                            cloneable = this._$15220.getTarget();
                            this._$29808.resendRequest(-91, (PDU)serializable2, this._$15220, (Target)cloneable, walker, this, this._$29873());
                            bl2 = false;
                            break;
                        }
                        if (!walker.next()) break;
                        bl2 = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                if (bl2) {
                    boolean bl5 = bl2 = !walker.next();
                    if (bl2 && walker.isRecursive() && !walker.getModel().getMetaData().isLeaf()) {
                        Walker[] walkerArray = new Walker[2];
                        for (int i4 = 0; i4 < walker.getModel().getRowCount(); ++i4) {
                            long l2 = walker.getModel().getRowIdentifier(i4);
                            Walker[] walkerArray2 = walker.getModel()._$38603(l2);
                            if (walkerArray[0] == null) {
                                walkerArray[0] = walkerArray2[0];
                            } else {
                                walkerArray[1].setNext(walkerArray2[0]);
                            }
                            walkerArray[1] = walkerArray2[1];
                            bl2 = false;
                        }
                        if (!bl2) {
                            walkerArray[0].next();
                        }
                    }
                    if (bl2 && walker.getNext() != null) {
                        walker.getNext().next();
                        bl2 = false;
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(ResponseEvent responseEvent) {
        Object object = this._$18502;
        synchronized (object) {
            try {
                this._$14889.cancel(responseEvent.getRequest(), this);
                this._$29808.removeOutstanding(responseEvent.getRequest());
                if (this._$29808.isRequestCanceled()) {
                    this.refreshFinished();
                    return;
                }
                boolean bl = this._$12571.logResponse(responseEvent, this._$29808);
                if (this._$38598(responseEvent, bl)) {
                    if (bl) {
                        this._$29808.requestFinished();
                    }
                    this._$18502.notify();
                    this.refreshFinished();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.refreshFinished();
            }
        }
    }

    public void requeryAll(DataModelListener dataModelListener) {
        try {
            this._$20776.cancelAllRowChanges(dataModelListener);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        this._$20776.removeAll();
        this.refresh(null, null);
    }

    public TreeMap getMetaData() {
        return this._$38572;
    }

    public MIBRepository getRepository() {
        return this._$7308;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$7308 = mIBRepository;
    }

    private String _$29873() {
        return "Received " + this._$29809 + " instances...";
    }

    public synchronized void removeGridRowListener(GridRowListener gridRowListener) {
        if (this._$38575 != null && this._$38575.contains(gridRowListener)) {
            Vector vector = (Vector)this._$38575.clone();
            vector.removeElement(gridRowListener);
            this._$38575 = vector;
        }
    }

    public synchronized void addGridRowListener(GridRowListener gridRowListener) {
        Vector vector;
        Vector vector2 = vector = this._$38575 == null ? new Vector(2) : (Vector)this._$38575.clone();
        if (!vector.contains(gridRowListener)) {
            vector.addElement(gridRowListener);
            this._$38575 = vector;
        }
    }

    protected void fireGridRowEvent(GridRowEvent gridRowEvent) {
        if (this._$38575 != null) {
            Vector vector = this._$38575;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((GridRowListener)vector.elementAt(i2)).gridRowEvent(gridRowEvent);
            }
        }
    }

    class CellValue {
        public JCValueConverter vc;
        public Object value;

        public CellValue(JCValueConverter jCValueConverter, Object object) {
            this.vc = jCValueConverter;
            this.value = object;
        }

        public MIBRepository getRepository() {
            return MIBTreeData.this._$7308;
        }

        public String toString() {
            Object object = this.value;
            if (this.vc.getEffectiveSyntax().hasEnums()) {
                if (object instanceof Integer) {
                    Integer n2 = (Integer)object;
                    if (n2 == null) {
                        return "";
                    }
                    MIBEnum mIBEnum = this.vc.getEffectiveSyntax().getEnum(n2.intValue());
                    if (mIBEnum != null) {
                        object = mIBEnum.toString();
                    }
                }
            } else if (this.vc.getSMISyntax() == 11 && object instanceof Long) {
                object = new TimeTicks((Long)object).toString();
            } else if (object instanceof ObjectID) {
                ObjectID objectID = (ObjectID)object;
                String string = MIBTreeData.this._$7308.getObjectName(objectID);
                if (string == null) {
                    string = MIBTreeData.this._$7308.getPathSuffix(objectID);
                }
                if (string != null) {
                    object = string;
                }
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
    }

    class CellValueComparator
    implements Comparator {
        CellValueComparator() {
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof CellValue && object2 instanceof CellValue) {
                CellValue cellValue = (CellValue)object;
                CellValue cellValue2 = (CellValue)object2;
                return cellValue.vc.compare(cellValue.value, cellValue2.value);
            }
            return ((Comparable)object).compareTo(object2);
        }
    }

    class Setter
    implements ResponseListener {
        private PDU _$18356;
        private long _$355;
        private Target _$15220;
        private PDU _$18357;
        private String _$7330;
        private String _$38637;
        private boolean _$18358 = false;

        public Setter(PDU pDU, Target target, long l2, String string) {
            this._$18356 = pDU;
            this._$355 = l2;
            this._$15220 = target;
            this._$7330 = string;
        }

        public void run() throws IOException {
            MIBTreeData.this._$29808.setCurrentRequest(this._$18356, this, "Comitting row with index " + this._$7330);
            MIBTreeData.this._$14889.set(this._$18356, this._$15220, null, this);
            MIBTreeData.this._$12571;
            SnmpLogger.logRequest(this._$18356, MIBTreeData.this._$15220);
        }

        public PDU getResponse() {
            return this._$18357;
        }

        public long getRow() {
            return this._$355;
        }

        public String getErrorText() {
            return this._$38637;
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            MIBTreeData.this._$14889.cancel(responseEvent.getRequest(), this);
            MIBTreeData.this._$29808.requestFinished();
            this._$18357 = responseEvent.getResponse();
            if (MIBTreeData.this._$12571.logResponse(responseEvent.getPeerAddress(), this._$18356, this._$18357, true)) {
                MIBTreeData.this._$29808.requestFinished();
            } else {
                this._$18358 = true;
                String string = "Timeout";
                if (this._$18357 != null) {
                    string = "Error while trying to commit row " + this._$7330 + ": " + this._$18357.getErrorStatusText();
                }
                MIBTreeData.this._$29808.requestFinishedWithError(string);
                this._$38637 = string;
            }
            this.notify();
        }

        public boolean isError() {
            return this._$18358;
        }
    }

    class Walker {
        private int _$16162 = 0;
        private Vector _$29849;
        private Vector _$29953;
        private int _$29954;
        private ObjectID _$29955;
        private ObjectID _$29956;
        private MIBGridTable _$11754;
        private boolean _$38629 = false;
        private Walker _$38636 = null;

        public Walker(MIBGridTable mIBGridTable, Vector vector, int n2) {
            this._$29849 = vector;
            this._$29954 = n2;
            this._$11754 = mIBGridTable;
        }

        public Vector getLastSend() {
            return this._$29953;
        }

        public void setMaxColumns(int n2) {
            this._$29954 = n2;
        }

        public void setLastSend(Vector vector) {
            this._$29953 = vector;
        }

        public MIBGridTable getModel() {
            return this._$11754;
        }

        public ObjectID getIndexFrom() {
            return this._$29955;
        }

        public ObjectID getIndexTo() {
            return this._$29956;
        }

        public void setIndexFrom(ObjectID objectID) {
            this._$29955 = objectID;
        }

        public void setIndexTo(ObjectID objectID) {
            this._$29956 = objectID;
        }

        public Walker getNext() {
            return this._$38636;
        }

        public void setNext(Walker walker) {
            this._$38636 = walker;
        }

        public boolean next() {
            if (this._$16162 >= this._$29849.size()) {
                return false;
            }
            PDU pDU = MIBTreeData.this._$15220.makePDU();
            int n2 = Math.min(this._$29954, this._$29849.size() - this._$16162);
            if (MIBTreeData.this._$25787 > 0) {
                if (this._$16162 == 0) {
                    pDU.setMaxRepetitions(2);
                } else {
                    pDU.setMaxRepetitions(MIBTreeData.this._$25787);
                }
                pDU.setNonRepeaters(0);
            } else {
                pDU.setNonRepeaters(n2);
                pDU.setMaxRepetitions(0);
            }
            this._$29953 = new Vector(n2 + 1);
            for (int i2 = this._$16162; i2 < this._$16162 + n2; ++i2) {
                Serializable serializable;
                OID oID = (OID)this._$29849.elementAt(i2);
                if (this._$29955 != null) {
                    serializable = new ObjectID(oID.toString());
                    ((ObjectID)serializable).append(this._$29955);
                    serializable = MIBTablePanel.predecessor((ObjectID)serializable);
                    oID = new OID(((ObjectID)serializable).toString());
                }
                serializable = new VariableBinding();
                ((VariableBinding)serializable).setOid(oID);
                pDU.add((VariableBinding)serializable);
                this._$29953.add(this._$29849.elementAt(i2));
            }
            try {
                Target target = MIBTreeData.this._$15220.getTarget();
                if (this._$16162 == 0) {
                    MIBTreeData.this._$29808.request(-91, pDU, MIBTreeData.this._$15220, target, this, MIBTreeData.this, MIBTreeData.this._$29873());
                } else {
                    MIBTreeData.this._$29808.resendRequest(-91, pDU, MIBTreeData.this._$15220, target, this, MIBTreeData.this, MIBTreeData.this._$29873());
                }
                this._$16162 += pDU.size();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }

        public void setRecursive(boolean bl) {
            this._$38629 = bl;
        }

        public boolean isRecursive() {
            return this._$38629;
        }
    }

    class MIBGridTable
    extends BaseDataTable {
        protected Vector colids;
        protected Index index;
        protected Vector indexes;
        protected TreeMap index2row;
        protected int lastRowSet;

        public MIBGridTable(MetaDataModel metaDataModel, Index index) {
            super(metaDataModel);
            this.index = null;
            this.indexes = new Vector(10, 10);
            this.index2row = new TreeMap();
            this.lastRowSet = -1;
            this.index = index;
            this._$10904();
        }

        public MIBGridTable(MetaDataModel metaDataModel, long l2, Index index) {
            super(metaDataModel, l2);
            this.index = null;
            this.indexes = new Vector(10, 10);
            this.index2row = new TreeMap();
            this.lastRowSet = -1;
            this.index = index;
            this._$10904();
        }

        public Object createNewRow() throws DataModelException {
            Vector vector = this.createDefaultInstances();
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public Index getIndex() {
            return this.index;
        }

        public int getFirstWritableColumn() {
            Vector vector = this.index.getColumns();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                MIBObjectType mIBObjectType = (MIBObjectType)vector.get(i2);
                if (MIBTreeData.isColumnReadOnly(mIBObjectType)) continue;
                return i2;
            }
            return 0;
        }

        public DataTableModel materializeTable(DataModelListener dataModelListener, long l2, TreeNode treeNode) throws DataModelException {
            return new MIBGridTable((BaseMetaData)treeNode, l2, (Index)((BaseMetaData)treeNode).getUserObject());
        }

        public MIBGridTable getTableForIndex(DataModelListener dataModelListener, ObjectID objectID, Index index, String string) throws DataModelException {
            if (this.index == index) {
                return this;
            }
            BaseMetaData baseMetaData = null;
            baseMetaData = this._$29893((BaseMetaData)this.getMetaData(), index);
            if (baseMetaData != null) {
                for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                    ObjectID objectID2 = (ObjectID)this.indexes.get(i2);
                    long l2 = this.getRowIdentifier(i2);
                    if (objectID.equals(objectID2) || objectID.isChildOf(objectID2)) {
                        MIBGridTable mIBGridTable = (MIBGridTable)this.getTable(l2, baseMetaData);
                        if (mIBGridTable == null) {
                            return (MIBGridTable)this.createTable(dataModelListener, l2, baseMetaData);
                        }
                        return mIBGridTable.getTableForIndex(dataModelListener, objectID, index, string);
                    }
                    try {
                        if (objectID.isLessThan(objectID2)) {
                            return (MIBGridTable)this.createTable(dataModelListener, l2, baseMetaData);
                        }
                        if (i2 + 1 >= this.getRowCount() && objectID2.isLessThan(objectID)) {
                            return (MIBGridTable)this.createTable(dataModelListener, l2, baseMetaData);
                        }
                        continue;
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        objectIDFormatException.printStackTrace();
                    }
                }
            }
            return null;
        }

        private BaseMetaData _$29893(BaseMetaData baseMetaData, Index index) {
            BaseMetaData baseMetaData2 = null;
            for (int i2 = 0; baseMetaData2 == null && i2 < baseMetaData.getChildCount(); ++i2) {
                BaseMetaData baseMetaData3 = (BaseMetaData)baseMetaData.getChildAt(i2);
                if (baseMetaData3.getUserObject() == index) {
                    baseMetaData2 = baseMetaData3;
                    break;
                }
                baseMetaData2 = this._$29893(baseMetaData3, index);
            }
            return baseMetaData2;
        }

        public void setValueAt(long l2, String string, Object object) throws DataModelException {
            Object object2 = super.getCell(l2, string);
            if (object instanceof DisabledCellValueEditor || !(object2 instanceof CellValue)) {
                super.setValueAt(l2, string, object2);
                return;
            }
            CellValue cellValue = (CellValue)object2;
            super.setValueAt(l2, string, new CellValue(cellValue.vc, cellValue.vc.toNative(cellValue.vc.fromString(object.toString()))));
        }

        public void removeAll() {
            super.removeAllChildren();
            this.store.clear();
            this.internalData.clear();
            this.insertedRows.clear();
            this.index2row = new TreeMap();
            this.indexes.clear();
        }

        private void _$10904() {
            this.colids = new Vector(this.index.getColumns().size() + 1);
            int n2 = 0;
            Enumeration enumeration = this.index.getColumns().elements();
            while (enumeration.hasMoreElements()) {
                MIBObjectType mIBObjectType = (MIBObjectType)enumeration.nextElement();
                if (n2 >= this.index.getIndexStructure().length && !mIBObjectType.getAccess().equals(SMI.ACCESS[0])) {
                    this.colids.addElement(new OID(mIBObjectType.getOid().toString()));
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveRow(long l2) throws DataModelException {
            Object object;
            int n2 = this.getRowIndex(l2);
            ObjectID objectID = (ObjectID)this.indexes.get(n2);
            String string = ((Index)((BaseMetaData)this.getMetaData()).getUserObject()).getTable().getName() + "." + objectID;
            if (_$5475.isInfoEnabled()) {
                _$5475.info("Comitting row with index " + string);
            }
            PDU pDU = MIBTreeData.this._$15220.makePDU();
            for (int i2 = this.index.getIndexStructure().length; i2 < this.getMetaData().getColumnCount(); ++i2) {
                object = this.getMetaData().getColumnIdentifier(i2);
                if (!this.getMetaData().getColumnObject((String)object).isWritable()) continue;
                VariableBinding variableBinding = new VariableBinding();
                variableBinding.setOid(new OID(this.getColumnObject(i2).getOid().toString() + "." + this.getIndexOf(n2)));
                CellValue cellValue = (CellValue)this.getResultData(l2, (String)object);
                Variable variable = cellValue.vc.fromNative(cellValue.value);
                if (variable == null) continue;
                variableBinding.setVariable(variable);
                pDU.add(variableBinding);
            }
            Setter setter = new Setter(pDU, MIBTreeData.this._$15220.getTarget(), l2, string);
            object = setter;
            synchronized (object) {
                try {
                    setter.run();
                }
                catch (IOException iOException) {
                    throw new DataModelException(l2, "", this, 10, iOException);
                }
                try {
                    setter.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (setter.isError()) {
                object = null;
                if (setter.getResponse() != null && setter.getResponse().getErrorIndex() > 0) {
                    try {
                        object = this.getMetaData().getColumnIdentifier(setter.getResponse().getErrorIndex() - 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                throw new DataModelException(l2, (String)object, this, 10, new RuntimeException(setter.getErrorText()));
            }
        }

        public Vector getColumnIDs() {
            return this.colids;
        }

        public Vector getColumns() {
            return this.index.getColumns();
        }

        public int getColumn(OID oID) {
            for (int i2 = 0; i2 < this.colids.size(); ++i2) {
                OID oID2 = (OID)this.colids.elementAt(i2);
                if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
                return this.index.getIndexStructure().length + i2;
            }
            return -1;
        }

        public int getColumn(OID oID, int n2) {
            for (int i2 = n2; i2 < this.colids.size(); ++i2) {
                OID oID2 = (OID)this.colids.elementAt(i2);
                if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
                return this.index.getIndexStructure().length + i2;
            }
            return -1;
        }

        public OID getOidOf(int n2, int n3) {
            MIBObject mIBObject = (MIBObject)this.index.getColumns().elementAt(n3);
            OID oID = new OID(mIBObject.getPrintableOid());
            oID.append(new OID(this.getIndexOf(n2).toString()));
            return oID;
        }

        public MIBObjectType getColumnObject(int n2) {
            return (MIBObjectType)this.getColumns().elementAt(n2);
        }

        public boolean isCellEditable(int n2, int n3) {
            return SMI.isWritable(this.getColumnObject(n3).getAccess());
        }

        public int getRow(ObjectID objectID) {
            if (this.index2row.containsKey(objectID)) {
                return this.index2row.headMap(objectID).size();
            }
            return -1;
        }

        public int getRow(OID oID) {
            ObjectID objectID = new ObjectID(oID.toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$7308.getSplittedObjectID((ObjectID)objectID).second;
                return this.getRow(objectID);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
                return -1;
            }
        }

        public ObjectID getIndex(OID oID) {
            if (oID == null) {
                return null;
            }
            ObjectID objectID = new ObjectID(oID.toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$7308.getSplittedObjectID((ObjectID)objectID).second;
                return objectID;
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
                return null;
            }
        }

        public ObjectID getIndexOf(int n2) {
            if (n2 < 0 || n2 >= this.indexes.size()) {
                return null;
            }
            return (ObjectID)this.indexes.elementAt(n2);
        }

        public int getIndexColumnCount() {
            return this.index.getIndexStructure().length;
        }

        public void refreshStart() {
            MIBTreeData.this._$29809 = 0;
            this.lastRowSet = -1;
        }

        public void refreshEnd() {
        }

        public Vector createDefaultInstances() {
            Vector<CellValue> vector = new Vector<CellValue>(this.getColumns().size());
            for (int i2 = 0; i2 < this.getColumns().size(); ++i2) {
                MIBObjectType mIBObjectType = this.getColumnObject(i2);
                JCValueConverter jCValueConverter = this.getValueConverter(i2);
                Variable variable = JCValueConverter.getDefaultValue(MIBTreeData.this._$7308, mIBObjectType, jCValueConverter.getEffectiveSyntax());
                if (variable == null) {
                    variable = this.getInitialValue(jCValueConverter.getEffectiveSyntax());
                }
                vector.addElement(new CellValue(jCValueConverter, jCValueConverter.toNative(variable)));
            }
            return vector;
        }

        protected void setIndexObjects(int n2, ObjectID objectID) {
            ObjectID[] objectIDArray = null;
            objectIDArray = MIBTreeData.this._$7308.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            for (int i2 = 0; i2 < this.getIndexColumnCount(); ++i2) {
                if (objectIDArray == null) continue;
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(i2);
                Variable variable = IndexConverter.getIndexVariable(this.index.getIndexStructure()[i2], objectIDArray[i2]);
                if (variable == null) continue;
                try {
                    super.setValueAt(this.getRowIdentifier(n2), objectIDArray[i2].toString(), new CellValue(jCValueConverter, jCValueConverter.toNative(variable)));
                    continue;
                }
                catch (DataModelException dataModelException) {
                    dataModelException.printStackTrace();
                }
            }
        }

        public JCValueConverter getValueConverter(int n2) {
            return (JCValueConverter)this.index.getValueConverter().elementAt(n2);
        }

        public Vector getValueConverters() {
            return this.index.getValueConverter();
        }

        private void _$29869(ObjectID objectID, VariableBinding[] variableBindingArray) {
            int n2;
            int n3 = this.getRowIndex(objectID);
            if (n3 == Integer.MAX_VALUE) {
                n3 = this.getRowCount();
            }
            if (n3 - this.lastRowSet > 1) {
                for (n2 = 0; n2 < n3 - this.lastRowSet - 1; ++n2) {
                    this.removeRow(this.lastRowSet + 1);
                }
            }
            if ((n2 = this.setRow(variableBindingArray, true)) > this.lastRowSet) {
                this.lastRowSet = n2;
            }
        }

        public void refreshRow(VariableBinding[] variableBindingArray) {
            if (variableBindingArray.length <= 0) {
                return;
            }
            ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().getValue());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$7308.getSplittedObjectID((ObjectID)objectID).second;
                if (objectID != null) {
                    OID oID = new OID(objectID.asIntArray());
                    VariableBinding[] variableBindingArray2 = variableBindingArray;
                    for (int i2 = 0; i2 < variableBindingArray2.length; ++i2) {
                        if (variableBindingArray2[i2].getOid().rightMostCompare(oID.size(), oID) == 0) continue;
                        VariableBinding[] variableBindingArray3 = new VariableBinding[i2];
                        if (variableBindingArray3.length > 0) {
                            System.arraycopy(variableBindingArray2, 0, variableBindingArray3, 0, i2);
                            this._$29869(objectID, variableBindingArray3);
                        }
                        variableBindingArray3 = new VariableBinding[variableBindingArray2.length - i2];
                        objectID = new ObjectID(variableBindingArray2[i2].getOid().getValue());
                        System.arraycopy(variableBindingArray2, i2, variableBindingArray3, 0, variableBindingArray2.length - i2);
                        variableBindingArray2 = variableBindingArray3;
                        objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$7308.getSplittedObjectID((ObjectID)objectID).second;
                        if (objectID != null) {
                            oID = new OID(objectID.asIntArray());
                        }
                        i2 = 0;
                    }
                    if (variableBindingArray2.length > 0) {
                        this._$29869(objectID, variableBindingArray2);
                    }
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
                objectIDFormatException.printStackTrace();
            }
        }

        public int getNumDataRows() {
            return this.indexes.size();
        }

        public int setRow(VariableBinding[] variableBindingArray, boolean bl) {
            if (variableBindingArray.length <= 0) {
                return -1;
            }
            return this.setSparseRow(variableBindingArray, bl);
        }

        public int setSparseRow(VariableBinding[] variableBindingArray, boolean bl) {
            if (variableBindingArray.length <= 0) {
                return -1;
            }
            ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$7308.getSplittedObjectID((ObjectID)objectID).second;
                int n2 = -1;
                if (objectID != null) {
                    n2 = this.getRow(objectID);
                    if (n2 < 0) {
                        n2 = bl ? this.addEmptyRow(objectID, null) : this.addNewRow(objectID);
                    }
                    int n3 = this.getIndexColumnCount();
                    for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
                        int n4 = this.getColumn(variableBindingArray[i2].getOid(), i2);
                        if (n4 < 0) continue;
                        JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n4);
                        try {
                            CellValue cellValue = new CellValue(jCValueConverter, jCValueConverter.toNative(variableBindingArray[i2].getVariable()));
                            super.setValueAt(this.getRowIdentifier(n2), this.colids.get(n4 - n3).toString(), cellValue);
                            continue;
                        }
                        catch (DataModelException dataModelException) {
                            dataModelException.printStackTrace();
                        }
                    }
                }
                return n2;
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
                objectIDFormatException.printStackTrace();
                return -1;
            }
        }

        protected int getRowIndex(ObjectID objectID) {
            try {
                if (((ObjectID)this.index2row.lastKey()).isLessThan(objectID)) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (Exception exception) {
                return Integer.MAX_VALUE;
            }
            int n2 = this.index2row.headMap(objectID).size();
            return n2;
        }

        protected int addRowAt(ObjectID objectID, Vector vector, DataModelListener dataModelListener) {
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            int n2 = this.getRowIndex(objectID);
            if (n2 >= 0) {
                if (n2 == Integer.MAX_VALUE) {
                    n2 = this.getRowCount();
                    this.addInternalRow(objectArray);
                    this.indexes.addElement(objectID);
                } else {
                    this.addInternalRow(objectArray, n2);
                    this.indexes.insertElementAt(objectID, n2);
                }
                this.index2row.put(objectID, objectID);
            }
            return n2;
        }

        protected long addRowAt(ObjectID objectID, Vector vector) {
            long l2 = -1L;
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            int n2 = this.getRowIndex(objectID);
            if (n2 >= 0) {
                if (n2 == Integer.MAX_VALUE) {
                    n2 = this.getRowCount();
                    l2 = this.addInternalRow(objectArray);
                    this.indexes.addElement(objectID);
                } else {
                    l2 = this.addInternalRow(objectArray, n2);
                    this.indexes.insertElementAt(objectID, n2);
                }
                this.index2row.put(objectID, objectID);
            }
            return l2;
        }

        public int addNewRow(ObjectID objectID) {
            int n2;
            Vector vector = this.createDefaultInstances();
            ObjectID[] objectIDArray = MIBTreeData.this._$7308.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            for (n2 = this.getIndexColumnCount() - 1; n2 >= 0; --n2) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n2);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n2], objectIDArray[n2]));
                vector.setElementAt(new CellValue(jCValueConverter, object), n2);
            }
            n2 = this.addRowAt(objectID, vector, null);
            return n2;
        }

        public String getIndexString(ObjectID objectID) {
            if (objectID == null) {
                return "<null>";
            }
            ObjectID[] objectIDArray = MIBTreeData.this._$7308.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            ValueConverter[] valueConverterArray = new JCValueConverter[this.getIndexColumnCount()];
            for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
                valueConverterArray[i2] = (JCValueConverter)this.index.getValueConverter().elementAt(i2);
            }
            return IndexConverter.getIndexString(valueConverterArray, this.index.getIndexStructure(), objectIDArray);
        }

        public int addEmptyRow(ObjectID objectID, DataModelListener dataModelListener) {
            int n2;
            ObjectID[] objectIDArray = MIBTreeData.this._$7308.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            Vector<CellValue> vector = new Vector<CellValue>(this.getIndexColumnCount() + 1);
            for (n2 = 0; n2 < this.getIndexColumnCount(); ++n2) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n2);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n2], objectIDArray[n2]));
                vector.addElement(new CellValue(jCValueConverter, object));
            }
            for (n2 = this.getIndexColumnCount(); n2 < this.index.getColumns().size(); ++n2) {
                vector.add(new CellValue((JCValueConverter)this.index.getValueConverter().get(n2), null));
            }
            return this.addRowAt(objectID, vector, dataModelListener);
        }

        public long addEmptyRow(ObjectID objectID) {
            int n2;
            ObjectID[] objectIDArray = MIBTreeData.this._$7308.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            Vector<CellValue> vector = new Vector<CellValue>(this.getIndexColumnCount() + 1);
            for (n2 = 0; n2 < this.getIndexColumnCount(); ++n2) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n2);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n2], objectIDArray[n2]));
                vector.addElement(new CellValue(jCValueConverter, object));
            }
            for (n2 = this.getIndexColumnCount(); n2 < this.index.getColumns().size(); ++n2) {
                vector.add(new CellValue((JCValueConverter)this.index.getValueConverter().get(n2), null));
            }
            return this.addRowAt(objectID, vector);
        }

        public boolean removeRow(OID oID) {
            try {
                ObjectID objectID = this.getIndex(oID);
                int n2 = this.getRowIndex(objectID);
                this.index2row.remove(objectID);
                this.indexes.removeElementAt(n2);
                this.store.removeRow(this.getRowIdentifier(n2));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean removeRow(int n2) {
            try {
                ObjectID objectID = (ObjectID)this.indexes.elementAt(n2);
                this.index2row.remove(objectID);
                this.indexes.removeElementAt(n2);
                this.store.removeRow(this.getRowIdentifier(n2));
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        public Variable getInitialValue(MIBSyntax mIBSyntax) {
            if (mIBSyntax.getType() == 3 && (mIBSyntax = MIBTreeData.this._$7308.resolveTC(mIBSyntax.getSyntax())) == null) {
                return null;
            }
            if (mIBSyntax.hasEnums()) {
                return new Integer32((int)mIBSyntax.getEnumsVector().firstElement().getLongValue());
            }
            if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32")) {
                return new Integer32();
            }
            if (mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32")) {
                return new Counter32();
            }
            if (mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32")) {
                return new Gauge32();
            }
            if (mIBSyntax.getSyntax().equals("Counter64")) {
                return new Counter64();
            }
            if (mIBSyntax.getSyntax().equals("TimeTicks")) {
                return new TimeTicks();
            }
            if (mIBSyntax.getSyntax().equals("IpAddress") || mIBSyntax.getSyntax().equals("NetworkAddress")) {
                return new IpAddress("0.0.0.0");
            }
            if (mIBSyntax.getSyntax().equals("Opaque")) {
                return new Opaque();
            }
            if (mIBSyntax.getSyntax().startsWith("OCTET STRING")) {
                return new OctetString();
            }
            if (mIBSyntax.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax.getSyntax().equals("OBJECT IDENTIFIER")) {
                return new OID();
            }
            return null;
        }

        public void removeAllChildren() {
        }

        public Walker makeRefresh(ObjectID objectID, ObjectID objectID2, boolean bl) {
            Vector vector = this.getColumnIDs();
            Walker walker = new Walker(this, vector, MIBTreeData.this._$38573);
            walker.setIndexFrom(objectID);
            walker.setIndexTo(objectID2);
            walker.setRecursive(bl);
            return walker;
        }

        public void refreshRow(long l2) {
            ObjectID objectID = this.getIndexOf(super.getRowIndex(l2));
            Walker walker = this.makeRefresh(objectID, objectID, false);
            walker.next();
        }

        public void refresh(long l2) throws DataModelException {
            super.refreshRow(l2);
        }

        public void requeryTable(DataModelListener dataModelListener) {
            try {
                this.cancelAllRowChanges(dataModelListener);
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
            try {
                this.removeAll();
                ObjectID objectID = null;
                MIBGridTable mIBGridTable = (MIBGridTable)this.getParent();
                if (mIBGridTable != null) {
                    objectID = mIBGridTable.getIndexOf(mIBGridTable.getRowIndex(super.getParentBookmark()));
                }
                Walker walker = this.makeRefresh(objectID, objectID, true);
                walker.next();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void requeryRowAndDetails(DataModelListener dataModelListener, long l2) throws DataModelException {
            this.cancelAllRowChanges(dataModelListener);
            try {
                ObjectID objectID = this.getIndexOf(super.getRowIndex(l2));
                Walker walker = this.makeRefresh(objectID, objectID, false);
                Walker[] walkerArray = this._$38603(l2);
                if (walkerArray[0] != null) {
                    walker.setNext(walkerArray[0]);
                }
                walker.next();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private Walker[] _$38603(long l2) {
            int n2 = super.getRowIndex(l2);
            ObjectID objectID = this.getIndexOf(n2);
            ObjectID objectID2 = null;
            if (n2 + 1 < this.getRowCount()) {
                objectID2 = this.getIndexOf(n2 + 1);
                objectID2 = MIBTablePanel.predecessor(new ObjectID(objectID2));
            }
            Walker[] walkerArray = new Walker[2];
            for (int i2 = 0; i2 < this.getMetaData().getChildCount(); ++i2) {
                if (_$5475.isDebugEnabled()) {
                    _$5475.debug("Requery row details for child " + i2);
                }
                BaseMetaData baseMetaData = (BaseMetaData)this.getMetaData().getChildAt(i2);
                MIBGridTable mIBGridTable = new MIBGridTable(baseMetaData, l2, (Index)baseMetaData.getUserObject());
                this.add(mIBGridTable);
                Walker walker = new Walker(mIBGridTable, mIBGridTable.getColumnIDs(), MIBTreeData.this._$38573);
                walker.setIndexFrom(objectID);
                walker.setIndexTo(objectID2);
                if (walkerArray[0] == null) {
                    walkerArray[0] = walker;
                } else {
                    walkerArray[1].setNext(walker);
                }
                walkerArray[1] = walker;
            }
            return walkerArray;
        }

        public void requeryDetails(long l2) {
            Walker[] walkerArray = this._$38603(l2);
            if (walkerArray[0] != null) {
                walkerArray[0].next();
            }
        }
    }
}

