/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.editors.validator;

import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.klg.jclass.field.validate.JCStringValidator;
import java.net.InetAddress;
import java.util.Locale;

public class IpAddressValidator
extends JCStringValidator {
    public IpAddressValidator() {
        super(Locale.getDefault(), null, 0, null, null, false, null, " ~*+?}[]{}()&%$\u00a7\"!/:;,#'|<>", false, "0.0.0.0");
    }

    public boolean validate(Object object) {
        if (object == null) {
            return false;
        }
        ObjectID objectID = new ObjectID(object.toString());
        try {
            if (!ObjectID.isIdentifier(objectID.toString())) {
                if (objectID.size() != 4) {
                    return false;
                }
                for (int i2 = 0; i2 < objectID.size(); ++i2) {
                    if (objectID.getSubIDAsLong(i2) <= 255L) continue;
                    return false;
                }
            } else {
                InetAddress inetAddress = InetAddress.getByName(object.toString());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean inRange(Object object) {
        return true;
    }

    public String formatForEdit(Object object) {
        if (object == null) {
            return "";
        }
        ComparableIpAddress comparableIpAddress = new ComparableIpAddress(object.toString());
        if (!comparableIpAddress.isValid()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(object.toString());
                return inetAddress.getHostAddress();
            }
            catch (Exception exception) {
                return object.toString();
            }
        }
        return object.toString();
    }

    public Object parse(Class clazz, String string) {
        return string;
    }

    public String format(Object object) {
        return this.formatForEdit(object);
    }
}

